/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.attach;

import com.sun.tools.attach.VirtualMachine;
import com.sun.tools.attach.VirtualMachineDescriptor;
import org.graalvm.visualvm.application.Application;
import org.graalvm.visualvm.attach.AttachModelImpl;
import org.graalvm.visualvm.attach.JRockitAttachModelImpl;
import org.graalvm.visualvm.attach.OracleJRockitAttachModelImpl;
import org.graalvm.visualvm.core.model.AbstractModelProvider;
import org.graalvm.visualvm.host.Host;
import org.graalvm.visualvm.tools.attach.AttachModel;
import org.graalvm.visualvm.tools.jvmstat.JvmJvmstatModel;
import org.graalvm.visualvm.tools.jvmstat.JvmJvmstatModelFactory;
import org.openide.util.Utilities;

public final class AttachModelProvider
extends AbstractModelProvider<AttachModel, Application> {
    AttachModelProvider() {
    }

    public AttachModel createModelFor(Application app) {
        JvmJvmstatModel jvmstat;
        if (Host.LOCALHOST.equals((Object)app.getHost()) && (jvmstat = JvmJvmstatModelFactory.getJvmstatModelFor((Application)app)) != null && jvmstat.isAttachable()) {
            if (Utilities.isWindows()) {
                Boolean this64bitArch = AttachModelProvider.is64BitArchitecture();
                Boolean app64bitArch = AttachModelProvider.is64BitArchitecture(jvmstat);
                if (this64bitArch != null && app64bitArch != null && !this64bitArch.equals(app64bitArch)) {
                    return null;
                }
            }
            String pid = String.valueOf(app.getPid());
            for (VirtualMachineDescriptor descr : VirtualMachine.list()) {
                if (!pid.equals(descr.id())) continue;
                String vmName = jvmstat.getVmName();
                if (vmName != null) {
                    if ("BEA JRockit(R)".equals(vmName)) {
                        return new JRockitAttachModelImpl(app);
                    }
                    if ("Oracle JRockit(R)".equals(vmName)) {
                        return new OracleJRockitAttachModelImpl(app);
                    }
                }
                return new AttachModelImpl(app);
            }
        }
        return null;
    }

    private static Boolean is64BitArchitecture(JvmJvmstatModel jvmstat) {
        String name = jvmstat.getVmName();
        if (name != null) {
            return name.toLowerCase().contains("64-bit");
        }
        return null;
    }

    private static Boolean is64BitArchitecture() {
        String thisArch = System.getProperty("sun.arch.data.model");
        if (thisArch != null) {
            return "64".equals(thisArch);
        }
        return null;
    }
}

