/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.popupswitcher;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.lang.ref.SoftReference;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import org.netbeans.swing.popupswitcher.SwitcherTableItem;
import org.netbeans.swing.popupswitcher.SwitcherTableModel;
import org.openide.awt.HtmlRenderer;
import org.openide.util.Utilities;

public class SwitcherTable
extends JTable {
    private static final Border rendererBorder = BorderFactory.createEmptyBorder(2, 5, 0, 5);
    private Icon nullIcon = new NullIcon();
    private Color foreground;
    private Color background;
    private Color selForeground;
    private Color selBackground;
    private Dimension prefSize;
    private boolean needCalcRowHeight = true;
    private final boolean showIcons;
    private static final boolean TABNAMES_HTML = Boolean.parseBoolean(System.getProperty("nb.tabnames.html", "true"));
    private static SoftReference<BufferedImage> ctx = null;

    public SwitcherTable(SwitcherTableItem[] switcherTableItemArray) {
        this(switcherTableItemArray, 0);
    }

    public SwitcherTable(SwitcherTableItem[] switcherTableItemArray, int n) {
        this.init();
        int n2 = n == 0 ? 10 : 5;
        int n3 = Utilities.getUsableScreenBounds().height - n - n2;
        this.setModel(new SwitcherTableModel(switcherTableItemArray, this.getRowHeight(), n3));
        this.getSelectionModel().clearSelection();
        this.getSelectionModel().setAnchorSelectionIndex(-1);
        this.getSelectionModel().setLeadSelectionIndex(-1);
        this.setAutoscrolls(false);
        boolean bl = false;
        for (SwitcherTableItem switcherTableItem : switcherTableItemArray) {
            if (switcherTableItem.getIcon() == null || switcherTableItem.getIcon().getIconWidth() <= 0) continue;
            bl = true;
            break;
        }
        this.showIcons = bl;
    }

    private void init() {
        Border border = UIManager.getBorder("nb.popupswitcher.border");
        if (null == border) {
            border = BorderFactory.createLineBorder(this.getForeground());
        }
        this.setBorder(border);
        this.setShowHorizontalLines(false);
        this.calcRowHeight(SwitcherTable.getOffscreenGraphics());
    }

    public void setSwitcherItems(SwitcherTableItem[] switcherTableItemArray, int n) {
        int n2 = n == 0 ? 10 : 5;
        int n3 = Utilities.getUsableScreenBounds().height - n - n2;
        this.setModel(new SwitcherTableModel(switcherTableItemArray, this.getRowHeight(), n3));
        this.prefSize = null;
    }

    @Override
    public void updateUI() {
        this.needCalcRowHeight = true;
        super.updateUI();
    }

    @Override
    public void setFont(Font font) {
        this.needCalcRowHeight = true;
        super.setFont(font);
    }

    @Override
    public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
        Object object;
        SwitcherTableItem switcherTableItem = (SwitcherTableItem)this.getSwitcherTableModel().getValueAt(n, n2);
        boolean bl = n == this.getSelectedRow() && n2 == this.getSelectedColumn() && switcherTableItem != null;
        Component component = tableCellRenderer.getTableCellRendererComponent(this, switcherTableItem, bl, bl, n, n2);
        JLabel jLabel = null;
        if (component instanceof JLabel) {
            object = (JLabel)component;
            jLabel = (JLabel)HtmlRenderer.createRenderer();
            if (jLabel instanceof HtmlRenderer.Renderer) {
                ((HtmlRenderer.Renderer)jLabel).setRenderStyle(1);
            }
            jLabel.setForeground(((Component)object).getForeground());
            jLabel.setBackground(((Component)object).getBackground());
            jLabel.setFont(((Component)object).getFont());
            component = jLabel;
        }
        if (switcherTableItem == null) {
            if (null != jLabel) {
                jLabel.setOpaque(false);
                jLabel.setIcon(null);
            }
            return component;
        }
        object = switcherTableItem.getIcon();
        if (object == null || object.getIconWidth() == 0) {
            object = this.nullIcon;
        }
        boolean bl2 = switcherTableItem.isActive();
        if (null != jLabel) {
            jLabel.setText(bl || bl2 && !TABNAMES_HTML ? this.stripHtml(switcherTableItem.getHtmlName()) : switcherTableItem.getHtmlName());
            jLabel.setBorder(rendererBorder);
            if (this.showIcons) {
                jLabel.setIcon((Icon)object);
                jLabel.setIconTextGap(26 - object.getIconWidth());
            }
        }
        if (bl2) {
            if (TABNAMES_HTML) {
                if (null != jLabel) {
                    jLabel.setText(jLabel.getText() + " \u2190");
                }
            } else if (Utilities.isWindows()) {
                component.setFont(this.getFont().deriveFont(1, this.getFont().getSize()));
            } else {
                component.setFont(new Font(this.getFont().getName(), 1, this.getFont().getSize()));
            }
        }
        if (null != jLabel) {
            jLabel.setOpaque(true);
        }
        return component;
    }

    private String stripHtml(String string) {
        if (null == string) {
            return null;
        }
        String string2 = string.replaceAll("<[^>]*>", "");
        string2 = string2.replaceAll("&nbsp;", " ");
        string2 = string2.trim();
        return string2;
    }

    @Override
    public Color getForeground() {
        if (this.foreground == null) {
            this.foreground = UIManager.getColor("nb.popupswitcher.foreground");
            if (this.foreground == null) {
                this.foreground = UIManager.getColor("ComboBox.foreground");
            }
        }
        return this.foreground != null ? this.foreground : super.getForeground();
    }

    @Override
    public Color getBackground() {
        if (this.background == null) {
            this.background = UIManager.getColor("nb.popupswitcher.background");
            if (this.background == null) {
                this.background = UIManager.getColor("ComboBox.background");
            }
            if (null != this.background) {
                this.background = new Color(this.background.getRGB());
            }
        }
        return this.background != null ? this.background : super.getBackground();
    }

    @Override
    public Color getSelectionForeground() {
        if (this.selForeground == null) {
            this.selForeground = UIManager.getColor("nb.popupswitcher.selectionForeground");
            if (this.selForeground == null) {
                this.selForeground = UIManager.getColor("ComboBox.selectionForeground");
            }
        }
        return this.selForeground != null ? this.selForeground : super.getSelectionForeground();
    }

    @Override
    public Color getSelectionBackground() {
        if (this.selBackground == null) {
            this.selBackground = UIManager.getColor("nb.popupswitcher.selectionBackground");
            if (this.selBackground == null) {
                this.selBackground = UIManager.getColor("ComboBox.selectionBackground");
            }
        }
        return this.selBackground != null ? this.selBackground : super.getSelectionBackground();
    }

    private void calcRowHeight(Graphics graphics) {
        Font font = this.getFont();
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        int n = Math.max(fontMetrics.getHeight(), 16) + 4;
        this.needCalcRowHeight = false;
        this.setRowHeight(n);
    }

    private static Graphics2D getOffscreenGraphics() {
        BufferedImage bufferedImage = null;
        if (ctx != null) {
            bufferedImage = ctx.get();
        }
        if (bufferedImage == null) {
            bufferedImage = new BufferedImage(10, 10, 1);
            ctx = new SoftReference<BufferedImage>(bufferedImage);
        }
        return (Graphics2D)bufferedImage.getGraphics();
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.prefSize == null) {
            int n;
            int n2 = this.getColumnCount();
            int n3 = this.getRowCount();
            int n4 = 0;
            for (n = 0; n < n2; ++n) {
                for (int i = 0; i < n3; ++i) {
                    TableCellRenderer tableCellRenderer = this.getCellRenderer(i, n);
                    Component component = this.prepareRenderer(tableCellRenderer, i, n);
                    n4 = Math.max(component.getPreferredSize().width + 1, n4);
                }
            }
            n4 = Math.min(n4, 250);
            for (n = 0; n < n2; ++n) {
                this.getColumnModel().getColumn(n).setPreferredWidth(n4);
            }
            this.prefSize = new Dimension(n4 * n2, n3 * this.getRowHeight());
        }
        return this.prefSize;
    }

    private SwitcherTableModel getSwitcherTableModel() {
        return (SwitcherTableModel)this.getModel();
    }

    public SwitcherTableItem getSelectedItem() {
        return (SwitcherTableItem)this.getValueAt(this.getSelectedRow(), this.getSelectedColumn());
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.needCalcRowHeight) {
            this.calcRowHeight(graphics);
        }
        super.paint(graphics);
    }

    @Override
    public void changeSelection(int n, int n2, boolean bl, boolean bl2) {
        super.changeSelection(n, n2, false, false);
    }

    public int getLastValidRow() {
        int n = this.getColumnCount() - 1;
        for (int i = this.getRowCount() - 1; i >= 0; --i) {
            if (this.getValueAt(i, n) == null) continue;
            return i;
        }
        return -1;
    }

    private static class NullIcon
    implements Icon {
        private NullIcon() {
        }

        @Override
        public int getIconWidth() {
            return 16;
        }

        @Override
        public int getIconHeight() {
            return 16;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        }
    }
}

