/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jfr.views.exceptions;

import java.awt.Font;
import java.time.Duration;
import javax.swing.JLabel;
import org.graalvm.visualvm.jfr.utils.ValuesConverter;
import org.graalvm.visualvm.jfr.views.exceptions.ExceptionsNode;
import org.graalvm.visualvm.lib.profiler.api.icons.Icons;
import org.graalvm.visualvm.lib.ui.swing.renderer.JavaNameRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.LabelRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.McsTimeRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.MultiRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.NumberRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.ProfilerRenderer;

final class ExceptionsRenderers {
    ExceptionsRenderers() {
    }

    private static int getMinimumWidth(String valueName) {
        return new JLabel((String)valueName).getPreferredSize().width + 30;
    }

    private static class TimeRenderer
    extends McsTimeRenderer {
        private TimeRenderer() {
        }

        public void setValue(Object value, int row) {
            if (value instanceof Duration) {
                long micros = ValuesConverter.durationToMicros((Duration)value);
                if (micros == 0L) {
                    this.setText("< 0.001 ms");
                } else {
                    super.setValue((Object)micros, row);
                }
            } else {
                this.setText("-");
            }
        }
    }

    static class MaxTimeRenderer
    extends TimeRenderer {
        MaxTimeRenderer() {
        }

        static String getDisplayName() {
            return "Max Time";
        }

        static boolean isInitiallyVisible() {
            return false;
        }

        int getPreferredWidth() {
            this.setValue(Duration.ofMillis(999999999999L), -1);
            return Math.max(this.getPreferredSize().width, ExceptionsRenderers.getMinimumWidth(MaxTimeRenderer.getDisplayName()));
        }
    }

    static class TotalTimeRenderer
    extends TimeRenderer {
        TotalTimeRenderer() {
        }

        static String getDisplayName() {
            return "Total Time";
        }

        static boolean isInitiallyVisible() {
            return false;
        }

        int getPreferredWidth() {
            this.setValue(Duration.ofMillis(999999999999L), -1);
            return Math.max(this.getPreferredSize().width, ExceptionsRenderers.getMinimumWidth(TotalTimeRenderer.getDisplayName()));
        }
    }

    static class CountRenderer
    extends NumberRenderer {
        CountRenderer() {
        }

        static String getDisplayName() {
            return "Count";
        }

        static boolean isInitiallyVisible() {
            return true;
        }

        int getPreferredWidth() {
            this.setValue(999999999999L, -1);
            return Math.max(this.getPreferredSize().width, ExceptionsRenderers.getMinimumWidth(CountRenderer.getDisplayName()));
        }
    }

    static class NameRenderer
    extends MultiRenderer {
        private static Font regular;
        private static Font bold;
        private final JavaNameRenderer javaRenderer = new JavaNameRenderer(Icons.getIcon((String)"LanguageIcons.Class"));
        private final LabelRenderer simpleRenderer = new LabelRenderer();
        private final ProfilerRenderer[] renderers = new ProfilerRenderer[]{this.javaRenderer, this.simpleRenderer};

        NameRenderer() {
        }

        protected ProfilerRenderer[] valueRenderers() {
            return this.renderers;
        }

        public void setValue(Object value, int row) {
            ExceptionsNode node;
            ExceptionsNode exceptionsNode = node = value instanceof ExceptionsNode ? (ExceptionsNode)((Object)value) : null;
            if (node instanceof ExceptionsNode.Class) {
                this.javaRenderer.setVisible(true);
                String name = node.name;
                int colon = name.indexOf(":");
                if (colon > 0) {
                    this.javaRenderer.setValue((Object)name.substring(0, colon).trim(), row);
                    this.simpleRenderer.setVisible(true);
                    this.simpleRenderer.setFont(NameRenderer.regular());
                    this.simpleRenderer.setText(name.substring(colon).trim());
                    this.simpleRenderer.setIcon(null);
                } else {
                    this.javaRenderer.setValue((Object)name, row);
                    this.simpleRenderer.setVisible(false);
                }
            } else {
                this.javaRenderer.setVisible(false);
                this.simpleRenderer.setVisible(true);
                if (node != null) {
                    ExceptionsNode parent = node.getParent();
                    this.simpleRenderer.setFont((parent == null || parent.getParent() == null) && !(value instanceof ExceptionsNode.Label) ? NameRenderer.bold() : NameRenderer.regular());
                    this.simpleRenderer.setText(node.name);
                    this.simpleRenderer.setIcon(node.icon);
                } else {
                    this.simpleRenderer.setFont(NameRenderer.regular());
                    this.simpleRenderer.setValue(value, row);
                }
            }
        }

        static String getDisplayName() {
            return "Name";
        }

        private static Font regular() {
            if (regular == null) {
                regular = new LabelRenderer().getFont();
            }
            return regular;
        }

        private static Font bold() {
            if (bold == null) {
                bold = new LabelRenderer().getFont().deriveFont(1);
            }
            return bold;
        }
    }
}

