/*
 * Decompiled with CFR 0.152.
 */
package com.graphbuilder.curve;

import com.graphbuilder.curve.BSpline;
import com.graphbuilder.curve.ControlPath;
import com.graphbuilder.curve.GroupIterator;
import com.graphbuilder.curve.MultiPath;
import com.graphbuilder.curve.ValueVector;

public class NURBSpline
extends BSpline {
    private static double[] nw = new double[0];
    private static double[] weight = new double[0];
    private ValueVector weightVector = new ValueVector(new double[]{1.0, 1.0, 1.0, 1.0}, 4);
    private boolean useWeightVector = true;

    public NURBSpline(ControlPath cp, GroupIterator gi) {
        super(cp, gi);
    }

    protected void eval(double[] p) {
        int i;
        int dim = p.length - 1;
        double t = p[dim];
        double sum2 = 0.0;
        int numPts = this.gi.getGroupSize();
        for (i = 0; i < numPts; ++i) {
            NURBSpline.nw[i] = this.N(t, i) * weight[i];
            sum2 += nw[i];
        }
        if (sum2 == 0.0) {
            sum2 = 1.0;
        }
        for (i = 0; i < dim; ++i) {
            double sum1 = 0.0;
            this.gi.set(0, 0);
            for (int j = 0; j < numPts; ++j) {
                sum1 += nw[j] * this.cp.getPoint(this.gi.next()).getLocation()[i];
            }
            p[i] = sum1 / sum2;
        }
    }

    public ValueVector getWeightVector() {
        return this.weightVector;
    }

    public void setWeightVector(ValueVector v) {
        if (v == null) {
            throw new IllegalArgumentException("Weight-vector cannot be null.");
        }
        this.weightVector = v;
    }

    public boolean getUseWeightVector() {
        return this.useWeightVector;
    }

    public void setUseWeightVector(boolean b) {
        this.useWeightVector = b;
    }

    public void appendTo(MultiPath mp) {
        if (!this.gi.isInRange(0, this.cp.numPoints())) {
            throw new IllegalArgumentException("Group iterator not in range");
        }
        int numPts = this.gi.getGroupSize();
        if (nw.length < numPts) {
            nw = new double[2 * numPts];
            weight = new double[2 * numPts];
        }
        if (this.useWeightVector) {
            if (this.weightVector.size() != numPts) {
                throw new IllegalArgumentException("weightVector.size(" + this.weightVector.size() + ") != group iterator size(" + numPts + ")");
            }
            for (int i = 0; i < numPts; ++i) {
                NURBSpline.weight[i] = this.weightVector.get(i);
                if (!(weight[i] < 0.0)) continue;
                throw new IllegalArgumentException("Negative weight not allowed");
            }
        } else {
            for (int i = 0; i < numPts; ++i) {
                NURBSpline.weight[i] = 1.0;
            }
        }
        super.appendTo(mp);
    }

    public void resetMemory() {
        super.resetMemory();
        if (nw.length > 0) {
            nw = new double[0];
            weight = new double[0];
        }
    }
}

