/*
The zlib/libpng License

Copyright (c) 2018 Arthur Brainville
Copyright (c) 2015 Andrew Fenn
Copyright (c) 2005-2010 Phillip Castaneda (pjcast -- www.wreckedgames.com)

This software is provided 'as-is', without any express or implied warranty. In no
event will the authors be held liable for any damages arising from the use of this
software.

Permission is granted to anyone to use this software for any purpose, including
commercial applications, and to alter it and redistribute it freely, subject to the
following restrictions:

    1. The origin of this software must not be misrepresented; you must not claim that
        you wrote the original software. If you use this software in a product,
        an acknowledgment in the product documentation would be appreciated
        but is not required.

    2. Altered source versions must be plainly marked as such, and must not be
        misrepresented as being the original software.

    3. This notice may not be removed or altered from any source distribution.   
*/

/**\mainpage Object-oriented Input System
 *
 * Welcome to the documentation of OIS. 
 *
 *
 * This website contains the documentation of the public API exposed by OIS.
 *
 * As the name of the library suggest, this is 100% Object-oriented.
 * Every C++ classes from the library is located inside the OIS namespace.
 *
 * This project is licensed under the terms of the <a href="https://opensource.org/licenses/Zlib">zlib/libpng licence</a>
 *
 */

#ifndef OIS_OISALL_H
#define OIS_OISALL_H

#include "OISPrereqs.h"
#include "OISObject.h"
#include "OISMouse.h"
#include "OISKeyboard.h"
#include "OISJoyStick.h"
#include "OISMultiTouch.h"
#include "OISInputManager.h"
#include "OISFactoryCreator.h"
#include "OISException.h"
#include "OISEvents.h"

#include "OISEffect.h"
#include "OISInterface.h"
#include "OISForceFeedback.h"

#endif
