/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.mapping;

import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.BooleanValue;
import org.apache.solr.common.SolrException;

class BooleanRemoveFunction
extends BooleanValue.AbstractBooleanValue {
    private final BooleanValue baseExpr;
    private final BooleanValue removeExpr;
    public static final String name = "remove";
    private final String exprStr;
    private final AnalyticsValueStream.ExpressionType funcType;
    boolean exists = false;

    public BooleanRemoveFunction(BooleanValue baseExpr, BooleanValue removeExpr) throws SolrException {
        this.baseExpr = baseExpr;
        this.removeExpr = removeExpr;
        this.exprStr = AnalyticsValueStream.createExpressionString(name, baseExpr, removeExpr);
        this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, baseExpr, removeExpr);
    }

    @Override
    public boolean getBoolean() {
        boolean value = this.baseExpr.getBoolean();
        this.exists = false;
        if (this.baseExpr.exists()) {
            this.exists = value == this.removeExpr.getBoolean() ? !this.removeExpr.exists() : true;
        }
        return value;
    }

    @Override
    public boolean exists() {
        return this.exists;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public String getExpressionStr() {
        return this.exprStr;
    }

    @Override
    public AnalyticsValueStream.ExpressionType getExpressionType() {
        return this.funcType;
    }
}

