/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.layout.template.json.resolver;

import org.apache.logging.log4j.layout.template.json.resolver.TemplateResolver;
import org.apache.logging.log4j.layout.template.json.resolver.TemplateResolverConfig;
import org.apache.logging.log4j.layout.template.json.util.JsonWriter;

final class StackTraceElementObjectResolver
implements TemplateResolver<StackTraceElement> {
    private static final TemplateResolver<StackTraceElement> CLASS_NAME_RESOLVER = (stackTraceElement, jsonWriter) -> jsonWriter.writeString(stackTraceElement.getClassName());
    private static final TemplateResolver<StackTraceElement> METHOD_NAME_RESOLVER = (stackTraceElement, jsonWriter) -> jsonWriter.writeString(stackTraceElement.getMethodName());
    private static final TemplateResolver<StackTraceElement> FILE_NAME_RESOLVER = (stackTraceElement, jsonWriter) -> jsonWriter.writeString(stackTraceElement.getFileName());
    private static final TemplateResolver<StackTraceElement> LINE_NUMBER_RESOLVER = (stackTraceElement, jsonWriter) -> jsonWriter.writeNumber(stackTraceElement.getLineNumber());
    private final TemplateResolver<StackTraceElement> internalResolver;

    StackTraceElementObjectResolver(TemplateResolverConfig config) {
        this.internalResolver = this.createInternalResolver(config);
    }

    private TemplateResolver<StackTraceElement> createInternalResolver(TemplateResolverConfig config) {
        String fieldName;
        switch (fieldName = config.getString("field")) {
            case "className": {
                return CLASS_NAME_RESOLVER;
            }
            case "methodName": {
                return METHOD_NAME_RESOLVER;
            }
            case "fileName": {
                return FILE_NAME_RESOLVER;
            }
            case "lineNumber": {
                return LINE_NUMBER_RESOLVER;
            }
        }
        throw new IllegalArgumentException("unknown field: " + config);
    }

    static String getName() {
        return "stackTraceElement";
    }

    @Override
    public void resolve(StackTraceElement stackTraceElement, JsonWriter jsonWriter) {
        this.internalResolver.resolve(stackTraceElement, jsonWriter);
    }
}

