/*
 * Decompiled with CFR 0.152.
 */
package vtk;

import java.io.File;
import vtk.vtkFileOutputWindow;

public enum vtkNativeLibrary {
    vtkWebCore("vtkWebCoreJava"),
    vtkWebGLExporter("vtkWebGLExporterJava"),
    vtkViewsInfovis("vtkViewsInfovisJava"),
    vtkViewsContext2D("vtkViewsContext2DJava"),
    vtkTestingRendering("vtkTestingRenderingJava"),
    vtkRenderingRayTracing("vtkRenderingRayTracingJava"),
    vtkRenderingVolumeAMR("vtkRenderingVolumeAMRJava"),
    vtkRenderingQt("vtkRenderingQtJava"),
    vtkPythonContext2D("vtkPythonContext2DJava"),
    vtkRenderingParallelLIC("vtkRenderingParallelLICJava"),
    vtkRenderingParallel("vtkRenderingParallelJava"),
    vtkRenderingOpenVR("vtkRenderingOpenVRJava"),
    vtkRenderingVolumeOpenGL2("vtkRenderingVolumeOpenGL2Java"),
    vtkRenderingMatplotlib("vtkRenderingMatplotlibJava"),
    vtkRenderingLabel("vtkRenderingLabelJava"),
    vtkRenderingLOD("vtkRenderingLODJava"),
    vtkRenderingLICOpenGL2("vtkRenderingLICOpenGL2Java"),
    vtkRenderingImage("vtkRenderingImageJava"),
    vtkRenderingExternal("vtkRenderingExternalJava"),
    vtkRenderingContextOpenGL2("vtkRenderingContextOpenGL2Java"),
    vtkParallelMPI4Py("vtkParallelMPI4PyJava"),
    vtkIOXdmf2("vtkIOXdmf2Java"),
    vtkIOVeraOut("vtkIOVeraOutJava"),
    vtkIOVPIC("vtkIOVPICJava"),
    vtkIOTecplotTable("vtkIOTecplotTableJava"),
    vtkIOTRUCHAS("vtkIOTRUCHASJava"),
    vtkIOSegY("vtkIOSegYJava"),
    vtkIOPostgreSQL("vtkIOPostgreSQLJava"),
    vtkIOParallelXdmf3("vtkIOParallelXdmf3Java"),
    vtkIOXdmf3("vtkIOXdmf3Java"),
    vtkIOParallelXML("vtkIOParallelXMLJava"),
    vtkIOParallelNetCDF("vtkIOParallelNetCDFJava"),
    vtkIOParallelLSDyna("vtkIOParallelLSDynaJava"),
    vtkIOParallelExodus("vtkIOParallelExodusJava"),
    vtkIOPLY("vtkIOPLYJava"),
    vtkIOPIO("vtkIOPIOJava"),
    vtkIOPDAL("vtkIOPDALJava"),
    vtkIOOggTheora("vtkIOOggTheoraJava"),
    vtkIOODBC("vtkIOODBCJava"),
    vtkIONetCDF("vtkIONetCDFJava"),
    vtkIOMySQL("vtkIOMySQLJava"),
    vtkIOMotionFX("vtkIOMotionFXJava"),
    vtkIOMPIParallel("vtkIOMPIParallelJava"),
    vtkIOParallel("vtkIOParallelJava"),
    vtkIOMPIImage("vtkIOMPIImageJava"),
    vtkIOMINC("vtkIOMINCJava"),
    vtkIOLSDyna("vtkIOLSDynaJava"),
    vtkIOLAS("vtkIOLASJava"),
    vtkIOInfovis("vtkIOInfovisJava"),
    vtkIOImport("vtkIOImportJava"),
    vtkIOH5part("vtkIOH5partJava"),
    vtkIOGeometry("vtkIOGeometryJava"),
    vtkIOGeoJSON("vtkIOGeoJSONJava"),
    vtkIOFFMPEG("vtkIOFFMPEGJava"),
    vtkIOVideo("vtkIOVideoJava"),
    vtkIOMovie("vtkIOMovieJava"),
    vtkIOExportPDF("vtkIOExportPDFJava"),
    vtkIOExportGL2PS("vtkIOExportGL2PSJava"),
    vtkRenderingGL2PSOpenGL2("vtkRenderingGL2PSOpenGL2Java"),
    vtkIOExport("vtkIOExportJava"),
    vtkRenderingVtkJS("vtkRenderingVtkJSJava"),
    vtkRenderingSceneGraph("vtkRenderingSceneGraphJava"),
    vtkIOExodus("vtkIOExodusJava"),
    vtkIOEnSight("vtkIOEnSightJava"),
    vtkIOCityGML("vtkIOCityGMLJava"),
    vtkIOAsynchronous("vtkIOAsynchronousJava"),
    vtkIOAMR("vtkIOAMRJava"),
    vtkInteractionImage("vtkInteractionImageJava"),
    vtkInfovisBoostGraphAlgorithms("vtkInfovisBoostGraphAlgorithmsJava"),
    vtkImagingStencil("vtkImagingStencilJava"),
    vtkImagingStatistics("vtkImagingStatisticsJava"),
    vtkImagingOpenGL2("vtkImagingOpenGL2Java"),
    vtkImagingMorphological("vtkImagingMorphologicalJava"),
    vtkImagingMath("vtkImagingMathJava"),
    vtkIOSQL("vtkIOSQLJava"),
    vtkGeovisGDAL("vtkGeovisGDALJava"),
    vtkIOGDAL("vtkIOGDALJava"),
    vtkGeovisCore("vtkGeovisCoreJava"),
    vtkInfovisLayout("vtkInfovisLayoutJava"),
    vtkViewsCore("vtkViewsCoreJava"),
    vtkInteractionWidgets("vtkInteractionWidgetsJava"),
    vtkRenderingVolume("vtkRenderingVolumeJava"),
    vtkRenderingAnnotation("vtkRenderingAnnotationJava"),
    vtkImagingHybrid("vtkImagingHybridJava"),
    vtkImagingColor("vtkImagingColorJava"),
    vtkInteractionStyle("vtkInteractionStyleJava"),
    vtkFiltersTopology("vtkFiltersTopologyJava"),
    vtkFiltersSelection("vtkFiltersSelectionJava"),
    vtkFiltersSMP("vtkFiltersSMPJava"),
    vtkFiltersReebGraph("vtkFiltersReebGraphJava"),
    vtkFiltersPython("vtkFiltersPythonJava"),
    vtkFiltersProgrammable("vtkFiltersProgrammableJava"),
    vtkFiltersPoints("vtkFiltersPointsJava"),
    vtkFiltersParallelVerdict("vtkFiltersParallelVerdictJava"),
    vtkFiltersVerdict("vtkFiltersVerdictJava"),
    vtkFiltersParallelStatistics("vtkFiltersParallelStatisticsJava"),
    vtkFiltersParallelImaging("vtkFiltersParallelImagingJava"),
    vtkFiltersParallelGeometry("vtkFiltersParallelGeometryJava"),
    vtkFiltersParallelFlowPaths("vtkFiltersParallelFlowPathsJava"),
    vtkFiltersParallelDIY2("vtkFiltersParallelDIY2Java"),
    vtkFiltersImaging("vtkFiltersImagingJava"),
    vtkImagingGeneral("vtkImagingGeneralJava"),
    vtkFiltersHyperTree("vtkFiltersHyperTreeJava"),
    vtkFiltersGeneric("vtkFiltersGenericJava"),
    vtkFiltersFlowPaths("vtkFiltersFlowPathsJava"),
    vtkFiltersAMR("vtkFiltersAMRJava"),
    vtkDomainsParallelChemistry("vtkDomainsParallelChemistryJava"),
    vtkFiltersParallelMPI("vtkFiltersParallelMPIJava"),
    vtkFiltersParallel("vtkFiltersParallelJava"),
    vtkFiltersTexture("vtkFiltersTextureJava"),
    vtkFiltersModeling("vtkFiltersModelingJava"),
    vtkFiltersHybrid("vtkFiltersHybridJava"),
    vtkParallelMPI("vtkParallelMPIJava"),
    vtkDomainsChemistryOpenGL2("vtkDomainsChemistryOpenGL2Java"),
    vtkRenderingOpenGL2("vtkRenderingOpenGL2Java"),
    vtkRenderingUI("vtkRenderingUIJava"),
    vtkDomainsChemistry("vtkDomainsChemistryJava"),
    vtkCommonPython("vtkCommonPythonJava"),
    vtkCommonArchive("vtkCommonArchiveJava"),
    vtkChartsCore("vtkChartsCoreJava"),
    vtkInfovisCore("vtkInfovisCoreJava"),
    vtkFiltersExtraction("vtkFiltersExtractionJava"),
    vtkIOXML("vtkIOXMLJava"),
    vtkIOXMLParser("vtkIOXMLParserJava"),
    vtkParallelCore("vtkParallelCoreJava"),
    vtkIOLegacy("vtkIOLegacyJava"),
    vtkIOCore("vtkIOCoreJava"),
    vtkFiltersStatistics("vtkFiltersStatisticsJava"),
    vtkImagingFourier("vtkImagingFourierJava"),
    vtkImagingSources("vtkImagingSourcesJava"),
    vtkIOImage("vtkIOImageJava"),
    vtkRenderingContext2D("vtkRenderingContext2DJava"),
    vtkRenderingFreeType("vtkRenderingFreeTypeJava"),
    vtkRenderingCore("vtkRenderingCoreJava"),
    vtkFiltersSources("vtkFiltersSourcesJava"),
    vtkCommonColor("vtkCommonColorJava"),
    vtkAcceleratorsVTKm("vtkAcceleratorsVTKmJava"),
    vtkImagingCore("vtkImagingCoreJava"),
    vtkFiltersGeometry("vtkFiltersGeometryJava"),
    vtkFiltersGeneral("vtkFiltersGeneralJava"),
    vtkCommonComputationalGeometry("vtkCommonComputationalGeometryJava"),
    vtkFiltersCore("vtkFiltersCoreJava"),
    vtkCommonExecutionModel("vtkCommonExecutionModelJava"),
    vtkCommonDataModel("vtkCommonDataModelJava"),
    vtkCommonSystem("vtkCommonSystemJava"),
    vtkCommonMisc("vtkCommonMiscJava"),
    vtkCommonTransforms("vtkCommonTransformsJava"),
    vtkCommonMath("vtkCommonMathJava"),
    vtkCommonCore("vtkCommonCoreJava");

    private String nativeLibraryName;
    private boolean loaded;

    public static boolean LoadAllNativeLibraries() {
        boolean bl = true;
        for (vtkNativeLibrary vtkNativeLibrary2 : vtkNativeLibrary.values()) {
            try {
                vtkNativeLibrary2.LoadLibrary();
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                bl = false;
                unsatisfiedLinkError.printStackTrace();
            }
        }
        return bl;
    }

    public static void LoadNativeLibraries(vtkNativeLibrary ... vtkNativeLibraryArray) {
        for (vtkNativeLibrary vtkNativeLibrary2 : vtkNativeLibraryArray) {
            vtkNativeLibrary2.LoadLibrary();
        }
    }

    public static void DisableOutputWindow(File file) {
        if (file == null) {
            file = new File("vtkError.txt");
        }
        vtkFileOutputWindow vtkFileOutputWindow2 = new vtkFileOutputWindow();
        vtkFileOutputWindow2.SetFileName(file.getAbsolutePath());
        vtkFileOutputWindow2.SetInstance(vtkFileOutputWindow2);
    }

    private vtkNativeLibrary(String string2) {
        this.nativeLibraryName = string2;
        this.loaded = false;
    }

    public void LoadLibrary() throws UnsatisfiedLinkError {
        if (!this.loaded) {
            if (System.getProperty("vtk.lib.dir") != null) {
                File file = new File(System.getProperty("vtk.lib.dir"));
                vtkNativeLibrary.patchJavaLibraryPath(file.getAbsolutePath());
                File file2 = new File(file, System.mapLibraryName(this.nativeLibraryName));
                if (file2.exists()) {
                    try {
                        Runtime.getRuntime().load(file2.getAbsolutePath());
                        this.loaded = true;
                        return;
                    }
                    catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                        unsatisfiedLinkError.printStackTrace();
                    }
                }
            }
            System.loadLibrary(this.nativeLibraryName);
        }
        this.loaded = true;
    }

    public boolean IsLoaded() {
        return this.loaded;
    }

    public String GetLibraryName() {
        return this.nativeLibraryName;
    }

    private static void patchJavaLibraryPath(String string) {
        if (string != null) {
            String string2 = System.getProperty("path.separator");
            String string3 = System.getProperty("java.library.path");
            if (!string3.contains(string)) {
                string3 = string3 + string2 + string;
                System.setProperty("java.library.path", string3);
            }
        }
    }
}

