/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.websocket;

import jakarta.websocket.SendHandler;
import jakarta.websocket.SendResult;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.tomcat.websocket.AsyncChannelWrapper;
import org.apache.tomcat.websocket.WsRemoteEndpointImplBase;

public class WsRemoteEndpointImplClient
extends WsRemoteEndpointImplBase {
    private final AsyncChannelWrapper channel;

    public WsRemoteEndpointImplClient(AsyncChannelWrapper asyncChannelWrapper) {
        this.channel = asyncChannelWrapper;
    }

    @Override
    protected boolean isMasked() {
        return true;
    }

    @Override
    protected void doWrite(SendHandler sendHandler, long l, ByteBuffer ... byteBufferArray) {
        for (ByteBuffer byteBuffer : byteBufferArray) {
            long l2;
            if (l == -1L) {
                l2 = this.getSendTimeout();
                if (l2 < 1L) {
                    l2 = Long.MAX_VALUE;
                }
            } else {
                l2 = l - System.currentTimeMillis();
                if (l2 < 0L) {
                    SendResult sendResult = new SendResult((Throwable)new IOException(sm.getString("wsRemoteEndpoint.writeTimeout")));
                    sendHandler.onResult(sendResult);
                }
            }
            try {
                this.channel.write(byteBuffer).get(l2, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException exception) {
                sendHandler.onResult(new SendResult((Throwable)exception));
                return;
            }
        }
        sendHandler.onResult(SENDRESULT_OK);
    }

    @Override
    protected void doClose() {
        this.channel.close();
    }
}

