/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.CharArrayWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Vector;
import java.util.jar.JarFile;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.compiler.ErrorDispatcher;
import org.apache.jasper.compiler.JspUtil;
import org.apache.jasper.compiler.Mark;
import org.apache.jasper.runtime.ExceptionUtils;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

class JspReader {
    private final Log log = LogFactory.getLog(JspReader.class);
    private Mark current;
    private String master;
    private List<String> sourceFiles;
    private int currFileId;
    private int size;
    private JspCompilationContext context;
    private ErrorDispatcher err;
    private boolean singleFile;

    public JspReader(JspCompilationContext jspCompilationContext, String string, String string2, JarFile jarFile, ErrorDispatcher errorDispatcher) throws JasperException, FileNotFoundException, IOException {
        this(jspCompilationContext, string, string2, JspUtil.getReader(string, string2, jarFile, jspCompilationContext, errorDispatcher), errorDispatcher);
    }

    public JspReader(JspCompilationContext jspCompilationContext, String string, String string2, InputStreamReader inputStreamReader, ErrorDispatcher errorDispatcher) throws JasperException {
        this.context = jspCompilationContext;
        this.err = errorDispatcher;
        this.sourceFiles = new Vector<String>();
        this.currFileId = 0;
        this.size = 0;
        this.singleFile = false;
        this.pushFile(string, string2, inputStreamReader);
    }

    JspCompilationContext getJspCompilationContext() {
        return this.context;
    }

    String getFile(int n) {
        return this.sourceFiles.get(n);
    }

    boolean hasMoreInput() throws JasperException {
        if (this.current.cursor >= this.current.stream.length) {
            if (this.singleFile) {
                return false;
            }
            while (this.popFile()) {
                if (this.current.cursor >= this.current.stream.length) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    int nextChar() throws JasperException {
        if (!this.hasMoreInput()) {
            return -1;
        }
        char c = this.current.stream[this.current.cursor];
        ++this.current.cursor;
        if (c == '\n') {
            ++this.current.line;
            this.current.col = 0;
        } else {
            ++this.current.col;
        }
        return c;
    }

    private int nextChar(Mark mark) throws JasperException {
        if (!this.hasMoreInput()) {
            return -1;
        }
        char c = this.current.stream[this.current.cursor];
        mark.init(this.current, this.singleFile);
        ++this.current.cursor;
        if (c == '\n') {
            ++this.current.line;
            this.current.col = 0;
        } else {
            ++this.current.col;
        }
        return c;
    }

    private Boolean indexOf(char c, Mark mark) throws JasperException {
        int n;
        if (!this.hasMoreInput()) {
            return null;
        }
        int n2 = this.current.stream.length;
        int n3 = this.current.line;
        int n4 = this.current.col;
        for (n = this.current.cursor; n < n2; ++n) {
            char c2 = this.current.stream[n];
            if (c2 == c) {
                mark.update(n, n3, n4);
            }
            if (c2 == '\n') {
                ++n3;
                n4 = 0;
            } else {
                ++n4;
            }
            if (c2 != c) continue;
            this.current.update(n + 1, n3, n4);
            return Boolean.TRUE;
        }
        this.current.update(n, n3, n4);
        return Boolean.FALSE;
    }

    void pushChar() {
        --this.current.cursor;
        --this.current.col;
    }

    String getText(Mark mark, Mark mark2) throws JasperException {
        Mark mark3 = this.mark();
        this.reset(mark);
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        while (!this.markEquals(mark2)) {
            charArrayWriter.write(this.nextChar());
        }
        charArrayWriter.close();
        this.setCurrent(mark3);
        return charArrayWriter.toString();
    }

    int peekChar() {
        return this.peekChar(0);
    }

    int peekChar(int n) {
        int n2 = this.current.cursor + n;
        if (n2 < this.current.stream.length) {
            return this.current.stream[n2];
        }
        return -1;
    }

    Mark mark() {
        return new Mark(this.current);
    }

    private boolean markEquals(Mark mark) {
        return mark.equals(this.current);
    }

    void reset(Mark mark) {
        this.current = new Mark(mark);
    }

    private void setCurrent(Mark mark) {
        this.current = mark;
    }

    boolean matches(String string) throws JasperException {
        int n;
        int n2 = this.current.cursor;
        int n3 = string.length();
        if (n2 + n3 < (n = this.current.stream.length)) {
            int n4;
            int n5 = this.current.line;
            int n6 = this.current.col;
            for (n4 = 0; n4 < n3; ++n4) {
                char c = this.current.stream[n4 + n2];
                if (string.charAt(n4) != c) {
                    return false;
                }
                if (c == '\n') {
                    ++n5;
                    n6 = 0;
                    continue;
                }
                ++n6;
            }
            this.current.update(n4 + n2, n5, n6);
        } else {
            Mark mark = this.mark();
            int n7 = 0;
            int n8 = 0;
            do {
                if ((char)(n7 = this.nextChar()) == string.charAt(n8++)) continue;
                this.setCurrent(mark);
                return false;
            } while (n8 < n3);
        }
        return true;
    }

    boolean matchesETag(String string) throws JasperException {
        Mark mark = this.mark();
        if (!this.matches("</" + string)) {
            return false;
        }
        this.skipSpaces();
        if (this.nextChar() == 62) {
            return true;
        }
        this.setCurrent(mark);
        return false;
    }

    boolean matchesETagWithoutLessThan(String string) throws JasperException {
        Mark mark = this.mark();
        if (!this.matches("/" + string)) {
            return false;
        }
        this.skipSpaces();
        if (this.nextChar() == 62) {
            return true;
        }
        this.setCurrent(mark);
        return false;
    }

    boolean matchesOptionalSpacesFollowedBy(String string) throws JasperException {
        Mark mark = this.mark();
        this.skipSpaces();
        boolean bl = this.matches(string);
        if (!bl) {
            this.setCurrent(mark);
        }
        return bl;
    }

    int skipSpaces() throws JasperException {
        int n = 0;
        while (this.hasMoreInput() && this.isSpace()) {
            ++n;
            this.nextChar();
        }
        return n;
    }

    Mark skipUntil(String string) throws JasperException {
        Mark mark = this.mark();
        int n = string.length();
        char c = string.charAt(0);
        Boolean bl = null;
        Mark mark2 = null;
        block0: while ((bl = this.indexOf(c, mark)) != null) {
            if (!bl.booleanValue()) continue;
            if (mark2 != null) {
                mark2.init(this.current, this.singleFile);
            } else {
                mark2 = this.mark();
            }
            for (int i = 1; i < n; ++i) {
                if (this.peekChar() != string.charAt(i)) {
                    this.current.init(mark2, this.singleFile);
                    continue block0;
                }
                this.nextChar();
            }
            return mark;
        }
        return null;
    }

    Mark skipUntilIgnoreEsc(String string, boolean bl) throws JasperException {
        Mark mark = this.mark();
        int n = string.length();
        int n2 = 120;
        int n3 = string.charAt(0);
        int n4 = this.nextChar(mark);
        while (n4 != -1) {
            block9: {
                if (n4 == 92 && n2 == 92) {
                    n4 = 0;
                } else if (n2 != 92) {
                    if (!(bl || n4 != 36 && n4 != 35 || this.peekChar() != 123)) {
                        this.nextChar();
                        this.skipELExpression();
                    } else if (n4 == n3) {
                        for (int i = 1; i < n; ++i) {
                            if (this.peekChar() == string.charAt(i)) {
                                this.nextChar();
                                continue;
                            }
                            break block9;
                        }
                        return mark;
                    }
                }
            }
            n2 = n4;
            n4 = this.nextChar(mark);
        }
        return null;
    }

    Mark skipUntilETag(String string) throws JasperException {
        Mark mark = this.skipUntil("</" + string);
        if (mark != null) {
            this.skipSpaces();
            if (this.nextChar() != 62) {
                mark = null;
            }
        }
        return mark;
    }

    Mark skipELExpression() throws JasperException {
        int n;
        Mark mark = this.mark();
        boolean bl = false;
        boolean bl2 = false;
        do {
            n = this.nextChar(mark);
            while (n == 92 && (bl || bl2)) {
                this.nextChar();
                n = this.nextChar();
            }
            if (n == -1) {
                return null;
            }
            if (n == 34 && !bl) {
                bl2 = !bl2;
                continue;
            }
            if (n != 39 || bl2) continue;
            boolean bl3 = bl = !bl;
        } while (n != 125 || bl || bl2);
        return mark;
    }

    final boolean isSpace() throws JasperException {
        return this.peekChar() <= 32;
    }

    String parseToken(boolean bl) throws JasperException {
        StringBuilder stringBuilder = new StringBuilder();
        this.skipSpaces();
        stringBuilder.setLength(0);
        if (!this.hasMoreInput()) {
            return "";
        }
        int n = this.peekChar();
        if (bl) {
            if (n == 34 || n == 39) {
                int n2 = n == 34 ? 34 : 39;
                n = this.nextChar();
                n = this.nextChar();
                while (n != -1 && n != n2) {
                    if (n == 92) {
                        n = this.nextChar();
                    }
                    stringBuilder.append((char)n);
                    n = this.nextChar();
                }
                if (n == -1) {
                    this.err.jspError(this.mark(), "jsp.error.quotes.unterminated");
                }
            } else {
                this.err.jspError(this.mark(), "jsp.error.attr.quoted");
            }
        } else if (!this.isDelimiter()) {
            do {
                if ((n = this.nextChar()) == 92 && (this.peekChar() == 34 || this.peekChar() == 39 || this.peekChar() == 62 || this.peekChar() == 37)) {
                    n = this.nextChar();
                }
                stringBuilder.append((char)n);
            } while (!this.isDelimiter());
        }
        return stringBuilder.toString();
    }

    void setSingleFile(boolean bl) {
        this.singleFile = bl;
    }

    private boolean isDelimiter() throws JasperException {
        if (!this.isSpace()) {
            int n = this.peekChar();
            if (n == 61 || n == 62 || n == 34 || n == 39 || n == 47) {
                return true;
            }
            if (n == 45) {
                Mark mark = this.mark();
                n = this.nextChar();
                if (n == 62 || n == 45 && this.nextChar() == 62) {
                    this.setCurrent(mark);
                    return true;
                }
                this.setCurrent(mark);
                return false;
            }
            return false;
        }
        return true;
    }

    private int registerSourceFile(String string) {
        if (this.sourceFiles.contains(string)) {
            return -1;
        }
        this.sourceFiles.add(string);
        ++this.size;
        return this.sourceFiles.size() - 1;
    }

    private int unregisterSourceFile(String string) {
        if (!this.sourceFiles.contains(string)) {
            return -1;
        }
        this.sourceFiles.remove(string);
        --this.size;
        return this.sourceFiles.size() - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushFile(String string, String string2, InputStreamReader inputStreamReader) throws JasperException {
        String string3 = string;
        int n = this.registerSourceFile(string3);
        if (n == -1) {
            block19: {
                if (inputStreamReader != null) {
                    try {
                        inputStreamReader.close();
                    }
                    catch (Exception exception) {
                        if (!this.log.isDebugEnabled()) break block19;
                        this.log.debug((Object)"Exception closing reader: ", (Throwable)exception);
                    }
                }
            }
            this.err.jspError("jsp.error.file.already.registered", string);
        }
        this.currFileId = n;
        try {
            CharArrayWriter charArrayWriter = new CharArrayWriter();
            char[] cArray = new char[1024];
            int n2 = 0;
            while ((n2 = inputStreamReader.read(cArray)) != -1) {
                charArrayWriter.write(cArray, 0, n2);
            }
            charArrayWriter.close();
            if (this.current == null) {
                this.current = new Mark(this, charArrayWriter.toCharArray(), n, this.getFile(n), this.master, string2);
            } else {
                this.current.pushStream(charArrayWriter.toCharArray(), n, this.getFile(n), string3, string2);
            }
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable(throwable);
            this.log.error((Object)"Exception parsing file ", throwable);
            this.popFile();
            this.err.jspError("jsp.error.file.cannot.read", string);
        }
        finally {
            block21: {
                if (inputStreamReader != null) {
                    try {
                        inputStreamReader.close();
                    }
                    catch (Exception exception) {
                        if (!this.log.isDebugEnabled()) break block21;
                        this.log.debug((Object)"Exception closing reader: ", (Throwable)exception);
                    }
                }
            }
        }
    }

    private boolean popFile() throws JasperException {
        Mark mark;
        if (this.current == null || this.currFileId < 0) {
            return false;
        }
        String string = this.getFile(this.currFileId);
        this.currFileId = this.unregisterSourceFile(string);
        if (this.currFileId < -1) {
            this.err.jspError("jsp.error.file.not.registered", string);
        }
        if ((mark = this.current.popStream()) != null) {
            this.master = this.current.baseDir;
            this.current = mark;
            return true;
        }
        return false;
    }
}

