/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http.mapper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.buf.Ascii;
import org.apache.tomcat.util.buf.CharChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.mapper.MappingData;
import org.apache.tomcat.util.http.mapper.WrapperMappingInfo;
import org.apache.tomcat.util.res.StringManager;

public final class Mapper {
    private static final Log log = LogFactory.getLog(Mapper.class);
    static final StringManager sm = StringManager.getManager((String)Mapper.class.getPackage().getName());
    Host[] hosts = new Host[0];
    String defaultHostName = null;
    ContextVersion context = new ContextVersion();

    public void setDefaultHostName(String string) {
        this.defaultHostName = string;
    }

    public synchronized void addHost(String string, String[] stringArray, Object object) {
        Object object2;
        MapElement[] mapElementArray = new Host[this.hosts.length + 1];
        Object object3 = new Host(string, object);
        if (Mapper.insertMap(this.hosts, mapElementArray, (MapElement)object3)) {
            this.hosts = mapElementArray;
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("mapper.addHost.success", new Object[]{string}));
            }
        } else {
            object2 = this.hosts[Mapper.find((MapElement[])this.hosts, string)];
            if (((Host)object2).object == object) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("mapper.addHost.sameHost", new Object[]{string}));
                }
                object3 = object2;
            } else {
                log.error((Object)sm.getString("mapper.duplicateHost", new Object[]{string, ((Host)object2).getRealHostName()}));
                return;
            }
        }
        object2 = new ArrayList(stringArray.length);
        for (String string2 : stringArray) {
            Host host = new Host(string2, (Host)object3);
            if (!this.addHostAliasImpl(host)) continue;
            object2.add(host);
        }
        ((Host)object3).addAliases((Collection<? extends Host>)object2);
    }

    public synchronized void removeHost(String string) {
        Host host = (Host)Mapper.exactFind((MapElement[])this.hosts, (String)string);
        if (host == null || host.isAlias()) {
            return;
        }
        Host[] hostArray = (Host[])this.hosts.clone();
        int n = 0;
        for (int i = 0; i < hostArray.length; ++i) {
            if (hostArray[i].getRealHost() == host) continue;
            hostArray[n++] = hostArray[i];
        }
        this.hosts = Arrays.copyOf(hostArray, n);
    }

    public synchronized void addHostAlias(String string, String string2) {
        Host host = (Host)Mapper.exactFind((MapElement[])this.hosts, (String)string);
        if (host == null) {
            return;
        }
        Host host2 = new Host(string2, host);
        if (this.addHostAliasImpl(host2)) {
            host.addAlias(host2);
        }
    }

    private boolean addHostAliasImpl(Host host) {
        MapElement[] mapElementArray = new Host[this.hosts.length + 1];
        if (Mapper.insertMap(this.hosts, mapElementArray, host)) {
            this.hosts = mapElementArray;
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("mapper.addHostAlias.success", new Object[]{host.name, host.getRealHostName()}));
            }
            return true;
        }
        Host host2 = this.hosts[Mapper.find((MapElement[])this.hosts, host.name)];
        if (host2.getRealHost() == host.getRealHost()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("mapper.addHostAlias.sameHost", new Object[]{host.name, host.getRealHostName()}));
            }
            return false;
        }
        log.error((Object)sm.getString("mapper.duplicateHostAlias", new Object[]{host.name, host.getRealHostName(), host2.getRealHostName()}));
        return false;
    }

    public synchronized void removeHostAlias(String string) {
        Host host = (Host)Mapper.exactFind((MapElement[])this.hosts, (String)string);
        if (host == null || !host.isAlias()) {
            return;
        }
        MapElement[] mapElementArray = new Host[this.hosts.length - 1];
        if (Mapper.removeMap(this.hosts, mapElementArray, string)) {
            this.hosts = mapElementArray;
            host.getRealHost().removeAlias(host);
        }
    }

    private void updateContextList(Host host, ContextList contextList) {
        host.contextList = contextList;
        for (Host host2 : host.getAliases()) {
            host2.contextList = contextList;
        }
    }

    public void setContext(String string, String[] stringArray, javax.naming.Context context) {
        this.context.path = string;
        this.context.welcomeResources = stringArray;
        this.context.resources = context;
    }

    @Deprecated
    public void addContextVersion(String string, Object object, String string2, String string3, Object object2, String[] stringArray, javax.naming.Context context) {
        this.addContextVersion(string, object, string2, string3, object2, stringArray, context, null);
    }

    @Deprecated
    public void addContextVersion(String string, Object object, String string2, String string3, Object object2, String[] stringArray, javax.naming.Context context, Collection<WrapperMappingInfo> collection) {
        this.addContextVersion(string, object, string2, string3, object2, stringArray, context, collection, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addContextVersion(String string, Object object, String string2, String string3, Object object2, String[] stringArray, javax.naming.Context context, Collection<WrapperMappingInfo> collection, boolean bl, boolean bl2) {
        Host host = (Host)Mapper.exactFind((MapElement[])this.hosts, (String)string);
        if (host == null) {
            this.addHost(string, new String[0], object);
            host = (Host)Mapper.exactFind((MapElement[])this.hosts, (String)string);
            if (host == null) {
                log.error((Object)("No host found: " + string));
                return;
            }
        }
        if (host.isAlias()) {
            log.error((Object)("No host found: " + string));
            return;
        }
        int n = Mapper.slashCount(string2);
        Host host2 = host;
        synchronized (host2) {
            ContextVersion contextVersion = new ContextVersion(string3, object2);
            contextVersion.path = string2;
            contextVersion.slashCount = n;
            contextVersion.welcomeResources = stringArray;
            contextVersion.resources = context;
            contextVersion.mapperContextRootRedirectEnabled = bl;
            contextVersion.mapperDirectoryRedirectEnabled = bl2;
            if (collection != null) {
                this.addWrappers(contextVersion, collection);
            }
            ContextList contextList = host.contextList;
            Context context2 = (Context)Mapper.exactFind((MapElement[])contextList.contexts, (String)string2);
            if (context2 == null) {
                context2 = new Context(string2, contextVersion);
                ContextList contextList2 = contextList.addContext(context2, n);
                if (contextList2 != null) {
                    this.updateContextList(host, contextList2);
                }
            } else {
                MapElement[] mapElementArray = context2.versions;
                MapElement[] mapElementArray2 = new ContextVersion[mapElementArray.length + 1];
                if (Mapper.insertMap(mapElementArray, mapElementArray2, contextVersion)) {
                    context2.versions = mapElementArray2;
                } else {
                    int n2 = Mapper.find(mapElementArray, string3);
                    if (n2 >= 0 && ((ContextVersion)mapElementArray[n2]).name.equals(string3)) {
                        mapElementArray[n2] = contextVersion;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeContextVersion(String string, String string2, String string3) {
        Host host = (Host)Mapper.exactFind((MapElement[])this.hosts, (String)string);
        if (host == null || host.isAlias()) {
            return;
        }
        Host host2 = host;
        synchronized (host2) {
            ContextList contextList = host.contextList;
            Context context = (Context)Mapper.exactFind((MapElement[])contextList.contexts, (String)string2);
            if (context == null) {
                return;
            }
            MapElement[] mapElementArray = context.versions;
            MapElement[] mapElementArray2 = new ContextVersion[mapElementArray.length - 1];
            if (Mapper.removeMap(mapElementArray, mapElementArray2, string3)) {
                if (mapElementArray2.length == 0) {
                    ContextList contextList2 = contextList.removeContext(string2);
                    if (contextList2 != null) {
                        this.updateContextList(host, contextList2);
                    }
                } else {
                    context.versions = mapElementArray2;
                }
            }
        }
    }

    public void pauseContextVersion(Object object, String string, String string2, String string3) {
        ContextVersion contextVersion = this.findContextVersion(string, string2, string3, true);
        if (contextVersion == null || !object.equals(contextVersion.object)) {
            return;
        }
        contextVersion.markPaused();
    }

    private ContextVersion findContextVersion(String string, String string2, String string3, boolean bl) {
        Host host = (Host)Mapper.exactFind((MapElement[])this.hosts, (String)string);
        if (host == null || host.isAlias()) {
            if (!bl) {
                log.error((Object)("No host found: " + string));
            }
            return null;
        }
        Context context = (Context)Mapper.exactFind((MapElement[])host.contextList.contexts, (String)string2);
        if (context == null) {
            if (!bl) {
                log.error((Object)("No context found: " + string2));
            }
            return null;
        }
        ContextVersion contextVersion = (ContextVersion)Mapper.exactFind((MapElement[])context.versions, (String)string3);
        if (contextVersion == null) {
            if (!bl) {
                log.error((Object)("No context version found: " + string2 + " " + string3));
            }
            return null;
        }
        return contextVersion;
    }

    public void addWrapper(String string, String string2, String string3, String string4, Object object, boolean bl, boolean bl2) {
        ContextVersion contextVersion = this.findContextVersion(string, string2, string3, false);
        if (contextVersion == null) {
            return;
        }
        this.addWrapper(contextVersion, string4, object, bl, bl2);
    }

    public void addWrapper(String string, Object object, boolean bl, boolean bl2) {
        this.addWrapper(this.context, string, object, bl, bl2);
    }

    public void addWrappers(String string, String string2, String string3, Collection<WrapperMappingInfo> collection) {
        ContextVersion contextVersion = this.findContextVersion(string, string2, string3, false);
        if (contextVersion == null) {
            return;
        }
        this.addWrappers(contextVersion, collection);
    }

    private void addWrappers(ContextVersion contextVersion, Collection<WrapperMappingInfo> collection) {
        for (WrapperMappingInfo wrapperMappingInfo : collection) {
            this.addWrapper(contextVersion, wrapperMappingInfo.getMapping(), wrapperMappingInfo.getWrapper(), wrapperMappingInfo.isJspWildCard(), wrapperMappingInfo.isResourceOnly());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addWrapper(ContextVersion contextVersion, String string, Object object, boolean bl, boolean bl2) {
        ContextVersion contextVersion2 = contextVersion;
        synchronized (contextVersion2) {
            if (string.endsWith("/*")) {
                MapElement[] mapElementArray = contextVersion.wildcardWrappers;
                MapElement[] mapElementArray2 = new Wrapper[mapElementArray.length + 1];
                String string2 = string.substring(0, string.length() - 2);
                Wrapper wrapper = new Wrapper(string2, object, bl, bl2);
                if (Mapper.insertMap(mapElementArray, mapElementArray2, wrapper)) {
                    contextVersion.wildcardWrappers = mapElementArray2;
                    int n = Mapper.slashCount(wrapper.name);
                    if (n > contextVersion.nesting) {
                        contextVersion.nesting = n;
                    }
                }
            } else if (string.startsWith("*.")) {
                MapElement[] mapElementArray = contextVersion.extensionWrappers;
                MapElement[] mapElementArray3 = new Wrapper[mapElementArray.length + 1];
                String string3 = string.substring(2);
                Wrapper wrapper = new Wrapper(string3, object, bl, bl2);
                if (Mapper.insertMap(mapElementArray, mapElementArray3, wrapper)) {
                    contextVersion.extensionWrappers = mapElementArray3;
                }
            } else if (string.equals("/")) {
                Wrapper wrapper;
                contextVersion.defaultWrapper = wrapper = new Wrapper("", object, bl, bl2);
            } else {
                MapElement[] mapElementArray = contextVersion.exactWrappers;
                MapElement[] mapElementArray4 = new Wrapper[mapElementArray.length + 1];
                String string4 = string.length() == 0 ? "/" : string;
                Wrapper wrapper = new Wrapper(string4, object, bl, bl2);
                if (Mapper.insertMap(mapElementArray, mapElementArray4, wrapper)) {
                    contextVersion.exactWrappers = mapElementArray4;
                }
            }
        }
    }

    public void removeWrapper(String string) {
        this.removeWrapper(this.context, string);
    }

    public void removeWrapper(String string, String string2, String string3, String string4) {
        ContextVersion contextVersion = this.findContextVersion(string, string2, string3, true);
        if (contextVersion == null || contextVersion.isPaused()) {
            return;
        }
        this.removeWrapper(contextVersion, string4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeWrapper(ContextVersion contextVersion, String string) {
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("mapper.removeWrapper", new Object[]{contextVersion.name, string}));
        }
        ContextVersion contextVersion2 = contextVersion;
        synchronized (contextVersion2) {
            if (string.endsWith("/*")) {
                String string2 = string.substring(0, string.length() - 2);
                MapElement[] mapElementArray = contextVersion.wildcardWrappers;
                if (mapElementArray.length == 0) {
                    return;
                }
                MapElement[] mapElementArray2 = new Wrapper[mapElementArray.length - 1];
                if (Mapper.removeMap(mapElementArray, mapElementArray2, string2)) {
                    contextVersion.nesting = 0;
                    for (MapElement mapElement : mapElementArray2) {
                        int n = Mapper.slashCount(((Wrapper)mapElement).name);
                        if (n <= contextVersion.nesting) continue;
                        contextVersion.nesting = n;
                    }
                    contextVersion.wildcardWrappers = mapElementArray2;
                }
            } else if (string.startsWith("*.")) {
                String string3 = string.substring(2);
                MapElement[] mapElementArray = contextVersion.extensionWrappers;
                if (mapElementArray.length == 0) {
                    return;
                }
                MapElement[] mapElementArray3 = new Wrapper[mapElementArray.length - 1];
                if (Mapper.removeMap(mapElementArray, mapElementArray3, string3)) {
                    contextVersion.extensionWrappers = mapElementArray3;
                }
            } else if (string.equals("/")) {
                contextVersion.defaultWrapper = null;
            } else {
                String string4 = string.length() == 0 ? "/" : string;
                MapElement[] mapElementArray = contextVersion.exactWrappers;
                if (mapElementArray.length == 0) {
                    return;
                }
                MapElement[] mapElementArray4 = new Wrapper[mapElementArray.length - 1];
                if (Mapper.removeMap(mapElementArray, mapElementArray4, string4)) {
                    contextVersion.exactWrappers = mapElementArray4;
                }
            }
        }
    }

    public void addWelcomeFile(String string, String string2, String string3, String string4) {
        ContextVersion contextVersion = this.findContextVersion(string, string2, string3, false);
        if (contextVersion == null) {
            return;
        }
        int n = contextVersion.welcomeResources.length + 1;
        String[] stringArray = new String[n];
        System.arraycopy(contextVersion.welcomeResources, 0, stringArray, 0, n - 1);
        stringArray[n - 1] = string4;
        contextVersion.welcomeResources = stringArray;
    }

    public void removeWelcomeFile(String string, String string2, String string3, String string4) {
        int n;
        ContextVersion contextVersion = this.findContextVersion(string, string2, string3, false);
        if (contextVersion == null || contextVersion.isPaused()) {
            return;
        }
        int n2 = -1;
        for (n = 0; n < contextVersion.welcomeResources.length; ++n) {
            if (!string4.equals(contextVersion.welcomeResources[n])) continue;
            n2 = n;
            break;
        }
        if (n2 > -1) {
            n = contextVersion.welcomeResources.length - 1;
            String[] stringArray = new String[n];
            System.arraycopy(contextVersion.welcomeResources, 0, stringArray, 0, n2);
            if (n2 < n) {
                System.arraycopy(contextVersion.welcomeResources, n2 + 1, stringArray, n2, n - n2);
            }
            contextVersion.welcomeResources = stringArray;
        }
    }

    public void clearWelcomeFiles(String string, String string2, String string3) {
        ContextVersion contextVersion = this.findContextVersion(string, string2, string3, false);
        if (contextVersion == null) {
            return;
        }
        contextVersion.welcomeResources = new String[0];
    }

    public void map(MessageBytes messageBytes, MessageBytes messageBytes2, String string, MappingData mappingData) throws Exception {
        if (messageBytes.isNull()) {
            messageBytes.getCharChunk().append(this.defaultHostName);
        }
        messageBytes.toChars();
        messageBytes2.toChars();
        this.internalMap(messageBytes.getCharChunk(), messageBytes2.getCharChunk(), string, mappingData);
    }

    public void map(MessageBytes messageBytes, MappingData mappingData) throws Exception {
        messageBytes.toChars();
        CharChunk charChunk = messageBytes.getCharChunk();
        charChunk.setLimit(-1);
        this.internalMapWrapper(this.context, charChunk, mappingData);
    }

    private final void internalMap(CharChunk charChunk, CharChunk charChunk2, String string, MappingData mappingData) throws Exception {
        if (mappingData.host != null) {
            throw new AssertionError();
        }
        charChunk2.setLimit(-1);
        MapElement[] mapElementArray = this.hosts;
        Host host = (Host)Mapper.exactFindIgnoreCase((MapElement[])mapElementArray, (CharChunk)charChunk);
        if (host == null) {
            if (this.defaultHostName == null) {
                return;
            }
            host = (Host)Mapper.exactFind((MapElement[])mapElementArray, (String)this.defaultHostName);
            if (host == null) {
                return;
            }
        }
        mappingData.host = host.object;
        ContextList contextList = host.contextList;
        MapElement[] mapElementArray2 = contextList.contexts;
        int n = contextList.nesting;
        int n2 = Mapper.find(mapElementArray2, charChunk2);
        if (n2 == -1) {
            return;
        }
        int n3 = -1;
        int n4 = charChunk2.getEnd();
        int n5 = -1;
        boolean bl = false;
        MapElement mapElement = null;
        while (n2 >= 0) {
            mapElement = mapElementArray2[n2];
            if (charChunk2.startsWith(((Context)mapElement).name)) {
                n5 = ((Context)mapElement).name.length();
                if (charChunk2.getLength() == n5) {
                    bl = true;
                    break;
                }
                if (charChunk2.startsWithIgnoreCase("/", n5)) {
                    bl = true;
                    break;
                }
            }
            n3 = n3 == -1 ? Mapper.nthSlash(charChunk2, n + 1) : Mapper.lastSlash(charChunk2);
            charChunk2.setEnd(n3);
            n2 = Mapper.find(mapElementArray2, charChunk2);
        }
        charChunk2.setEnd(n4);
        if (!bl) {
            mapElement = ((Context)mapElementArray2[0]).name.equals("") ? mapElementArray2[0] : null;
        }
        if (mapElement == null) {
            return;
        }
        mappingData.contextPath.setString(((Context)mapElement).name);
        ContextVersion contextVersion = null;
        MapElement[] mapElementArray3 = ((Context)mapElement).versions;
        int n6 = mapElementArray3.length;
        if (n6 > 1) {
            Object[] objectArray = new Object[mapElementArray3.length];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = mapElementArray3[i].object;
            }
            mappingData.contexts = objectArray;
            if (string != null) {
                contextVersion = (ContextVersion)Mapper.exactFind((MapElement[])mapElementArray3, (String)string);
            }
        }
        if (contextVersion == null) {
            contextVersion = mapElementArray3[n6 - 1];
        }
        mappingData.context = contextVersion.object;
        mappingData.contextSlashCount = contextVersion.slashCount;
        if (!contextVersion.isPaused()) {
            this.internalMapWrapper(contextVersion, charChunk2, mappingData);
        }
    }

    private final void internalMapWrapper(ContextVersion contextVersion, CharChunk charChunk, MappingData mappingData) throws Exception {
        Object object;
        char[] cArray;
        boolean bl;
        Wrapper[] wrapperArray;
        int n = charChunk.getOffset();
        int n2 = charChunk.getEnd();
        boolean bl2 = false;
        int n3 = contextVersion.path.length();
        if (n3 == n2 - n) {
            bl2 = true;
        }
        int n4 = n + n3;
        charChunk.setOffset(n4);
        Wrapper[] wrapperArray2 = contextVersion.exactWrappers;
        this.internalMapExactWrapper(wrapperArray2, charChunk, mappingData);
        boolean bl3 = false;
        Wrapper[] wrapperArray3 = contextVersion.wildcardWrappers;
        if (mappingData.wrapper == null) {
            this.internalMapWildcardWrapper(wrapperArray3, contextVersion.nesting, charChunk, mappingData);
            if (mappingData.wrapper != null && mappingData.jspWildCard) {
                wrapperArray = (Wrapper[])charChunk.getBuffer();
                if (wrapperArray[n2 - 1] == 47) {
                    mappingData.wrapper = null;
                    bl3 = true;
                } else {
                    mappingData.wrapperPath.setChars((char[])wrapperArray, charChunk.getStart(), charChunk.getLength());
                    mappingData.pathInfo.recycle();
                }
            }
        }
        if (mappingData.wrapper == null && bl2 && contextVersion.mapperContextRootRedirectEnabled) {
            charChunk.append('/');
            n2 = charChunk.getEnd();
            mappingData.redirectPath.setChars(charChunk.getBuffer(), n, n2 - n);
            charChunk.setEnd(n2 - 1);
            return;
        }
        wrapperArray = contextVersion.extensionWrappers;
        if (mappingData.wrapper == null && !bl3) {
            this.internalMapExtensionWrapper(wrapperArray, charChunk, mappingData, true);
        }
        if (mappingData.wrapper == null) {
            bl = bl3;
            if (!bl) {
                cArray = charChunk.getBuffer();
                boolean bl4 = bl = cArray[n2 - 1] == '/';
            }
            if (bl) {
                for (int i = 0; i < contextVersion.welcomeResources.length && mappingData.wrapper == null; ++i) {
                    charChunk.setOffset(n);
                    charChunk.setEnd(n2);
                    charChunk.append(contextVersion.welcomeResources[i], 0, contextVersion.welcomeResources[i].length());
                    charChunk.setOffset(n4);
                    this.internalMapExactWrapper(wrapperArray2, charChunk, mappingData);
                    if (mappingData.wrapper == null) {
                        this.internalMapWildcardWrapper(wrapperArray3, contextVersion.nesting, charChunk, mappingData);
                    }
                    if (mappingData.wrapper != null || contextVersion.resources == null) continue;
                    object = null;
                    String string = charChunk.toString();
                    try {
                        object = contextVersion.resources.lookup(string);
                    }
                    catch (NamingException namingException) {
                        // empty catch block
                    }
                    if (object == null || object instanceof DirContext) continue;
                    this.internalMapExtensionWrapper(wrapperArray, charChunk, mappingData, true);
                    if (mappingData.wrapper != null || contextVersion.defaultWrapper == null) continue;
                    mappingData.wrapper = contextVersion.defaultWrapper.object;
                    mappingData.requestPath.setChars(charChunk.getBuffer(), charChunk.getStart(), charChunk.getLength());
                    mappingData.wrapperPath.setChars(charChunk.getBuffer(), charChunk.getStart(), charChunk.getLength());
                    mappingData.requestPath.setString(string);
                    mappingData.wrapperPath.setString(string);
                }
                charChunk.setOffset(n4);
                charChunk.setEnd(n2);
            }
        }
        if (mappingData.wrapper == null) {
            bl = bl3;
            if (!bl) {
                cArray = charChunk.getBuffer();
                boolean bl5 = bl = cArray[n2 - 1] == '/';
            }
            if (bl) {
                for (int i = 0; i < contextVersion.welcomeResources.length && mappingData.wrapper == null; ++i) {
                    charChunk.setOffset(n);
                    charChunk.setEnd(n2);
                    charChunk.append(contextVersion.welcomeResources[i], 0, contextVersion.welcomeResources[i].length());
                    charChunk.setOffset(n4);
                    this.internalMapExtensionWrapper(wrapperArray, charChunk, mappingData, false);
                }
                charChunk.setOffset(n4);
                charChunk.setEnd(n2);
            }
        }
        if (mappingData.wrapper == null && !bl3) {
            if (contextVersion.defaultWrapper != null) {
                mappingData.wrapper = contextVersion.defaultWrapper.object;
                mappingData.requestPath.setChars(charChunk.getBuffer(), charChunk.getStart(), charChunk.getLength());
                mappingData.wrapperPath.setChars(charChunk.getBuffer(), charChunk.getStart(), charChunk.getLength());
            }
            char[] cArray2 = charChunk.getBuffer();
            if (contextVersion.resources != null && cArray2[n2 - 1] != '/') {
                Object object2 = null;
                object = charChunk.toString();
                try {
                    object2 = ((String)object).length() == 0 ? contextVersion.resources.lookup("/") : contextVersion.resources.lookup((String)object);
                }
                catch (NamingException namingException) {
                    // empty catch block
                }
                if (object2 != null && object2 instanceof DirContext && contextVersion.mapperDirectoryRedirectEnabled) {
                    charChunk.setOffset(n);
                    charChunk.append('/');
                    mappingData.redirectPath.setChars(charChunk.getBuffer(), charChunk.getStart(), charChunk.getLength());
                } else {
                    mappingData.requestPath.setString((String)object);
                    mappingData.wrapperPath.setString((String)object);
                }
            }
        }
        charChunk.setOffset(n);
        charChunk.setEnd(n2);
    }

    private final void internalMapExactWrapper(Wrapper[] wrapperArray, CharChunk charChunk, MappingData mappingData) {
        Wrapper wrapper = (Wrapper)Mapper.exactFind((MapElement[])wrapperArray, (CharChunk)charChunk);
        if (wrapper != null) {
            mappingData.requestPath.setString(wrapper.name);
            mappingData.wrapper = wrapper.object;
            if (charChunk.equals("/")) {
                mappingData.pathInfo.setString("/");
                mappingData.wrapperPath.setString("");
                mappingData.contextPath.setString("");
            } else {
                mappingData.wrapperPath.setString(wrapper.name);
            }
        }
    }

    private final void internalMapWildcardWrapper(Wrapper[] wrapperArray, int n, CharChunk charChunk, MappingData mappingData) {
        int n2 = charChunk.getEnd();
        int n3 = -1;
        int n4 = -1;
        int n5 = Mapper.find((MapElement[])wrapperArray, charChunk);
        if (n5 != -1) {
            boolean bl = false;
            while (n5 >= 0) {
                if (charChunk.startsWith(wrapperArray[n5].name)) {
                    n4 = wrapperArray[n5].name.length();
                    if (charChunk.getLength() == n4) {
                        bl = true;
                        break;
                    }
                    if (charChunk.startsWithIgnoreCase("/", n4)) {
                        bl = true;
                        break;
                    }
                }
                n3 = n3 == -1 ? Mapper.nthSlash(charChunk, n + 1) : Mapper.lastSlash(charChunk);
                charChunk.setEnd(n3);
                n5 = Mapper.find((MapElement[])wrapperArray, charChunk);
            }
            charChunk.setEnd(n2);
            if (bl) {
                mappingData.wrapperPath.setString(wrapperArray[n5].name);
                if (charChunk.getLength() > n4) {
                    mappingData.pathInfo.setChars(charChunk.getBuffer(), charChunk.getOffset() + n4, charChunk.getLength() - n4);
                }
                mappingData.requestPath.setChars(charChunk.getBuffer(), charChunk.getOffset(), charChunk.getLength());
                mappingData.wrapper = wrapperArray[n5].object;
                mappingData.jspWildCard = wrapperArray[n5].jspWildCard;
            }
        }
    }

    private final void internalMapExtensionWrapper(Wrapper[] wrapperArray, CharChunk charChunk, MappingData mappingData, boolean bl) {
        int n;
        char[] cArray = charChunk.getBuffer();
        int n2 = charChunk.getEnd();
        int n3 = charChunk.getOffset();
        int n4 = -1;
        for (n = n2 - 1; n >= n3; --n) {
            if (cArray[n] != '/') continue;
            n4 = n;
            break;
        }
        if (n4 >= 0) {
            n = -1;
            for (int i = n2 - 1; i > n4; --i) {
                if (cArray[i] != '.') continue;
                n = i;
                break;
            }
            if (n >= 0) {
                charChunk.setOffset(n + 1);
                charChunk.setEnd(n2);
                Wrapper wrapper = (Wrapper)Mapper.exactFind((MapElement[])wrapperArray, (CharChunk)charChunk);
                if (wrapper != null && (bl || !wrapper.resourceOnly)) {
                    mappingData.wrapperPath.setChars(cArray, n3, n2 - n3);
                    mappingData.requestPath.setChars(cArray, n3, n2 - n3);
                    mappingData.wrapper = wrapper.object;
                }
                charChunk.setOffset(n3);
                charChunk.setEnd(n2);
            }
        }
    }

    private static final int find(MapElement[] mapElementArray, CharChunk charChunk) {
        return Mapper.find(mapElementArray, charChunk, charChunk.getStart(), charChunk.getEnd());
    }

    private static final int find(MapElement[] mapElementArray, CharChunk charChunk, int n, int n2) {
        int n3 = 0;
        int n4 = mapElementArray.length - 1;
        if (n4 == -1) {
            return -1;
        }
        if (Mapper.compare(charChunk, n, n2, mapElementArray[0].name) < 0) {
            return -1;
        }
        if (n4 == 0) {
            return 0;
        }
        int n5 = 0;
        do {
            n5 = (n4 + n3) / 2;
            int n6 = Mapper.compare(charChunk, n, n2, mapElementArray[n5].name);
            if (n6 == 1) {
                n3 = n5;
                continue;
            }
            if (n6 == 0) {
                return n5;
            }
            n4 = n5;
        } while (n4 - n3 != 1);
        int n7 = Mapper.compare(charChunk, n, n2, mapElementArray[n4].name);
        if (n7 < 0) {
            return n3;
        }
        return n4;
    }

    private static final int findIgnoreCase(MapElement[] mapElementArray, CharChunk charChunk) {
        return Mapper.findIgnoreCase(mapElementArray, charChunk, charChunk.getStart(), charChunk.getEnd());
    }

    private static final int findIgnoreCase(MapElement[] mapElementArray, CharChunk charChunk, int n, int n2) {
        int n3 = 0;
        int n4 = mapElementArray.length - 1;
        if (n4 == -1) {
            return -1;
        }
        if (Mapper.compareIgnoreCase(charChunk, n, n2, mapElementArray[0].name) < 0) {
            return -1;
        }
        if (n4 == 0) {
            return 0;
        }
        int n5 = 0;
        do {
            n5 = (n4 + n3) / 2;
            int n6 = Mapper.compareIgnoreCase(charChunk, n, n2, mapElementArray[n5].name);
            if (n6 == 1) {
                n3 = n5;
                continue;
            }
            if (n6 == 0) {
                return n5;
            }
            n4 = n5;
        } while (n4 - n3 != 1);
        int n7 = Mapper.compareIgnoreCase(charChunk, n, n2, mapElementArray[n4].name);
        if (n7 < 0) {
            return n3;
        }
        return n4;
    }

    private static final int find(MapElement[] mapElementArray, String string) {
        int n = 0;
        int n2 = mapElementArray.length - 1;
        if (n2 == -1) {
            return -1;
        }
        if (string.compareTo(mapElementArray[0].name) < 0) {
            return -1;
        }
        if (n2 == 0) {
            return 0;
        }
        int n3 = 0;
        do {
            n3 = (n2 + n) / 2;
            int n4 = string.compareTo(mapElementArray[n3].name);
            if (n4 > 0) {
                n = n3;
                continue;
            }
            if (n4 == 0) {
                return n3;
            }
            n2 = n3;
        } while (n2 - n != 1);
        int n5 = string.compareTo(mapElementArray[n2].name);
        if (n5 < 0) {
            return n;
        }
        return n2;
    }

    private static final <E extends MapElement> E exactFind(E[] EArray, String string) {
        int n = Mapper.find(EArray, string);
        if (n >= 0) {
            E e = EArray[n];
            if (string.equals(((MapElement)e).name)) {
                return e;
            }
        }
        return null;
    }

    private static final <E extends MapElement> E exactFind(E[] EArray, CharChunk charChunk) {
        int n = Mapper.find(EArray, charChunk);
        if (n >= 0) {
            E e = EArray[n];
            if (charChunk.equals(((MapElement)e).name)) {
                return e;
            }
        }
        return null;
    }

    private static final <E extends MapElement> E exactFindIgnoreCase(E[] EArray, CharChunk charChunk) {
        int n = Mapper.findIgnoreCase(EArray, charChunk);
        if (n >= 0) {
            E e = EArray[n];
            if (charChunk.equalsIgnoreCase(((MapElement)e).name)) {
                return e;
            }
        }
        return null;
    }

    private static final int compare(CharChunk charChunk, int n, int n2, String string) {
        int n3 = 0;
        char[] cArray = charChunk.getBuffer();
        int n4 = string.length();
        if (n2 - n < n4) {
            n4 = n2 - n;
        }
        for (int i = 0; i < n4 && n3 == 0; ++i) {
            if (cArray[i + n] > string.charAt(i)) {
                n3 = 1;
                continue;
            }
            if (cArray[i + n] >= string.charAt(i)) continue;
            n3 = -1;
        }
        if (n3 == 0) {
            if (string.length() > n2 - n) {
                n3 = -1;
            } else if (string.length() < n2 - n) {
                n3 = 1;
            }
        }
        return n3;
    }

    private static final int compareIgnoreCase(CharChunk charChunk, int n, int n2, String string) {
        int n3 = 0;
        char[] cArray = charChunk.getBuffer();
        int n4 = string.length();
        if (n2 - n < n4) {
            n4 = n2 - n;
        }
        for (int i = 0; i < n4 && n3 == 0; ++i) {
            if (Ascii.toLower(cArray[i + n]) > Ascii.toLower(string.charAt(i))) {
                n3 = 1;
                continue;
            }
            if (Ascii.toLower(cArray[i + n]) >= Ascii.toLower(string.charAt(i))) continue;
            n3 = -1;
        }
        if (n3 == 0) {
            if (string.length() > n2 - n) {
                n3 = -1;
            } else if (string.length() < n2 - n) {
                n3 = 1;
            }
        }
        return n3;
    }

    private static final int lastSlash(CharChunk charChunk) {
        char[] cArray = charChunk.getBuffer();
        int n = charChunk.getEnd();
        int n2 = charChunk.getStart();
        int n3 = n;
        while (n3 > n2 && cArray[--n3] != '/') {
        }
        return n3;
    }

    private static final int nthSlash(CharChunk charChunk, int n) {
        int n2;
        char[] cArray = charChunk.getBuffer();
        int n3 = charChunk.getEnd();
        int n4 = n2 = charChunk.getStart();
        int n5 = 0;
        while (n4 < n3) {
            if (cArray[n4++] != '/' || ++n5 != n) continue;
            --n4;
            break;
        }
        return n4;
    }

    private static final int slashCount(String string) {
        int n = -1;
        int n2 = 0;
        while ((n = string.indexOf(47, n + 1)) != -1) {
            ++n2;
        }
        return n2;
    }

    private static final boolean insertMap(MapElement[] mapElementArray, MapElement[] mapElementArray2, MapElement mapElement) {
        int n = Mapper.find(mapElementArray, mapElement.name);
        if (n != -1 && mapElement.name.equals(mapElementArray[n].name)) {
            return false;
        }
        System.arraycopy(mapElementArray, 0, mapElementArray2, 0, n + 1);
        mapElementArray2[n + 1] = mapElement;
        System.arraycopy(mapElementArray, n + 1, mapElementArray2, n + 2, mapElementArray.length - n - 1);
        return true;
    }

    private static final boolean removeMap(MapElement[] mapElementArray, MapElement[] mapElementArray2, String string) {
        int n = Mapper.find(mapElementArray, string);
        if (n != -1 && string.equals(mapElementArray[n].name)) {
            System.arraycopy(mapElementArray, 0, mapElementArray2, 0, n);
            System.arraycopy(mapElementArray, n + 1, mapElementArray2, n, mapElementArray.length - n - 1);
            return true;
        }
        return false;
    }

    protected static class Wrapper
    extends MapElement {
        public final boolean jspWildCard;
        public final boolean resourceOnly;

        public Wrapper(String string, Object object, boolean bl, boolean bl2) {
            super(string, object);
            this.jspWildCard = bl;
            this.resourceOnly = bl2;
        }
    }

    protected static final class ContextVersion
    extends MapElement {
        public String path = null;
        public int slashCount;
        public String[] welcomeResources = new String[0];
        public javax.naming.Context resources = null;
        public Wrapper defaultWrapper = null;
        public Wrapper[] exactWrappers = new Wrapper[0];
        public Wrapper[] wildcardWrappers = new Wrapper[0];
        public Wrapper[] extensionWrappers = new Wrapper[0];
        public int nesting = 0;
        public boolean mapperContextRootRedirectEnabled = false;
        public boolean mapperDirectoryRedirectEnabled = false;
        private volatile boolean paused;

        public ContextVersion() {
            super(null, null);
        }

        public ContextVersion(String string, Object object) {
            super(string, object);
        }

        public boolean isPaused() {
            return this.paused;
        }

        public void markPaused() {
            this.paused = true;
        }
    }

    protected static final class Context
    extends MapElement {
        public volatile ContextVersion[] versions;

        public Context(String string, ContextVersion contextVersion) {
            super(string, null);
            this.versions = new ContextVersion[]{contextVersion};
        }
    }

    protected static final class ContextList {
        public final Context[] contexts;
        public final int nesting;

        public ContextList() {
            this(new Context[0], 0);
        }

        private ContextList(Context[] contextArray, int n) {
            this.contexts = contextArray;
            this.nesting = n;
        }

        public ContextList addContext(Context context, int n) {
            MapElement[] mapElementArray = new Context[this.contexts.length + 1];
            if (Mapper.insertMap(this.contexts, mapElementArray, context)) {
                return new ContextList((Context[])mapElementArray, Math.max(this.nesting, n));
            }
            return null;
        }

        public ContextList removeContext(String string) {
            MapElement[] mapElementArray = new Context[this.contexts.length - 1];
            if (Mapper.removeMap(this.contexts, mapElementArray, string)) {
                int n = 0;
                for (MapElement mapElement : mapElementArray) {
                    n = Math.max(n, Mapper.slashCount(((Context)mapElement).name));
                }
                return new ContextList((Context[])mapElementArray, n);
            }
            return null;
        }
    }

    protected static final class Host
    extends MapElement {
        public volatile ContextList contextList;
        private final Host realHost;
        private final List<Host> aliases;

        public Host(String string, Object object) {
            super(string, object);
            this.realHost = this;
            this.contextList = new ContextList();
            this.aliases = new CopyOnWriteArrayList<Host>();
        }

        public Host(String string, Host host) {
            super(string, host.object);
            this.realHost = host;
            this.contextList = host.contextList;
            this.aliases = null;
        }

        public boolean isAlias() {
            return this.realHost != this;
        }

        public Host getRealHost() {
            return this.realHost;
        }

        public String getRealHostName() {
            return this.realHost.name;
        }

        public Collection<Host> getAliases() {
            return this.aliases;
        }

        public void addAlias(Host host) {
            this.aliases.add(host);
        }

        public void addAliases(Collection<? extends Host> collection) {
            this.aliases.addAll(collection);
        }

        public void removeAlias(Host host) {
            this.aliases.remove(host);
        }
    }

    protected static abstract class MapElement {
        public final String name;
        public final Object object;

        public MapElement(String string, Object object) {
            this.name = string;
            this.object = object;
        }
    }
}

