/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.ui.memory;

import java.awt.AWTKeyStroke;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.HashSet;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumnModel;
import org.graalvm.visualvm.lib.jfluid.results.CCTNode;
import org.graalvm.visualvm.lib.jfluid.results.ExportDataDumper;
import org.graalvm.visualvm.lib.jfluid.results.memory.LivenessMemoryResultsSnapshot;
import org.graalvm.visualvm.lib.jfluid.results.memory.MemoryCCTManager;
import org.graalvm.visualvm.lib.jfluid.results.memory.MemoryResultsSnapshot;
import org.graalvm.visualvm.lib.jfluid.results.memory.PresoObjAllocCCTNode;
import org.graalvm.visualvm.lib.jfluid.results.memory.PresoObjLivenessCCTNode;
import org.graalvm.visualvm.lib.jfluid.utils.StringUtils;
import org.graalvm.visualvm.lib.profiler.api.icons.Icons;
import org.graalvm.visualvm.lib.ui.UIConstants;
import org.graalvm.visualvm.lib.ui.UIUtils;
import org.graalvm.visualvm.lib.ui.components.FilterComponent;
import org.graalvm.visualvm.lib.ui.components.JTreeTable;
import org.graalvm.visualvm.lib.ui.components.table.CustomBarCellRenderer;
import org.graalvm.visualvm.lib.ui.components.treetable.AbstractTreeTableModel;
import org.graalvm.visualvm.lib.ui.components.treetable.ExtendedTreeTableModel;
import org.graalvm.visualvm.lib.ui.components.treetable.JTreeTablePanel;
import org.graalvm.visualvm.lib.ui.components.treetable.TreeTableModel;
import org.graalvm.visualvm.lib.ui.memory.MemoryResUserActionsHandler;
import org.graalvm.visualvm.lib.ui.memory.ReverseMemCallGraphPanel;

public class SnapshotReverseMemCallGraphPanel
extends ReverseMemCallGraphPanel {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.graalvm.visualvm.lib.ui.memory.Bundle");
    private static final String NO_STACK_TRACES_MSG = messages.getString("SnapshotReverseMemCallGraphPanel_NoStackTracesMsg");
    private static final String TREETABLE_ACCESS_NAME = messages.getString("SnapshotReverseMemCallGraphPanel_TreeTableAccessName");
    private static final String METHOD_NAME_FILTER = messages.getString("MemoryResultsPanel_MethodNameFilterHint");
    protected int classId;
    private AbstractTreeTableModel abstractTreeTableModel;
    private JPanel noContentPanel;
    private MemoryCCTManager callGraphManager;
    private MemoryResultsSnapshot snapshot;
    private boolean initialSortingOrder;
    private int initialSortingColumn;

    public SnapshotReverseMemCallGraphPanel(MemoryResultsSnapshot snapshot, MemoryResUserActionsHandler actionsHandler) {
        super(actionsHandler, snapshot instanceof LivenessMemoryResultsSnapshot);
        this.snapshot = snapshot;
        this.noContentPanel = new JPanel();
        this.noContentPanel.setLayout(new BorderLayout());
        this.noContentPanel.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        JLabel noContentIcon = new JLabel(Icons.getIcon((String)"ProfilerIcons.SnapshotMemory32"));
        noContentIcon.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 5));
        noContentIcon.setVerticalAlignment(1);
        noContentIcon.setEnabled(false);
        JTextArea noContentText = new JTextArea(NO_STACK_TRACES_MSG);
        noContentText.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        noContentText.setFont(noContentText.getFont().deriveFont(14));
        noContentText.setEditable(false);
        noContentText.setEnabled(false);
        noContentText.setWrapStyleWord(true);
        noContentText.setLineWrap(true);
        noContentText.setBackground(this.noContentPanel.getBackground());
        JPanel containerPanel = new JPanel(new BorderLayout());
        containerPanel.add((Component)noContentIcon, "West");
        containerPanel.add((Component)noContentText, "Center");
        this.noContentPanel.add((Component)containerPanel, "North");
        this.setDefaultSorting();
    }

    public void setClassId(int classId) {
        this.classId = classId;
        this.callGraphManager = new MemoryCCTManager(this.snapshot, classId, true);
        if (!this.callGraphManager.isEmpty()) {
            this.customBarCellRenderer = new CustomBarCellRenderer(0L, this.callGraphManager.getRootNode().totalObjSize);
            this.columnRenderers[1] = this.customBarCellRenderer;
        }
    }

    public BufferedImage getCurrentViewScreenshot(boolean onlyVisibleArea) {
        if (this.treeTablePanel == null || this.treeTable == null) {
            return null;
        }
        if (onlyVisibleArea) {
            return UIUtils.createScreenshot(this.treeTablePanel.getScrollPane());
        }
        return UIUtils.createScreenshot(this.treeTable);
    }

    private StringBuffer getCSVHeader(String separator) {
        String newLine = "\r\n";
        String quote = "\"";
        StringBuffer result = new StringBuffer(quote + this.columnNames[0] + quote + separator);
        for (int i = 2; i < this.columnNames.length; ++i) {
            result.append(quote).append(this.columnNames[i]).append(quote).append(separator);
        }
        result.append(messages.getString("SnapshotReverseMemCallGraphPanel_ExportAddedColumnName")).append(newLine);
        return result;
    }

    public void exportData(int exportedFileType, ExportDataDumper eDD, String viewName) {
        if (this.callGraphManager.getRootNode() instanceof PresoObjLivenessCCTNode) {
            ((PresoObjLivenessCCTNode)this.callGraphManager.getRootNode()).setDecimalFormat();
            switch (exportedFileType) {
                case 1: {
                    eDD.dumpData((CharSequence)this.getCSVHeader(","));
                    ((PresoObjLivenessCCTNode)this.callGraphManager.getRootNode()).exportCSVData(",", 0, eDD);
                    eDD.close();
                    break;
                }
                case 2: {
                    eDD.dumpData((CharSequence)this.getCSVHeader(";"));
                    ((PresoObjLivenessCCTNode)this.callGraphManager.getRootNode()).exportCSVData(";", 0, eDD);
                    eDD.close();
                    break;
                }
                case 3: {
                    eDD.dumpData((CharSequence)this.getXMLHeader(viewName));
                    ((PresoObjLivenessCCTNode)this.callGraphManager.getRootNode()).exportXMLData(eDD, " ");
                    eDD.dumpDataAndClose(this.getXMLFooter());
                    break;
                }
                case 4: {
                    eDD.dumpData((CharSequence)this.getHTMLHeader(viewName));
                    ((PresoObjLivenessCCTNode)this.callGraphManager.getRootNode()).exportHTMLData(eDD, 0);
                    eDD.dumpDataAndClose(this.getHTMLFooter());
                }
            }
        } else {
            switch (exportedFileType) {
                case 1: {
                    eDD.dumpData((CharSequence)this.getCSVHeader(","));
                    this.callGraphManager.getRootNode().exportCSVData(",", 0, eDD);
                    eDD.close();
                    break;
                }
                case 2: {
                    eDD.dumpData((CharSequence)this.getCSVHeader(";"));
                    this.callGraphManager.getRootNode().exportCSVData(";", 0, eDD);
                    eDD.close();
                    break;
                }
                case 3: {
                    eDD.dumpData((CharSequence)this.getXMLHeader(viewName));
                    this.callGraphManager.getRootNode().exportXMLData(eDD, " ");
                    eDD.dumpDataAndClose(this.getXMLFooter());
                    break;
                }
                case 4: {
                    eDD.dumpData((CharSequence)this.getHTMLHeader(viewName));
                    this.callGraphManager.getRootNode().exportHTMLData(eDD, 0);
                    eDD.dumpDataAndClose(this.getHTMLFooter());
                }
            }
        }
    }

    private StringBuffer getHTMLHeader(String viewName) {
        StringBuffer result = new StringBuffer("<HTML><HEAD><meta http-equiv=\"Content-type\" content=\"text/html; charset=utf-8\" /><TITLE>" + viewName + "</TITLE><style type=\"text/css\">pre.method{overflow:auto;width:600;height:30;vertical-align:baseline}pre.parent{overflow:auto;width:400;height:30;vertical-align:baseline}td.method{text-align:left;width:600}td.parent{text-align:left;width:400}td.right{text-align:right;white-space:nowrap}</style></HEAD><BODY><table border=\"1\"><tr><th>" + this.columnNames[0] + "</th>");
        for (int i = 2; i < this.columnNames.length; ++i) {
            result.append("<th>").append(this.columnNames[i]).append("</th>");
        }
        result.append("<th>").append(messages.getString("SnapshotReverseMemCallGraphPanel_ExportAddedColumnName")).append("</th></tr>");
        return result;
    }

    private StringBuffer getHTMLFooter() {
        return new StringBuffer("</TABLE></BODY></HTML>");
    }

    private StringBuffer getXMLHeader(String viewName) {
        String newline = System.getProperty("line.separator");
        StringBuffer result = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + newline + "<ExportedView Name=\"" + viewName + "\" type=\"tree\">" + newline + "<tree>" + newline);
        return result;
    }

    private StringBuffer getXMLFooter() {
        String newline = System.getProperty("line.separator");
        StringBuffer result = new StringBuffer("</tree>" + newline + "</ExportedView>");
        return result;
    }

    public void setDefaultSorting() {
        this.setSorting(1, false);
    }

    public boolean isEmpty() {
        return this.callGraphManager == null || this.callGraphManager.isEmpty();
    }

    public void setSorting(int sColumn, boolean sOrder) {
        if (sColumn == -1) {
            this.setDefaultSorting();
        } else {
            this.initialSortingColumn = sColumn;
            this.initialSortingOrder = sOrder;
        }
    }

    public boolean fitsVisibleArea() {
        return !this.treeTablePanel.getScrollPane().getVerticalScrollBar().isEnabled();
    }

    public boolean hasView() {
        return this.treeTable != null;
    }

    @Override
    public void prepareResults() {
        if (this.callGraphManager == null || this.callGraphManager.isEmpty()) {
            this.removeAll();
            this.add((Component)this.noContentPanel, "Center");
        } else {
            this.abstractTreeTableModel = new AbstractTreeTableModel((CCTNode)this.callGraphManager.getRootNode(), this.initialSortingColumn, this.initialSortingOrder){

                @Override
                public int getColumnCount() {
                    return SnapshotReverseMemCallGraphPanel.this.columnNames.length;
                }

                @Override
                public String getColumnName(int column) {
                    return SnapshotReverseMemCallGraphPanel.this.columnNames[column];
                }

                @Override
                public Class getColumnClass(int column) {
                    if (column == 0) {
                        return TreeTableModel.class;
                    }
                    return Object.class;
                }

                @Override
                public Object getValueAt(Object node, int column) {
                    if (SnapshotReverseMemCallGraphPanel.this.extendedResults) {
                        PresoObjLivenessCCTNode pNode = (PresoObjLivenessCCTNode)node;
                        switch (column) {
                            case 0: {
                                return pNode;
                            }
                            case 1: {
                                return new Long(pNode.totalObjSize);
                            }
                            case 2: {
                                long value = ((PresoObjLivenessCCTNode)this.root).totalObjSize;
                                return SnapshotReverseMemCallGraphPanel.this.intFormat.format(pNode.totalObjSize) + " B (" + (value == 0L ? "-%" : SnapshotReverseMemCallGraphPanel.this.percentFormat.format((float)pNode.totalObjSize / (float)value)) + ")";
                            }
                            case 3: {
                                long value = ((PresoObjLivenessCCTNode)this.root).nLiveObjects;
                                return SnapshotReverseMemCallGraphPanel.this.intFormat.format(pNode.nLiveObjects) + " (" + (value == 0L ? "-%" : SnapshotReverseMemCallGraphPanel.this.percentFormat.format((float)pNode.nLiveObjects / (float)value)) + ")";
                            }
                            case 4: {
                                return SnapshotReverseMemCallGraphPanel.this.intFormat.format(pNode.nCalls);
                            }
                            case 5: {
                                return StringUtils.floatPerCentToString((float)pNode.avgObjectAge);
                            }
                            case 6: {
                                return SnapshotReverseMemCallGraphPanel.this.intFormat.format(pNode.survGen);
                            }
                        }
                    } else {
                        PresoObjAllocCCTNode pNode = (PresoObjAllocCCTNode)node;
                        switch (column) {
                            case 0: {
                                return pNode;
                            }
                            case 1: {
                                return new Long(pNode.totalObjSize);
                            }
                            case 2: {
                                long value = ((PresoObjAllocCCTNode)this.root).totalObjSize;
                                return SnapshotReverseMemCallGraphPanel.this.intFormat.format(pNode.totalObjSize) + " B (" + (value == 0L ? "-%" : SnapshotReverseMemCallGraphPanel.this.percentFormat.format((float)pNode.totalObjSize / (float)value)) + ")";
                            }
                            case 3: {
                                long value = ((PresoObjAllocCCTNode)this.root).nCalls;
                                return SnapshotReverseMemCallGraphPanel.this.intFormat.format(pNode.nCalls) + " (" + (value == 0L ? "-%" : SnapshotReverseMemCallGraphPanel.this.percentFormat.format((float)pNode.nCalls / (float)value)) + ")";
                            }
                        }
                    }
                    return null;
                }

                @Override
                public String getColumnToolTipText(int col) {
                    return SnapshotReverseMemCallGraphPanel.this.columnToolTips[col];
                }

                @Override
                public void sortByColumn(int column, boolean order) {
                    if (SnapshotReverseMemCallGraphPanel.this.extendedResults) {
                        PresoObjLivenessCCTNode pRoot = (PresoObjLivenessCCTNode)this.root;
                        switch (column) {
                            case 0: {
                                pRoot.sortChildren(6, order);
                                break;
                            }
                            case 1: 
                            case 2: {
                                pRoot.sortChildren(1, order);
                                break;
                            }
                            case 3: {
                                pRoot.sortChildren(2, order);
                                break;
                            }
                            case 4: {
                                pRoot.sortChildren(3, order);
                                break;
                            }
                            case 5: {
                                pRoot.sortChildren(4, order);
                                break;
                            }
                            case 6: {
                                pRoot.sortChildren(5, order);
                            }
                        }
                    } else {
                        PresoObjAllocCCTNode pRoot = (PresoObjAllocCCTNode)this.root;
                        switch (column) {
                            case 0: {
                                pRoot.sortChildren(1, order);
                                break;
                            }
                            case 1: 
                            case 2: {
                                pRoot.sortChildren(2, order);
                                break;
                            }
                            case 3: {
                                pRoot.sortChildren(3, order);
                            }
                        }
                    }
                }

                @Override
                public boolean getInitialSorting(int column) {
                    switch (column) {
                        case 0: {
                            return true;
                        }
                    }
                    return false;
                }
            };
            this.treeTableModel = new ExtendedTreeTableModel(this.abstractTreeTableModel);
            this.treeTable = new JTreeTable(this.treeTableModel){

                @Override
                public void doLayout() {
                    int columnsWidthsSum = 0;
                    int realFirstColumn = -1;
                    TableColumnModel colModel = this.getColumnModel();
                    for (int i = 0; i < SnapshotReverseMemCallGraphPanel.this.treeTableModel.getColumnCount(); ++i) {
                        int index = SnapshotReverseMemCallGraphPanel.this.treeTableModel.getRealColumn(i);
                        if (index == 0) {
                            realFirstColumn = i;
                            continue;
                        }
                        columnsWidthsSum += colModel.getColumn(i).getPreferredWidth();
                    }
                    if (realFirstColumn != -1) {
                        colModel.getColumn(realFirstColumn).setPreferredWidth(Math.max(this.getWidth() - columnsWidthsSum, SnapshotReverseMemCallGraphPanel.this.minNamesColumnWidth));
                    }
                    super.doLayout();
                }
            };
            this.treeTable.getAccessibleContext().setAccessibleName(TREETABLE_ACCESS_NAME);
            this.treeTable.setRowSelectionAllowed(true);
            this.treeTable.setSelectionMode(0);
            this.treeTable.setGridColor(UIConstants.TABLE_VERTICAL_GRID_COLOR);
            this.treeTable.setSelectionBackground(UIConstants.TABLE_SELECTION_BACKGROUND_COLOR);
            this.treeTable.setSelectionForeground(UIConstants.TABLE_SELECTION_FOREGROUND_COLOR);
            this.treeTable.setShowHorizontalLines(false);
            this.treeTable.setShowVerticalLines(true);
            this.treeTable.setRowMargin(0);
            this.treeTable.setRowHeight(UIUtils.getDefaultRowHeight() + 2);
            this.treeTable.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "DEFAULT_ACTION");
            this.treeTable.getActionMap().put("DEFAULT_ACTION", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SnapshotReverseMemCallGraphPanel.this.performDefaultAction(SnapshotReverseMemCallGraphPanel.this.treePath);
                }
            });
            HashSet<AWTKeyStroke> keys = new HashSet<AWTKeyStroke>(this.treeTable.getFocusTraversalKeys(0));
            keys.add(KeyStroke.getKeyStroke(9, 0));
            this.treeTable.setFocusTraversalKeys(0, keys);
            keys = new HashSet<AWTKeyStroke>(this.treeTable.getFocusTraversalKeys(1));
            keys.add(KeyStroke.getKeyStroke(9, 1));
            this.treeTable.setFocusTraversalKeys(1, keys);
            this.setColumnsData();
            UIUtils.autoExpandRoot(this.treeTable.getTree());
            UIUtils.makeTreeAutoExpandable(this.treeTable.getTree());
            this.treeTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    int selectedRow = SnapshotReverseMemCallGraphPanel.this.treeTable.getSelectedRow();
                    if (selectedRow == -1) {
                        return;
                    }
                    SnapshotReverseMemCallGraphPanel.this.treePath = SnapshotReverseMemCallGraphPanel.this.treeTable.getTree().getPathForRow(selectedRow);
                }
            });
            this.treeTable.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    int selectedRow;
                    if ((e.getKeyCode() == 525 || e.getKeyCode() == 121 && e.getModifiers() == 1) && (selectedRow = SnapshotReverseMemCallGraphPanel.this.treeTable.getSelectedRow()) != -1) {
                        SnapshotReverseMemCallGraphPanel.this.treePath = SnapshotReverseMemCallGraphPanel.this.treeTable.getTree().getPathForRow(selectedRow);
                        PresoObjAllocCCTNode node = (PresoObjAllocCCTNode)SnapshotReverseMemCallGraphPanel.this.treePath.getLastPathComponent();
                        SnapshotReverseMemCallGraphPanel.this.enableDisablePopup(node);
                        Rectangle cellRect = SnapshotReverseMemCallGraphPanel.this.treeTable.getCellRect(selectedRow, 0, false);
                        SnapshotReverseMemCallGraphPanel.this.popupMenu.show(e.getComponent(), cellRect.x + SnapshotReverseMemCallGraphPanel.this.treeTable.getSize().width > 50 ? 50 : 5, cellRect.y);
                    }
                }
            });
            this.treeTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (e.getModifiers() == 4) {
                        SnapshotReverseMemCallGraphPanel.this.treePath = SnapshotReverseMemCallGraphPanel.this.treeTable.getTree().getPathForRow(SnapshotReverseMemCallGraphPanel.this.treeTable.rowAtPoint(e.getPoint()));
                        if (SnapshotReverseMemCallGraphPanel.this.treePath != null) {
                            SnapshotReverseMemCallGraphPanel.this.treeTable.getTree().setSelectionPath(SnapshotReverseMemCallGraphPanel.this.treePath);
                        }
                    }
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    SnapshotReverseMemCallGraphPanel.this.treePath = SnapshotReverseMemCallGraphPanel.this.treeTable.getTree().getPathForRow(SnapshotReverseMemCallGraphPanel.this.treeTable.rowAtPoint(e.getPoint()));
                    if (SnapshotReverseMemCallGraphPanel.this.treePath == null) {
                        if (e.getModifiers() == 4) {
                            SnapshotReverseMemCallGraphPanel.this.treeTable.getTree().clearSelection();
                        }
                    } else {
                        SnapshotReverseMemCallGraphPanel.this.treeTable.getTree().setSelectionPath(SnapshotReverseMemCallGraphPanel.this.treePath);
                        if (e.getModifiers() == 4) {
                            PresoObjAllocCCTNode node = (PresoObjAllocCCTNode)SnapshotReverseMemCallGraphPanel.this.treePath.getLastPathComponent();
                            SnapshotReverseMemCallGraphPanel.this.enableDisablePopup(node);
                            SnapshotReverseMemCallGraphPanel.this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
                        } else if (e.getModifiers() == 16 && e.getClickCount() == 2 && SnapshotReverseMemCallGraphPanel.this.treeTableModel.isLeaf(SnapshotReverseMemCallGraphPanel.this.treePath.getPath()[SnapshotReverseMemCallGraphPanel.this.treePath.getPath().length - 1])) {
                            SnapshotReverseMemCallGraphPanel.this.performDefaultAction(SnapshotReverseMemCallGraphPanel.this.treePath);
                        }
                    }
                }
            });
            this.removeAll();
            this.treeTablePanel = new JTreeTablePanel(this.treeTable);
            this.treeTablePanel.clearBorders();
            this.treeTablePanel.setCorner("UPPER_RIGHT_CORNER", this.cornerButton);
            this.add((Component)this.treeTablePanel, "Center");
            this.initFilterPanel();
        }
    }

    private void initFilterPanel() {
        this.filterComponent = FilterComponent.create(true, true);
        this.filterComponent.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                String filterString = SnapshotReverseMemCallGraphPanel.this.filterComponent.getFilterValue();
                int filterType = SnapshotReverseMemCallGraphPanel.this.filterComponent.getFilterType();
                SnapshotReverseMemCallGraphPanel.this.snapshot.filterReverse(filterString, filterType, SnapshotReverseMemCallGraphPanel.this.treeTable.getSortingColumn(), SnapshotReverseMemCallGraphPanel.this.treeTable.getSortingOrder(), (PresoObjAllocCCTNode)SnapshotReverseMemCallGraphPanel.this.abstractTreeTableModel.getRoot(), SnapshotReverseMemCallGraphPanel.this.classId, true);
                SnapshotReverseMemCallGraphPanel.this.treeTable.updateTreeTable();
            }
        });
        this.filterComponent.setHint(METHOD_NAME_FILTER);
        this.add((Component)this.filterComponent.getComponent(), "South");
    }

    private void enableDisablePopup(PresoObjAllocCCTNode node) {
        if (this.popupShowSource != null) {
            this.popupShowSource.setEnabled(!node.isFiltered());
        }
    }
}

