/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.ui.swing;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.plaf.synth.SynthTreeUI;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.graalvm.visualvm.lib.jfluid.results.CCTNode;
import org.graalvm.visualvm.lib.ui.UIUtils;
import org.graalvm.visualvm.lib.ui.swing.ProfilerRowSorter;
import org.graalvm.visualvm.lib.ui.swing.ProfilerTable;
import org.graalvm.visualvm.lib.ui.swing.ProfilerTreeTableModel;
import org.graalvm.visualvm.lib.ui.swing.renderer.LabelRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.ProfilerRenderer;

public class ProfilerTreeTable
extends ProfilerTable {
    private static final boolean DISABLE_TREEUI_FIX = Boolean.getBoolean("ProfilerTreeTable.disableTreeUIFix");
    private final TableModelImpl model = (TableModelImpl)this.getModel();
    private final ProfilerTreeTableTree tree = this.model.getTree();

    public ProfilerTreeTable(ProfilerTreeTableModel model, boolean sortable, boolean hideableColums, int[] scrollableColumns) {
        super(new TableModelImpl(model), sortable, hideableColums, scrollableColumns);
        Adapter adapter = new Adapter();
        this.tree.addTreeSelectionListener(adapter);
        this.tree.addTreeExpansionListener(adapter);
        this.tree.addTreeWillExpandListener(adapter);
        this.tree.getModel().addTreeModelListener(adapter);
        this.getSelectionModel().addListSelectionListener(adapter);
        this.tree.setRowHeight(this.rowHeight);
        this.setDefaultRenderer(JTree.class, this.tree);
    }

    TreePath getRootPath() {
        return new TreePath(this.model.treeModel.getRoot());
    }

    TreePath getSelectionPath() {
        return this.tree.getSelectionPath();
    }

    TreePath getNextPath(TreePath path) {
        return this.getNextPath(path, true);
    }

    TreePath getNextPath(TreePath path, boolean down) {
        SortedFilteredTreeModel _model = this.model.treeModel;
        TreeNode node = (TreeNode)path.getLastPathComponent();
        if (down && _model.getChildCount(node) > 0) {
            return path.pathByAddingChild(_model.getChild(node, 0));
        }
        TreePath parentPath = path.getParentPath();
        if (!down && parentPath == null) {
            return path.pathByAddingChild(_model.getChild(node, 0));
        }
        TreeNode parent = (TreeNode)parentPath.getLastPathComponent();
        int idx = _model.getIndexOfChild(parent, node) + 1;
        if (_model.getChildCount(parent) > idx) {
            return parentPath.pathByAddingChild(_model.getChild(parent, idx));
        }
        if (!down && parentPath.getParentPath() == null) {
            return parentPath.pathByAddingChild(_model.getChild(parent, 0));
        }
        return this.getNextPath(parentPath, false);
    }

    TreePath getPreviousPath(TreePath path) {
        return this.getPreviousPath(path, true);
    }

    TreePath getPreviousPath(TreePath path, boolean down) {
        TreeNode parent;
        int idx;
        SortedFilteredTreeModel _model = this.model.treeModel;
        TreeNode node = (TreeNode)path.getLastPathComponent();
        TreePath parentPath = path.getParentPath();
        if (parentPath == null) {
            parentPath = path;
        }
        int n = idx = (parent = (TreeNode)parentPath.getLastPathComponent()) == node ? parent.getChildCount() : _model.getIndexOfChild(parent, node);
        if (idx == 0) {
            if (parent != this.model.treeModel.getRoot()) {
                return parentPath;
            }
            idx = parent.getChildCount();
        }
        node = (TreeNode)_model.getChild(parent, idx - 1);
        path = parentPath.pathByAddingChild(node);
        if (down) {
            while (_model.getChildCount(node) != 0) {
                node = (TreeNode)_model.getChild(node, _model.getChildCount(node) - 1);
                path = path.pathByAddingChild(node);
            }
        }
        return path;
    }

    public void selectPath(TreePath path, boolean scrollToVisible) {
        Rectangle bounds;
        this.internal = true;
        this.markExpansionTransaction();
        try {
            this.tree.setSelectionPath(path);
            this.tree.setSelectionPath(null);
            this.tree.setSelectionPath(path);
        }
        finally {
            this.clearExpansionTransaction();
            this.internal = false;
        }
        if (scrollToVisible && (bounds = this.tree.getPathBounds(path)) != null) {
            this.scrollRectToVisible(bounds);
        }
    }

    public TreePath getPathForRow(int row) {
        return this.tree.getPathForRow(row);
    }

    @Override
    public TreeNode getValueForRow(int row) {
        if (row == -1) {
            return null;
        }
        return this.model.nodeForRow(row);
    }

    @Override
    public void setRowHeight(int rowHeight) {
        super.setRowHeight(rowHeight);
        if (this.tree != null) {
            this.tree.setRowHeight(rowHeight);
        }
    }

    public void setShowsRootHandles(boolean newValue) {
        if (this.tree != null) {
            this.tree.setShowsRootHandles(newValue);
        }
    }

    public boolean getShowsRootHandles() {
        return this.tree != null ? this.tree.getShowsRootHandles() : false;
    }

    public void setRootVisible(boolean rootVisible) {
        if (this.tree != null) {
            this.tree.setRootVisible(rootVisible);
        }
    }

    public boolean isRootVisible() {
        return this.tree != null ? this.tree.isRootVisible() : false;
    }

    private void markExpansionTransaction() {
        this.tree.putClientProperty("expansion_transaction", Boolean.TRUE);
    }

    private void clearExpansionTransaction() {
        this.tree.putClientProperty("expansion_transaction", null);
        TreePath[] selectedPaths = this.tree.getSelectionPaths();
        this.model.fireTableDataChanged();
        this.tree.setSelectionPaths(selectedPaths);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collapseChildren(int row) {
        if (this.tree != null) {
            try {
                this.markExpansionTransaction();
                TreePath tpath = this.tree.getPathForRow(row);
                if (tpath == null || this.tree.isCollapsed(tpath)) {
                    return;
                }
                TreeModel tmodel = this.tree.getModel();
                Object selected = tpath.getLastPathComponent();
                int nchildren = tmodel.getChildCount(selected);
                for (int i = 0; i < nchildren; ++i) {
                    this.tree.collapsePath(tpath.pathByAddingChild(tmodel.getChild(selected, i)));
                }
            }
            finally {
                this.clearExpansionTransaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collapseChildren(TreePath tpath) {
        if (this.tree != null) {
            try {
                this.markExpansionTransaction();
                if (tpath == null || this.tree.isCollapsed(tpath)) {
                    return;
                }
                TreeModel tmodel = this.tree.getModel();
                Object selected = tpath.getLastPathComponent();
                int nchildren = tmodel.getChildCount(selected);
                for (int i = 0; i < nchildren; ++i) {
                    TreePath tp = tpath.pathByAddingChild(tmodel.getChild(selected, i));
                    this.tree.collapsePath(tp);
                }
            }
            finally {
                this.clearExpansionTransaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collapseAll() {
        if (this.tree != null) {
            try {
                this.markExpansionTransaction();
                TreePath selected = this.tree.getSelectionPath();
                if (selected != null && selected.getPathCount() > 2) {
                    this.tree.setSelectionPath(new TreePath(new Object[]{selected.getPathComponent(0), selected.getPathComponent(1)}));
                }
                TreeModel tmodel = this.tree.getModel();
                Object root = tmodel.getRoot();
                int nchildren = tmodel.getChildCount(root);
                for (int i = 0; i < nchildren; ++i) {
                    this.tree.collapsePath(new TreePath(new Object[]{root, tmodel.getChild(root, i)}));
                }
                this.tree.resetExpandedNodes();
            }
            finally {
                this.clearExpansionTransaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expandPlainPath(int row, int maxChildren) {
        if (this.tree != null) {
            try {
                this.markExpansionTransaction();
                TreePath tpath = this.tree.getPathForRow(row);
                if (tpath == null) {
                    return;
                }
                TreeModel tmodel = this.tree.getModel();
                int childCount = tmodel.getChildCount(tpath.getLastPathComponent());
                while (childCount > 0 && childCount <= maxChildren) {
                    tpath = tpath.pathByAddingChild(tmodel.getChild(tpath.getLastPathComponent(), 0));
                    childCount = tmodel.getChildCount(tpath.getLastPathComponent());
                }
                this.tree.putClientProperty("auto_expanding", Boolean.TRUE);
                try {
                    this.tree.expandPath(tpath);
                    this.selectPath(tpath, true);
                }
                finally {
                    this.tree.putClientProperty("auto_expanding", null);
                }
            }
            finally {
                this.clearExpansionTransaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expandFirstPath(int row) {
        if (this.tree != null) {
            try {
                this.markExpansionTransaction();
                TreePath tpath = this.tree.getPathForRow(row);
                if (tpath == null) {
                    return;
                }
                TreeModel tmodel = this.tree.getModel();
                while (tmodel.getChildCount(tpath.getLastPathComponent()) > 0) {
                    tpath = tpath.pathByAddingChild(tmodel.getChild(tpath.getLastPathComponent(), 0));
                }
                this.tree.putClientProperty("auto_expanding", Boolean.TRUE);
                try {
                    this.selectPath(tpath, true);
                }
                finally {
                    this.tree.putClientProperty("auto_expanding", null);
                }
            }
            finally {
                this.clearExpansionTransaction();
            }
        }
    }

    public void expandPath(TreePath path) {
        if (this.tree != null) {
            try {
                this.markExpansionTransaction();
                this.tree.putClientProperty("auto_expanding", Boolean.TRUE);
                try {
                    this.tree.expandPath(path);
                }
                finally {
                    this.tree.putClientProperty("auto_expanding", null);
                }
            }
            finally {
                this.clearExpansionTransaction();
            }
        }
    }

    public void expandRow(int row) {
        if (this.tree != null) {
            try {
                this.markExpansionTransaction();
                this.tree.putClientProperty("auto_expanding", Boolean.TRUE);
                try {
                    this.tree.expandRow(row);
                }
                finally {
                    this.tree.putClientProperty("auto_expanding", null);
                }
            }
            finally {
                this.clearExpansionTransaction();
            }
        }
    }

    public void makeTreeAutoExpandable(int maxChildToExpand) {
        if (this.tree != null) {
            UIUtils.makeTreeAutoExpandable((JTree)this.tree, maxChildToExpand);
        }
    }

    protected void nodeExpanding(TreeNode node) {
    }

    protected void nodeExpanded(TreeNode node) {
    }

    protected void nodeCollapsing(TreeNode node) {
    }

    protected void nodeCollapsed(TreeNode node) {
    }

    public void setForgetPreviouslyExpanded(boolean ignorePreviouslyExpanded) {
        this.tree.setForgetPreviouslyExpanded(ignorePreviouslyExpanded);
    }

    public Enumeration<TreePath> getExpandedNodes() {
        return this.tree == null ? null : this.tree.getExpandedDescendants(new TreePath(this.tree.getModel().getRoot()));
    }

    public void clearExpandedNodes(Enumeration<TreePath> nodes) {
        if (this.tree != null) {
            this.tree.removeDescendantToggledPaths(nodes);
            this.tree.updateUI();
        }
    }

    public void resetExpandedNodes() {
        if (this.tree != null) {
            this.tree.resetExpandedNodes();
        }
    }

    public void resetPath(TreePath path) {
        if (this.tree != null) {
            ((SortedFilteredTreeModel)this.tree.getModel()).clearPath(path);
        }
    }

    public DefaultTreeModel getTreeModel() {
        return this.tree == null ? null : (DefaultTreeModel)this.tree.getModel();
    }

    public void setCellRenderer(TreeCellRenderer renderer) {
        if (this.tree != null) {
            this.tree.setCellRenderer(renderer);
            this.model.setRenderer(renderer);
        }
    }

    public void setTreeCellRenderer(ProfilerRenderer renderer) {
        this.setCellRenderer(ProfilerTreeTable.createTreeCellRenderer(renderer));
    }

    public static TreeCellRenderer createTreeCellRenderer(ProfilerRenderer renderer) {
        return new ProfilerRendererWrapper(renderer);
    }

    @Override
    Component getRenderer(TableCellRenderer renderer, int row, int column, boolean sized) {
        Component comp = super.getRenderer(renderer, row, column, sized);
        if (sized && JTree.class.equals(this.getColumnClass(column))) {
            Rectangle bounds = this.tree.getRowBounds(row);
            comp.setBounds(bounds.x, 0, bounds.width, comp.getHeight());
        }
        return comp;
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        this.tree.dispatchEvent(e);
        if (!e.isConsumed()) {
            super.processKeyEvent(e);
        }
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        int row;
        Rectangle treeCellRect;
        Point point;
        int column;
        MouseEvent treeEvent = null;
        if (e != null && (column = this.columnAtPoint(point = e.getPoint())) != -1 && this.getColumnClass(column) == JTree.class && (treeCellRect = this.tree.getRowBounds(row = this.rowAtPoint(point))) != null) {
            Rectangle tableCellRect = this.getCellRect(row, column, true);
            int _column = this.convertColumnIndexToModel(column);
            int treeX = point.x - tableCellRect.x + this.getColumnOffset(_column);
            if (treeX > treeCellRect.x) {
                treeX = treeCellRect.x + treeCellRect.width / 2;
            }
            treeEvent = new MouseEvent(this.tree, e.getID(), e.getWhen(), e.getModifiers(), treeX, e.getY(), e.getClickCount(), e.isPopupTrigger());
            TreeNode value = this.getValueForRow(row);
            if (value instanceof TreeNode && !value.isLeaf()) {
                e = ProfilerTreeTable.clearClicks(e);
            }
        }
        super.processMouseEvent(e);
        if (treeEvent != null) {
            this.tree.dispatchEvent(treeEvent);
        }
    }

    @Override
    public void addRowFilter(RowFilter filter) {
        super.addRowFilter(filter);
        this.refreshFilter();
    }

    @Override
    public void removeRowFilter(RowFilter filter) {
        super.removeRowFilter(filter);
        this.refreshFilter();
    }

    @Override
    public void setRowFilter(RowFilter filter) {
        super.setRowFilter(filter);
        this.refreshFilter();
    }

    private void refreshFilter() {
        this.model.filter(this._getRowSorter().getRowFilter());
    }

    public Comparator getCurrentComparator() {
        return this.model.getComparator();
    }

    public String getStringValue(TreeNode node, int column) {
        Object value = this.model.getValueAt(node, this.convertColumnIndexToModel(column));
        if (this.getColumnClass(column) == JTree.class) {
            TreeCellRenderer renderer = this.tree.getCellRenderer();
            renderer.getTreeCellRendererComponent(this.tree, value, false, false, false, -1, false);
            return renderer.toString();
        }
        TableCellRenderer renderer = this.getCellRenderer(-1, column);
        if (renderer instanceof ProfilerRenderer) {
            ((ProfilerRenderer)((Object)renderer)).setValue(value, -1);
        } else {
            renderer.getTableCellRendererComponent(this, value, false, false, -1, column);
        }
        return renderer.toString();
    }

    @Override
    protected TableRowSorter createRowSorter() {
        ProfilerTreeTableSorter s = new ProfilerTreeTableSorter(this.getModel()){

            @Override
            public void allRowsChanged() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ProfilerTreeTable.this.updateColumnsPreferredWidth();
                    }
                });
            }

            @Override
            protected void setSortKeysImpl(List newKeys) {
                ProfilerTreeTable.this.willBeSorted(Collections.unmodifiableList(newKeys));
                super.setSortKeysImpl(newKeys);
            }
        };
        s.setDefaultSortOrder(SortOrder.DESCENDING);
        s.setDefaultSortOrder(0, SortOrder.ASCENDING);
        return s;
    }

    protected void willBeSorted(List<? extends RowSorter.SortKey> sortKeys) {
    }

    @Override
    protected void saveSelection() {
    }

    @Override
    protected void restoreSelection() {
    }

    static UIState getUIState(JTree tree) {
        TreePath[] selectedPaths = tree.getSelectionPaths();
        TreePath rootPath = new TreePath(tree.getModel().getRoot());
        Enumeration<TreePath> expandedPaths = tree.getExpandedDescendants(rootPath);
        return new UIState(selectedPaths, expandedPaths);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void restoreExpandedNodes(JTree tree, UIState uiState) {
        try {
            tree.putClientProperty("expansion_transaction", Boolean.TRUE);
            Enumeration paths = uiState.getExpandedPaths();
            if (paths != null) {
                while (paths.hasMoreElements()) {
                    TreePath tp = (TreePath)paths.nextElement();
                    tree.expandPath(ProfilerTreeTable.getSimilarPath(tp, tree.getModel()));
                }
            }
        }
        catch (Exception e) {
            System.err.println(">>> Exception in ProfilerTreeTable.restoreExpandedNodes: " + e.getMessage());
            e.printStackTrace();
        }
        finally {
            tree.putClientProperty("expansion_transaction", null);
        }
    }

    static void restoreSelectedNodes(JTree tree, UIState uiState) {
        try {
            TreePath[] sel = uiState.getSelectedPaths();
            if (sel != null) {
                for (int i = 0; i < sel.length; ++i) {
                    sel[i] = ProfilerTreeTable.getSimilarPath(sel[i], tree.getModel());
                }
            }
            tree.setSelectionPaths(sel);
        }
        catch (Exception e) {
            System.err.println(">>> Exception in ProfilerTreeTable.restoreSelectedNodes: " + e.getMessage());
            e.printStackTrace();
        }
    }

    protected UIState getUIState() {
        return this.tree == null ? null : ProfilerTreeTable.getUIState(this.tree);
    }

    protected void restoreExpandedNodes(UIState uiState) {
        if (this.tree != null) {
            ProfilerTreeTable.restoreExpandedNodes(this.tree, uiState);
        }
    }

    protected void restoreSelectedNodes(UIState uiState) {
        if (this.tree != null) {
            ProfilerTreeTable.restoreSelectedNodes(this.tree, uiState);
        }
    }

    private static TreePath getSimilarPath(TreePath oldPath, TreeModel currentModel) {
        if (oldPath == null || oldPath.getPathCount() < 1) {
            return null;
        }
        Object currentRoot = currentModel.getRoot();
        if (!currentRoot.equals(oldPath.getPathComponent(0))) {
            return null;
        }
        TreePath p = new TreePath(currentRoot);
        Object[] op = oldPath.getPath();
        Object n = currentRoot;
        for (int i = 1; i < op.length; ++i) {
            Object nn = null;
            for (int ii = 0; ii < currentModel.getChildCount(n); ++ii) {
                Object c = currentModel.getChild(n, ii);
                if (!c.equals(op[i])) continue;
                nn = c;
                break;
            }
            if (nn == null) {
                return null;
            }
            n = nn;
            p = p.pathByAddingChild(n);
        }
        return p;
    }

    private static class SynthLikeTreeUI
    extends BasicTreeUI {
        private static final Icon[] ICONS = new Icon[4];
        private boolean isSelected;

        private SynthLikeTreeUI() {
        }

        void setSelected(boolean selected) {
            this.isSelected = selected;
        }

        @Override
        public Icon getExpandedIcon() {
            return this.isSelected ? ICONS[1] : ICONS[0];
        }

        @Override
        public Icon getCollapsedIcon() {
            return this.isSelected ? ICONS[3] : ICONS[2];
        }

        @Override
        protected void paintHorizontalPartOfLeg(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
        }

        @Override
        protected void paintVerticalPartOfLeg(Graphics g, Rectangle clipBounds, Insets insets, TreePath path) {
        }

        static {
            final BufferedImage[] image = new BufferedImage[1];
            BufferedImage tmp = new BufferedImage(50, 50, 2);
            DefaultMutableTreeNode root = new DefaultMutableTreeNode();
            root.add(new DefaultMutableTreeNode());
            JTree tree = new JTree(root);
            tree.setRootVisible(true);
            tree.setShowsRootHandles(true);
            tree.setSize(50, 50);
            tree.setUI(new SynthTreeUI(){

                @Override
                protected void drawCentered(Component c, Graphics graphics, Icon icon, int x, int y) {
                    int w = icon.getIconWidth();
                    int h = icon.getIconHeight();
                    image[0] = new BufferedImage(w, h, 2);
                    super.drawCentered(c, image[0].getGraphics(), icon, w / 2, h / 2);
                }
            });
            tree.expandRow(0);
            tree.clearSelection();
            tree.paint(tmp.getGraphics());
            SynthLikeTreeUI.ICONS[0] = new ImageIcon(image[0]);
            tree.expandRow(0);
            tree.setSelectionRow(0);
            tree.paint(tmp.getGraphics());
            SynthLikeTreeUI.ICONS[1] = new ImageIcon(image[0]);
            tree.collapseRow(0);
            tree.clearSelection();
            tree.paint(tmp.getGraphics());
            SynthLikeTreeUI.ICONS[2] = new ImageIcon(image[0]);
            tree.collapseRow(0);
            tree.setSelectionRow(0);
            tree.paint(tmp.getGraphics());
            SynthLikeTreeUI.ICONS[3] = new ImageIcon(image[0]);
        }
    }

    private static class ProfilerTreeTableTree
    extends JTree
    implements TableCellRenderer,
    Accessible {
        private int currentX;
        private int currentWidth;
        private int currentRowOffset;
        private boolean currentFirst;
        private boolean currentFocused;
        private boolean currentSelected;
        private boolean customRendering;
        private SynthLikeTreeUI synthLikeUI;
        private boolean workaroundVerticalLines;
        private boolean forgetPreviouslyExpanded;
        private final Dimension prefSize = new Dimension();
        private boolean changingModel;

        ProfilerTreeTableTree(SortedFilteredTreeModel model) {
            super((TreeModel)null);
            this.setOpaque(false);
            this.setBorder(BorderFactory.createEmptyBorder());
            this.getSelectionModel().setSelectionMode(1);
            this.setCellRenderer(new ProfilerRendererWrapper(new LabelRenderer()));
            this.setLargeModel(true);
            this.setModel(model);
        }

        @Override
        public boolean isFixedRowHeight() {
            return true;
        }

        @Override
        public void setUI(TreeUI ui) {
            if (ui instanceof SynthTreeUI) {
                super.setUI(ui);
                SynthTreeUI synthUI = (SynthTreeUI)ui;
                int left = synthUI.getLeftChildIndent();
                int right = synthUI.getRightChildIndent();
                this.synthLikeUI = new SynthLikeTreeUI();
                super.setUI(this.synthLikeUI);
                boolean nimbus = UIUtils.isNimbusLookAndFeel();
                this.synthLikeUI.setLeftChildIndent(left + (nimbus ? 4 : 6));
                this.synthLikeUI.setRightChildIndent(right);
            } else {
                this.synthLikeUI = null;
                super.setUI(ui);
                if (!DISABLE_TREEUI_FIX && ui instanceof BasicTreeUI) {
                    this.workaroundVerticalLines = UIManager.getBoolean("Tree.paintLines");
                }
            }
        }

        @Override
        public void validate() {
        }

        @Override
        public void revalidate() {
        }

        @Override
        public boolean hasFocus() {
            return this.currentFocused;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            ProfilerTable ptable = (ProfilerTable)table;
            this.currentRowOffset = row * this.rowHeight;
            this.currentFirst = column == 0 || this.isFirstColumn(table.getColumnModel(), column);
            this.currentFocused = !ptable.shadesUnfocusedSelection() || hasFocus || table.hasFocus();
            this.currentSelected = isSelected;
            Rectangle cellBounds = this.getRowBounds(row);
            if (cellBounds == null) {
                this.currentX = 0;
                this.currentWidth = 0;
            } else {
                this.currentX = cellBounds.x;
                this.currentWidth = cellBounds.width;
            }
            this.customRendering = ptable.isCustomRendering();
            if (this.synthLikeUI != null) {
                this.synthLikeUI.setSelected(isSelected);
            }
            return this;
        }

        @Override
        public Dimension getPreferredSize() {
            this.prefSize.setSize(this.currentX + this.currentWidth, this.rowHeight);
            return this.prefSize;
        }

        @Override
        public void paint(Graphics g) {
            g.setColor(this.getBackground());
            int rectX = this.currentSelected || this.customRendering || !this.currentFirst ? 0 : this.currentX;
            g.fillRect(rectX, 0, this.getWidth() - rectX, this.rowHeight);
            g.translate(this.customRendering ? -this.currentX : 0, -this.currentRowOffset);
            if (this.workaroundVerticalLines && !this.rootVisible && this.currentRowOffset > 0) {
                this.rootVisible = true;
                super.paint(g);
                this.rootVisible = false;
            } else {
                super.paint(g);
            }
        }

        private boolean isFirstColumn(TableColumnModel columns, int column) {
            int x = 0;
            for (int i = 0; i < column; ++i) {
                x += columns.getColumn(i).getWidth();
            }
            return x == 0;
        }

        @Override
        public void setAnchorSelectionPath(TreePath newPath) {
        }

        void setForgetPreviouslyExpanded(boolean forgetPreviouslyExpanded) {
            this.forgetPreviouslyExpanded = forgetPreviouslyExpanded;
        }

        @Override
        public boolean hasBeenExpanded(TreePath path) {
            return this.forgetPreviouslyExpanded ? false : super.hasBeenExpanded(path);
        }

        @Override
        public void fireTreeCollapsed(TreePath path) {
            super.fireTreeCollapsed(path);
            if (this.forgetPreviouslyExpanded) {
                super.removeDescendantToggledPaths(Collections.enumeration(Collections.singletonList(path)));
                ((SortedFilteredTreeModel)this.getModel()).clearPath(path);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        this.updateUI();
                    }
                });
            }
        }

        @Override
        protected void removeDescendantToggledPaths(Enumeration<TreePath> toRemove) {
            super.removeDescendantToggledPaths(toRemove);
        }

        void resetExpandedNodes() {
            this.clearToggledPaths();
            this.updateUI();
        }

        @Override
        public Enumeration<TreePath> getExpandedDescendants(TreePath parent) {
            return Boolean.TRUE.equals(this.getClientProperty("auto_expanding")) ? null : super.getExpandedDescendants(parent);
        }

        @Override
        public void expandPath(TreePath path) {
            if (this.changingModel) {
                path = this.getSimilarPath(path);
            }
            super.expandPath(path);
        }

        @Override
        public void setSelectionPath(TreePath path) {
            if (this.changingModel) {
                path = this.getSimilarPath(path);
            }
            super.setSelectionPath(path);
        }

        @Override
        public void setSelectionPaths(TreePath[] paths) {
            if (this.changingModel && paths != null) {
                ArrayList<TreePath> similarPaths = new ArrayList<TreePath>();
                for (int i = 0; i < paths.length; ++i) {
                    TreePath similarPath = this.getSimilarPath(paths[i]);
                    if (similarPath == null) continue;
                    similarPaths.add(similarPath);
                }
                super.setSelectionPaths(similarPaths.toArray(new TreePath[0]));
            } else {
                super.setSelectionPaths(paths);
            }
        }

        private TreePath getSimilarPath(TreePath oldPath) {
            if (oldPath == null || oldPath.getPathCount() < 1) {
                return null;
            }
            TreeModel currentModel = this.getModel();
            Object currentRoot = currentModel.getRoot();
            if (!currentRoot.equals(oldPath.getPathComponent(0))) {
                return null;
            }
            TreePath p = new TreePath(currentRoot);
            Object[] op = oldPath.getPath();
            Object n = currentRoot;
            for (int i = 1; i < op.length; ++i) {
                Object nn = null;
                for (int ii = 0; ii < currentModel.getChildCount(n); ++ii) {
                    Object c = currentModel.getChild(n, ii);
                    if (!c.equals(op[i])) continue;
                    nn = c;
                    break;
                }
                if (nn == null) {
                    return null;
                }
                n = nn;
                p = p.pathByAddingChild(n);
            }
            return p;
        }

        private void setChangingModel(boolean changing) {
            this.changingModel = changing;
        }

        boolean isChangingModel() {
            return this.changingModel;
        }

        @Override
        protected void processEvent(AWTEvent e) {
            if (e instanceof KeyEvent) {
                if (this.supportsKeyEvent((KeyEvent)e)) {
                    super.processEvent(e);
                }
            } else if (e instanceof MouseEvent && this.supportsMouseEvent((MouseEvent)e)) {
                super.processEvent(e);
            }
        }

        private boolean supportsKeyEvent(KeyEvent e) {
            switch (e.getKeyCode()) {
                case 33: 
                case 34: {
                    return false;
                }
            }
            return true;
        }

        private boolean supportsMouseEvent(MouseEvent e) {
            return true;
        }

        @Override
        public String toString() {
            return this.getCellRenderer().toString();
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            TreeCellRenderer renderer = this.getCellRenderer();
            return renderer instanceof Accessible ? ((Accessible)((Object)renderer)).getAccessibleContext() : new JComponent.AccessibleJComponent(){};
        }
    }

    private class Adapter
    implements TreeModelListener,
    TreeExpansionListener,
    TreeWillExpandListener,
    TreeSelectionListener,
    ListSelectionListener {
        private boolean internal;

        private Adapter() {
        }

        @Override
        public void treeExpanded(TreeExpansionEvent event) {
            this.notifyTable();
            Object expanded = event.getPath().getLastPathComponent();
            if (expanded instanceof TreeNode) {
                ProfilerTreeTable.this.nodeExpanded((TreeNode)expanded);
            }
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent event) {
            this.notifyTable();
            Object collapsed = event.getPath().getLastPathComponent();
            if (collapsed instanceof TreeNode) {
                ProfilerTreeTable.this.nodeCollapsed((TreeNode)collapsed);
            }
        }

        @Override
        public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
            Object expanding = event.getPath().getLastPathComponent();
            if (expanding instanceof TreeNode) {
                ProfilerTreeTable.this.nodeExpanding((TreeNode)expanding);
            }
        }

        @Override
        public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            Object collapsing = event.getPath().getLastPathComponent();
            if (collapsing instanceof TreeNode) {
                ProfilerTreeTable.this.nodeCollapsing((TreeNode)collapsing);
            }
        }

        @Override
        public void treeNodesChanged(TreeModelEvent e) {
            this.notifyTable();
        }

        @Override
        public void treeNodesInserted(TreeModelEvent e) {
            this.notifyTable();
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent e) {
            this.notifyTable();
        }

        @Override
        public void treeStructureChanged(TreeModelEvent e) {
            ProfilerTreeTable.this.tree.setChangingModel(true);
            try {
                this.notifyTable();
            }
            finally {
                ProfilerTreeTable.this.tree.setChangingModel(false);
            }
        }

        private void notifyTable() {
            if (ProfilerTreeTable.this.tree.isChangingModel()) {
                return;
            }
            if (ProfilerTreeTable.this.tree.getClientProperty("expansion_transaction") != null) {
                return;
            }
            TreePath[] selectedPaths = ProfilerTreeTable.this.tree.getSelectionPaths();
            ProfilerTreeTable.this.model.fireTableDataChanged();
            ProfilerTreeTable.this.tree.setSelectionPaths(selectedPaths);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void valueChanged(TreeSelectionEvent e) {
            if (this.internal) {
                return;
            }
            TreePath selected = e.getPath();
            if (!Objects.equals(selected, ProfilerTreeTable.this.tree.getSelectionPath())) {
                return;
            }
            int row = selected == null ? -1 : ProfilerTreeTable.this.tree.getRowForPath(selected);
            try {
                this.internal = true;
                if (row != -1) {
                    ProfilerTreeTable.this.selectRow(row, !ProfilerTreeTable.this.tree.isChangingModel());
                } else {
                    ProfilerTreeTable.this.clearSelection();
                }
            }
            finally {
                this.internal = false;
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (this.internal) {
                return;
            }
            int row = ProfilerTreeTable.this.getSelectedRow();
            try {
                this.internal = true;
                if (row != -1) {
                    ProfilerTreeTable.this.tree.setSelectionRow(row);
                } else {
                    ProfilerTreeTable.this.tree.clearSelection();
                }
                ProfilerTreeTable.this.repaint();
            }
            finally {
                this.internal = false;
            }
        }
    }

    protected static class UIState {
        private final TreePath[] selectedPaths;
        private final Enumeration<TreePath> expandedPaths;

        UIState(TreePath[] selectedPaths, Enumeration<TreePath> expandedPaths) {
            this.selectedPaths = selectedPaths;
            this.expandedPaths = expandedPaths;
        }

        public TreePath[] getSelectedPaths() {
            return this.selectedPaths;
        }

        public Enumeration getExpandedPaths() {
            return this.expandedPaths;
        }
    }

    private static final class TreePathKey {
        private final TreeNode[] pathToRoot;
        private int hashCode;

        TreePathKey(TreeNode[] _pathToRoot) {
            this.pathToRoot = _pathToRoot;
            this.hashCode = 1;
            for (TreeNode node : this.pathToRoot) {
                this.hashCode = 31 * this.hashCode + node.hashCode();
            }
        }

        public final int hashCode() {
            return this.hashCode;
        }

        public final boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TreePathKey)) {
                return false;
            }
            TreeNode[] _pathToRoot = ((TreePathKey)o).pathToRoot;
            if (this.pathToRoot.length != _pathToRoot.length) {
                return false;
            }
            for (int i = this.pathToRoot.length - 1; i >= 0; --i) {
                if (this.pathToRoot[i].equals(_pathToRoot[i])) continue;
                return false;
            }
            return true;
        }
    }

    private static class SortedFilteredTreeModel
    extends FilteredTreeModel {
        private Comparator comparator;
        private Map<TreePathKey, int[]> viewToModel;

        SortedFilteredTreeModel(TreeNode root, TreeCellRenderer r, Comparator comp, RowFilter filter) {
            super(root, r, filter);
            this.comparator = comp;
        }

        void setComparator(Comparator comp) {
            this.comparator = comp;
            this.reload();
        }

        Comparator getComparator() {
            return this.comparator;
        }

        @Override
        public Object getChild(Object parent, int index) {
            if (this.comparator == null || parent instanceof CCTNode.DoNotSortChildren) {
                return super.getChild(parent, index);
            }
            return super.getChild(parent, this.viewToModel(parent)[index]);
        }

        @Override
        public int getIndexOfChild(Object parent, Object child) {
            if (this.comparator == null || parent instanceof CCTNode.DoNotSortChildren) {
                return super.getIndexOfChild(parent, child);
            }
            int index = super.getIndexOfChild(parent, child);
            int[] indexes = this.viewToModel(parent);
            for (int i = 0; i < indexes.length; ++i) {
                if (indexes[i] != index) continue;
                return i;
            }
            return -1;
        }

        @Override
        protected void clearKey(TreePathKey key) {
            super.clearKey(key);
            this.viewToModel = null;
        }

        @Override
        protected void fireTreeStructureChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
            this.viewToModel = null;
            super.fireTreeStructureChanged(source, path, childIndices, children);
        }

        private int[] viewToModel(Object parent) {
            TreePathKey parentKey;
            int[] indexes;
            if (this.viewToModel == null) {
                this.viewToModel = new HashMap<TreePathKey, int[]>();
            }
            if ((indexes = this.viewToModel.get(parentKey = new TreePathKey(this.getPathToRoot((TreeNode)parent)))) == null) {
                int i;
                Object[] children = new Object[super.getChildCount(parent)];
                for (i = 0; i < children.length; ++i) {
                    children[i] = super.getChild(parent, i);
                }
                Arrays.sort(children, this.comparator);
                indexes = new int[children.length];
                for (i = 0; i < indexes.length; ++i) {
                    indexes[i] = super.getIndexOfChild(parent, children[i]);
                }
                this.viewToModel.put(parentKey, indexes);
            }
            return indexes;
        }
    }

    private static final class FilterEntry
    extends RowFilter.Entry {
        private Object value;
        private Object identifier;

        FilterEntry(Object _value, Object _identifier) {
            this.value = _value;
            this.identifier = _identifier;
        }

        void setContext(Object _value, Object _identifier) {
            this.value = _value;
            this.identifier = _identifier;
        }

        @Override
        public Object getValue(int index) {
            return this.value;
        }

        public Object getModel() {
            return null;
        }

        @Override
        public int getValueCount() {
            return 1;
        }

        public Object getIdentifier() {
            return this.identifier;
        }
    }

    private static class FilteredTreeModel
    extends DefaultTreeModel {
        private TreeCellRenderer renderer;
        private RowFilter filter;
        private Map<TreePathKey, List> cache;

        FilteredTreeModel(TreeNode root, TreeCellRenderer r, RowFilter f) {
            super(root);
            this.renderer = r;
            this.filter = f;
        }

        void setRenderer(TreeCellRenderer r) {
            this.renderer = r;
            this.reload();
        }

        TreeCellRenderer getRenderer() {
            return this.renderer;
        }

        void setFilter(RowFilter f) {
            this.filter = f;
            this.reload();
        }

        RowFilter getFilter() {
            return this.filter;
        }

        @Override
        public Object getChild(Object parent, int index) {
            if (this.renderer == null || this.filter == null) {
                return super.getChild(parent, index);
            }
            return this.filteredChildren(parent).get(index);
        }

        @Override
        public int getIndexOfChild(Object parent, Object child) {
            if (this.renderer == null || this.filter == null) {
                return super.getIndexOfChild(parent, child);
            }
            return this.filteredChildren(parent).indexOf(child);
        }

        @Override
        public int getChildCount(Object parent) {
            if (this.renderer == null || this.filter == null) {
                return super.getChildCount(parent);
            }
            return this.filteredChildren(parent).size();
        }

        void clearPath(TreePath path) {
            this.clearKey(null);
        }

        protected void clearKey(TreePathKey key) {
            this.cache = null;
        }

        @Override
        protected void fireTreeStructureChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
            this.cache = null;
            super.fireTreeStructureChanged(source, path, childIndices, children);
        }

        private List filteredChildren(Object parent) {
            TreeNode tParent;
            TreePathKey parentKey;
            ArrayList<TreeNode> children;
            if (this.cache == null) {
                this.cache = new HashMap<TreePathKey, List>();
            }
            if ((children = this.cache.get(parentKey = new TreePathKey(this.getPathToRoot(tParent = (TreeNode)parent)))) == null) {
                FilterEntry entry = null;
                children = new ArrayList<TreeNode>(tParent.getChildCount());
                CCTNode filtered = null;
                Enumeration<? extends TreeNode> childrenE = tParent.children();
                if (childrenE != null) {
                    while (childrenE.hasMoreElements()) {
                        TreeNode child = childrenE.nextElement();
                        this.renderer.getTreeCellRendererComponent(null, child, false, false, false, -1, false);
                        if (entry == null) {
                            entry = new FilterEntry(this.renderer.toString(), child);
                        } else {
                            entry.setContext(this.renderer.toString(), child);
                        }
                        if (this.filter.include(entry)) {
                            children.add(child);
                            continue;
                        }
                        if (!(parent instanceof CCTNode)) continue;
                        if (filtered == null) {
                            filtered = ((CCTNode)child).createFilteredNode();
                            continue;
                        }
                        filtered.merge((CCTNode)child);
                    }
                }
                if (filtered != null) {
                    List filteredChildren = this.filteredChildren(filtered);
                    if (!((CCTNode)parent).isFiltered()) {
                        children.add((TreeNode)filtered);
                    } else if (!children.isEmpty()) {
                        children.add((TreeNode)filtered);
                    } else {
                        children.addAll(filteredChildren);
                    }
                }
                this.cache.put(parentKey, children);
            }
            return children;
        }
    }

    private static class TableModelImpl
    extends AbstractTableModel {
        private final ProfilerTreeTableTree tree;
        private SortedFilteredTreeModel treeModel;
        private final ProfilerTreeTableModel treeTableModel;

        TableModelImpl(ProfilerTreeTableModel model) {
            this.treeTableModel = model;
            this.treeModel = this.treeModelImpl(model.getRoot(), null, null);
            model.addListener(new ProfilerTreeTableModel.Adapter(){

                @Override
                public void dataChanged() {
                    this.fireTableDataChanged();
                }

                @Override
                public void structureChanged() {
                    treeModel.reload();
                }

                @Override
                public void childrenChanged(TreeNode node) {
                    treeModel.reload(node);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void rootChanged(TreeNode oldRoot, TreeNode newRoot) {
                    tree.setChangingModel(true);
                    try {
                        UIState uiState = ProfilerTreeTable.getUIState(tree);
                        Comparator comparator = treeModel != null ? treeModel.getComparator() : null;
                        RowFilter filter = treeModel != null ? treeModel.getFilter() : null;
                        treeModel = this.treeModelImpl(newRoot, comparator, filter);
                        tree.setModel(treeModel);
                        if (uiState != null) {
                            ProfilerTreeTable.restoreExpandedNodes(tree, uiState);
                        }
                        this.fireTableDataChanged();
                        if (uiState != null) {
                            ProfilerTreeTable.restoreSelectedNodes(tree, uiState);
                        }
                    }
                    finally {
                        tree.setChangingModel(false);
                    }
                }
            });
            this.tree = new ProfilerTreeTableTree(this.treeModel);
        }

        private SortedFilteredTreeModel treeModelImpl(TreeNode root, Comparator comparator, RowFilter filter) {
            return new SortedFilteredTreeModel(root, this.tree == null ? null : this.tree.getCellRenderer(), comparator, filter){

                @Override
                protected void fireTreeStructureChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
                    UIState uiState = tree == null ? null : ProfilerTreeTable.getUIState(tree);
                    super.fireTreeStructureChanged(source, path, childIndices, children);
                    if (uiState != null) {
                        ProfilerTreeTable.restoreExpandedNodes(tree, uiState);
                    }
                    this.fireTableDataChanged();
                    if (uiState != null) {
                        ProfilerTreeTable.restoreSelectedNodes(tree, uiState);
                    }
                }
            };
        }

        void sort(Comparator comparator) {
            this.treeModel.setComparator(comparator);
        }

        Comparator getComparator() {
            return this.treeModel.getComparator();
        }

        void filter(RowFilter filter) {
            this.treeModel.setFilter(filter);
        }

        RowFilter getFilter() {
            return this.treeModel.getFilter();
        }

        void setRenderer(TreeCellRenderer renderer) {
            this.treeModel.setRenderer(renderer);
        }

        ProfilerTreeTableTree getTree() {
            return this.tree;
        }

        TreeNode nodeForRow(int rowIndex) {
            TreePath path = this.tree.getPathForRow(rowIndex);
            return path == null ? null : (TreeNode)path.getLastPathComponent();
        }

        @Override
        public int getRowCount() {
            return this.tree.getRowCount();
        }

        @Override
        public int getColumnCount() {
            return this.treeTableModel.getColumnCount();
        }

        @Override
        public String getColumnName(int columnIndex) {
            return this.treeTableModel.getColumnName(columnIndex);
        }

        public Class getColumnClass(int columnIndex) {
            return this.treeTableModel.getColumnClass(columnIndex);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            TreeNode node = this.nodeForRow(rowIndex);
            return node == null ? false : this.treeTableModel.isCellEditable(node, columnIndex);
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            TreeNode node = this.nodeForRow(rowIndex);
            return node == null ? null : this.treeTableModel.getValueAt(node, columnIndex);
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            TreeNode node = this.nodeForRow(rowIndex);
            if (node != null) {
                this.treeTableModel.setValueAt(aValue, node, columnIndex);
            }
        }

        Object getValueAt(TreeNode node, int column) {
            return this.treeTableModel.getValueAt(node, column);
        }
    }

    private static class ProfilerTreeTableSorter
    extends ProfilerRowSorter {
        private final TableModelImpl model;
        private List<RowSorter.SortKey> sortKeys;
        private boolean sorting;

        ProfilerTreeTableSorter(TableModel model) {
            super(model);
            this.model = (TableModelImpl)model;
        }

        @Override
        public int convertRowIndexToModel(int index) {
            return index;
        }

        @Override
        public int convertRowIndexToView(int index) {
            return index;
        }

        @Override
        public int getViewRowCount() {
            return this.model.getRowCount();
        }

        @Override
        public int getModelRowCount() {
            return this.model.getRowCount();
        }

        @Override
        public void sort() {
            this.sorting = true;
            super.sort();
            this.sorting = false;
        }

        @Override
        public RowFilter getRowFilter() {
            return this.sorting ? null : super.getRowFilter();
        }

        @Override
        protected void setSortKeysImpl(List newKeys) {
            this.sortKeys = newKeys == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList(newKeys));
            this.model.sort(this.createComparator(newKeys));
        }

        @Override
        public List<? extends RowSorter.SortKey> getSortKeys() {
            return this.sortKeys;
        }

        protected Comparator createComparator(List<RowSorter.SortKey> sortKeys) {
            if (sortKeys == null || sortKeys.isEmpty()) {
                return null;
            }
            RowSorter.SortKey sortKey = sortKeys.get(0);
            SortOrder sortOrder = sortKey.getSortOrder();
            if (SortOrder.UNSORTED.equals((Object)sortOrder)) {
                return null;
            }
            final boolean ascending = SortOrder.ASCENDING.equals((Object)sortOrder);
            final int sortColumn = sortKey.getColumn();
            Class columnClass = this.model.getColumnClass(sortColumn);
            final Comparator comp = JTree.class.equals((Object)columnClass) ? null : (Comparable.class.isAssignableFrom(columnClass) ? new Comparator(){

                public int compare(Object o1, Object o2) {
                    return ((Comparable)o1).compareTo(o2);
                }
            } : this.getComparator(sortColumn));
            return new Comparator(){

                public int compare(Object o1, Object o2) {
                    int result;
                    if (o1 instanceof CCTNode.FixedPosition) {
                        result = o1 instanceof CCTNode.AlwaysFirst ? -1 : 1;
                        result = ascending ? result : -result;
                    } else if (o2 instanceof CCTNode.FixedPosition) {
                        result = o2 instanceof CCTNode.AlwaysFirst ? 1 : -1;
                        result = ascending ? result : -result;
                    } else {
                        Object v2;
                        Object v1;
                        result = comp == null ? o1.toString().compareTo(o2.toString()) : ((v1 = model.getValueAt((TreeNode)o1, sortColumn)) == (v2 = model.getValueAt((TreeNode)o2, sortColumn)) ? 0 : (v1 == null ? -1 : (v2 == null ? 1 : comp.compare(v1, v2))));
                    }
                    return ascending ? result : result * -1;
                }
            };
        }
    }

    private static class ProfilerRendererWrapper
    implements TreeCellRenderer,
    ProfilerRenderer {
        private final ProfilerRenderer renderer;

        ProfilerRendererWrapper(ProfilerRenderer renderer) {
            this.renderer = renderer;
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            this.setValue(value, row);
            JComponent comp = this.getComponent();
            comp.setOpaque(false);
            if (tree != null) {
                comp.setForeground(tree.getForeground());
                comp.setBackground(tree.getBackground());
            }
            return comp;
        }

        @Override
        public void setValue(Object value, int row) {
            this.renderer.setValue(value, row);
        }

        @Override
        public int getHorizontalAlignment() {
            return this.renderer.getHorizontalAlignment();
        }

        @Override
        public JComponent getComponent() {
            return this.renderer.getComponent();
        }

        @Override
        public void move(int x, int y) {
            this.renderer.move(x, y);
        }

        public String toString() {
            return this.renderer.toString();
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            return this.renderer.getAccessibleContext();
        }
    }

    public static abstract class NodeExpansionEvaluator {
        public abstract Boolean hasBeenExpanded(TreePath var1);
    }
}

