/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.truffle.details;

import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.api.DetailsSupport;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.spi.DetailsProvider;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.spi.DetailsUtils;

public class TruffleDetailsProvider
extends DetailsProvider.Basic {
    private static final String DEFAULT_CALL_TARGET_MASK = "com.oracle.truffle.api.impl.DefaultCallTarget";
    private static final String OPTIMIZED_CALL_TARGET_MASK = "org.graalvm.compiler.truffle.OptimizedCallTarget";
    private static final String OPTIMIZED_CALL_TARGET1_MASK = "org.graalvm.compiler.truffle.runtime.OptimizedCallTarget+";
    private static final String ENT_OPTIMIZED_CALL_TARGET_MASK = "com.oracle.graal.truffle.OptimizedCallTarget";
    private static final String LANG_INFO_MASK = "com.oracle.truffle.api.nodes.LanguageInfo";
    private static final String LANG_CACHE_MASK = "com.oracle.truffle.api.vm.LanguageCache";
    private static final String LANG_CACHE1_MASK = "com.oracle.truffle.polyglot.LanguageCache";
    private static final String POLYGLOT_MASK = "com.oracle.truffle.api.vm.PolyglotLanguage";
    private static final String INSTRUMENT_INFO_MASK = "com.oracle.truffle.api.InstrumentInfo";
    private static final String NATIVE_ROOT_MASK = "com.oracle.truffle.nfi.LibFFIFunctionMessageResolutionForeign$ExecuteLibFFIFunctionSubNode$EXECUTERootNode";
    private static final String NODE_MASK = "com.oracle.truffle.api.nodes.Node+";

    public TruffleDetailsProvider() {
        super(new String[]{DEFAULT_CALL_TARGET_MASK, OPTIMIZED_CALL_TARGET_MASK, OPTIMIZED_CALL_TARGET1_MASK, ENT_OPTIMIZED_CALL_TARGET_MASK, LANG_INFO_MASK, LANG_CACHE_MASK, LANG_CACHE1_MASK, POLYGLOT_MASK, INSTRUMENT_INFO_MASK, NATIVE_ROOT_MASK, NODE_MASK});
    }

    public String getDetailsString(String className, Instance instance) {
        if (DEFAULT_CALL_TARGET_MASK.equals(className)) {
            String rootNode = DetailsUtils.getInstanceFieldString((Instance)instance, (String)"rootNode");
            if (rootNode != null) {
                return rootNode;
            }
            return DetailsUtils.getInstanceFieldString((Instance)instance, (String)"name");
        }
        if (OPTIMIZED_CALL_TARGET_MASK.equals(className) || OPTIMIZED_CALL_TARGET1_MASK.equals(className) || ENT_OPTIMIZED_CALL_TARGET_MASK.equals(className)) {
            String rootNode = DetailsUtils.getInstanceFieldString((Instance)instance, (String)"rootNode");
            if (rootNode != null) {
                Object entryPoint = instance.getValueOfField("entryPoint");
                if (entryPoint instanceof Long && (Long)entryPoint != 0L) {
                    rootNode = rootNode + " <opt>";
                }
                if (instance.getValueOfField("sourceCallTarget") != null) {
                    rootNode = rootNode + " <split-" + Long.toHexString(instance.getInstanceId()) + ">";
                }
                return rootNode;
            }
            return DetailsUtils.getInstanceFieldString((Instance)instance, (String)"name");
        }
        if (LANG_INFO_MASK.equals(className) || LANG_CACHE_MASK.equals(className) || LANG_CACHE1_MASK.equals(className)) {
            String name = DetailsUtils.getInstanceFieldString((Instance)instance, (String)"name");
            String version = DetailsUtils.getInstanceFieldString((Instance)instance, (String)"version");
            if (name != null && version != null) {
                return name + " (version " + version + ")";
            }
            return name;
        }
        if (POLYGLOT_MASK.equals(className)) {
            return DetailsUtils.getInstanceFieldString((Instance)instance, (String)"info");
        }
        if (INSTRUMENT_INFO_MASK.equals(className)) {
            String name = DetailsUtils.getInstanceFieldString((Instance)instance, (String)"name");
            String version = DetailsUtils.getInstanceFieldString((Instance)instance, (String)"version");
            if (name != null && !name.isEmpty() && version != null && !version.isEmpty()) {
                return name + " (version " + version + ")";
            }
            if (name == null || name.isEmpty()) {
                return DetailsUtils.getInstanceFieldString((Instance)instance, (String)"id");
            }
            return name;
        }
        if (NATIVE_ROOT_MASK.equals(className)) {
            return "native call";
        }
        if (NODE_MASK.equals(className)) {
            return DetailsUtils.getInstanceFieldString((Instance)instance, (String)"sourceSection");
        }
        return null;
    }

    public DetailsProvider.View getDetailsView(String className, Instance instance) {
        Object val;
        if (NODE_MASK.equals(className) && (val = instance.getValueOfField("sourceSection")) instanceof Instance) {
            Instance sourceSection = (Instance)val;
            return DetailsSupport.getDetailsView((Instance)sourceSection);
        }
        return null;
    }
}

