/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.FontLibrary;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.RoadPainter;
import net.sf.freecol.common.debug.DebugUtils;
import net.sf.freecol.common.debug.FreeColDebugger;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ColonyTile;
import net.sf.freecol.common.model.Direction;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.LostCityRumour;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Resource;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovement;
import net.sf.freecol.common.model.TileItem;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.resources.ResourceManager;
import net.sf.freecol.common.util.StringUtils;
import net.sf.freecol.common.util.Utils;

public final class TileViewer {
    private static final Logger logger = Logger.getLogger(TileViewer.class.getName());
    private final FreeColClient freeColClient;
    private ImageLibrary lib;
    private RoadPainter rp;
    private int tileHeight;
    private int tileWidth;
    private int halfHeight;
    private int halfWidth;
    static final int STATE_OFFSET_X = 25;
    static final int STATE_OFFSET_Y = 10;
    private final GeneralPath fog = new GeneralPath();

    TileViewer(FreeColClient freeColClient) {
        this.freeColClient = freeColClient;
        this.setImageLibraryAndUpdateData(new ImageLibrary());
    }

    ImageLibrary getImageLibrary() {
        return this.lib;
    }

    static BufferedImage createTileImageWithOverlayAndForest(TileType type, Dimension size) {
        BufferedImage forestImage;
        Dimension size2 = new Dimension(size.width > 0 ? size.width : (2 * ImageLibrary.TILE_SIZE.width * size.height + (ImageLibrary.TILE_OVERLAY_SIZE.height + 1)) / (2 * ImageLibrary.TILE_OVERLAY_SIZE.height), -1);
        BufferedImage terrainImage = ImageLibrary.getTerrainImage(type, 0, 0, size2);
        BufferedImage overlayImage = ImageLibrary.getOverlayImage(type, type.getId(), size2);
        BufferedImage bufferedImage = forestImage = type.isForested() ? ImageLibrary.getForestImage(type, size2) : null;
        if (overlayImage == null && forestImage == null) {
            return terrainImage;
        }
        int width = terrainImage.getWidth();
        int height = terrainImage.getHeight();
        if (overlayImage != null) {
            height = Math.max(height, overlayImage.getHeight());
        }
        if (forestImage != null) {
            height = Math.max(height, forestImage.getHeight());
        }
        BufferedImage compositeImage = new BufferedImage(width, height, 2);
        Graphics2D g = compositeImage.createGraphics();
        g.drawImage((Image)terrainImage, 0, height - terrainImage.getHeight(), null);
        if (overlayImage != null) {
            g.drawImage((Image)overlayImage, 0, height - overlayImage.getHeight(), null);
        }
        if (forestImage != null) {
            g.drawImage((Image)forestImage, 0, height - forestImage.getHeight(), null);
        }
        g.dispose();
        return compositeImage;
    }

    BufferedImage createTileImageWithBeachBorderAndItems(Tile tile) {
        if (!tile.isExplored()) {
            return this.lib.getTerrainImage(null, tile.getX(), tile.getY());
        }
        TileType tileType = tile.getType();
        Dimension terrainTileSize = this.lib.tileSize;
        BufferedImage overlayImage = this.lib.getOverlayImage(tile);
        int compoundHeight = overlayImage != null ? overlayImage.getHeight() : (tileType.isForested() ? this.lib.tileForestSize.height : terrainTileSize.height);
        BufferedImage image = new BufferedImage(terrainTileSize.width, compoundHeight, 2);
        Graphics2D g = image.createGraphics();
        g.translate(0, compoundHeight - terrainTileSize.height);
        this.displayTileWithBeachAndBorder(g, tile);
        this.displayTileItems(g, tile, overlayImage);
        g.dispose();
        return image;
    }

    BufferedImage createTileImage(Tile tile) {
        TileType tileType = tile.getType();
        Dimension terrainTileSize = this.lib.tileSize;
        BufferedImage overlayImage = this.lib.getOverlayImage(tile);
        int compoundHeight = overlayImage != null ? overlayImage.getHeight() : (tileType.isForested() ? this.lib.tileForestSize.height : terrainTileSize.height);
        BufferedImage image = new BufferedImage(terrainTileSize.width, compoundHeight, 2);
        Graphics2D g = image.createGraphics();
        g.translate(0, compoundHeight - terrainTileSize.height);
        this.displayTile(g, tile, overlayImage);
        g.dispose();
        return image;
    }

    BufferedImage createColonyTileImage(Tile tile, Colony colony) {
        TileType tileType = tile.getType();
        Dimension terrainTileSize = this.lib.tileSize;
        BufferedImage overlayImage = this.lib.getOverlayImage(tile);
        int compoundHeight = overlayImage != null ? overlayImage.getHeight() : (tileType.isForested() ? this.lib.tileForestSize.height : terrainTileSize.height);
        BufferedImage image = new BufferedImage(terrainTileSize.width, compoundHeight, 2);
        Graphics2D g = image.createGraphics();
        g.translate(0, compoundHeight - terrainTileSize.height);
        this.displayColonyTile(g, tile, colony, overlayImage);
        g.dispose();
        return image;
    }

    void displayColonyTiles(Graphics2D g, Tile[][] tiles, Colony colony) {
        Set<String> overlayCache = ImageLibrary.createOverlayCache();
        Dimension tileSize = this.lib.tileSize;
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                if (tiles[x][y] == null) continue;
                int xx = (2 - x + y) * tileSize.width / 2;
                int yy = (x + y) * tileSize.height / 2;
                g.translate(xx, yy);
                BufferedImage overlayImage = this.lib.getOverlayImage(tiles[x][y], overlayCache);
                this.displayColonyTile(g, tiles[x][y], colony, overlayImage);
                g.translate(-xx, -yy);
            }
        }
    }

    private void displayColonyTile(Graphics2D g, Tile tile, Colony colony, BufferedImage overlayImage) {
        Unit unit;
        this.displayTile(g, tile, overlayImage);
        ColonyTile colonyTile = colony.getColonyTile(tile);
        switch (colonyTile.getNoWorkReason()) {
            case NONE: 
            case COLONY_CENTER: 
            case CLAIM_REQUIRED: {
                break;
            }
            default: {
                g.drawImage((Image)this.lib.getMiscImage("image.tile.tileTaken"), 0, 0, null);
            }
        }
        int price = colony.getOwner().getLandPrice(tile);
        if (price > 0 && !tile.hasSettlement()) {
            BufferedImage image = this.lib.getMiscImage("image.tileitem.nativeLand");
            this.displayCenteredImage(g, image);
        }
        if ((unit = colonyTile.getOccupyingUnit()) != null) {
            BufferedImage image = this.lib.getSmallerUnitImage(unit);
            g.drawImage((Image)image, this.tileWidth / 4 - image.getWidth() / 2, this.halfHeight - image.getHeight() / 2, null);
            Player owner = this.freeColClient.getMyPlayer();
            String text = Messages.message(unit.getOccupationLabel(owner, false));
            g.drawImage((Image)this.lib.getOccupationIndicatorChip(g, unit, text), (int)(25.0f * this.lib.getScaleFactor()), 0, null);
        }
    }

    private void displayTile(Graphics2D g, Tile tile, BufferedImage overlayImage) {
        this.displayTileWithBeachAndBorder(g, tile);
        if (tile.isExplored()) {
            this.displayTileItems(g, tile, overlayImage);
            this.displaySettlementWithChipsOrPopulationNumber(g, tile, false);
            this.displayFogOfWar(g, tile);
            this.displayOptionalTileText(g, tile);
        }
    }

    void setImageLibraryAndUpdateData(ImageLibrary lib) {
        this.lib = lib;
        Dimension tileSize = lib.tileSize;
        this.rp = new RoadPainter(tileSize);
        this.tileHeight = tileSize.height;
        this.tileWidth = tileSize.width;
        this.halfHeight = this.tileHeight / 2;
        this.halfWidth = this.tileWidth / 2;
        this.fog.reset();
        this.fog.moveTo(this.halfWidth, 0.0f);
        this.fog.lineTo(this.tileWidth, this.halfHeight);
        this.fog.lineTo(this.halfWidth, this.tileHeight);
        this.fog.lineTo(0.0f, this.halfHeight);
        this.fog.closePath();
    }

    void displayCenteredImage(Graphics2D g, BufferedImage image) {
        g.drawImage((Image)image, (this.tileWidth - image.getWidth()) / 2, (this.tileHeight - image.getHeight()) / 2, null);
    }

    void displayLargeCenteredImage(Graphics2D g, BufferedImage image) {
        int y = this.tileHeight - image.getHeight();
        if (y > 0) {
            y /= 2;
        }
        g.drawImage((Image)image, (this.tileWidth - image.getWidth()) / 2, y, null);
    }

    void displayTileWithBeachAndBorder(Graphics2D g, Tile tile) {
        if (tile != null) {
            TileType tileType = tile.getType();
            int x = tile.getX();
            int y = tile.getY();
            g.drawImage((Image)this.lib.getTerrainImage(tileType, x, y), 0, 0, null);
            if (tile.isExplored()) {
                if (!tile.isLand() && tile.getStyle() > 0) {
                    int cornerStyle;
                    int edgeStyle = tile.getStyle() >> 4;
                    if (edgeStyle > 0) {
                        g.drawImage((Image)this.lib.getBeachEdgeImage(edgeStyle, x, y), 0, 0, null);
                    }
                    if ((cornerStyle = tile.getStyle() & 0xF) > 0) {
                        g.drawImage((Image)this.lib.getBeachCornerImage(cornerStyle, x, y), 0, 0, null);
                    }
                }
                ArrayList<SortableImage> imageBorders = new ArrayList<SortableImage>(8);
                for (Direction direction : Direction.values()) {
                    TileType borderingTileType;
                    Tile borderingTile = tile.getNeighbourOrNull(direction);
                    if (borderingTile == null || !borderingTile.isExplored() || (borderingTileType = borderingTile.getType()) == tileType) continue;
                    if (!tile.isLand() && borderingTile.isLand()) {
                        SortableImage si = new SortableImage(this.lib.getBorderImage(borderingTileType, direction, x, y), borderingTileType.getIndex());
                        imageBorders.add(si);
                        TileImprovement river = borderingTile.getRiver();
                        if (river == null || !river.isConnectedTo(direction.getReverseDirection())) continue;
                        si = new SortableImage(this.lib.getRiverMouthImage(direction, borderingTile.getRiver().getMagnitude(), x, y), -1);
                        imageBorders.add(si);
                        continue;
                    }
                    if (tile.isLand() && !borderingTile.isLand() || borderingTileType.getIndex() >= tileType.getIndex() || this.lib.getTerrainImage(tileType, 0, 0).equals(this.lib.getTerrainImage(borderingTileType, 0, 0))) continue;
                    SortableImage si = new SortableImage(this.lib.getBorderImage(borderingTileType, direction, x, y), borderingTileType.getIndex());
                    imageBorders.add(si);
                }
                Collections.sort(imageBorders);
                for (SortableImage sorted : imageBorders) {
                    g.drawImage((Image)sorted.image, 0, 0, null);
                }
            }
        }
    }

    void displayUnknownTileBorder(Graphics2D g, Tile tile) {
        for (Direction direction : Direction.values()) {
            Tile borderingTile = tile.getNeighbourOrNull(direction);
            if (borderingTile == null || borderingTile.isExplored()) continue;
            g.drawImage((Image)this.lib.getBorderImage(null, direction, tile.getX(), tile.getY()), 0, 0, null);
        }
    }

    void displayFogOfWar(Graphics2D g, Tile tile) {
        if (this.freeColClient.getGame() != null && this.freeColClient.getGame().getSpecification().getBoolean("model.option.fogOfWar") && this.freeColClient.getMyPlayer() != null && !this.freeColClient.getMyPlayer().canSee(tile)) {
            g.setColor(Color.BLACK);
            Composite oldComposite = g.getComposite();
            g.setComposite(AlphaComposite.getInstance(3, 0.2f));
            g.fill(this.fog);
            g.setComposite(oldComposite);
        }
    }

    void displayOptionalTileText(Graphics2D g, Tile tile) {
        String value;
        String text = null;
        int op = this.freeColClient.getClientOptions().getInteger("model.option.displayTileText");
        switch (op) {
            case 1: {
                text = Messages.getName(tile);
                break;
            }
            case 2: {
                if (tile.getOwner() == null) break;
                text = Messages.message(tile.getOwner().getNationLabel());
                break;
            }
            case 3: {
                if (tile.getRegion() == null) break;
                if (FreeColDebugger.isInDebugMode(FreeColDebugger.DebugMode.MENUS) && tile.getRegion().getName() == null) {
                    text = tile.getRegion().getSuffix();
                    break;
                }
                text = Messages.message(tile.getRegion().getLabel());
                break;
            }
            case 0: {
                break;
            }
            default: {
                logger.warning("displayTileText option " + op + " out of range");
            }
        }
        g.setColor(Color.BLACK);
        g.setFont(FontLibrary.createFont(FontLibrary.FontType.NORMAL, FontLibrary.FontSize.TINY, this.lib.getScaleFactor()));
        if (text != null) {
            int b = StringUtils.getBreakingPoint(text);
            if (b == -1) {
                g.drawString(text, (this.tileWidth - g.getFontMetrics().stringWidth(text)) / 2, (this.tileHeight - g.getFontMetrics().getAscent()) / 2);
            } else {
                g.drawString(text.substring(0, b), (this.tileWidth - g.getFontMetrics().stringWidth(text.substring(0, b))) / 2, this.halfHeight - g.getFontMetrics().getAscent() * 2 / 3);
                g.drawString(text.substring(b + 1), (this.tileWidth - g.getFontMetrics().stringWidth(text.substring(b + 1))) / 2, this.halfHeight + g.getFontMetrics().getAscent() * 2 / 3);
            }
        }
        if (FreeColDebugger.debugDisplayCoordinates()) {
            String posString = tile.getX() + ", " + tile.getY();
            if (tile.getHighSeasCount() >= 0) {
                posString = posString + "/" + Integer.toString(tile.getHighSeasCount());
            }
            g.drawString(posString, (this.tileWidth - g.getFontMetrics().stringWidth(posString)) / 2, (this.tileHeight - g.getFontMetrics().getAscent()) / 2);
        }
        if ((value = DebugUtils.getColonyValue(tile)) != null) {
            g.drawString(value, (this.tileWidth - g.getFontMetrics().stringWidth(value)) / 2, (this.tileHeight - g.getFontMetrics().getAscent()) / 2);
        }
    }

    void displaySettlementWithChipsOrPopulationNumber(Graphics2D g, Tile tile, boolean withNumber) {
        Player player = this.freeColClient.getMyPlayer();
        Settlement settlement = tile.getSettlement();
        if (settlement != null) {
            if (settlement instanceof Colony) {
                Colony colony = (Colony)settlement;
                BufferedImage colonyImage = this.lib.getSettlementImage(settlement);
                this.displayLargeCenteredImage(g, colonyImage);
                if (withNumber) {
                    String populationString = Integer.toString(colony.getDisplayUnitCount());
                    int bonus = colony.getProductionBonus();
                    Color theColor = ResourceManager.getColor("color.map.productionBonus." + bonus);
                    Font font = colony.getPreferredSizeChange() > 0 ? FontLibrary.createFont(FontLibrary.FontType.SIMPLE, FontLibrary.FontSize.SMALLER, 3, this.lib.getScaleFactor()) : FontLibrary.createFont(FontLibrary.FontType.SIMPLE, FontLibrary.FontSize.TINY, 1, this.lib.getScaleFactor());
                    BufferedImage stringImage = this.lib.getStringImage(g, populationString, theColor, font);
                    this.displayCenteredImage(g, stringImage);
                }
            } else if (settlement instanceof IndianSettlement) {
                BufferedImage chip;
                IndianSettlement is = (IndianSettlement)settlement;
                BufferedImage settlementImage = this.lib.getSettlementImage(settlement);
                this.displayCenteredImage(g, settlementImage);
                float xOffset = 25.0f * this.lib.getScaleFactor();
                float yOffset = 10.0f * this.lib.getScaleFactor();
                int colonyLabels = this.freeColClient.getClientOptions().getInteger("model.option.displayColonyLabels");
                if (colonyLabels != 2) {
                    chip = this.lib.getIndianSettlementChip(g, is);
                    g.drawImage((Image)chip, (int)xOffset, (int)yOffset, null);
                    xOffset += (float)(chip.getWidth() + 2);
                    Unit missionary = is.getMissionary();
                    if (missionary != null) {
                        boolean expert = missionary.hasAbility("model.ability.expertMissionary");
                        g.drawImage((Image)this.lib.getMissionChip(g, missionary.getOwner(), expert), (int)xOffset, (int)yOffset, null);
                        xOffset += (float)(chip.getWidth() + 2);
                    }
                }
                if ((chip = this.lib.getAlarmChip(g, is, player)) != null) {
                    g.drawImage((Image)chip, (int)xOffset, (int)yOffset, null);
                }
            } else {
                logger.warning("Bogus settlement: " + settlement);
            }
        }
    }

    void displayTileItems(Graphics2D g, Tile tile, BufferedImage overlayImage) {
        int startIndex;
        int index;
        List<Object> tileItems = tile.getTileItemContainer() != null ? tile.getTileItemContainer().getTileItems() : new ArrayList();
        for (index = startIndex = 0; index < tileItems.size(); ++index) {
            if (((TileItem)tileItems.get(index)).getZIndex() >= 100) {
                startIndex = index;
                break;
            }
            this.displayTileItem(g, tile, (TileItem)tileItems.get(index));
            startIndex = index + 1;
        }
        if (overlayImage != null) {
            g.drawImage((Image)overlayImage, 0, this.tileHeight - overlayImage.getHeight(), null);
        }
        for (index = startIndex; index < tileItems.size(); ++index) {
            if (((TileItem)tileItems.get(index)).getZIndex() >= 200) {
                startIndex = index;
                break;
            }
            this.displayTileItem(g, tile, (TileItem)tileItems.get(index));
            startIndex = index + 1;
        }
        if (tile.isForested()) {
            BufferedImage forestImage = this.lib.getForestImage(tile.getType(), tile.getRiverStyle());
            g.drawImage((Image)forestImage, 0, this.tileHeight - forestImage.getHeight(), null);
        }
        for (TileItem tileItem : tileItems.subList(startIndex, tileItems.size())) {
            this.displayTileItem(g, tile, tileItem);
        }
    }

    private void displayTileItem(Graphics2D g, Tile tile, TileItem item) {
        if (item instanceof TileImprovement) {
            this.displayTileImprovement(g, tile, (TileImprovement)item);
        } else if (item instanceof LostCityRumour) {
            this.displayLostCityRumour(g);
        } else {
            this.displayResourceTileItem(g, (Resource)item);
        }
    }

    private void displayResourceTileItem(Graphics2D g, Resource item) {
        BufferedImage bonusImage = this.lib.getMiscImage("image.tileitem." + item.getType().getId());
        this.displayCenteredImage(g, bonusImage);
    }

    private void displayLostCityRumour(Graphics2D g) {
        this.displayCenteredImage(g, this.lib.getMiscImage("image.tileitem.lostCityRumour"));
    }

    private void displayTileImprovement(Graphics2D g, Tile tile, TileImprovement ti) {
        if (ti.isComplete()) {
            if (ti.isRoad()) {
                this.rp.displayRoad(g, tile);
            } else if (ti.isRiver() && ti.getMagnitude() < 3) {
                if (ti.getStyle() != null) {
                    g.drawImage((Image)this.lib.getRiverImage(ti.getStyle()), 0, 0, null);
                }
            } else {
                String key = "image.tile." + ti.getType().getId();
                if (ResourceManager.hasImageResource(key)) {
                    BufferedImage overlay = ResourceManager.getImage(key, this.lib.tileSize);
                    g.drawImage((Image)overlay, 0, 0, null);
                }
            }
        }
    }

    private static class SortableImage
    implements Comparable<SortableImage> {
        public final BufferedImage image;
        public final int index;

        public SortableImage(BufferedImage image, int index) {
            this.image = image;
            this.index = index;
        }

        @Override
        public int compareTo(SortableImage other) {
            return other.index - this.index;
        }

        public boolean equals(Object other) {
            if (other instanceof SortableImage) {
                return this.compareTo((SortableImage)other) == 0;
            }
            return super.equals(other);
        }

        public int hashCode() {
            int hash = super.hashCode();
            hash = 37 * hash + Utils.hashCode(this.image);
            return 37 * hash + this.index;
        }
    }
}

