/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.spi.connector.transport;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.aether.spi.connector.transport.GetTask;
import org.eclipse.aether.spi.connector.transport.PeekTask;
import org.eclipse.aether.spi.connector.transport.PutTask;
import org.eclipse.aether.spi.connector.transport.TransportListener;
import org.eclipse.aether.spi.connector.transport.TransportTask;
import org.eclipse.aether.spi.connector.transport.Transporter;
import org.eclipse.aether.transfer.TransferCancelledException;

public abstract class AbstractTransporter
implements Transporter {
    private final AtomicBoolean closed = new AtomicBoolean();

    protected AbstractTransporter() {
    }

    @Override
    public void peek(PeekTask task) throws Exception {
        this.failIfClosed(task);
        this.implPeek(task);
    }

    protected abstract void implPeek(PeekTask var1) throws Exception;

    @Override
    public void get(GetTask task) throws Exception {
        this.failIfClosed(task);
        this.implGet(task);
    }

    protected abstract void implGet(GetTask var1) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void utilGet(GetTask task, InputStream is2, boolean close, long length, boolean resume) throws IOException, TransferCancelledException {
        OutputStream os = null;
        try {
            os = task.newOutputStream(resume);
            task.getListener().transportStarted(resume ? task.getResumeOffset() : 0L, length);
            AbstractTransporter.copy(os, is2, task.getListener());
            os.close();
            os = null;
            if (close) {
                is2.close();
                is2 = null;
            }
        }
        finally {
            block29: {
                block28: {
                    if (os == null) break block28;
                    os.close();
                }
                try {
                    if (close && is2 != null) {
                        is2.close();
                    }
                    break block29;
                }
                catch (IOException iOException) {}
                break block29;
                catch (IOException iOException) {
                    try {
                        if (close && is2 != null) {
                            is2.close();
                        }
                    }
                    catch (IOException iOException2) {}
                    catch (Throwable throwable) {
                        try {
                            if (close && is2 != null) {
                                is2.close();
                            }
                        }
                        catch (IOException iOException3) {}
                        throw throwable;
                    }
                }
            }
        }
    }

    @Override
    public void put(PutTask task) throws Exception {
        this.failIfClosed(task);
        this.implPut(task);
    }

    protected abstract void implPut(PutTask var1) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void utilPut(PutTask task, OutputStream os, boolean close) throws IOException, TransferCancelledException {
        InputStream is2 = null;
        try {
            task.getListener().transportStarted(0L, task.getDataLength());
            is2 = task.newInputStream();
            AbstractTransporter.copy(os, is2, task.getListener());
            if (close) {
                os.close();
            } else {
                os.flush();
            }
            os = null;
            is2.close();
            is2 = null;
        }
        finally {
            block30: {
                block29: {
                    if (!close || os == null) break block29;
                    os.close();
                }
                try {
                    if (is2 != null) {
                        is2.close();
                    }
                    break block30;
                }
                catch (IOException iOException) {}
                break block30;
                catch (IOException iOException) {
                    try {
                        if (is2 != null) {
                            is2.close();
                        }
                    }
                    catch (IOException iOException2) {}
                    catch (Throwable throwable) {
                        try {
                            if (is2 != null) {
                                is2.close();
                            }
                        }
                        catch (IOException iOException3) {}
                        throw throwable;
                    }
                }
            }
        }
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.implClose();
        }
    }

    protected abstract void implClose();

    private void failIfClosed(TransportTask task) {
        if (this.closed.get()) {
            throw new IllegalStateException("transporter closed, cannot execute task " + task);
        }
    }

    private static void copy(OutputStream os, InputStream is2, TransportListener listener) throws IOException, TransferCancelledException {
        ByteBuffer buffer = ByteBuffer.allocate(32768);
        byte[] array2 = buffer.array();
        int read2 = is2.read(array2);
        while (read2 >= 0) {
            os.write(array2, 0, read2);
            ((Buffer)buffer).rewind();
            ((Buffer)buffer).limit(read2);
            listener.transportProgressed(buffer);
            read2 = is2.read(array2);
        }
    }
}

