# Contributors to OpenRCT2
Includes all git commit authors. Aliases are GitHub user names.

## Development team
* Ted John (IntelOrca) - Owner
* Duncan Frost (duncanspumpkin)
* Michael Steenbeek (Gymnasiast) - translation management
* Michał Janiszewski (janisozaur)
* Hielke Morsink (Broxzier)
* Matthias Moninger (ZehMatt)
* Tulio Paschoalin Leao (tupaschoal)

## Former development team members
* Lewis Fox (LRFLEW)
* Marijn van der Werf (marijnvdwerf)
* (zsilencer)
* Richard Jenkins (rwjuk)
* Aaron van Geffen (AaronVanGeffen)

## Long term contributors
The following people are not part of the development team, but have been contributing for a long time.
* Matte Andersson (Nubbie)
* Kenton Boadway (Krutonium)
* Joe Minor Jr (wolfreak99)

## Implementation (RCT2)
* Ted John (IntelOrca)
* Duncan Frost (duncanspumpkin)
* Peter Hill (ZedThree) - String handling, misc.
* (qcz) - Scenery window, misc.
* Matthias Lanzinger (lnz) - Climate, finance, scenario, ride reachability
* (zsilencer) - Audio, multiplayer, misc.
* (DutchRPW) - peep_update_days_in_queue, misc. money-related functions
* Adrian Wielgosik (adrian17) - Ride window, top toolbar, map window, misc.
* (hexdec) - Music credits window, staff window, misc.
* Dennis Devriendt (ddevrien) - Banner window, map window, options window
* Maciek Baron (MaciekBaron) - Peep enums, item flags, misc.
* (Hual) - Minimap window resizing; address identification; sub_6C0C3F.
* (AngeloG) - Scrollbar input, misc.
* (jcdavis) - Misc.
* (marcotc) - Rain drawing, misc.
* (vanderkleij) - create_sprite, move_sprite_to_list
* Ben Pye (benpye) - Logo rendering on title screen
* (JeroenSack) - widget_scroll_get_part, misc.
* Sijmen Schoon (SijmenSchoon) - redraw_peep_and_rain, misc bugfixes.
* Lewis Fox (LRFLEW) - sub_69A997, OpenGL support, macOS
* Marijn van der Werf (marijnvdwerf) - Peep functions, drawing and paint code

## Additional implementation (OpenRCT2)
* (atmaxinger) - User configuration
* (anyc) - Housecleaning, cross-platform fixes
* Michael Steenbeek (Gymnasiast) - Cheats, RCT1 ride style, misc.
* Miso Zmiric (mzmiric5) - Old Twitch integration, misc.
* Inseok Lee (dlunch) - Load save files from command line
* Jørn Lomax (jvlomax) - Configuration parser
* Alexander Overvoorde (Overv) - OpenGL improvements, Steam overlay detection, various bugfixes.
* (eezstreet) - Add finances button to toolbar
* Hielke Morsink (Broxzier) - Tile inspector, heightmap loader, misc.
* Joe Minor Jr (wolfreak99) - Various cheats, bugfixes, new About and Changelog windows.
* Thomas den Hollander (ThomasdenH) - Dithering in sprite importer, invert viewport dragging, park rating cheats misc.
* James Robertson (rd3k) - Initial tile inspector, misc changes.
* Robert Jordan (trigger-death) - UI theming, title sequence editor, misc.
* Aaron van Geffen (AaronVanGeffen) - scenario select screen, font detection, misc.
* Michał Janiszewski (janisozaur) - Linux port, crash handling, security, misc.
* Kelson Blakewood (spacek531) - title sequences, title sequence features, vehicle features
* Hugo Wallenburg (Goddesen) - Misc.
* Edward Calver (X7123M3-256) - New Hybrid Coaster track, extended sprite toolchain, more vehicle cheats, misc.
* Matte Andersson (Nubbie) - Misc, UX
* Daniel Trujillo Viedma (gDanix) - Custom currency.
* (zaxcav) - Improvements to original pathfinding algorithm.
* Jeroen D. Stout (JeroenDStout) - Light effects, train crossings, virtual floor.
* Matthias Moninger (ZehMatt) - Game actions, multiplayer synchronisation, misc.
* Joël Troch (JoelTroch) - Keyboard shortcuts for ride construction.
* Thomas Delebo (delebota) - Server descriptions and greetings.
* Richard Jenkins (rwjuk) - Path issues overlay, console improvements, bug fixes
* Brian Callahan (ibara) - OpenBSD port.
* Jens Heuseveldt (jensj12) - Mountain tool improvements, misc.
* Park Joon-Kyu (segfault87) - Allow filtering guests by name
* Harrison Gentry (hgentry) - Date-changing command, misc.
* Joshua Moerman (Jaxan) - Minimap cleanup, misc.
* Nicolas Hawrysh (xp4xbox) - Various (ride) sprite improvements.
* Albert Morgese (Fusxfaranto) - Shop auto-rotation, unicode uppercasing.
* Olivier Wervers (oli414) - Remove unused objects command, various bugfixes
* Christian Schubert (Osmodium) - Ensuring custom user content folders, incl. open folder.
* (Xkeeper0) - Improved banner tooltips; multiplayer status in toolbar.
* Kevin Strehl (bitman2049) - Tile inspector keybindings
* Anton Scharnowski (scrapes) - Added Scenery Scatter Options Window.
* Chad Ian Anderson (pizza2004) - Added New Game option, bug fixes, misc.
* Peter Ryszkiewicz (pRizz) - Added horizontal grid lines to finance charts.
* Hudson Oliveira (hdpoliveira) - Misc.
* Jim Verheijde (Jimver) - Make handymen less likely to get stuck in queue lines, misc.
* Helio Batimarqui (batimarqui) - Misc.
* Keith Stellyes (keithstellyes) - Misc.
* Bas Cantrijn (Basssiiie) - Various plugin additions, misc.
* Adrian Zdanowicz (CookiePLMonster) - Misc.
* Andrew Pratt (andrewpratt64) - Added api hook for vehicle crashes

## Bug fixes
* (KirilAngelov)
* (halfbro)
* (Myrtle)
* (nean)
* Ed Foley (e-foley)
* Michael Pham (nightroan)
* Lucas Riutzel (jackinloadup)
* Youngjae Yu (YJSoft)
* Chanwoong Kim (kexplo)
* Josué Acevedo (Wirlie)
* Martin Černáč (octaroot)
* (marcovmun)
* Sven Slootweg (joepie91)
* Daniel Trujillo Viedma (gDanix)
* Niels NTG Poldervaart (Niels-NTG) - Screenshot filenames
* Jonathan Haas (HaasJona)
* Jake Breen (Haekb)
* Marco Benzi Tobar (Lisergishnu)
* (ceeac)
* Tomas Dittmann (Chaosmeister)
* William Wallace (Willox)
* Christian Friedrich Coors (ccoors)
* Robbin Voortman (rvoortman)
* Willem J. Lee (telk5093)
* Ethan Smith (ethanhs) - Refactor MAX_PATH
* Robert Lewicki (rlewicki)
* Liam Parker (elInfidel)
* Tyler Ruckinger (TyPR124)
* Justin Gottula (jgottula)
* Seongsik Park (pss9205)
* (Deurklink)
* Nathan Zabriskie (NathanZabriskie)
* Toby Hinloopen (tobyhinloopen)
* Patrick Martinez (martip23)
* Andy Ford (AndyTWF)
* Matthew Beaudin (mattbeaudin)
* Øystein Dale (oystedal)
* Christian Schubert (Osmodium)
* James Lord (RCTMASTA)
* Brian Massino (Nazey), Lauren Watson (lwatson2016), Jason Myre (jmyre1999), Nicole Wright (nicolewright), Josh Tucker (joshtucker132)
* Hussein Okasha (Hokasha2016), Brandon Dupree (Bdupree5), Zetao Ye (ZbrettonYe), Jordan Arevalos (Jarevalos2017)
* Florian Will (w-flo)
* Trevor Harkness (tharkne), Steve Xu (stevexu-umich)
* (aw20368)
* Jim Armstrong (41northstudios)
* Kenny Castro-Monroy (kennycastro007)
* Joseph Atkins-Turkish (Spacerat)
* Denis Khabenkov (kodmord)
* Kevin Laframboise (klaframboise)
* Tushar Sariya (TusharSariya)
* (WantDiscussion)
* Tomáš Žilínek (TomasZilinek)
* Mustapha Elghoul (mustaphaelghoul)
* Tyler Leamon (tylerleamon)
* Michael Coates (outerwear)
* Reid Baris (Rdbaris)
* Deanna Baris (dbaris)
* Chaitanya Thengdi (chaitanyathengdi)
* Sidney Kuyateh (autinerd)
* Łukasz Pękalski (Lukasz-Pe)
* (quale)
* Arran Ireland (ion232)
* Ryan Bello (ryan-bello)
* Simon Jarrett (mwnciau)
* Richard Fine (richard-fine)
* Tom Parsons (tombomp)
* Stephan Spengler (Sadret)
* Roger Seekell (rpstester)
* Ben Johnston (gsckoco)
* (evilclownattack)
* Adam Bloom (adam-bloom)
* Geoff B. (geoff-B)
* Ryan D. (rctdude2)
* (zrowny)
* Emre Aydin (aemreaydin)
* Daniel Karandikar (DKarandikar)
* Struan Clark (xtruan)
* Kane Shaw (seifer7)
* Saad Rehman (SaadRehmanCS)
* (ocalhoun6)
* Sean Payne (seanmajorpayne)
* Soham Roy (sohamroy19)
* Gaven Rendell (Rendello)
* Christian Haase (chrhaase)

## Toolchain
* (Balletie) - macOS
* Kevin Burke (kevinburke) - macOS, Unix
* Miso Zmiric (mzmiric5) - Initial macOS toolchain
* Jarno Veuger (JarnoVgr) - Windows build server
* Ted John (IntelOrca) - Windows
* Michał Janiszewski (janisozaur) - Linux, Travis CI
* Lewis Fox (LRFLEW) - macOS
* Andrew Rimpici (Andy608) - macOS
* Adam Bloom (adam-bloom) - macOS, CI

## Documentation
* (honzi)
* Kevin Burke (kevinburke)
* James Robertson (rd3k)
* Max Boße (MakaHost)
* (MaxBareiss)
* Mithun Hunsur (Philpax)
* (RollingStar)

## Translation
* Extracting from original files: Ted John (IntelOrca)
* Reviewing and merging: Michael Steenbeek (Gymnasiast), Matte Andersson (Nubbie), Rune Laenen (runelaenen) (formerly)
* Fixing unmaintained languages: Michael Steenbeek (Gymnasiast)
* Miscellaneous fixes: Alexander Overvoorde (Overv), Ed Foley (e-foley)

* English (UK) - Ted John (IntelOrca), (Tinytimrob)
* English (US) - Ted John (IntelOrca), Michael Steenbeek (Gymnasiast); small fixes: (LRFLEW), (mike-koch), Harry Lam (daihakken)
* Catalan - Joan Josep (J0anJosep)
* Chinese (Simplified) - Naiji Ma (naijim), (izhangfei), Eric Zhao (sczyh30), (Muhhan)
* Chinese (Traditional) - Harry Lam (daihakken)
* Czech - Martin Černáč (octaroot), (Clonewayx), Tomáš Pazdiora (Aroidzap)
* Danish - Lars P. Sørensen (LPSGizmo)
* Dutch - Michael Steenbeek (Gymnasiast), Yannic Geurts (xzbobzx), (mrtnptrs), Thomas den Hollander (ThomasdenH), (hostbrute),  Marijn van der Werf (marijnvdwerf), Tom Kroes (ThePsionic); reviewing and discussion: Aaron van Geffen (AaronVanGeffen), (Balletie) and Sijmen Schoon (SijmenSchoon).
* Finnish - (DJHasis), (Zode), (TheWing)
* French - (fbourigault), Joël Troch (JoelTroch), Michael Steenbeek (Gymnasiast), Romain Vigier (rmnvgr), (AziasYur), Hugo Courtial (s0r00t), David Delobel (incyclum), Nicolas Hawrysh (xp4xbox)
* German - (danidoedel), (atmaxinger), (Yepoleb), Daniel Kessel (dkessel), Leon (AllGoodNamesAreTaken), (raidcookie)
* Italian - Luca Andrea Rossi (LucaRed), Precious Ugo Abara (48cfu)
* Japanese - Aaron van Geffen (AaronVanGeffen), Haruna Chinzei, Nick Hall (nickhall), (jhako), Harry Lam (daihakken)
* Korean - Willem J. Lee (telk5093), (NeverDruid); small fixes: (kexplo)
* Norwegian - Hugo Wallenburg (Goddesen)
* Polish - Adrian Wielgosik (adrian17), (lopezloo), Michał Janiszewski (janisozaur)
* Portuguese (BR) - (kaudy), (renansimoes), Tulio Paschoalin Leao (tupaschoal)
* Russian - (Soosisya)
* Spanish - (mdtrooper), Josué Acevedo (Wirlie), Daniel Trujillo Viedma (gDanix); small fixes: (teapartycthulu)
* Swedish - (Jinxit), (mharrys), (Slimeyo), Matte Andersson (Nubbie)

## Graphics
* OpenRCT2 Logo - Yannic Geurts (xzbobzx)
* Booster Sprites - Nicolas Hawrysh (xp4xbox)

## RollerCoaster Tycoon 2 credits
Design and programming by Chris Sawyer
Graphics by Simon Foster
Sound and music by Allister Brimble
Additional sounds recorded by David Ellis
Representation by Jacqui Lyons at Marjacq Ltd.

Thanks to: Peter James Adcock, Joe Booth, and John Wardley

Licensed to Infogrames Interactive Inc.
