from enum import IntEnum
from typing import overload, NewType, Optional, Tuple

from OCC.Core.Standard import *
from OCC.Core.NCollection import *
from OCC.Core.gp import *
from OCC.Core.Plate import *
from OCC.Core.Geom import *


class NLPlate_SequenceOfHGPPConstraint:
    def __init__(self) -> None: ...
    def __len__(self) -> int: ...
    def Size(self) -> int: ...
    def Clear(self) -> None: ...
    def First(self) -> False: ...
    def Last(self) -> False: ...
    def Length(self) -> int: ...
    def Append(self, theItem: False) -> False: ...
    def Prepend(self, theItem: False) -> False: ...
    def RemoveFirst(self) -> None: ...
    def Reverse(self) -> None: ...
    def Value(self, theIndex: int) -> False: ...
    def SetValue(self, theIndex: int, theValue: False) -> None: ...

class NLPlate_StackOfPlate:
    def __init__(self) -> None: ...
    def __len__(self) -> int: ...
    def Size(self) -> int: ...
    def Clear(self) -> None: ...
    def First(self) -> Plate_Plate: ...
    def Last(self) -> Plate_Plate: ...
    def Append(self, theItem: Plate_Plate) -> Plate_Plate: ...
    def Prepend(self, theItem: Plate_Plate) -> Plate_Plate: ...
    def RemoveFirst(self) -> None: ...
    def Reverse(self) -> None: ...
    def Value(self, theIndex: int) -> Plate_Plate: ...
    def SetValue(self, theIndex: int, theValue: Plate_Plate) -> None: ...

class NLPlate_HGPPConstraint(Standard_Transient):
	def ActiveOrder(self) -> int: ...
	def G0Criterion(self) -> float: ...
	def G0Target(self) -> gp_XYZ: ...
	def G1Criterion(self) -> float: ...
	def G1Target(self) -> Plate_D1: ...
	def G2Criterion(self) -> float: ...
	def G2Target(self) -> Plate_D2: ...
	def G3Criterion(self) -> float: ...
	def G3Target(self) -> Plate_D3: ...
	def IncrementalLoadAllowed(self) -> bool: ...
	def IsG0(self) -> bool: ...
	def Orientation(self) -> int: ...
	def SetActiveOrder(self, ActiveOrder: int) -> None: ...
	def SetG0Criterion(self, TolDist: float) -> None: ...
	def SetG1Criterion(self, TolAng: float) -> None: ...
	def SetG2Criterion(self, TolCurv: float) -> None: ...
	def SetG3Criterion(self, TolG3: float) -> None: ...
	def SetIncrementalLoadAllowed(self, ILA: bool) -> None: ...
	def SetOrientation(self, Orient: Optional[int] = 0) -> None: ...
	def SetUV(self, UV: gp_XY) -> None: ...
	def SetUVFreeSliding(self, UVFree: bool) -> None: ...
	def UV(self) -> gp_XY: ...
	def UVFreeSliding(self) -> bool: ...

class NLPlate_NLPlate:
	def __init__(self, InitialSurface: Geom_Surface) -> None: ...
	def ConstraintsSliding(self, NbIterations: Optional[int] = 3) -> None: ...
	def Continuity(self) -> int: ...
	def Evaluate(self, point2d: gp_XY) -> gp_XYZ: ...
	def EvaluateDerivative(self, point2d: gp_XY, iu: int, iv: int) -> gp_XYZ: ...
	def IncrementalSolve(self, ord: Optional[int] = 2, InitialConsraintOrder: Optional[int] = 1, NbIncrements: Optional[int] = 4, UVSliding: Optional[bool] = False) -> None: ...
	def Init(self) -> None: ...
	def IsDone(self) -> bool: ...
	def Load(self, GConst: NLPlate_HGPPConstraint) -> None: ...
	def MaxActiveConstraintOrder(self) -> int: ...
	def Solve(self, ord: Optional[int] = 2, InitialConsraintOrder: Optional[int] = 1) -> None: ...
	def Solve2(self, ord: Optional[int] = 2, InitialConsraintOrder: Optional[int] = 1) -> None: ...
	def destroy(self) -> None: ...

class NLPlate_HPG0Constraint(NLPlate_HGPPConstraint):
	def __init__(self, UV: gp_XY, Value: gp_XYZ) -> None: ...
	def ActiveOrder(self) -> int: ...
	def G0Target(self) -> gp_XYZ: ...
	def IncrementalLoadAllowed(self) -> bool: ...
	def IsG0(self) -> bool: ...
	def SetIncrementalLoadAllowed(self, ILA: bool) -> None: ...
	def SetUVFreeSliding(self, UVFree: bool) -> None: ...
	def UVFreeSliding(self) -> bool: ...

class NLPlate_HPG1Constraint(NLPlate_HGPPConstraint):
	def __init__(self, UV: gp_XY, D1T: Plate_D1) -> None: ...
	def ActiveOrder(self) -> int: ...
	def G1Target(self) -> Plate_D1: ...
	def IncrementalLoadAllowed(self) -> bool: ...
	def IsG0(self) -> bool: ...
	def Orientation(self) -> int: ...
	def SetIncrementalLoadAllowed(self, ILA: bool) -> None: ...
	def SetOrientation(self, Orient: Optional[int] = 0) -> None: ...

class NLPlate_HPG0G1Constraint(NLPlate_HPG0Constraint):
	def __init__(self, UV: gp_XY, Value: gp_XYZ, D1T: Plate_D1) -> None: ...
	def ActiveOrder(self) -> int: ...
	def G1Target(self) -> Plate_D1: ...
	def Orientation(self) -> int: ...
	def SetOrientation(self, Orient: Optional[int] = 0) -> None: ...

class NLPlate_HPG2Constraint(NLPlate_HPG1Constraint):
	def __init__(self, UV: gp_XY, D1T: Plate_D1, D2T: Plate_D2) -> None: ...
	def ActiveOrder(self) -> int: ...
	def G2Target(self) -> Plate_D2: ...

class NLPlate_HPG0G2Constraint(NLPlate_HPG0G1Constraint):
	def __init__(self, UV: gp_XY, Value: gp_XYZ, D1T: Plate_D1, D2T: Plate_D2) -> None: ...
	def ActiveOrder(self) -> int: ...
	def G2Target(self) -> Plate_D2: ...

class NLPlate_HPG3Constraint(NLPlate_HPG2Constraint):
	def __init__(self, UV: gp_XY, D1T: Plate_D1, D2T: Plate_D2, D3T: Plate_D3) -> None: ...
	def ActiveOrder(self) -> int: ...
	def G3Target(self) -> Plate_D3: ...

class NLPlate_HPG0G3Constraint(NLPlate_HPG0G2Constraint):
	def __init__(self, UV: gp_XY, Value: gp_XYZ, D1T: Plate_D1, D2T: Plate_D2, D3T: Plate_D3) -> None: ...
	def ActiveOrder(self) -> int: ...
	def G3Target(self) -> Plate_D3: ...

# harray1 classes
# harray2 classes
# hsequence classes

