//
// Copyright (c) ZeroC, Inc. All rights reserved.
//
//
// Ice version 3.7.6
//
// <auto-generated>
//
// Generated from file `Router.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

#ifndef __Ice_Router_h__
#define __Ice_Router_h__

#include <IceUtil/PushDisableWarnings.h>
#include <Ice/ProxyF.h>
#include <Ice/ObjectF.h>
#include <Ice/ValueF.h>
#include <Ice/Exception.h>
#include <Ice/LocalObject.h>
#include <Ice/StreamHelpers.h>
#include <Ice/Comparable.h>
#include <Ice/Proxy.h>
#include <Ice/Object.h>
#include <Ice/GCObject.h>
#include <Ice/Value.h>
#include <Ice/Incoming.h>
#include <Ice/FactoryTableInit.h>
#include <IceUtil/ScopedArray.h>
#include <Ice/Optional.h>
#include <Ice/BuiltinSequences.h>
#include <IceUtil/UndefSysMacros.h>

#ifndef ICE_IGNORE_VERSION
#   if ICE_INT_VERSION / 100 != 307
#       error Ice version mismatch!
#   endif
#   if ICE_INT_VERSION % 100 >= 50
#       error Beta header file detected
#   endif
#   if ICE_INT_VERSION % 100 < 6
#       error Ice patch level mismatch!
#   endif
#endif

#ifndef ICE_API
#   if defined(ICE_STATIC_LIBS)
#       define ICE_API /**/
#   elif defined(ICE_API_EXPORTS)
#       define ICE_API ICE_DECLSPEC_EXPORT
#   else
#       define ICE_API ICE_DECLSPEC_IMPORT
#   endif
#endif

#ifdef ICE_CPP11_MAPPING // C++11 mapping

namespace Ice
{

class Router;
class RouterPrx;
class RouterFinder;
class RouterFinderPrx;

}

namespace Ice
{

/**
 * The Ice router interface. Routers can be set either globally with
 * {@link Communicator#setDefaultRouter}, or with <code>ice_router</code> on specific
 * proxies.
 * \headerfile Ice/Ice.h
 */
class ICE_API Router : public virtual Object
{
public:

    using ProxyType = RouterPrx;

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(::std::string id, const Current& current) const override;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector<::std::string> ice_ids(const Current& current) const override;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual ::std::string ice_id(const Current& current) const override;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Encapsulates the results of a call to getClientProxy.
     */
    struct GetClientProxyResult
    {
        /** The router's client proxy. */
        ::std::shared_ptr<ObjectPrx> returnValue;
        /** Indicates whether or not the router supports a routing table. */
        Ice::optional<bool> hasRoutingTable;
    };

    /**
     * Get the router's client proxy, i.e., the proxy to use for
     * forwarding requests from the client to the router.
     *
     * If a null proxy is returned, the client will forward requests
     * to the router's endpoints.
     * @param hasRoutingTable Indicates whether or not the router supports a routing
     * table. If it is supported, the Ice runtime will call addProxies to populate the
     * routing table. This out parameter is only supported starting with Ice 3.7.
     * The Ice runtime assumes the router has a routing table if the optional is not
     * set.
     * @param current The Current object for the invocation.
     * @return The router's client proxy.
     */
    virtual ::std::shared_ptr<ObjectPrx> getClientProxy(Ice::optional<bool>& hasRoutingTable, const Current& current) const = 0;
    /// \cond INTERNAL
    bool _iceD_getClientProxy(::IceInternal::Incoming&, const Current&) const;
    /// \endcond

    /**
     * Get the router's server proxy, i.e., the proxy to use for
     * forwarding requests from the server to the router.
     * @param current The Current object for the invocation.
     * @return The router's server proxy.
     */
    virtual ::std::shared_ptr<ObjectPrx> getServerProxy(const Current& current) const = 0;
    /// \cond INTERNAL
    bool _iceD_getServerProxy(::IceInternal::Incoming&, const Current&) const;
    /// \endcond

    /**
     * Add new proxy information to the router's routing table.
     * @param proxies The proxies to add.
     * @param current The Current object for the invocation.
     * @return Proxies discarded by the router.
     */
    virtual ObjectProxySeq addProxies(ObjectProxySeq proxies, const Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_addProxies(::IceInternal::Incoming&, const Current&);
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const Current&) override;
    /// \endcond
};

/**
 * This inferface should be implemented by services implementing the
 * Ice::Router interface. It should be advertised through an Ice
 * object with the identity `Ice/RouterFinder'. This allows clients to
 * retrieve the router proxy with just the endpoint information of the
 * service.
 * \headerfile Ice/Ice.h
 */
class ICE_API RouterFinder : public virtual Object
{
public:

    using ProxyType = RouterFinderPrx;

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(::std::string id, const Current& current) const override;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector<::std::string> ice_ids(const Current& current) const override;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual ::std::string ice_id(const Current& current) const override;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Get the router proxy implemented by the process hosting this
     * finder object. The proxy might point to several replicas.
     * @param current The Current object for the invocation.
     * @return The router proxy.
     */
    virtual ::std::shared_ptr<RouterPrx> getRouter(const Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_getRouter(::IceInternal::Incoming&, const Current&);
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const Current&) override;
    /// \endcond
};

}

namespace Ice
{

/**
 * The Ice router interface. Routers can be set either globally with
 * {@link Communicator#setDefaultRouter}, or with <code>ice_router</code> on specific
 * proxies.
 * \headerfile Ice/Ice.h
 */
class ICE_CLASS(ICE_API) RouterPrx : public virtual Proxy<RouterPrx, ObjectPrx>
{
public:

    /**
     * Get the router's client proxy, i.e., the proxy to use for
     * forwarding requests from the client to the router.
     *
     * If a null proxy is returned, the client will forward requests
     * to the router's endpoints.
     * @param hasRoutingTable Indicates whether or not the router supports a routing
     * table. If it is supported, the Ice runtime will call addProxies to populate the
     * routing table. This out parameter is only supported starting with Ice 3.7.
     * The Ice runtime assumes the router has a routing table if the optional is not
     * set.
     * @param context The Context map to send with the invocation.
     * @return The router's client proxy.
     */
    ::std::shared_ptr<ObjectPrx> getClientProxy(Ice::optional<bool>& hasRoutingTable, const Context& context = noExplicitContext)
    {
        auto _result = _makePromiseOutgoing<Router::GetClientProxyResult>(true, this, &RouterPrx::_iceI_getClientProxy, context).get();
        hasRoutingTable = _result.hasRoutingTable;
        return ::std::move(_result.returnValue);
    }

    /**
     * Get the router's client proxy, i.e., the proxy to use for
     * forwarding requests from the client to the router.
     *
     * If a null proxy is returned, the client will forward requests
     * to the router's endpoints.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getClientProxyAsync(const Context& context = noExplicitContext)
        -> decltype(::std::declval<P<Router::GetClientProxyResult>>().get_future())
    {
        return _makePromiseOutgoing<Router::GetClientProxyResult, P>(false, this, &RouterPrx::_iceI_getClientProxy, context);
    }

    /**
     * Get the router's client proxy, i.e., the proxy to use for
     * forwarding requests from the client to the router.
     *
     * If a null proxy is returned, the client will forward requests
     * to the router's endpoints.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getClientProxyAsync(::std::function<void(::std::shared_ptr<::Ice::ObjectPrx>, Ice::optional<bool>)> response,
                        ::std::function<void(::std::exception_ptr)> ex = nullptr,
                        ::std::function<void(bool)> sent = nullptr,
                        const Context& context = noExplicitContext)
    {
        auto _responseCb = [response](Router::GetClientProxyResult&& _result)
        {
            response(::std::move(_result.returnValue), _result.hasRoutingTable);
        };
        return _makeLamdaOutgoing<Router::GetClientProxyResult>(std::move(_responseCb), std::move(ex), std::move(sent), this, &Ice::RouterPrx::_iceI_getClientProxy, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICE_API) void _iceI_getClientProxy(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<Router::GetClientProxyResult>>&, const Context&);
    /// \endcond

    /**
     * Get the router's server proxy, i.e., the proxy to use for
     * forwarding requests from the server to the router.
     * @param context The Context map to send with the invocation.
     * @return The router's server proxy.
     */
    ::std::shared_ptr<ObjectPrx> getServerProxy(const Context& context = noExplicitContext)
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Ice::ObjectPrx>>(true, this, &RouterPrx::_iceI_getServerProxy, context).get();
    }

    /**
     * Get the router's server proxy, i.e., the proxy to use for
     * forwarding requests from the server to the router.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getServerProxyAsync(const Context& context = noExplicitContext)
        -> decltype(::std::declval<P<::std::shared_ptr<::Ice::ObjectPrx>>>().get_future())
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Ice::ObjectPrx>, P>(false, this, &RouterPrx::_iceI_getServerProxy, context);
    }

    /**
     * Get the router's server proxy, i.e., the proxy to use for
     * forwarding requests from the server to the router.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getServerProxyAsync(::std::function<void(::std::shared_ptr<::Ice::ObjectPrx>)> response,
                        ::std::function<void(::std::exception_ptr)> ex = nullptr,
                        ::std::function<void(bool)> sent = nullptr,
                        const Context& context = noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::shared_ptr<::Ice::ObjectPrx>>(std::move(response), std::move(ex), std::move(sent), this, &Ice::RouterPrx::_iceI_getServerProxy, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICE_API) void _iceI_getServerProxy(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::Ice::ObjectPrx>>>&, const Context&);
    /// \endcond

    /**
     * Add new proxy information to the router's routing table.
     * @param proxies The proxies to add.
     * @param context The Context map to send with the invocation.
     * @return Proxies discarded by the router.
     */
    ObjectProxySeq addProxies(const ObjectProxySeq& proxies, const Context& context = noExplicitContext)
    {
        return _makePromiseOutgoing<::Ice::ObjectProxySeq>(true, this, &RouterPrx::_iceI_addProxies, proxies, context).get();
    }

    /**
     * Add new proxy information to the router's routing table.
     * @param proxies The proxies to add.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto addProxiesAsync(const ObjectProxySeq& proxies, const Context& context = noExplicitContext)
        -> decltype(::std::declval<P<::Ice::ObjectProxySeq>>().get_future())
    {
        return _makePromiseOutgoing<::Ice::ObjectProxySeq, P>(false, this, &RouterPrx::_iceI_addProxies, proxies, context);
    }

    /**
     * Add new proxy information to the router's routing table.
     * @param proxies The proxies to add.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    addProxiesAsync(const ObjectProxySeq& proxies,
                    ::std::function<void(::Ice::ObjectProxySeq)> response,
                    ::std::function<void(::std::exception_ptr)> ex = nullptr,
                    ::std::function<void(bool)> sent = nullptr,
                    const Context& context = noExplicitContext)
    {
        return _makeLamdaOutgoing<::Ice::ObjectProxySeq>(std::move(response), std::move(ex), std::move(sent), this, &Ice::RouterPrx::_iceI_addProxies, proxies, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICE_API) void _iceI_addProxies(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::Ice::ObjectProxySeq>>&, const ObjectProxySeq&, const Context&);
    /// \endcond

    /**
     * Obtains the Slice type ID of this interface.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();

protected:

    /// \cond INTERNAL
    RouterPrx() = default;
    friend ::std::shared_ptr<RouterPrx> IceInternal::createProxy<RouterPrx>();

    ICE_MEMBER(ICE_API) virtual ::std::shared_ptr<ObjectPrx> _newInstance() const override;
    /// \endcond
};

/**
 * This inferface should be implemented by services implementing the
 * Ice::Router interface. It should be advertised through an Ice
 * object with the identity `Ice/RouterFinder'. This allows clients to
 * retrieve the router proxy with just the endpoint information of the
 * service.
 * \headerfile Ice/Ice.h
 */
class ICE_CLASS(ICE_API) RouterFinderPrx : public virtual Proxy<RouterFinderPrx, ObjectPrx>
{
public:

    /**
     * Get the router proxy implemented by the process hosting this
     * finder object. The proxy might point to several replicas.
     * @param context The Context map to send with the invocation.
     * @return The router proxy.
     */
    ::std::shared_ptr<RouterPrx> getRouter(const Context& context = noExplicitContext)
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Ice::RouterPrx>>(true, this, &RouterFinderPrx::_iceI_getRouter, context).get();
    }

    /**
     * Get the router proxy implemented by the process hosting this
     * finder object. The proxy might point to several replicas.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getRouterAsync(const Context& context = noExplicitContext)
        -> decltype(::std::declval<P<::std::shared_ptr<::Ice::RouterPrx>>>().get_future())
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Ice::RouterPrx>, P>(false, this, &RouterFinderPrx::_iceI_getRouter, context);
    }

    /**
     * Get the router proxy implemented by the process hosting this
     * finder object. The proxy might point to several replicas.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getRouterAsync(::std::function<void(::std::shared_ptr<::Ice::RouterPrx>)> response,
                   ::std::function<void(::std::exception_ptr)> ex = nullptr,
                   ::std::function<void(bool)> sent = nullptr,
                   const Context& context = noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::shared_ptr<::Ice::RouterPrx>>(std::move(response), std::move(ex), std::move(sent), this, &Ice::RouterFinderPrx::_iceI_getRouter, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICE_API) void _iceI_getRouter(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::Ice::RouterPrx>>>&, const Context&);
    /// \endcond

    /**
     * Obtains the Slice type ID of this interface.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();

protected:

    /// \cond INTERNAL
    RouterFinderPrx() = default;
    friend ::std::shared_ptr<RouterFinderPrx> IceInternal::createProxy<RouterFinderPrx>();

    ICE_MEMBER(ICE_API) virtual ::std::shared_ptr<ObjectPrx> _newInstance() const override;
    /// \endcond
};

}

/// \cond STREAM
namespace Ice
{

}
/// \endcond

/// \cond INTERNAL
namespace Ice
{

using RouterPtr = ::std::shared_ptr<Router>;
using RouterPrxPtr = ::std::shared_ptr<RouterPrx>;

using RouterFinderPtr = ::std::shared_ptr<RouterFinder>;
using RouterFinderPrxPtr = ::std::shared_ptr<RouterFinderPrx>;

}
/// \endcond

#else // C++98 mapping

namespace IceProxy
{

namespace Ice
{

class Router;
/// \cond INTERNAL
ICE_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< Router>&);
ICE_API ::IceProxy::Ice::Object* upCast(Router*);
/// \endcond

class RouterFinder;
/// \cond INTERNAL
ICE_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< RouterFinder>&);
ICE_API ::IceProxy::Ice::Object* upCast(RouterFinder*);
/// \endcond

}

}

namespace Ice
{

class Router;
/// \cond INTERNAL
ICE_API Object* upCast(Router*);
/// \endcond
typedef ::IceInternal::Handle< Router> RouterPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::Ice::Router> RouterPrx;
typedef RouterPrx RouterPrxPtr;
/// \cond INTERNAL
ICE_API void _icePatchObjectPtr(RouterPtr&, const ObjectPtr&);
/// \endcond

class RouterFinder;
/// \cond INTERNAL
ICE_API Object* upCast(RouterFinder*);
/// \endcond
typedef ::IceInternal::Handle< RouterFinder> RouterFinderPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::Ice::RouterFinder> RouterFinderPrx;
typedef RouterFinderPrx RouterFinderPrxPtr;
/// \cond INTERNAL
ICE_API void _icePatchObjectPtr(RouterFinderPtr&, const ObjectPtr&);
/// \endcond

}

namespace Ice
{

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::Ice::Router::begin_getClientProxy.
 * Create a wrapper instance by calling ::Ice::newCallback_Router_getClientProxy.
 */
class Callback_Router_getClientProxy_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Router_getClientProxy_Base> Callback_Router_getClientProxyPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::Ice::Router::begin_getServerProxy.
 * Create a wrapper instance by calling ::Ice::newCallback_Router_getServerProxy.
 */
class Callback_Router_getServerProxy_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Router_getServerProxy_Base> Callback_Router_getServerProxyPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::Ice::Router::begin_addProxies.
 * Create a wrapper instance by calling ::Ice::newCallback_Router_addProxies.
 */
class Callback_Router_addProxies_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Router_addProxies_Base> Callback_Router_addProxiesPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::Ice::RouterFinder::begin_getRouter.
 * Create a wrapper instance by calling ::Ice::newCallback_RouterFinder_getRouter.
 */
class Callback_RouterFinder_getRouter_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_RouterFinder_getRouter_Base> Callback_RouterFinder_getRouterPtr;

}

namespace IceProxy
{

namespace Ice
{

class ICE_CLASS(ICE_API) Router : public virtual ::Ice::Proxy<Router, ::IceProxy::Ice::Object>
{
public:

    /**
     * Get the router's client proxy, i.e., the proxy to use for
     * forwarding requests from the client to the router.
     *
     * If a null proxy is returned, the client will forward requests
     * to the router's endpoints.
     * @param hasRoutingTable Indicates whether or not the router supports a routing
     * table. If it is supported, the Ice runtime will call addProxies to populate the
     * routing table. This out parameter is only supported starting with Ice 3.7.
     * The Ice runtime assumes the router has a routing table if the optional is not
     * set.
     * @param context The Context map to send with the invocation.
     * @return The router's client proxy.
     */
    ICE_MEMBER(ICE_API) ::Ice::ObjectPrx getClientProxy(IceUtil::Optional<bool>& hasRoutingTable, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getClientProxy(hasRoutingTable, _iceI_begin_getClientProxy(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Get the router's client proxy, i.e., the proxy to use for
     * forwarding requests from the client to the router.
     *
     * If a null proxy is returned, the client will forward requests
     * to the router's endpoints.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getClientProxy(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getClientProxy(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Get the router's client proxy, i.e., the proxy to use for
     * forwarding requests from the client to the router.
     *
     * If a null proxy is returned, the client will forward requests
     * to the router's endpoints.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getClientProxy(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getClientProxy(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get the router's client proxy, i.e., the proxy to use for
     * forwarding requests from the client to the router.
     *
     * If a null proxy is returned, the client will forward requests
     * to the router's endpoints.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getClientProxy(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getClientProxy(context, cb, cookie);
    }

    /**
     * Get the router's client proxy, i.e., the proxy to use for
     * forwarding requests from the client to the router.
     *
     * If a null proxy is returned, the client will forward requests
     * to the router's endpoints.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getClientProxy(const ::Ice::Callback_Router_getClientProxyPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getClientProxy(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get the router's client proxy, i.e., the proxy to use for
     * forwarding requests from the client to the router.
     *
     * If a null proxy is returned, the client will forward requests
     * to the router's endpoints.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getClientProxy(const ::Ice::Context& context, const ::Ice::Callback_Router_getClientProxyPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getClientProxy(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getClientProxy.
     * @param hasRoutingTable Indicates whether or not the router supports a routing
     * table. If it is supported, the Ice runtime will call addProxies to populate the
     * routing table. This out parameter is only supported starting with Ice 3.7.
     * The Ice runtime assumes the router has a routing table if the optional is not
     * set.
     * @param result The asynchronous result object for the invocation.
     * @return The router's client proxy.
     */
    ICE_MEMBER(ICE_API) ::Ice::ObjectPrx end_getClientProxy(IceUtil::Optional<bool>& hasRoutingTable, const ::Ice::AsyncResultPtr& result);
    /// \cond INTERNAL

    ICE_MEMBER(ICE_API) void _iceI_end_getClientProxy(IceUtil::Optional<bool>& iceP_hasRoutingTable, ::Ice::ObjectPrxPtr& ret, const ::Ice::AsyncResultPtr&);
    /// \endcond

private:

    ICE_MEMBER(ICE_API) ::Ice::AsyncResultPtr _iceI_begin_getClientProxy(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Get the router's server proxy, i.e., the proxy to use for
     * forwarding requests from the server to the router.
     * @param context The Context map to send with the invocation.
     * @return The router's server proxy.
     */
    ICE_MEMBER(ICE_API) ::Ice::ObjectPrx getServerProxy(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getServerProxy(_iceI_begin_getServerProxy(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Get the router's server proxy, i.e., the proxy to use for
     * forwarding requests from the server to the router.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getServerProxy(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getServerProxy(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Get the router's server proxy, i.e., the proxy to use for
     * forwarding requests from the server to the router.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getServerProxy(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getServerProxy(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get the router's server proxy, i.e., the proxy to use for
     * forwarding requests from the server to the router.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getServerProxy(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getServerProxy(context, cb, cookie);
    }

    /**
     * Get the router's server proxy, i.e., the proxy to use for
     * forwarding requests from the server to the router.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getServerProxy(const ::Ice::Callback_Router_getServerProxyPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getServerProxy(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get the router's server proxy, i.e., the proxy to use for
     * forwarding requests from the server to the router.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getServerProxy(const ::Ice::Context& context, const ::Ice::Callback_Router_getServerProxyPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getServerProxy(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getServerProxy.
     * @param result The asynchronous result object for the invocation.
     * @return The router's server proxy.
     */
    ICE_MEMBER(ICE_API) ::Ice::ObjectPrx end_getServerProxy(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICE_API) ::Ice::AsyncResultPtr _iceI_begin_getServerProxy(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Add new proxy information to the router's routing table.
     * @param proxies The proxies to add.
     * @param context The Context map to send with the invocation.
     * @return Proxies discarded by the router.
     */
    ICE_MEMBER(ICE_API) ::Ice::ObjectProxySeq addProxies(const ::Ice::ObjectProxySeq& proxies, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_addProxies(_iceI_begin_addProxies(proxies, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Add new proxy information to the router's routing table.
     * @param proxies The proxies to add.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_addProxies(const ::Ice::ObjectProxySeq& proxies, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_addProxies(proxies, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Add new proxy information to the router's routing table.
     * @param proxies The proxies to add.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_addProxies(const ::Ice::ObjectProxySeq& proxies, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_addProxies(proxies, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Add new proxy information to the router's routing table.
     * @param proxies The proxies to add.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_addProxies(const ::Ice::ObjectProxySeq& proxies, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_addProxies(proxies, context, cb, cookie);
    }

    /**
     * Add new proxy information to the router's routing table.
     * @param proxies The proxies to add.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_addProxies(const ::Ice::ObjectProxySeq& proxies, const ::Ice::Callback_Router_addProxiesPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_addProxies(proxies, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Add new proxy information to the router's routing table.
     * @param proxies The proxies to add.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_addProxies(const ::Ice::ObjectProxySeq& proxies, const ::Ice::Context& context, const ::Ice::Callback_Router_addProxiesPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_addProxies(proxies, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_addProxies.
     * @param result The asynchronous result object for the invocation.
     * @return Proxies discarded by the router.
     */
    ICE_MEMBER(ICE_API) ::Ice::ObjectProxySeq end_addProxies(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICE_API) ::Ice::AsyncResultPtr _iceI_begin_addProxies(const ::Ice::ObjectProxySeq&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Obtains the Slice type ID corresponding to this interface.
     * @return A fully-scoped type ID.
     */
    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();

protected:
    /// \cond INTERNAL

    ICE_MEMBER(ICE_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
    /// \endcond
};

class ICE_CLASS(ICE_API) RouterFinder : public virtual ::Ice::Proxy<RouterFinder, ::IceProxy::Ice::Object>
{
public:

    /**
     * Get the router proxy implemented by the process hosting this
     * finder object. The proxy might point to several replicas.
     * @param context The Context map to send with the invocation.
     * @return The router proxy.
     */
    ICE_MEMBER(ICE_API) ::Ice::RouterPrx getRouter(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getRouter(_iceI_begin_getRouter(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Get the router proxy implemented by the process hosting this
     * finder object. The proxy might point to several replicas.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getRouter(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getRouter(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Get the router proxy implemented by the process hosting this
     * finder object. The proxy might point to several replicas.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getRouter(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getRouter(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get the router proxy implemented by the process hosting this
     * finder object. The proxy might point to several replicas.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getRouter(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getRouter(context, cb, cookie);
    }

    /**
     * Get the router proxy implemented by the process hosting this
     * finder object. The proxy might point to several replicas.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getRouter(const ::Ice::Callback_RouterFinder_getRouterPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getRouter(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get the router proxy implemented by the process hosting this
     * finder object. The proxy might point to several replicas.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getRouter(const ::Ice::Context& context, const ::Ice::Callback_RouterFinder_getRouterPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getRouter(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getRouter.
     * @param result The asynchronous result object for the invocation.
     * @return The router proxy.
     */
    ICE_MEMBER(ICE_API) ::Ice::RouterPrx end_getRouter(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICE_API) ::Ice::AsyncResultPtr _iceI_begin_getRouter(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Obtains the Slice type ID corresponding to this interface.
     * @return A fully-scoped type ID.
     */
    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();

protected:
    /// \cond INTERNAL

    ICE_MEMBER(ICE_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
    /// \endcond
};

}

}

namespace Ice
{

/**
 * The Ice router interface. Routers can be set either globally with
 * {@link Communicator#setDefaultRouter}, or with <code>ice_router</code> on specific
 * proxies.
 * \headerfile Ice/Ice.h
 */
class ICE_API Router : public virtual Object
{
public:

    typedef RouterPrx ProxyType;
    typedef RouterPtr PointerType;

    virtual ~Router();

#ifdef ICE_CPP11_COMPILER
    Router() = default;
    Router(const Router&) = default;
    Router& operator=(const Router&) = default;
#endif

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(const ::std::string& id, const Current& current = emptyCurrent) const;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector< ::std::string> ice_ids(const Current& current = emptyCurrent) const;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual const ::std::string& ice_id(const Current& current = emptyCurrent) const;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Get the router's client proxy, i.e., the proxy to use for
     * forwarding requests from the client to the router.
     *
     * If a null proxy is returned, the client will forward requests
     * to the router's endpoints.
     * @param hasRoutingTable Indicates whether or not the router supports a routing
     * table. If it is supported, the Ice runtime will call addProxies to populate the
     * routing table. This out parameter is only supported starting with Ice 3.7.
     * The Ice runtime assumes the router has a routing table if the optional is not
     * set.
     * @param current The Current object for the invocation.
     * @return The router's client proxy.
     */
    virtual ObjectPrx getClientProxy(IceUtil::Optional<bool>& hasRoutingTable, const Current& current = emptyCurrent) const = 0;
    /// \cond INTERNAL
    bool _iceD_getClientProxy(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Get the router's server proxy, i.e., the proxy to use for
     * forwarding requests from the server to the router.
     * @param current The Current object for the invocation.
     * @return The router's server proxy.
     */
    virtual ObjectPrx getServerProxy(const Current& current = emptyCurrent) const = 0;
    /// \cond INTERNAL
    bool _iceD_getServerProxy(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Add new proxy information to the router's routing table.
     * @param proxies The proxies to add.
     * @param current The Current object for the invocation.
     * @return Proxies discarded by the router.
     */
    virtual ObjectProxySeq addProxies(const ObjectProxySeq& proxies, const Current& current = emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_addProxies(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const Current&);
    /// \endcond

protected:

    /// \cond STREAM
    virtual void _iceWriteImpl(OutputStream*) const;
    virtual void _iceReadImpl(InputStream*);
    /// \endcond
};

/// \cond INTERNAL
inline bool operator==(const Router& lhs, const Router& rhs)
{
    return static_cast<const Object&>(lhs) == static_cast<const Object&>(rhs);
}

inline bool operator<(const Router& lhs, const Router& rhs)
{
    return static_cast<const Object&>(lhs) < static_cast<const Object&>(rhs);
}
/// \endcond

/**
 * This inferface should be implemented by services implementing the
 * Ice::Router interface. It should be advertised through an Ice
 * object with the identity `Ice/RouterFinder'. This allows clients to
 * retrieve the router proxy with just the endpoint information of the
 * service.
 * \headerfile Ice/Ice.h
 */
class ICE_API RouterFinder : public virtual Object
{
public:

    typedef RouterFinderPrx ProxyType;
    typedef RouterFinderPtr PointerType;

    virtual ~RouterFinder();

#ifdef ICE_CPP11_COMPILER
    RouterFinder() = default;
    RouterFinder(const RouterFinder&) = default;
    RouterFinder& operator=(const RouterFinder&) = default;
#endif

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(const ::std::string& id, const Current& current = emptyCurrent) const;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector< ::std::string> ice_ids(const Current& current = emptyCurrent) const;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual const ::std::string& ice_id(const Current& current = emptyCurrent) const;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Get the router proxy implemented by the process hosting this
     * finder object. The proxy might point to several replicas.
     * @param current The Current object for the invocation.
     * @return The router proxy.
     */
    virtual RouterPrx getRouter(const Current& current = emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_getRouter(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const Current&);
    /// \endcond

protected:

    /// \cond STREAM
    virtual void _iceWriteImpl(OutputStream*) const;
    virtual void _iceReadImpl(InputStream*);
    /// \endcond
};

/// \cond INTERNAL
inline bool operator==(const RouterFinder& lhs, const RouterFinder& rhs)
{
    return static_cast<const Object&>(lhs) == static_cast<const Object&>(rhs);
}

inline bool operator<(const RouterFinder& lhs, const RouterFinder& rhs)
{
    return static_cast<const Object&>(lhs) < static_cast<const Object&>(rhs);
}
/// \endcond

}

/// \cond STREAM
namespace Ice
{

}
/// \endcond

namespace Ice
{

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::Ice::Router::begin_getClientProxy.
 * Create a wrapper instance by calling ::Ice::newCallback_Router_getClientProxy.
 */
template<class T>
class CallbackNC_Router_getClientProxy : public Callback_Router_getClientProxy_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ObjectPrx&, const IceUtil::Optional<bool>&);

    CallbackNC_Router_getClientProxy(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const AsyncResultPtr& result) const
    {
        RouterPrx proxy = RouterPrx::uncheckedCast(result->getProxy());
        IceUtil::Optional<bool> iceP_hasRoutingTable;
        ObjectPrx ret;
        try
        {
            ret = proxy->end_getClientProxy(iceP_hasRoutingTable, result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret, iceP_hasRoutingTable);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::Router::begin_getClientProxy.
 */
template<class T> Callback_Router_getClientProxyPtr
newCallback_Router_getClientProxy(const IceUtil::Handle<T>& instance, void (T::*cb)(const ObjectPrx&, const IceUtil::Optional<bool>&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Router_getClientProxy<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::Router::begin_getClientProxy.
 */
template<class T> Callback_Router_getClientProxyPtr
newCallback_Router_getClientProxy(T* instance, void (T::*cb)(const ObjectPrx&, const IceUtil::Optional<bool>&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Router_getClientProxy<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::Ice::Router::begin_getClientProxy.
 * Create a wrapper instance by calling ::Ice::newCallback_Router_getClientProxy.
 */
template<class T, typename CT>
class Callback_Router_getClientProxy : public Callback_Router_getClientProxy_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ObjectPrx&, const IceUtil::Optional<bool>&, const CT&);

    Callback_Router_getClientProxy(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const AsyncResultPtr& result) const
    {
        RouterPrx proxy = RouterPrx::uncheckedCast(result->getProxy());
        IceUtil::Optional<bool> iceP_hasRoutingTable;
        ObjectPrx ret;
        try
        {
            ret = proxy->end_getClientProxy(iceP_hasRoutingTable, result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, iceP_hasRoutingTable, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::Router::begin_getClientProxy.
 */
template<class T, typename CT> Callback_Router_getClientProxyPtr
newCallback_Router_getClientProxy(const IceUtil::Handle<T>& instance, void (T::*cb)(const ObjectPrx&, const IceUtil::Optional<bool>&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Router_getClientProxy<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::Router::begin_getClientProxy.
 */
template<class T, typename CT> Callback_Router_getClientProxyPtr
newCallback_Router_getClientProxy(T* instance, void (T::*cb)(const ObjectPrx&, const IceUtil::Optional<bool>&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Router_getClientProxy<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::Ice::Router::begin_getServerProxy.
 * Create a wrapper instance by calling ::Ice::newCallback_Router_getServerProxy.
 */
template<class T>
class CallbackNC_Router_getServerProxy : public Callback_Router_getServerProxy_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ObjectPrx&);

    CallbackNC_Router_getServerProxy(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const AsyncResultPtr& result) const
    {
        RouterPrx proxy = RouterPrx::uncheckedCast(result->getProxy());
        ObjectPrx ret;
        try
        {
            ret = proxy->end_getServerProxy(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::Router::begin_getServerProxy.
 */
template<class T> Callback_Router_getServerProxyPtr
newCallback_Router_getServerProxy(const IceUtil::Handle<T>& instance, void (T::*cb)(const ObjectPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Router_getServerProxy<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::Router::begin_getServerProxy.
 */
template<class T> Callback_Router_getServerProxyPtr
newCallback_Router_getServerProxy(T* instance, void (T::*cb)(const ObjectPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Router_getServerProxy<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::Ice::Router::begin_getServerProxy.
 * Create a wrapper instance by calling ::Ice::newCallback_Router_getServerProxy.
 */
template<class T, typename CT>
class Callback_Router_getServerProxy : public Callback_Router_getServerProxy_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ObjectPrx&, const CT&);

    Callback_Router_getServerProxy(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const AsyncResultPtr& result) const
    {
        RouterPrx proxy = RouterPrx::uncheckedCast(result->getProxy());
        ObjectPrx ret;
        try
        {
            ret = proxy->end_getServerProxy(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::Router::begin_getServerProxy.
 */
template<class T, typename CT> Callback_Router_getServerProxyPtr
newCallback_Router_getServerProxy(const IceUtil::Handle<T>& instance, void (T::*cb)(const ObjectPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Router_getServerProxy<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::Router::begin_getServerProxy.
 */
template<class T, typename CT> Callback_Router_getServerProxyPtr
newCallback_Router_getServerProxy(T* instance, void (T::*cb)(const ObjectPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Router_getServerProxy<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::Ice::Router::begin_addProxies.
 * Create a wrapper instance by calling ::Ice::newCallback_Router_addProxies.
 */
template<class T>
class CallbackNC_Router_addProxies : public Callback_Router_addProxies_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ObjectProxySeq&);

    CallbackNC_Router_addProxies(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const AsyncResultPtr& result) const
    {
        RouterPrx proxy = RouterPrx::uncheckedCast(result->getProxy());
        ObjectProxySeq ret;
        try
        {
            ret = proxy->end_addProxies(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::Router::begin_addProxies.
 */
template<class T> Callback_Router_addProxiesPtr
newCallback_Router_addProxies(const IceUtil::Handle<T>& instance, void (T::*cb)(const ObjectProxySeq&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Router_addProxies<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::Router::begin_addProxies.
 */
template<class T> Callback_Router_addProxiesPtr
newCallback_Router_addProxies(T* instance, void (T::*cb)(const ObjectProxySeq&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Router_addProxies<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::Ice::Router::begin_addProxies.
 * Create a wrapper instance by calling ::Ice::newCallback_Router_addProxies.
 */
template<class T, typename CT>
class Callback_Router_addProxies : public Callback_Router_addProxies_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ObjectProxySeq&, const CT&);

    Callback_Router_addProxies(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const AsyncResultPtr& result) const
    {
        RouterPrx proxy = RouterPrx::uncheckedCast(result->getProxy());
        ObjectProxySeq ret;
        try
        {
            ret = proxy->end_addProxies(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::Router::begin_addProxies.
 */
template<class T, typename CT> Callback_Router_addProxiesPtr
newCallback_Router_addProxies(const IceUtil::Handle<T>& instance, void (T::*cb)(const ObjectProxySeq&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Router_addProxies<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::Router::begin_addProxies.
 */
template<class T, typename CT> Callback_Router_addProxiesPtr
newCallback_Router_addProxies(T* instance, void (T::*cb)(const ObjectProxySeq&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Router_addProxies<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::Ice::RouterFinder::begin_getRouter.
 * Create a wrapper instance by calling ::Ice::newCallback_RouterFinder_getRouter.
 */
template<class T>
class CallbackNC_RouterFinder_getRouter : public Callback_RouterFinder_getRouter_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const RouterPrx&);

    CallbackNC_RouterFinder_getRouter(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const AsyncResultPtr& result) const
    {
        RouterFinderPrx proxy = RouterFinderPrx::uncheckedCast(result->getProxy());
        RouterPrx ret;
        try
        {
            ret = proxy->end_getRouter(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::RouterFinder::begin_getRouter.
 */
template<class T> Callback_RouterFinder_getRouterPtr
newCallback_RouterFinder_getRouter(const IceUtil::Handle<T>& instance, void (T::*cb)(const RouterPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_RouterFinder_getRouter<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::RouterFinder::begin_getRouter.
 */
template<class T> Callback_RouterFinder_getRouterPtr
newCallback_RouterFinder_getRouter(T* instance, void (T::*cb)(const RouterPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_RouterFinder_getRouter<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::Ice::RouterFinder::begin_getRouter.
 * Create a wrapper instance by calling ::Ice::newCallback_RouterFinder_getRouter.
 */
template<class T, typename CT>
class Callback_RouterFinder_getRouter : public Callback_RouterFinder_getRouter_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const RouterPrx&, const CT&);

    Callback_RouterFinder_getRouter(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const AsyncResultPtr& result) const
    {
        RouterFinderPrx proxy = RouterFinderPrx::uncheckedCast(result->getProxy());
        RouterPrx ret;
        try
        {
            ret = proxy->end_getRouter(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::RouterFinder::begin_getRouter.
 */
template<class T, typename CT> Callback_RouterFinder_getRouterPtr
newCallback_RouterFinder_getRouter(const IceUtil::Handle<T>& instance, void (T::*cb)(const RouterPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_RouterFinder_getRouter<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::RouterFinder::begin_getRouter.
 */
template<class T, typename CT> Callback_RouterFinder_getRouterPtr
newCallback_RouterFinder_getRouter(T* instance, void (T::*cb)(const RouterPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_RouterFinder_getRouter<T, CT>(instance, cb, excb, sentcb);
}

}

#endif

#include <IceUtil/PopDisableWarnings.h>
#endif
