/*
 * Decompiled with CFR 0.152.
 */
package jakarta.el;

import jakarta.el.ELContext;
import jakarta.el.ELResolver;
import java.beans.FeatureDescriptor;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;

public class CompositeELResolver
extends ELResolver {
    private static final Class<?> SCOPED_ATTRIBUTE_EL_RESOLVER;
    private int size = 0;
    private ELResolver[] resolvers = new ELResolver[8];

    public void add(ELResolver eLResolver) {
        Objects.requireNonNull(eLResolver);
        if (this.size >= this.resolvers.length) {
            ELResolver[] eLResolverArray = new ELResolver[this.size * 2];
            System.arraycopy(this.resolvers, 0, eLResolverArray, 0, this.size);
            this.resolvers = eLResolverArray;
        }
        this.resolvers[this.size++] = eLResolver;
    }

    @Override
    public Object getValue(ELContext eLContext, Object object, Object object2) {
        eLContext.setPropertyResolved(false);
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            Object object3 = this.resolvers[i].getValue(eLContext, object, object2);
            if (!eLContext.isPropertyResolved()) continue;
            return object3;
        }
        return null;
    }

    @Override
    public Object invoke(ELContext eLContext, Object object, Object object2, Class<?>[] classArray, Object[] objectArray) {
        eLContext.setPropertyResolved(false);
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            Object object3 = this.resolvers[i].invoke(eLContext, object, object2, classArray, objectArray);
            if (!eLContext.isPropertyResolved()) continue;
            return object3;
        }
        return null;
    }

    @Override
    public Class<?> getType(ELContext eLContext, Object object, Object object2) {
        eLContext.setPropertyResolved(false);
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            Object object3;
            Class<?> clazz = this.resolvers[i].getType(eLContext, object, object2);
            if (!eLContext.isPropertyResolved()) continue;
            if (SCOPED_ATTRIBUTE_EL_RESOLVER != null && SCOPED_ATTRIBUTE_EL_RESOLVER.isAssignableFrom(this.resolvers[i].getClass()) && (object3 = this.resolvers[i].getValue(eLContext, object, object2)) != null) {
                return object3.getClass();
            }
            return clazz;
        }
        return null;
    }

    @Override
    public void setValue(ELContext eLContext, Object object, Object object2, Object object3) {
        eLContext.setPropertyResolved(false);
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            this.resolvers[i].setValue(eLContext, object, object2, object3);
            if (!eLContext.isPropertyResolved()) continue;
            return;
        }
    }

    @Override
    public boolean isReadOnly(ELContext eLContext, Object object, Object object2) {
        eLContext.setPropertyResolved(false);
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            boolean bl = this.resolvers[i].isReadOnly(eLContext, object, object2);
            if (!eLContext.isPropertyResolved()) continue;
            return bl;
        }
        return false;
    }

    @Override
    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext eLContext, Object object) {
        return new FeatureIterator(eLContext, object, this.resolvers, this.size);
    }

    @Override
    public Class<?> getCommonPropertyType(ELContext eLContext, Object object) {
        Class<?> clazz = null;
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            Class<?> clazz2 = this.resolvers[i].getCommonPropertyType(eLContext, object);
            if (clazz2 == null || clazz != null && !clazz.isAssignableFrom(clazz2)) continue;
            clazz = clazz2;
        }
        return clazz;
    }

    @Override
    public Object convertToType(ELContext eLContext, Object object, Class<?> clazz) {
        eLContext.setPropertyResolved(false);
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            Object object2 = this.resolvers[i].convertToType(eLContext, object, clazz);
            if (!eLContext.isPropertyResolved()) continue;
            return object2;
        }
        return null;
    }

    static {
        Class<?> clazz = null;
        try {
            clazz = Class.forName("jakarta.servlet.jsp.el.ScopedAttributeELResolver");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        SCOPED_ATTRIBUTE_EL_RESOLVER = clazz;
    }

    private static final class FeatureIterator
    implements Iterator<FeatureDescriptor> {
        private final ELContext context;
        private final Object base;
        private final ELResolver[] resolvers;
        private final int size;
        private Iterator<FeatureDescriptor> itr;
        private int idx;
        private FeatureDescriptor next;

        public FeatureIterator(ELContext eLContext, Object object, ELResolver[] eLResolverArray, int n) {
            this.context = eLContext;
            this.base = object;
            this.resolvers = eLResolverArray;
            this.size = n;
            this.idx = 0;
            this.guaranteeIterator();
        }

        private void guaranteeIterator() {
            while (this.itr == null && this.idx < this.size) {
                this.itr = this.resolvers[this.idx].getFeatureDescriptors(this.context, this.base);
                ++this.idx;
            }
        }

        @Override
        public boolean hasNext() {
            if (this.next != null) {
                return true;
            }
            if (this.itr != null) {
                while (this.next == null && this.itr.hasNext()) {
                    this.next = this.itr.next();
                }
            } else {
                return false;
            }
            if (this.next == null) {
                this.itr = null;
                this.guaranteeIterator();
            }
            return this.hasNext();
        }

        @Override
        public FeatureDescriptor next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            FeatureDescriptor featureDescriptor = this.next;
            this.next = null;
            return featureDescriptor;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

