/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.smiles;

import javajs.util.AU;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.P3;
import javajs.util.PT;
import org.jmol.api.SmilesMatcherInterface;
import org.jmol.modelset.Atom;
import org.jmol.smiles.InvalidSmilesException;
import org.jmol.smiles.SmilesAtom;
import org.jmol.smiles.SmilesBond;
import org.jmol.smiles.SmilesGenerator;
import org.jmol.smiles.SmilesParser;
import org.jmol.smiles.SmilesSearch;
import org.jmol.util.BSUtil;
import org.jmol.util.Elements;
import org.jmol.util.Logger;
import org.jmol.util.Node;
import org.jmol.util.Point3fi;

public class SmilesMatcher
implements SmilesMatcherInterface {
    private static final int MODE_BITSET = 1;
    private static final int MODE_ARRAY = 2;
    private static final int MODE_MAP = 3;
    private static final int MODE_ATROP = 4;
    private boolean okMF = true;

    @Override
    public String getLastException() {
        return this.okMF ? InvalidSmilesException.getLastError() : "MF_FAILED";
    }

    @Override
    public String getMolecularFormula(String pattern, boolean isSmarts) throws Exception {
        this.clearExceptions();
        SmilesSearch search = SmilesParser.newSearch("/nostereo/" + pattern, isSmarts, true);
        search.createTopoMap(null);
        search.nodes = search.targetAtoms;
        return search.getMolecularFormula(!isSmarts, null, false);
    }

    private void clearExceptions() {
        this.okMF = true;
        InvalidSmilesException.clear();
    }

    @Override
    public String getSmiles(Node[] atoms, int ac, BS bsSelected, String bioComment, int flags) throws Exception {
        this.clearExceptions();
        return new SmilesGenerator().getSmiles(this, atoms, ac, bsSelected, bioComment, flags);
    }

    @Override
    public int areEqual(String smiles1, String smiles2) throws Exception {
        boolean isWild;
        this.clearExceptions();
        boolean bl = isWild = smiles1.indexOf("*") >= 0;
        if (!isWild && smiles1.equals(smiles2)) {
            return 1;
        }
        int flags = (isWild ? 2 : 1) | 8;
        BS[] result = (BS[])this.matchPriv(smiles1, null, 0, null, null, false, flags, 2, SmilesParser.newSearch(smiles2, false, true));
        return result == null ? -1 : result.length;
    }

    public boolean areEqualTest(String smiles, SmilesSearch search) throws Exception {
        BS[] ret = (BS[])this.matchPriv(smiles, null, 0, null, null, false, 9, 2, search);
        return ret != null && ret.length == 1;
    }

    @Override
    public int[][] find(String pattern, String target, int flags) throws Exception {
        this.clearExceptions();
        target = SmilesParser.cleanPattern(target);
        pattern = SmilesParser.cleanPattern(pattern);
        SmilesSearch search = SmilesParser.newSearch(target, false, true);
        int[][] array = (int[][])this.matchPriv(pattern, null, 0, null, null, false, flags, 3, search);
        int i = array.length;
        while (--i >= 0) {
            int[] a = array[i];
            int j = a.length;
            while (--j >= 0) {
                a[j] = ((SmilesAtom)search.targetAtoms[a[j]]).mapIndex;
            }
        }
        return array;
    }

    @Override
    public Node[] getAtoms(String target) throws Exception {
        this.clearExceptions();
        target = SmilesParser.cleanPattern(target);
        SmilesSearch search = SmilesParser.newSearch(target, false, true);
        search.createTopoMap(new BS());
        return search.targetAtoms;
    }

    @Override
    public String getRelationship(String smiles1, String smiles2) throws Exception {
        int n2;
        boolean check;
        String mf2;
        if (smiles1 == null || smiles2 == null || smiles1.length() == 0 || smiles2.length() == 0) {
            return "";
        }
        String mf1 = this.getMolecularFormula(smiles1, false);
        if (!mf1.equals(mf2 = this.getMolecularFormula(smiles2, false))) {
            return "none";
        }
        int n1 = PT.countChar(PT.rep(smiles1, "@@", "@"), '@');
        boolean bl = check = n1 == (n2 = PT.countChar(PT.rep(smiles2, "@@", "@"), '@')) && this.areEqual(smiles2, smiles1) > 0;
        if (!check) {
            String s = smiles1 + smiles2;
            if (s.indexOf("/") >= 0 || s.indexOf("\\") >= 0 || s.indexOf("@") >= 0) {
                if (n1 == n2 && n1 > 0 && s.indexOf("@SP") < 0) {
                    boolean bl2 = check = this.areEqual("/invertstereo/" + smiles2, smiles1) > 0;
                    if (check) {
                        return "enantiomers";
                    }
                }
                boolean bl3 = check = this.areEqual("/nostereo/" + smiles2, smiles1) > 0;
                if (check) {
                    return n1 == n2 ? "diastereomers" : "ambiguous stereochemistry!";
                }
            }
            return "constitutional isomers";
        }
        return "identical";
    }

    @Override
    public String reverseChirality(String smiles) {
        smiles = PT.rep(smiles, "@@", "!@");
        smiles = PT.rep(smiles, "@", "@@");
        smiles = PT.rep(smiles, "!@@", "@");
        return smiles;
    }

    @Override
    public BS getSubstructureSet(String pattern, Node[] atoms, int ac, BS bsSelected, int flags) throws Exception {
        return (BS)this.matchPriv(pattern, atoms, ac, bsSelected, null, true, flags | SmilesParser.getFlags(pattern), 1, null);
    }

    @Override
    public void getMMFF94AtomTypes(String[] smarts, Node[] atoms, int ac, BS bsSelected, Lst<BS> ret, Lst<BS>[] vRings) throws Exception {
        this.clearExceptions();
        SmilesParser sp = new SmilesParser(true, true);
        SmilesSearch search = null;
        int flags = 770;
        search = sp.parse("");
        search.exitFirstMatch = false;
        search.targetAtoms = atoms;
        search.targetAtomCount = Math.abs(ac);
        search.setSelected(bsSelected);
        search.flags = flags;
        search.getRingData(vRings, true, true);
        search.asVector = false;
        search.subSearches = new SmilesSearch[1];
        search.getSelections();
        BS bsDone = new BS();
        for (int i = 0; i < smarts.length; ++i) {
            if (smarts[i] == null || smarts[i].length() == 0 || smarts[i].startsWith("#")) {
                ret.addLast(null);
                continue;
            }
            search.clear();
            search.subSearches[0] = sp.getSubsearch(search, SmilesParser.cleanPattern(smarts[i]), flags);
            BS bs = BSUtil.copy((BS)search.search());
            ret.addLast(bs);
            bsDone.or(bs);
            if (bsDone.cardinality() != ac) continue;
            return;
        }
    }

    @Override
    public BS[] getSubstructureSetArray(String pattern, Node[] atoms, int ac, BS bsSelected, BS bsAromatic, int flags) throws Exception {
        return (BS[])this.matchPriv(pattern, atoms, ac, bsSelected, bsAromatic, true, flags, 2, null);
    }

    public String getAtropisomerKeys(String pattern, Node[] atoms, int ac, BS bsSelected, BS bsAromatic, int flags) throws Exception {
        return (String)this.matchPriv(pattern, atoms, ac, bsSelected, bsAromatic, false, flags, 4, null);
    }

    @Override
    public String polyhedronToSmiles(Node center, int[][] faces, int atomCount, P3[] points, int flags, String details) throws Exception {
        Node[] atoms = new SmilesAtom[atomCount];
        for (int i = 0; i < atomCount; ++i) {
            P3 pt;
            atoms[i] = new SmilesAtom();
            P3 p3 = pt = points == null ? null : points[i];
            if (pt instanceof Node) {
                atoms[i].elementNumber = ((Node)((Object)pt)).getElementNumber();
                atoms[i].bioAtomName = ((Node)((Object)pt)).getAtomName();
                atoms[i].atomNumber = ((Node)((Object)pt)).getAtomNumber();
                atoms[i].setT(pt);
            } else {
                int n = atoms[i].elementNumber = pt instanceof Point3fi ? (int)((Point3fi)pt).sD : -2;
                if (pt != null) {
                    atoms[i].setT(pt);
                }
            }
            atoms[i].index = i;
        }
        int nBonds = 0;
        int i = faces.length;
        while (--i >= 0) {
            int n;
            int[] face = faces[i];
            int j = n = face.length;
            while (--j >= 0) {
                int iatom2;
                int iatom = face[j];
                if (iatom >= atomCount || (iatom2 = face[(j + 1) % n]) >= atomCount || ((SmilesAtom)atoms[iatom]).getBondTo((SmilesAtom)atoms[iatom2]) != null) continue;
                SmilesBond b = new SmilesBond((SmilesAtom)atoms[iatom], (SmilesAtom)atoms[iatom2], 1, false);
                b.index = nBonds++;
            }
        }
        for (i = 0; i < atomCount; ++i) {
            int n = atoms[i].bondCount;
            if (n != 0 && n == atoms[i].bonds.length) continue;
            atoms[i].bonds = (SmilesBond[])AU.arrayCopyObject(atoms[i].bonds, n);
        }
        String s = null;
        SmilesGenerator g = new SmilesGenerator();
        if (points != null) {
            g.polySmilesCenter = (P3)((Object)center);
        }
        this.clearExceptions();
        s = g.getSmiles(this, atoms, atomCount, BSUtil.newBitSet2(0, atomCount), null, flags | 0x1000 | 0x10 | 0x20);
        if ((flags & 0x10000) == 65536) {
            s = ((flags & 0x20000) == 0 ? "" : "//* " + center + " *//\t") + "[" + Elements.elementSymbolFromNumber(center.getElementNumber()) + "@PH" + atomCount + (details == null ? "" : "/" + details + "/") + "]." + s;
        }
        return s;
    }

    @Override
    public int[][] getCorrelationMaps(String pattern, Node[] atoms, int atomCount, BS bsSelected, int flags) throws Exception {
        return (int[][])this.matchPriv(pattern, atoms, atomCount, bsSelected, null, true, flags, 3, null);
    }

    private Object matchPriv(String pattern, Node[] atoms, int ac, BS bsSelected, BS bsAromatic, boolean doTestAromatic, int flags, int mode, SmilesSearch searchTarget) throws Exception {
        this.clearExceptions();
        try {
            boolean isTopo;
            boolean isSmarts = (flags & 2) == 2;
            SmilesSearch search = SmilesParser.newSearch(pattern, isSmarts, false);
            boolean bl = isTopo = (flags & 0x4000) == 16384;
            if (searchTarget != null) {
                search.haveTopo = true;
                bsAromatic = new BS();
                searchTarget.setFlags(searchTarget.flags | SmilesParser.getFlags(pattern));
                searchTarget.createTopoMap(bsAromatic);
                atoms = searchTarget.targetAtoms;
                ac = searchTarget.targetAtoms.length;
                if (isSmarts) {
                    int[] a1 = searchTarget.elementCounts;
                    int[] a2 = search.elementCounts;
                    for (int i = Math.max(searchTarget.elementNumberMax, search.elementNumberMax); i > 0; --i) {
                        if (a1[i] >= a2[i]) continue;
                        this.okMF = false;
                        break;
                    }
                } else {
                    String mf = isTopo ? null : search.getMolecularFormulaImpl(true, null, false);
                    this.okMF = mf == null || mf.equals(searchTarget.getMolecularFormulaImpl(true, null, false));
                }
                search.mf = null;
                searchTarget.mf = null;
            }
            if (this.okMF) {
                if (!isSmarts && !search.patternAromatic) {
                    if (bsAromatic == null) {
                        bsAromatic = new BS();
                    }
                    search.normalizeAromaticity(bsAromatic);
                    search.isNormalized = true;
                }
                search.targetAtoms = atoms;
                search.targetAtomCount = ac;
                if (!(ac == 0 || bsSelected != null && bsSelected.isEmpty())) {
                    boolean is3D = !(atoms[0] instanceof SmilesAtom);
                    search.setSelected(bsSelected);
                    search.getSelections();
                    if (!doTestAromatic) {
                        search.bsAromatic = bsAromatic;
                    }
                    search.setRingData(null, null, is3D || doTestAromatic);
                    search.exitFirstMatch = (flags & 8) == 8;
                    search.mapUnique = (flags & 0x80) == 128;
                }
            }
            switch (mode) {
                case 1: {
                    search.asVector = false;
                    return this.okMF ? search.search() : new BS();
                }
                case 2: {
                    if (!this.okMF) {
                        return new BS[0];
                    }
                    search.asVector = true;
                    Lst vb = (Lst)search.search();
                    return vb.toArray(new BS[vb.size()]);
                }
                case 4: {
                    if (!this.okMF) {
                        return "";
                    }
                    search.exitFirstMatch = true;
                    search.setAtropicity = true;
                    search.search();
                    return search.atropKeys;
                }
                case 3: {
                    if (!this.okMF) {
                        return new int[0][0];
                    }
                    search.getMaps = true;
                    search.setFlags(flags | search.flags);
                    Lst vl = (Lst)search.search();
                    return vl.toArray((T[])AU.newInt2(vl.size()));
                }
            }
        }
        catch (Exception e) {
            if (Logger.debugging) {
                e.printStackTrace();
            }
            if (InvalidSmilesException.getLastError() == null) {
                this.clearExceptions();
            }
            throw new InvalidSmilesException(InvalidSmilesException.getLastError());
        }
        return null;
    }

    @Override
    public String cleanSmiles(String smiles) {
        return SmilesParser.cleanPattern(smiles);
    }

    @Override
    public int[][] getMapForJME(String jme, Atom[] at, BS bsAtoms) {
        SmilesSearch molecule = new SmilesSearch();
        String[] tokens = PT.getTokens(jme);
        int nAtoms = PT.parseInt(tokens[0]);
        int nBonds = PT.parseInt(tokens[1]);
        int pt = 2;
        int i = 0;
        while (i < nAtoms) {
            String sa = tokens[pt];
            SmilesAtom a = molecule.addAtom();
            int ic = sa.indexOf("+");
            int charge = 0;
            if (ic >= 0) {
                charge = ic == sa.length() - 1 ? 1 : PT.parseInt(sa.substring(ic + 1));
            } else {
                ic = sa.indexOf("-");
                if (ic >= 0) {
                    charge = PT.parseInt(sa.substring(ic));
                }
            }
            a.setCharge(charge);
            a.setSymbol(ic < 0 ? sa : sa.substring(0, ic));
            ++i;
            pt += 3;
        }
        i = 0;
        while (i < nBonds) {
            int ia = PT.parseInt(tokens[pt++]) - 1;
            int ib = PT.parseInt(tokens[pt++]) - 1;
            int iorder = PT.parseInt(tokens[pt++]);
            SmilesAtom a1 = molecule.patternAtoms[ia];
            SmilesAtom a2 = molecule.patternAtoms[ib];
            int order = 1;
            switch (iorder) {
                default: {
                    break;
                }
                case 2: {
                    order = 2;
                    break;
                }
                case 3: {
                    order = 3;
                }
            }
            new SmilesBond((SmilesAtom)a1, (SmilesAtom)a2, (int)order, (boolean)false).index = i++;
        }
        String s = "";
        try {
            molecule.isSmarts = true;
            molecule.set();
            BS bs = BSUtil.newBitSet2(0, nAtoms);
            s = this.getSmiles(molecule.patternAtoms, molecule.ac, bs, null, 34);
            int[][] map = this.getCorrelationMaps(s, molecule.patternAtoms, nAtoms, bs, 42);
            int[][] map2 = this.getCorrelationMaps(s, at, bsAtoms.cardinality(), bsAtoms, 42);
            return new int[][]{map[0], map2[0]};
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

