/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.socket;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import jnr.constants.platform.AddressFamily;
import jnr.constants.platform.NameInfo;
import jnr.constants.platform.ProtocolFamily;
import jnr.constants.platform.Sock;
import jnr.netdb.Protocol;
import jnr.netdb.Service;
import jnr.unixsocket.UnixSocketAddress;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyInteger;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.socket.SocketType;
import org.jruby.ext.socket.SocketUtils;
import org.jruby.ext.socket.SocketUtilsIPV6;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.StringSupport;
import org.jruby.util.TypeConverter;
import org.jruby.util.io.Sockaddr;

public class Addrinfo
extends RubyObject {
    final short ARPHRD_ETHER = 1;
    final short ARPHRD_LOOPBACK = (short)772;
    final short AF_PACKET = (short)17;
    final byte PACKET_HOST = 0;
    public static final int AI_PASSIVE = 1;
    public static final int AI_CANONNAME = 2;
    public static final int AI_NUMERICHOST = 4;
    public static final int AI_NUMERICSERV = 8;
    public static final int AI_MASK = 15;
    public static final int AI_ALL = 256;
    public static final int AI_V4MAPPED_CFG = 512;
    public static final int AI_ADDRCONFIG = 1024;
    public static final int AI_V4MAPPED = 2048;
    public static final int AI_DEFAULT = 1536;
    private SocketAddress socketAddress;
    private ProtocolFamily pfamily = ProtocolFamily.PF_UNSPEC;
    private Sock sock;
    private SocketType socketType;
    private String interfaceName;
    private boolean interfaceLink;
    private NetworkInterface networkInterface;
    private boolean isBroadcast;
    private Protocol protocol = Protocol.getProtocolByNumber(0);

    public static void createAddrinfo(Ruby runtime2) {
        RubyClass addrinfo = runtime2.defineClass("Addrinfo", runtime2.getData(), Addrinfo::new);
        addrinfo.defineAnnotatedMethods(Addrinfo.class);
    }

    public Addrinfo(Ruby runtime2, RubyClass cls) {
        super(runtime2, cls);
    }

    public Addrinfo(Ruby runtime2, RubyClass cls, NetworkInterface networkInterface, boolean isBroadcast) {
        super(runtime2, cls);
        this.networkInterface = networkInterface;
        this.interfaceLink = true;
        this.isBroadcast = isBroadcast;
        this.interfaceName = networkInterface.getName();
        this.socketType = SocketType.SOCKET;
    }

    public Addrinfo(Ruby runtime2, RubyClass cls, InetAddress inetAddress) {
        super(runtime2, cls);
        this.socketAddress = new InetSocketAddress(inetAddress, 0);
        this.socketType = SocketType.SOCKET;
    }

    public Addrinfo(Ruby runtime2, RubyClass cls, InetAddress inetAddress, int port, Sock sock) {
        super(runtime2, cls);
        this.socketAddress = new InetSocketAddress(inetAddress, port);
        this.pfamily = ProtocolFamily.valueOf(this.getAddressFamily().intValue());
        this.socketType = SocketType.SOCKET;
        this.setSockAndProtocol(sock);
    }

    public Addrinfo(Ruby runtime2, RubyClass cls, SocketAddress socketAddress, Sock sock, SocketType socketType) {
        super(runtime2, cls);
        this.socketAddress = socketAddress;
        this.pfamily = ProtocolFamily.valueOf(this.getAddressFamily().intValue());
        this.socketType = socketType;
        this.setSockAndProtocol(sock);
    }

    public Addrinfo(Ruby runtime2, RubyClass cls, InetAddress inetAddress, int port) {
        super(runtime2, cls);
        this.socketAddress = new InetSocketAddress(inetAddress, port);
        this.setSockAndProtocol(Sock.SOCK_STREAM);
    }

    public Addrinfo(Ruby runtime2, RubyClass cls, SocketAddress socketAddress) {
        super(runtime2, cls);
        this.socketAddress = socketAddress;
        this.pfamily = ProtocolFamily.valueOf(this.getAddressFamily().intValue());
        this.setSockAndProtocol(Sock.SOCK_STREAM);
    }

    public int getPort() {
        return this.socketAddress instanceof InetSocketAddress ? this.getInetSocketAddress().getPort() : -1;
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject _sockaddr) {
        this.initializeCommon(context, _sockaddr, null, null, null);
        return context.nil;
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject _sockaddr, IRubyObject _family) {
        this.initializeCommon(context, _sockaddr, _family, null, null);
        return context.nil;
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject _sockaddr, IRubyObject _family, IRubyObject _socktype) {
        this.initializeCommon(context, _sockaddr, _family, _socktype, null);
        return context.nil;
    }

    @JRubyMethod(required=1, optional=4, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject[] args2) {
        switch (args2.length) {
            case 1: {
                return this.initialize(context, args2[0]);
            }
            case 2: {
                return this.initialize(context, args2[0], args2[1]);
            }
            case 3: {
                return this.initialize(context, args2[0], args2[1], args2[2]);
            }
        }
        IRubyObject _sockaddr = args2[0];
        IRubyObject _family = args2[1];
        IRubyObject _socktype = args2[2];
        IRubyObject _protocol = args2[3];
        this.initializeCommon(context, _sockaddr, _family, _socktype, _protocol);
        return context.nil;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initializeCommon(ThreadContext context, IRubyObject sockaddr, IRubyObject family2, IRubyObject sock, IRubyObject port) {
        Ruby runtime2 = context.runtime;
        try {
            IRubyObject _sockaddrAry = TypeConverter.checkArrayType(context, sockaddr);
            if (_sockaddrAry != context.nil) {
                RubyArray sockaddAry = (RubyArray)_sockaddrAry;
                family2 = sockaddAry.eltOk(0L).convertToString();
                AddressFamily af = SocketUtils.addressFamilyFromArg(family2);
                ProtocolFamily pf = SocketUtils.protocolFamilyFromArg(family2);
                if (af == AddressFamily.AF_UNIX || pf == ProtocolFamily.PF_UNIX) {
                    RubyString path2 = sockaddAry.eltOk(1L).convertToString();
                    this.socketAddress = new UnixSocketAddress(new File(((Object)path2).toString()));
                    this.socketType = SocketType.UNIX;
                    this.sock = Sock.SOCK_STREAM;
                    return;
                }
                if (af != AddressFamily.AF_INET && pf != ProtocolFamily.PF_INET && af != AddressFamily.AF_INET6 && pf != ProtocolFamily.PF_INET6) throw runtime2.newRaiseException(runtime2.getClass("SocketError"), "unknown address family: " + family2.toString());
                RubyInteger service = sockaddAry.eltOk(1L).convertToInteger();
                Object nodename = sockaddAry.eltOk(2L);
                Object numericnode = sockaddAry.eltOk(3L);
                InetAddress inetAddress = null;
                int _port = service.convertToInteger().getIntValue();
                if (!nodename.isNil()) {
                    inetAddress = Addrinfo.getRubyInetAddress(nodename);
                }
                if (inetAddress == null) {
                    inetAddress = Addrinfo.getRubyInetAddress(numericnode);
                }
                this.socketAddress = new InetSocketAddress(inetAddress, _port);
                this.pfamily = pf;
            } else {
                InetAddress inetAddress = Addrinfo.getRubyInetAddress(sockaddr);
                if (inetAddress == null) {
                    this.socketAddress = Sockaddr.sockaddrFromBytes(runtime2, sockaddr.convertToString().getBytes());
                }
                int _port = port != null ? SocketUtils.portToInt(port) : 0;
                this.socketAddress = new InetSocketAddress(inetAddress, _port);
                this.pfamily = this.getInetAddress() instanceof Inet4Address ? ProtocolFamily.PF_INET : ProtocolFamily.PF_INET6;
            }
            this.socketType = SocketType.SOCKET;
            this.setSockAndProtocol(sock);
            return;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw runtime2.newIOErrorFromException(ioe);
        }
    }

    private void setSockAndProtocol(IRubyObject sock) {
        this.setSockAndProtocol(sock == null ? null : SocketUtils.sockFromArg(sock));
    }

    private void setSockAndProtocol(Sock sock) {
        this.sock = sock;
        if (this.socketAddress instanceof InetSocketAddress) {
            if (this.sock == Sock.SOCK_STREAM) {
                this.protocol = Protocol.getProtocolByName("tcp");
            } else if (this.sock == Sock.SOCK_DGRAM) {
                this.protocol = Protocol.getProtocolByName("udp");
            }
        }
    }

    @JRubyMethod
    public IRubyObject inspect(ThreadContext context) {
        String base = "#<Addrinfo: %s>";
        StringBuilder val = new StringBuilder();
        if (this.interfaceLink) {
            val.append(this.packet_inspect());
        } else {
            val.append(this.inspect_sockaddr(context).toString());
        }
        if (!(this.pfamily != ProtocolFamily.PF_INET && this.pfamily != ProtocolFamily.PF_INET6 || this.sock != Sock.SOCK_STREAM && this.sock != Sock.SOCK_DGRAM)) {
            val.append(" ").append(this.protocol.getName().toUpperCase());
        } else if (this.sock != null) {
            val.append(" ").append(this.sock.name().toUpperCase());
        } else if (this.protocol != null && this.protocol.getProto() != 0) {
            val.append(" ").append(String.format("UNKNOWN PROTOCOL(%d)", this.protocol.getProto()));
        }
        String inspectName = this.inspectname();
        if (inspectName != null && !this.interfaceLink) {
            val.append(" (").append(inspectName).append(")");
        }
        return context.runtime.newString(String.format(base, val.toString()));
    }

    @JRubyMethod
    public IRubyObject inspect_sockaddr(ThreadContext context) {
        if (this.socketAddress instanceof UnixSocketAddress) {
            String path2 = this.getUnixSocketAddress().path();
            return context.runtime.newString(path2.startsWith("/") ? path2 : "UNIX " + path2);
        }
        int port = this.getInetSocketAddress().getPort();
        if (this.getInetAddress() instanceof Inet6Address) {
            String host = this.ipv6_ip();
            String hostPort = port == 0 ? host : "[" + host + "]:" + port;
            return context.runtime.newString(hostPort);
        }
        String portString = port == 0 ? "" : ":" + port;
        String host = this.getInetSocketAddress().getAddress().getHostAddress();
        return context.runtime.newString(host + portString);
    }

    @JRubyMethod(rest=true, meta=true)
    public static IRubyObject getaddrinfo(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return RubyArray.newArray(context.runtime, SocketUtils.getaddrinfoList(context, args2));
    }

    @JRubyMethod(meta=true)
    public static IRubyObject ip(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        String host = StringSupport.checkEmbeddedNulls(context.runtime, arg2.convertToString()).toString();
        try {
            InetAddress addy = SocketUtils.getRubyInetAddress(host);
            Addrinfo addrinfo = new Addrinfo(context.runtime, (RubyClass)recv2, addy);
            addrinfo.protocol = Protocol.getProtocolByName("ip");
            addrinfo.pfamily = addy instanceof Inet4Address ? ProtocolFamily.PF_INET : ProtocolFamily.PF_INET6;
            return addrinfo;
        }
        catch (UnknownHostException uhe) {
            throw SocketUtils.sockerr(context.runtime, "host not found");
        }
    }

    @JRubyMethod(meta=true)
    public static IRubyObject tcp(ThreadContext context, IRubyObject recv2, IRubyObject host, IRubyObject port) {
        Ruby runtime2 = context.runtime;
        Addrinfo addrinfo = new Addrinfo(runtime2, (RubyClass)recv2);
        addrinfo.initializeCommon(context, host, runtime2.newFixnum(ProtocolFamily.PF_UNSPEC.intValue()), runtime2.newFixnum(Sock.SOCK_STREAM.intValue()), port);
        return addrinfo;
    }

    @JRubyMethod(meta=true)
    public static IRubyObject udp(ThreadContext context, IRubyObject recv2, IRubyObject host, IRubyObject port) {
        Ruby runtime2 = context.runtime;
        Addrinfo addrinfo = new Addrinfo(runtime2, (RubyClass)recv2);
        addrinfo.initializeCommon(context, host, runtime2.newFixnum(ProtocolFamily.PF_UNSPEC.intValue()), runtime2.newFixnum(Sock.SOCK_DGRAM.intValue()), port);
        return addrinfo;
    }

    @JRubyMethod(meta=true)
    public static IRubyObject unix(ThreadContext context, IRubyObject recv2, IRubyObject path2) {
        Addrinfo addrinfo = new Addrinfo(context.runtime, (RubyClass)recv2);
        addrinfo.socketAddress = new UnixSocketAddress(new File(path2.convertToString().toString()));
        addrinfo.sock = Sock.SOCK_STREAM;
        addrinfo.socketType = SocketType.UNIX;
        addrinfo.pfamily = ProtocolFamily.PF_UNIX;
        addrinfo.protocol = Protocol.getProtocolByName("ip");
        return addrinfo;
    }

    @JRubyMethod(meta=true)
    public static IRubyObject unix(ThreadContext context, IRubyObject recv2, IRubyObject path2, IRubyObject type2) {
        Addrinfo addrinfo = new Addrinfo(context.runtime, (RubyClass)recv2);
        addrinfo.socketAddress = new UnixSocketAddress(new File(path2.convertToString().toString()));
        addrinfo.sock = SocketUtils.sockFromArg(type2);
        addrinfo.socketType = SocketType.UNIX;
        addrinfo.pfamily = ProtocolFamily.PF_UNIX;
        addrinfo.protocol = Protocol.getProtocolByName("ip");
        return addrinfo;
    }

    @JRubyMethod
    public IRubyObject afamily(ThreadContext context) {
        return context.runtime.newFixnum(this.getAddressFamily().intValue());
    }

    @JRubyMethod
    public IRubyObject pfamily(ThreadContext context) {
        return context.runtime.newFixnum(this.pfamily.intValue());
    }

    @JRubyMethod
    public IRubyObject socktype(ThreadContext context) {
        if (this.sock == null) {
            return context.runtime.newFixnum(0);
        }
        return context.runtime.newFixnum(this.sock.intValue());
    }

    @JRubyMethod
    public IRubyObject protocol(ThreadContext context) {
        return context.runtime.newFixnum(this.protocol.getProto());
    }

    @JRubyMethod
    public IRubyObject canonname(ThreadContext context) {
        if (this.socketAddress instanceof InetSocketAddress) {
            return context.runtime.newString(this.getInetSocketAddress().getAddress().getCanonicalHostName());
        }
        if (this.socketAddress instanceof UnixSocketAddress) {
            return context.runtime.newString(this.getUnixSocketAddress().path());
        }
        throw context.runtime.newNotImplementedError("canonname not implemented for socket address: " + this.socketAddress);
    }

    @JRubyMethod(name={"ipv4?"})
    public IRubyObject ipv4_p(ThreadContext context) {
        return RubyBoolean.newBoolean(context, this.getAddressFamily() == AddressFamily.AF_INET);
    }

    @JRubyMethod(name={"ipv6?"})
    public IRubyObject ipv6_p(ThreadContext context) {
        return RubyBoolean.newBoolean(context, this.getAddressFamily() == AddressFamily.AF_INET6);
    }

    @JRubyMethod(name={"unix?"})
    public IRubyObject unix_p(ThreadContext context) {
        return RubyBoolean.newBoolean(context, this.getAddressFamily() == AddressFamily.AF_UNIX);
    }

    @JRubyMethod(name={"ip?"})
    public IRubyObject ip_p(ThreadContext context) {
        return RubyBoolean.newBoolean(context, this.getAddressFamily() == AddressFamily.AF_INET || this.getAddressFamily() == AddressFamily.AF_INET6);
    }

    @JRubyMethod
    public IRubyObject ip_unpack(ThreadContext context) {
        RubyArray ary = RubyArray.newArray(context.runtime, 2);
        ary.append(this.ip_address(context));
        ary.append(this.ip_port(context));
        return ary;
    }

    @JRubyMethod
    public IRubyObject ip_address(ThreadContext context) {
        if (this.getAddressFamily() != AddressFamily.AF_INET && this.getAddressFamily() != AddressFamily.AF_INET6) {
            throw SocketUtils.sockerr(context.runtime, "need IPv4 or IPv6 address");
        }
        String fullHost = ((InetSocketAddress)this.socketAddress).getAddress().getHostAddress();
        String host = this.getAddressFamily() == AddressFamily.AF_INET6 ? this.ipv6_ip() : fullHost;
        return context.runtime.newString(host);
    }

    @JRubyMethod(notImplemented=true)
    public IRubyObject ip_port(ThreadContext context) {
        if (this.getAddressFamily() != AddressFamily.AF_INET && this.getAddressFamily() != AddressFamily.AF_INET6) {
            throw SocketUtils.sockerr(context.runtime, "need IPv4 or IPv6 address");
        }
        return context.runtime.newFixnum(((InetSocketAddress)this.socketAddress).getPort());
    }

    @JRubyMethod(name={"ipv4_private?"})
    public IRubyObject ipv4_private_p(ThreadContext context) {
        if (this.getAddressFamily() == AddressFamily.AF_INET) {
            return RubyBoolean.newBoolean(context, this.getInet4Address().isSiteLocalAddress());
        }
        return RubyBoolean.newBoolean(context, false);
    }

    @JRubyMethod(name={"ipv4_loopback?"})
    public IRubyObject ipv4_loopback_p(ThreadContext context) {
        if (this.getAddressFamily() == AddressFamily.AF_INET) {
            return RubyBoolean.newBoolean(context, ((InetSocketAddress)this.socketAddress).getAddress().isLoopbackAddress());
        }
        return RubyBoolean.newBoolean(context, false);
    }

    @JRubyMethod(name={"ipv4_multicast?"})
    public IRubyObject ipv4_multicast_p(ThreadContext context) {
        if (this.getAddressFamily() == AddressFamily.AF_INET) {
            return RubyBoolean.newBoolean(context, this.getInet4Address().isMulticastAddress());
        }
        return context.fals;
    }

    @JRubyMethod(name={"ipv6_unspecified?"})
    public IRubyObject ipv6_unspecified_p(ThreadContext context) {
        if (this.getAddressFamily() == AddressFamily.AF_INET6) {
            return RubyBoolean.newBoolean(context, this.getInet6Address().getHostAddress().equals("::"));
        }
        return context.fals;
    }

    @JRubyMethod(name={"ipv6_loopback?"})
    public IRubyObject ipv6_loopback_p(ThreadContext context) {
        if (this.getAddressFamily() == AddressFamily.AF_INET6) {
            return RubyBoolean.newBoolean(context, this.getInetSocketAddress().getAddress().isLoopbackAddress());
        }
        return RubyBoolean.newBoolean(context, false);
    }

    @JRubyMethod(name={"ipv6_multicast?"})
    public IRubyObject ipv6_multicast_p(ThreadContext context) {
        if (this.getAddressFamily() == AddressFamily.AF_INET6) {
            return RubyBoolean.newBoolean(context, this.getInet6Address().isMulticastAddress());
        }
        return context.fals;
    }

    @JRubyMethod(name={"ipv6_linklocal?"})
    public IRubyObject ipv6_linklocal_p(ThreadContext context) {
        return RubyBoolean.newBoolean(context, this.getInetSocketAddress().getAddress().isLinkLocalAddress());
    }

    @JRubyMethod(name={"ipv6_sitelocal?"})
    public IRubyObject ipv6_sitelocal_p(ThreadContext context) {
        return RubyBoolean.newBoolean(context, ((InetSocketAddress)this.socketAddress).getAddress().isSiteLocalAddress());
    }

    @JRubyMethod(name={"ipv6_v4mapped?"})
    public IRubyObject ipv6_v4mapped_p(ThreadContext context) {
        Inet6Address in6 = this.getInet6Address();
        return RubyBoolean.newBoolean(context, in6 != null && in6.getHostAddress().indexOf(":") == -1);
    }

    @JRubyMethod(name={"ipv6_v4compat?"})
    public IRubyObject ipv6_v4compat_p(ThreadContext context) {
        Inet6Address in6 = this.getInet6Address();
        return RubyBoolean.newBoolean(context, in6 != null && in6.isIPv4CompatibleAddress());
    }

    @JRubyMethod(name={"ipv6_mc_nodelocal?"})
    public IRubyObject ipv6_mc_nodelocal_p(ThreadContext context) {
        Inet6Address in6 = this.getInet6Address();
        return RubyBoolean.newBoolean(context, in6 != null && in6.isMCNodeLocal());
    }

    @JRubyMethod(name={"ipv6_mc_linklocal?"})
    public IRubyObject ipv6_mc_linklocal_p(ThreadContext context) {
        Inet6Address in6 = this.getInet6Address();
        return RubyBoolean.newBoolean(context, in6 != null && in6.isMCLinkLocal());
    }

    @JRubyMethod(name={"ipv6_mc_sitelocal?"})
    public IRubyObject ipv6_mc_sitelocal_p(ThreadContext context) {
        Inet6Address in6 = this.getInet6Address();
        return RubyBoolean.newBoolean(context, in6 != null && in6.isMCSiteLocal());
    }

    @JRubyMethod(name={"ipv6_mc_orglocal?"})
    public IRubyObject ipv6_mc_orglocal_p(ThreadContext context) {
        Inet6Address in6 = this.getInet6Address();
        return RubyBoolean.newBoolean(context, in6 != null && in6.isMCOrgLocal());
    }

    @JRubyMethod(name={"ipv6_mc_global?"})
    public IRubyObject ipv6_mc_global_p(ThreadContext context) {
        Inet6Address in6 = this.getInet6Address();
        return RubyBoolean.newBoolean(context, in6 != null && in6.isMCGlobal());
    }

    @JRubyMethod(notImplemented=true)
    public IRubyObject ipv6_to_ipv4(ThreadContext context) {
        return context.nil;
    }

    @JRubyMethod
    public IRubyObject unix_path(ThreadContext context) {
        if (this.getAddressFamily() != AddressFamily.AF_UNIX) {
            throw SocketUtils.sockerr(context.runtime, "need AF_UNIX address");
        }
        return context.runtime.newString(this.getUnixSocketAddress().path());
    }

    @JRubyMethod(name={"to_sockaddr", "to_s"})
    public IRubyObject to_sockaddr(ThreadContext context) {
        switch (this.getAddressFamily()) {
            case AF_INET: 
            case AF_INET6: {
                InetAddress inetAddress = ((InetSocketAddress)this.socketAddress).getAddress();
                int port = ((InetSocketAddress)this.socketAddress).getPort();
                return Sockaddr.pack_sockaddr_in(context, port, inetAddress.getHostAddress());
            }
            case AF_UNIX: {
                return Sockaddr.pack_sockaddr_un(context, this.getUnixSocketAddress().path());
            }
            case AF_UNSPEC: {
                ByteArrayOutputStream bufS = new ByteArrayOutputStream();
                DataOutputStream ds = new DataOutputStream(bufS);
                try {
                    ds.writeShort(this.swapShortEndian((short)17));
                    ds.writeShort(0);
                    ds.writeInt(this.swapIntEndian(this.networkInterface.getIndex()));
                    ds.writeShort(this.swapShortEndian(this.hatype()));
                    ds.writeByte(0);
                    byte[] hw = this.hwaddr();
                    ds.writeByte(hw.length);
                    ds.write(hw);
                }
                catch (IOException e) {
                    throw SocketUtils.sockerr(context.runtime, "to_sockaddr: " + e.getMessage());
                }
                return context.runtime.newString(new ByteList(bufS.toByteArray(), false));
            }
        }
        return context.nil;
    }

    private short hatype() {
        try {
            short ht = 1;
            if (this.networkInterface.isLoopback()) {
                ht = 772;
            }
            return ht;
        }
        catch (IOException e) {
            return 0;
        }
    }

    private byte[] hwaddr() {
        try {
            byte[] hw = new byte[]{0, 0, 0, 0, 0, 0};
            if (!this.networkInterface.isLoopback() && (hw = this.networkInterface.getHardwareAddress()) == null) {
                hw = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
            }
            if (this.isBroadcast) {
                hw = new byte[]{-1, -1, -1, -1, -1, -1};
            }
            return hw;
        }
        catch (IOException e) {
            return ByteList.NULL_ARRAY;
        }
    }

    public String packet_inspect() {
        StringBuffer hwaddr_sb = new StringBuffer();
        String sep = "";
        for (byte b2 : this.hwaddr()) {
            hwaddr_sb.append(sep);
            sep = ":";
            hwaddr_sb.append(String.format("%02x", b2));
        }
        return "PACKET[protocol=0 " + this.interfaceName + " hatype=" + this.hatype() + " HOST hwaddr=" + hwaddr_sb + "]";
    }

    private int swapIntEndian(int i2) {
        return ((i2 & 0xFF) << 24) + ((i2 & 0xFF00) << 8) + ((i2 & 0xFF0000) >> 8) + (i2 >> 24 & 0xFF);
    }

    private int swapShortEndian(short i2) {
        return ((i2 & 0xFF) << 8) + ((i2 & 0xFF00) >> 8);
    }

    private String ipv6_ip() {
        if (this.getAddressFamily() != AddressFamily.AF_INET6) {
            return null;
        }
        InetAddress in = this.getInetAddress();
        if (in.isLoopbackAddress()) {
            return "::1";
        }
        return SocketUtilsIPV6.getIPV6Address(in.getHostAddress());
    }

    private String inspectname() {
        InetAddress address2;
        if (this.socketAddress instanceof InetSocketAddress && !(address2 = this.getInetSocketAddress().getAddress()).toString().startsWith("/")) {
            return address2.getHostName();
        }
        return null;
    }

    private static InetAddress getRubyInetAddress(IRubyObject node) {
        try {
            if (node instanceof RubyInteger) {
                byte[] bytes2;
                if (node instanceof RubyBignum) {
                    bytes2 = ((RubyBignum)node).getBigIntegerValue().toByteArray();
                } else {
                    long i2 = (long)node.convertToInteger().getIntValue() & 0xFFFFL;
                    bytes2 = new byte[]{(byte)(i2 >> 24 & 0xFFL), (byte)(i2 >> 16 & 0xFFL), (byte)(i2 >> 8 & 0xFFL), (byte)(i2 & 0xFFL)};
                }
                return SocketUtils.getRubyInetAddress(bytes2);
            }
            return SocketUtils.getRubyInetAddress(node.convertToString().toString());
        }
        catch (UnknownHostException uhe) {
            return null;
        }
    }

    @JRubyMethod(optional=1)
    public IRubyObject getnameinfo(ThreadContext context, IRubyObject[] args2) {
        int flags2;
        RubyString hostname;
        Ruby runtime2 = context.runtime;
        InetSocketAddress inet = this.getInetSocketAddress();
        if (inet != null) {
            hostname = runtime2.newString(inet.getHostName());
        } else {
            UnixSocketAddress unix2 = this.getUnixSocketAddress();
            hostname = runtime2.newString(unix2.path());
        }
        RubyString rubyService = null;
        if (args2.length > 0 && ((flags2 = args2[0].convertToInteger().getIntValue()) & NameInfo.NI_NUMERICSERV.intValue()) != 0) {
            rubyService = runtime2.newString(Integer.toString(this.getPort()));
        }
        if (rubyService == null) {
            Service service = Service.getServiceByPort(this.getPort(), this.protocol.getName());
            rubyService = runtime2.newString(service.getName());
        }
        return runtime2.newArray((IRubyObject)hostname, (IRubyObject)rubyService);
    }

    @JRubyMethod(notImplemented=true)
    public IRubyObject marshal_dump(ThreadContext context) {
        return context.nil;
    }

    @JRubyMethod(notImplemented=true)
    public IRubyObject marshal_load(ThreadContext context, IRubyObject arg2) {
        return context.nil;
    }

    @JRubyMethod
    public IRubyObject to_str(ThreadContext context) {
        return context.runtime.newString(this.toString());
    }

    public Inet6Address getInet6Address() {
        InetSocketAddress in = this.getInetSocketAddress();
        if (in != null && in.getAddress() instanceof Inet6Address) {
            return (Inet6Address)in.getAddress();
        }
        return null;
    }

    public Inet4Address getInet4Address() {
        InetSocketAddress in = this.getInetSocketAddress();
        if (in != null && in.getAddress() instanceof Inet4Address) {
            return (Inet4Address)in.getAddress();
        }
        return null;
    }

    public InetAddress getInetAddress() {
        if (this.socketAddress instanceof InetSocketAddress) {
            return ((InetSocketAddress)this.socketAddress).getAddress();
        }
        return null;
    }

    public SocketAddress getSocketAddress() {
        return this.socketAddress;
    }

    public InetSocketAddress getInetSocketAddress() {
        if (this.socketAddress instanceof InetSocketAddress) {
            return (InetSocketAddress)this.socketAddress;
        }
        return null;
    }

    public UnixSocketAddress getUnixSocketAddress() {
        if (this.socketAddress instanceof UnixSocketAddress) {
            return (UnixSocketAddress)this.socketAddress;
        }
        return null;
    }

    @Override
    public String toString() {
        return this.socketAddress.toString();
    }

    AddressFamily getAddressFamily() {
        if (this.socketAddress instanceof InetSocketAddress) {
            if (this.getInetAddress() instanceof Inet4Address) {
                return AddressFamily.AF_INET;
            }
            return AddressFamily.AF_INET6;
        }
        if (this.socketAddress instanceof UnixSocketAddress) {
            return AddressFamily.AF_UNIX;
        }
        return AddressFamily.AF_UNSPEC;
    }
}

