/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.targets.indy;

import java.math.BigInteger;
import org.jcodings.Encoding;
import org.jruby.Ruby;
import org.jruby.RubyBignum;
import org.jruby.RubyClass;
import org.jruby.RubyEncoding;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.compiler.impl.SkinnyMethodAdapter;
import org.jruby.ir.IRManager;
import org.jruby.ir.instructions.CallBase;
import org.jruby.ir.operands.UndefinedValue;
import org.jruby.ir.targets.IRBytecodeAdapter;
import org.jruby.ir.targets.JVM;
import org.jruby.ir.targets.ValueCompiler;
import org.jruby.ir.targets.indy.BignumObjectSite;
import org.jruby.ir.targets.indy.Bootstrap;
import org.jruby.ir.targets.indy.FixnumObjectSite;
import org.jruby.ir.targets.indy.FloatObjectSite;
import org.jruby.ir.targets.indy.RegexpObjectSite;
import org.jruby.ir.targets.indy.SymbolObjectSite;
import org.jruby.ir.targets.indy.SymbolProcObjectSite;
import org.jruby.ir.targets.simple.NormalValueCompiler;
import org.jruby.runtime.CallType;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.CachingCallSite;
import org.jruby.util.ByteList;
import org.jruby.util.CodegenUtils;

public class IndyValueCompiler
implements ValueCompiler {
    private final IRBytecodeAdapter compiler;
    private final NormalValueCompiler normalValueCompiler;

    public IndyValueCompiler(IRBytecodeAdapter compiler) {
        this.compiler = compiler;
        this.normalValueCompiler = new NormalValueCompiler(compiler);
    }

    @Override
    public void pushRuntime() {
        this.compiler.loadContext();
        this.compiler.adapter.invokedynamic("runtime", CodegenUtils.sig(Ruby.class, ThreadContext.class), Bootstrap.contextValue(), new Object[0]);
    }

    @Override
    public void pushObjectClass() {
        this.compiler.loadContext();
        this.compiler.invokeIRHelper("getObject", CodegenUtils.sig(RubyClass.class, ThreadContext.class));
    }

    @Override
    public void pushUndefined() {
        this.compiler.adapter.getstatic(CodegenUtils.p(UndefinedValue.class), "UNDEFINED", CodegenUtils.ci(UndefinedValue.class));
    }

    @Override
    public void pushFixnum(long l) {
        this.compiler.loadContext();
        this.compiler.adapter.invokedynamic("fixnum", CodegenUtils.sig(JVM.OBJECT, ThreadContext.class), FixnumObjectSite.BOOTSTRAP, l);
    }

    @Override
    public void pushFloat(double d) {
        this.compiler.loadContext();
        this.compiler.adapter.invokedynamic("flote", CodegenUtils.sig(JVM.OBJECT, ThreadContext.class), FloatObjectSite.BOOTSTRAP, d);
    }

    @Override
    public void pushString(ByteList bl, int cr) {
        this.compiler.loadContext();
        this.compiler.adapter.invokedynamic("string", CodegenUtils.sig(RubyString.class, ThreadContext.class), Bootstrap.string(), RubyEncoding.decodeRaw(bl), bl.getEncoding().toString(), cr);
    }

    @Override
    public void pushFrozenString(ByteList bl, int cr, String file2, int line) {
        this.compiler.loadContext();
        this.compiler.adapter.invokedynamic("frozen", CodegenUtils.sig(RubyString.class, ThreadContext.class), Bootstrap.fstring(), RubyEncoding.decodeRaw(bl), bl.getEncoding().toString(), cr, file2, line);
    }

    @Override
    public void pushEmptyString(Encoding encoding2) {
        this.compiler.loadContext();
        this.compiler.adapter.invokedynamic("emptyString", CodegenUtils.sig(RubyString.class, ThreadContext.class), Bootstrap.EMPTY_STRING_BOOTSTRAP, encoding2.toString());
    }

    @Override
    public void pushByteList(ByteList bl) {
        this.compiler.adapter.invokedynamic("bytelist", CodegenUtils.sig(ByteList.class, new Class[0]), Bootstrap.bytelist(), RubyEncoding.decodeRaw(bl), bl.getEncoding().toString());
    }

    @Override
    public void pushRegexp(ByteList source2, int options2) {
        this.compiler.loadContext();
        this.compiler.adapter.invokedynamic("regexp", CodegenUtils.sig(RubyRegexp.class, ThreadContext.class), RegexpObjectSite.BOOTSTRAP, RubyEncoding.decodeRaw(source2), source2.getEncoding().toString(), options2);
    }

    @Override
    public void pushSymbol(ByteList bytes2) {
        this.compiler.loadContext();
        this.compiler.adapter.invokedynamic("symbol", CodegenUtils.sig(JVM.OBJECT, ThreadContext.class), SymbolObjectSite.BOOTSTRAP, RubyEncoding.decodeRaw(bytes2), bytes2.getEncoding().toString());
    }

    @Override
    public void pushSymbolProc(ByteList bytes2) {
        this.compiler.loadContext();
        this.compiler.adapter.invokedynamic("symbolProc", CodegenUtils.sig(JVM.OBJECT, ThreadContext.class), SymbolProcObjectSite.BOOTSTRAP, RubyEncoding.decodeRaw(bytes2), bytes2.getEncoding().toString());
    }

    @Override
    public void pushEncoding(Encoding encoding2) {
        this.compiler.loadContext();
        this.compiler.adapter.invokedynamic("encoding", CodegenUtils.sig(RubyEncoding.class, ThreadContext.class), Bootstrap.contextValueString(), new String(encoding2.getName()));
    }

    @Override
    public void pushNil() {
        this.compiler.loadContext();
        this.compiler.adapter.invokedynamic("nil", CodegenUtils.sig(IRubyObject.class, ThreadContext.class), Bootstrap.contextValue(), new Object[0]);
    }

    @Override
    public void pushBoolean(boolean b2) {
        this.compiler.loadContext();
        this.compiler.adapter.invokedynamic(b2 ? "True" : "False", CodegenUtils.sig(IRubyObject.class, ThreadContext.class), Bootstrap.contextValue(), new Object[0]);
    }

    @Override
    public void pushBignum(BigInteger bigint) {
        this.compiler.loadContext();
        this.compiler.adapter.invokedynamic("bignum", CodegenUtils.sig(RubyBignum.class, ThreadContext.class), BignumObjectSite.BOOTSTRAP, bigint.toString());
    }

    @Override
    public void pushCallSite(String className, String siteName, String scopeFieldName, CallBase call2) {
        CallType callType = call2.getCallType();
        boolean profileCandidate = call2.hasLiteralClosure() && scopeFieldName != null && IRManager.IR_INLINER;
        boolean profiled = false;
        boolean refined = call2.isPotentiallyRefined();
        boolean specialSite = profiled || refined || profileCandidate;
        SkinnyMethodAdapter method2 = this.compiler.adapter;
        if (!specialSite) {
            method2.invokedynamic("callSite", CodegenUtils.sig(CachingCallSite.class, new Class[0]), Bootstrap.CALLSITE, call2.getId(), callType.ordinal());
            return;
        }
        this.normalValueCompiler.pushCallSite(className, siteName, scopeFieldName, call2);
    }

    @Override
    public void pushConstantLookupSite(String className, String siteName, ByteList name2) {
        this.normalValueCompiler.pushConstantLookupSite(className, siteName, name2);
    }
}

