/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.plus.views;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import net.osmand.data.RotatedTileBox;
import net.osmand.plus.OsmandSettings;
import net.osmand.plus.TargetPointsHelper;
import net.osmand.plus.routing.RoutingHelper;
import net.osmand.plus.views.OsmandMapLayer;
import net.sourceforge.offroad.OsmWindow;
import net.sourceforge.offroad.R;
import net.sourceforge.offroad.actions.NavigationRotationAction;
import net.sourceforge.offroad.ui.DirectOffroadLayer;
import net.sourceforge.offroad.ui.Drawable;
import net.sourceforge.offroad.ui.OsmBitmapPanel;
import net.sourceforge.offroad.ui.RoundButton;

public class MapControlsLayer
extends OsmandMapLayer
implements DirectOffroadLayer {
    private static final int TIMEOUT_TO_SHOW_BUTTONS = 7000;
    public static final int REQUEST_ADDRESS_SELECT = 2;
    private static final int REQUEST_LOCATION_FOR_NAVIGATION_PERMISSION = 200;
    private List<MapHudButton> controls = new ArrayList<MapHudButton>();
    private final OsmBitmapPanel mapActivity;
    private Color shadowColor = null;
    private OsmandSettings settings;
    private MapHudButton backToLocationControl;
    private MapHudButton menuControl;
    private MapHudButton compassHud;
    private float cachedRotate = 0.0f;
    private BufferedImage appModeIcon;
    private OsmWindow app;
    private MapHudButton routePlanningBtn;
    private long touchEvent;
    private MapHudButton mapZoomOut;
    private MapHudButton mapZoomIn;
    private MapHudButton layersHud;
    private long lastZoom;
    private boolean hasTargets;

    public MapHudButton createHudButton(JButton iv, String resId) {
        MapHudButton mc = new MapHudButton();
        mc.iv = iv;
        mc.resId = resId;
        return mc;
    }

    public MapControlsLayer(OsmBitmapPanel activity) {
        this.mapActivity = activity;
        this.app = activity.getMyApplication();
        this.settings = activity.getMyApplication().getSettings();
    }

    @Override
    public boolean drawInScreenPixels() {
        return true;
    }

    @Override
    public void initLayer(OsmBitmapPanel view) {
        this.initTopControls();
        this.initDasboardRelatedControls();
        this.updateControls(view.copyCurrentTileBox(), null);
    }

    public void initDasboardRelatedControls() {
        this.initControls();
        this.initRouteControls();
    }

    private void initTopControls() {
        JButton compass = this.mapActivity.findViewById(0);
        this.compassHud = this.createHudButton(compass, "map_compass").setIconColorId(R.color.color_black).setBg("map_bt_round_2_shadow", R.color.map_widget_light_trans, "btn_inset_circle_night", R.color.map_widget_dark);
        this.compassHud.compass = true;
        this.controls.add(this.compassHud);
        NavigationRotationAction rotationAction = new NavigationRotationAction(this.app);
        rotationAction.setAbsolute(0.0);
        compass.addActionListener(rotationAction);
    }

    private void initRouteControls() {
    }

    public void setControlsClickable(boolean clickable) {
        for (MapHudButton mb : this.controls) {
            mb.iv.setEnabled(clickable);
        }
    }

    private TargetPointsHelper getTargets() {
        return this.mapActivity.getMyApplication().getTargetPointsHelper();
    }

    private void initControls() {
    }

    @Override
    public void destroyLayer() {
        this.controls.clear();
    }

    @Override
    public void onDraw(Graphics2D canvas, RotatedTileBox tileBox, OsmandMapLayer.DrawSettings nightMode) {
        this.updateControls(tileBox, nightMode);
    }

    private void updateControls(RotatedTileBox tileBox, OsmandMapLayer.DrawSettings nightMode) {
        Color textColor;
        boolean isNight = nightMode != null && nightMode.isNightMode();
        Color shadw = isNight ? R.color.color_transparent : R.color.color_white;
        Color color2 = textColor = isNight ? R.color.widgettext_night : R.color.color_black;
        if (this.shadowColor != shadw) {
            this.shadowColor = shadw;
        }
        boolean routePlanningMode = false;
        RoutingHelper rh = this.mapActivity.getApplication().getRoutingHelper();
        if (rh.isRoutePlanningMode()) {
            routePlanningMode = true;
        } else if ((rh.isRouteCalculated() || rh.isRouteBeingCalculated()) && !rh.isFollowingMode()) {
            routePlanningMode = true;
        }
        boolean routeFollowingMode = !routePlanningMode && rh.isFollowingMode();
        boolean dialogOpened = false;
        boolean showRouteCalculationControls = routePlanningMode || System.currentTimeMillis() - this.touchEvent < 7000L && routeFollowingMode;
        boolean showButtons = showRouteCalculationControls || !routeFollowingMode;
        this.compassHud.updateVisibility(!dialogOpened);
        this.updateCompass(isNight);
        for (MapHudButton mc : this.controls) {
            mc.update(this.mapActivity.getMyApplication(), isNight);
        }
    }

    private void updateCompass(boolean isNight) {
        float mapRotate = this.mapActivity.copyCurrentTileBox().getRotate();
        if (mapRotate != this.cachedRotate) {
            this.cachedRotate = mapRotate;
            ((RoundButton)this.compassHud.iv).setRotate(this.cachedRotate);
            this.compassHud.iv.invalidate();
        }
        if (this.settings.ROTATE_MAP.get() == 0) {
            this.compassHud.setIconResId(isNight ? "map_compass_niu_white" : "map_compass_niu");
        } else if (this.settings.ROTATE_MAP.get() == 1) {
            this.compassHud.setIconResId(isNight ? "map_compass_bearing_white" : "map_compass_bearing");
        } else {
            this.compassHud.setIconResId(isNight ? "map_compass_white" : "map_compass");
        }
    }

    @Override
    public boolean onSingleTap(Point2D point, RotatedTileBox tileBox) {
        return true;
    }

    private class MapHudButton {
        JButton iv;
        String bgDark;
        String bgLight;
        String resId;
        String resLightId;
        String resDarkId;
        Color resClrLight = R.color.icon_color;
        Color resClrDark = R.color.color_black;
        boolean nightMode = false;
        boolean f = true;
        boolean compass;
        private Color bgLightColor;
        private Color bgDarkColor;

        private MapHudButton() {
        }

        public MapHudButton setRoundTransparent() {
            this.setBg("map_bt_round_1_shadow", R.color.map_widget_light_trans, "map_bt_round_1_shadow", R.color.map_widget_dark);
            return this;
        }

        public MapHudButton setBg(String dayBg, Color pColorDay, String nightBg, Color pColorNight) {
            if (nightBg.equals(this.bgDark) && this.bgLight.equals(dayBg)) {
                return this;
            }
            this.bgDark = nightBg;
            this.bgLight = dayBg;
            this.bgLightColor = pColorDay;
            this.bgDarkColor = pColorNight;
            this.f = true;
            return this;
        }

        public boolean updateVisibility(boolean visible) {
            if (visible != this.iv.isVisible()) {
                this.iv.setVisible(visible);
                this.iv.invalidate();
                return true;
            }
            return false;
        }

        public MapHudButton setBg(String bg) {
            if (bg.equals(this.bgDark) && bg.equals(this.bgLight)) {
                return this;
            }
            this.bgDark = bg;
            this.bgLight = bg;
            this.f = true;
            return this;
        }

        public boolean setIconResId(String resId) {
            if (resId.equals(this.resId)) {
                return false;
            }
            this.resId = resId;
            this.f = true;
            return true;
        }

        public boolean resetIconColors() {
            if (R.color.icon_color.equals(this.resClrLight) && R.color.color_black.equals(this.resClrDark)) {
                return false;
            }
            this.resClrLight = R.color.icon_color;
            this.resClrDark = R.color.color_black;
            this.f = true;
            return true;
        }

        public MapHudButton setIconColorId(Color clr) {
            if (clr.equals(this.resClrLight) && clr.equals(this.resClrDark)) {
                return this;
            }
            this.resClrLight = clr;
            this.resClrDark = clr;
            this.f = true;
            return this;
        }

        public MapHudButton setIconsId(String icnLight, String icnDark) {
            if (icnLight.equals(this.resLightId) && icnDark.equals(this.resDarkId)) {
                return this;
            }
            this.resLightId = icnLight;
            this.resDarkId = icnDark;
            this.f = true;
            return this;
        }

        public MapHudButton setIconColorId(Color clrLight, Color clrDark) {
            if (clrLight.equals(this.resClrLight) && clrDark.equals(this.resClrDark)) {
                return this;
            }
            this.resClrLight = clrLight;
            this.resClrDark = clrDark;
            this.f = true;
            return this;
        }

        public void update(OsmWindow ctx, boolean night) {
            if (this.nightMode == night && !this.f) {
                return;
            }
            this.f = false;
            this.nightMode = night;
            if (this.compass) {
                RoundButton roundButton = (RoundButton)this.iv;
                roundButton.setBackgroundIcon(MapControlsLayer.this.readImage(night ? this.bgDark : this.bgLight, MapControlsLayer.this.mapActivity));
                roundButton.setBackground(night ? this.bgDarkColor : this.bgLightColor);
            }
            BufferedImage d = null;
            if (this.resDarkId != null && this.nightMode) {
                d = MapControlsLayer.this.readImage(this.resDarkId, MapControlsLayer.this.mapActivity);
            } else if (this.resLightId != null && !this.nightMode) {
                d = MapControlsLayer.this.readImage(this.resLightId, MapControlsLayer.this.mapActivity);
            } else if (this.resId != null) {
                d = MapControlsLayer.this.readImage(this.resId, MapControlsLayer.this.mapActivity);
            }
            if (this.compass) {
                RoundButton roundButton = (RoundButton)this.iv;
                roundButton.setForegroundIcon(d);
            } else {
                this.iv.setIcon(new ImageIcon(d));
            }
        }
    }

    private class CompassDrawable
    extends Drawable {
        private Drawable original;

        public CompassDrawable(Drawable original) {
            this.original = original;
        }

        @Override
        public void draw(Graphics2D canvas) {
            canvas.rotate(MapControlsLayer.this.cachedRotate, this.getIntrinsicWidth() / 2, this.getIntrinsicHeight() / 2);
            this.original.draw(canvas);
        }

        @Override
        public int getMinimumHeight() {
            return this.original.getMinimumHeight();
        }

        @Override
        public int getMinimumWidth() {
            return this.original.getMinimumWidth();
        }

        @Override
        public int getIntrinsicHeight() {
            return this.original.getIntrinsicHeight();
        }

        @Override
        public int getIntrinsicWidth() {
            return this.original.getIntrinsicWidth();
        }

        @Override
        public void setChangingConfigurations(int configs) {
            super.setChangingConfigurations(configs);
            this.original.setChangingConfigurations(configs);
        }

        @Override
        public void setBounds(int left, int top, int right, int bottom) {
            super.setBounds(left, top, right, bottom);
            this.original.setBounds(left, top, right, bottom);
        }

        @Override
        public void setAlpha(int alpha) {
            this.original.setAlpha(alpha);
        }

        @Override
        public int getOpacity() {
            return this.original.getOpacity();
        }
    }
}

