# This file has been autogenerated by the pywayland scanner

# Copyright 2015 Sean Vig
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

from pywayland.protocol_core import Argument, ArgumentType, Global, Interface, Proxy, Resource
from ..wayland import WlSurface


class ZwpPointerGestureHoldV1(Interface):
    """A hold gesture object

    A hold gesture object notifies a client about a single- or multi-finger
    hold gesture detected on an indirect input device such as a touchpad. The
    gesture is usually initiated by one or more fingers being held down without
    significant movement. The precise conditions of when such a gesture is
    detected are implementation-dependent.

    In particular, this gesture may be used to cancel kinetic scrolling.

    A hold gesture consists of two stages: begin and end. Unlike pinch and
    swipe there is no update stage. There cannot be multiple simultaneous hold,
    pinch or swipe gestures on a same pointer/seat, how compositors prevent
    these situations is implementation-dependent.

    A gesture may be cancelled by the compositor or the hardware. Clients
    should not consider performing permanent or irreversible actions until the
    end of a gesture has been received.
    """

    name = "zwp_pointer_gesture_hold_v1"
    version = 3


class ZwpPointerGestureHoldV1Proxy(Proxy):
    interface = ZwpPointerGestureHoldV1

    @ZwpPointerGestureHoldV1.request(version=3)
    def destroy(self):
        """Destroy the hold gesture object
        """
        self._marshal(0)
        self._destroy()


class ZwpPointerGestureHoldV1Resource(Resource):
    interface = ZwpPointerGestureHoldV1

    @ZwpPointerGestureHoldV1.event(
        Argument(ArgumentType.Uint),
        Argument(ArgumentType.Uint),
        Argument(ArgumentType.Object, interface=WlSurface),
        Argument(ArgumentType.Uint),
        version=3,
    )
    def begin(self, serial, time, surface, fingers):
        """Multi-finger hold begin

        This event is sent when a hold gesture is detected on the device.

        :param serial:
        :type serial:
            `ArgumentType.Uint`
        :param time:
            timestamp with millisecond granularity
        :type time:
            `ArgumentType.Uint`
        :param surface:
        :type surface:
            :class:`~pywayland.protocol.wayland.WlSurface`
        :param fingers:
            number of fingers
        :type fingers:
            `ArgumentType.Uint`
        """
        self._post_event(0, serial, time, surface, fingers)

    @ZwpPointerGestureHoldV1.event(
        Argument(ArgumentType.Uint),
        Argument(ArgumentType.Uint),
        Argument(ArgumentType.Int),
        version=3,
    )
    def end(self, serial, time, cancelled):
        """Multi-finger hold end

        This event is sent when a hold gesture ceases to be valid. This may
        happen when the holding fingers are lifted or the gesture is cancelled,
        for example if the fingers move past an implementation-defined
        threshold, the finger count changes or the hold gesture changes into a
        different type of gesture.

        When a gesture is cancelled, the client may need to undo state changes
        caused by this gesture. What causes a gesture to be cancelled is
        implementation-dependent.

        :param serial:
        :type serial:
            `ArgumentType.Uint`
        :param time:
            timestamp with millisecond granularity
        :type time:
            `ArgumentType.Uint`
        :param cancelled:
            1 if the gesture was cancelled, 0 otherwise
        :type cancelled:
            `ArgumentType.Int`
        """
        self._post_event(1, serial, time, cancelled)


class ZwpPointerGestureHoldV1Global(Global):
    interface = ZwpPointerGestureHoldV1


ZwpPointerGestureHoldV1._gen_c()
ZwpPointerGestureHoldV1.proxy_class = ZwpPointerGestureHoldV1Proxy
ZwpPointerGestureHoldV1.resource_class = ZwpPointerGestureHoldV1Resource
ZwpPointerGestureHoldV1.global_class = ZwpPointerGestureHoldV1Global
