/*
 * Decompiled with CFR 0.152.
 */
package sun.util.locale;

import java.util.List;
import java.util.Map;
import java.util.Set;

public final class LocaleUtils {
    private LocaleUtils() {
    }

    public static boolean caseIgnoreMatch(String s1, String s2) {
        if (s1 == s2) {
            return true;
        }
        int len = s1.length();
        if (len != s2.length()) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            char c2;
            char c1 = s1.charAt(i);
            if (c1 == (c2 = s2.charAt(i)) || LocaleUtils.toLower(c1) == LocaleUtils.toLower(c2)) continue;
            return false;
        }
        return true;
    }

    static int caseIgnoreCompare(String s1, String s2) {
        if (s1 == s2) {
            return 0;
        }
        return LocaleUtils.toLowerString(s1).compareTo(LocaleUtils.toLowerString(s2));
    }

    static char toUpper(char c) {
        return LocaleUtils.isLower(c) ? (char)(c - 32) : c;
    }

    static char toLower(char c) {
        return LocaleUtils.isUpper(c) ? (char)(c + 32) : c;
    }

    public static String toLowerString(String s) {
        int idx;
        int len = s.length();
        for (idx = 0; idx < len && !LocaleUtils.isUpper(s.charAt(idx)); ++idx) {
        }
        if (idx == len) {
            return s;
        }
        char[] buf = new char[len];
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            buf[i] = i < idx ? c : LocaleUtils.toLower(c);
        }
        return new String(buf);
    }

    static String toUpperString(String s) {
        int idx;
        int len = s.length();
        for (idx = 0; idx < len && !LocaleUtils.isLower(s.charAt(idx)); ++idx) {
        }
        if (idx == len) {
            return s;
        }
        char[] buf = new char[len];
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            buf[i] = i < idx ? c : LocaleUtils.toUpper(c);
        }
        return new String(buf);
    }

    static String toTitleString(String s) {
        int len = s.length();
        if (len == 0) {
            return s;
        }
        int idx = 0;
        if (!LocaleUtils.isLower(s.charAt(idx))) {
            for (idx = 1; idx < len && !LocaleUtils.isUpper(s.charAt(idx)); ++idx) {
            }
        }
        if (idx == len) {
            return s;
        }
        char[] buf = new char[len];
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            buf[i] = i == 0 && idx == 0 ? LocaleUtils.toUpper(c) : (i < idx ? c : LocaleUtils.toLower(c));
        }
        return new String(buf);
    }

    private static boolean isUpper(char c) {
        return c >= 'A' && c <= 'Z';
    }

    private static boolean isLower(char c) {
        return c >= 'a' && c <= 'z';
    }

    static boolean isAlpha(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
    }

    static boolean isAlphaString(String s) {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            if (LocaleUtils.isAlpha(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    static boolean isNumeric(char c) {
        return c >= '0' && c <= '9';
    }

    static boolean isNumericString(String s) {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            if (LocaleUtils.isNumeric(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    static boolean isAlphaNumeric(char c) {
        return LocaleUtils.isAlpha(c) || LocaleUtils.isNumeric(c);
    }

    static boolean isAlphaNumericString(String s) {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            if (LocaleUtils.isAlphaNumeric(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    static boolean isEmpty(Set<?> set) {
        return set == null || set.isEmpty();
    }

    static boolean isEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    static boolean isEmpty(List<?> list) {
        return list == null || list.isEmpty();
    }
}

