/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.filters;

import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.catalina.filters.FilterBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class HttpHeaderSecurityFilter
extends FilterBase {
    private final Log log = LogFactory.getLog(HttpHeaderSecurityFilter.class);
    private static final String HSTS_HEADER_NAME = "Strict-Transport-Security";
    private boolean hstsEnabled = true;
    private int hstsMaxAgeSeconds = 0;
    private boolean hstsIncludeSubDomains = false;
    private boolean hstsPreload = false;
    private String hstsHeaderValue;
    private static final String ANTI_CLICK_JACKING_HEADER_NAME = "X-Frame-Options";
    private boolean antiClickJackingEnabled = true;
    private XFrameOption antiClickJackingOption = XFrameOption.DENY;
    private URI antiClickJackingUri;
    private String antiClickJackingHeaderValue;
    private static final String BLOCK_CONTENT_TYPE_SNIFFING_HEADER_NAME = "X-Content-Type-Options";
    private static final String BLOCK_CONTENT_TYPE_SNIFFING_HEADER_VALUE = "nosniff";
    private boolean blockContentTypeSniffingEnabled = true;
    private static final String XSS_PROTECTION_HEADER_NAME = "X-XSS-Protection";
    private static final String XSS_PROTECTION_HEADER_VALUE = "1; mode=block";
    private boolean xssProtectionEnabled = true;

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        StringBuilder stringBuilder = new StringBuilder("max-age=");
        stringBuilder.append(this.hstsMaxAgeSeconds);
        if (this.hstsIncludeSubDomains) {
            stringBuilder.append(";includeSubDomains");
        }
        if (this.hstsPreload) {
            stringBuilder.append(";preload");
        }
        this.hstsHeaderValue = stringBuilder.toString();
        StringBuilder stringBuilder2 = new StringBuilder(this.antiClickJackingOption.headerValue);
        if (this.antiClickJackingOption == XFrameOption.ALLOW_FROM) {
            stringBuilder2.append(' ');
            stringBuilder2.append(this.antiClickJackingUri);
        }
        this.antiClickJackingHeaderValue = stringBuilder2.toString();
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (servletResponse instanceof HttpServletResponse) {
            HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
            if (servletResponse.isCommitted()) {
                throw new ServletException(sm.getString("httpHeaderSecurityFilter.committed"));
            }
            if (this.hstsEnabled && servletRequest.isSecure()) {
                httpServletResponse.setHeader(HSTS_HEADER_NAME, this.hstsHeaderValue);
            }
            if (this.antiClickJackingEnabled) {
                httpServletResponse.setHeader(ANTI_CLICK_JACKING_HEADER_NAME, this.antiClickJackingHeaderValue);
            }
            if (this.blockContentTypeSniffingEnabled) {
                httpServletResponse.setHeader(BLOCK_CONTENT_TYPE_SNIFFING_HEADER_NAME, BLOCK_CONTENT_TYPE_SNIFFING_HEADER_VALUE);
            }
            if (this.xssProtectionEnabled) {
                httpServletResponse.setHeader(XSS_PROTECTION_HEADER_NAME, XSS_PROTECTION_HEADER_VALUE);
            }
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    @Override
    protected Log getLogger() {
        return this.log;
    }

    @Override
    protected boolean isConfigProblemFatal() {
        return true;
    }

    public boolean isHstsEnabled() {
        return this.hstsEnabled;
    }

    public void setHstsEnabled(boolean bl) {
        this.hstsEnabled = bl;
    }

    public int getHstsMaxAgeSeconds() {
        return this.hstsMaxAgeSeconds;
    }

    public void setHstsMaxAgeSeconds(int n) {
        this.hstsMaxAgeSeconds = n < 0 ? 0 : n;
    }

    public boolean isHstsIncludeSubDomains() {
        return this.hstsIncludeSubDomains;
    }

    public void setHstsIncludeSubDomains(boolean bl) {
        this.hstsIncludeSubDomains = bl;
    }

    public boolean isHstsPreload() {
        return this.hstsPreload;
    }

    public void setHstsPreload(boolean bl) {
        this.hstsPreload = bl;
    }

    public boolean isAntiClickJackingEnabled() {
        return this.antiClickJackingEnabled;
    }

    public void setAntiClickJackingEnabled(boolean bl) {
        this.antiClickJackingEnabled = bl;
    }

    public String getAntiClickJackingOption() {
        return this.antiClickJackingOption.toString();
    }

    public void setAntiClickJackingOption(String string) {
        for (XFrameOption xFrameOption : XFrameOption.values()) {
            if (!xFrameOption.getHeaderValue().equalsIgnoreCase(string)) continue;
            this.antiClickJackingOption = xFrameOption;
            return;
        }
        throw new IllegalArgumentException(sm.getString("httpHeaderSecurityFilter.clickjack.invalid", new Object[]{string}));
    }

    public String getAntiClickJackingUri() {
        return this.antiClickJackingUri.toString();
    }

    public boolean isBlockContentTypeSniffingEnabled() {
        return this.blockContentTypeSniffingEnabled;
    }

    public void setBlockContentTypeSniffingEnabled(boolean bl) {
        this.blockContentTypeSniffingEnabled = bl;
    }

    public void setAntiClickJackingUri(String string) {
        URI uRI;
        try {
            uRI = new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException(uRISyntaxException);
        }
        this.antiClickJackingUri = uRI;
    }

    public boolean isXssProtectionEnabled() {
        return this.xssProtectionEnabled;
    }

    public void setXssProtectionEnabled(boolean bl) {
        this.xssProtectionEnabled = bl;
    }

    private static enum XFrameOption {
        DENY("DENY"),
        SAME_ORIGIN("SAMEORIGIN"),
        ALLOW_FROM("ALLOW-FROM");

        private final String headerValue;

        private XFrameOption(String string2) {
            this.headerValue = string2;
        }

        public String getHeaderValue() {
            return this.headerValue;
        }
    }
}

