/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp.datasources;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.sql.ConnectionPoolDataSource;
import org.apache.tomcat.dbcp.dbcp.datasources.InstanceKeyDataSource;
import org.apache.tomcat.dbcp.dbcp.datasources.InstanceKeyObjectFactory;
import org.apache.tomcat.dbcp.dbcp.datasources.KeyedCPDSConnectionFactory;
import org.apache.tomcat.dbcp.dbcp.datasources.PooledConnectionAndInfo;
import org.apache.tomcat.dbcp.dbcp.datasources.PooledConnectionManager;
import org.apache.tomcat.dbcp.dbcp.datasources.SharedPoolDataSourceFactory;
import org.apache.tomcat.dbcp.dbcp.datasources.UserPassKey;
import org.apache.tomcat.dbcp.pool.KeyedObjectPool;
import org.apache.tomcat.dbcp.pool.impl.GenericKeyedObjectPool;

public class SharedPoolDataSource
extends InstanceKeyDataSource {
    private static final long serialVersionUID = -8132305535403690372L;
    private int maxActive = 8;
    private int maxIdle = 8;
    private int maxWait = (int)Math.min(Integer.MAX_VALUE, -1L);
    private transient KeyedObjectPool<UserPassKey, PooledConnectionAndInfo> pool = null;
    private transient KeyedCPDSConnectionFactory factory = null;

    @Override
    public void close() throws Exception {
        if (this.pool != null) {
            this.pool.close();
        }
        InstanceKeyObjectFactory.removeInstance(this.instanceKey);
    }

    public int getMaxActive() {
        return this.maxActive;
    }

    public void setMaxActive(int n) {
        this.assertInitializationAllowed();
        this.maxActive = n;
    }

    public int getMaxIdle() {
        return this.maxIdle;
    }

    public void setMaxIdle(int n) {
        this.assertInitializationAllowed();
        this.maxIdle = n;
    }

    public int getMaxWait() {
        return this.maxWait;
    }

    public void setMaxWait(int n) {
        this.assertInitializationAllowed();
        this.maxWait = n;
    }

    public int getNumActive() {
        return this.pool == null ? 0 : this.pool.getNumActive();
    }

    public int getNumIdle() {
        return this.pool == null ? 0 : this.pool.getNumIdle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected PooledConnectionAndInfo getPooledConnectionAndInfo(String string, String string2) throws SQLException {
        Object object = this;
        synchronized (object) {
            if (this.pool == null) {
                try {
                    this.registerPool(string, string2);
                }
                catch (NamingException namingException) {
                    throw new SQLException("RegisterPool failed", namingException);
                }
            }
        }
        object = null;
        UserPassKey userPassKey = new UserPassKey(string, string2);
        try {
            object = this.pool.borrowObject(userPassKey);
        }
        catch (Exception exception) {
            throw new SQLException("Could not retrieve connection info from pool", exception);
        }
        return object;
    }

    @Override
    protected PooledConnectionManager getConnectionManager(UserPassKey userPassKey) {
        return this.factory;
    }

    @Override
    public Reference getReference() throws NamingException {
        Reference reference = new Reference(this.getClass().getName(), SharedPoolDataSourceFactory.class.getName(), null);
        reference.add(new StringRefAddr("instanceKey", this.instanceKey));
        return reference;
    }

    private void registerPool(String string, String string2) throws NamingException, SQLException {
        ConnectionPoolDataSource connectionPoolDataSource = this.testCPDS(string, string2);
        GenericKeyedObjectPool<UserPassKey, PooledConnectionAndInfo> genericKeyedObjectPool = new GenericKeyedObjectPool<UserPassKey, PooledConnectionAndInfo>(null);
        genericKeyedObjectPool.setMaxActive(this.getMaxActive());
        genericKeyedObjectPool.setMaxIdle(this.getMaxIdle());
        genericKeyedObjectPool.setMaxWait(this.getMaxWait());
        genericKeyedObjectPool.setWhenExhaustedAction(this.whenExhaustedAction(this.maxActive, this.maxWait));
        genericKeyedObjectPool.setTestOnBorrow(this.getTestOnBorrow());
        genericKeyedObjectPool.setTestOnReturn(this.getTestOnReturn());
        genericKeyedObjectPool.setTimeBetweenEvictionRunsMillis(this.getTimeBetweenEvictionRunsMillis());
        genericKeyedObjectPool.setNumTestsPerEvictionRun(this.getNumTestsPerEvictionRun());
        genericKeyedObjectPool.setMinEvictableIdleTimeMillis(this.getMinEvictableIdleTimeMillis());
        genericKeyedObjectPool.setTestWhileIdle(this.getTestWhileIdle());
        this.pool = genericKeyedObjectPool;
        this.factory = new KeyedCPDSConnectionFactory(connectionPoolDataSource, this.pool, this.getValidationQuery(), this.isRollbackAfterValidation());
    }

    @Override
    protected void setupDefaults(Connection connection, String string) throws SQLException {
        int n;
        boolean bl = this.isDefaultAutoCommit();
        if (connection.getAutoCommit() != bl) {
            connection.setAutoCommit(bl);
        }
        if ((n = this.getDefaultTransactionIsolation()) != -1) {
            connection.setTransactionIsolation(n);
        }
        boolean bl2 = this.isDefaultReadOnly();
        if (connection.isReadOnly() != bl2) {
            connection.setReadOnly(bl2);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        try {
            objectInputStream.defaultReadObject();
            SharedPoolDataSource sharedPoolDataSource = (SharedPoolDataSource)new SharedPoolDataSourceFactory().getObjectInstance((Object)this.getReference(), (Name)null, (Context)null, (Hashtable)null);
            this.pool = sharedPoolDataSource.pool;
        }
        catch (NamingException namingException) {
            throw new IOException("NamingException: " + namingException);
        }
    }
}

