/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Scanner;
import javax.swing.Timer;
import org.jmol.api.JmolViewer;
import org.jmol.script.ScriptContext;
import org.jmol.viewer.Viewer;

public class InputScannerThread
extends Thread {
    private JmolViewer vwr;
    private Scanner scanner;
    private boolean isSilent;
    private StringBuilder buffer = new StringBuilder();
    private Timer t;

    InputScannerThread(JmolViewer vwr, boolean isSilent) {
        this.vwr = vwr;
        this.isSilent = isSilent;
        this.start();
    }

    @Override
    public synchronized void start() {
        this.scanner = new Scanner(System.in);
        this.scanner.useDelimiter(System.lineSeparator());
        super.start();
    }

    @Override
    public void run() {
        try {
            Thread.currentThread().setPriority(1);
            this.say(null);
            while (this.mainLoop()) {
            }
        }
        catch (InterruptedException e) {
            System.exit(1);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    boolean mainLoop() throws InterruptedException {
        if (Viewer.isSwingJS) {
            if (this.t == null) {
                this.t = new Timer(100, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        InputScannerThread.this.scan();
                    }
                });
                this.t.setRepeats(false);
                this.t.start();
            } else {
                this.t.restart();
            }
            return false;
        }
        Thread.sleep(100L);
        this.scan();
        return true;
    }

    void scan() {
        while (this.scanner.hasNext()) {
            String s = this.scanner.next();
            if (s.toLowerCase().equals("exitjmol")) {
                System.exit(0);
            }
            if (this.vwr.checkHalt(s, false)) {
                this.buffer = new StringBuilder();
                s = "";
            }
            this.buffer.append(s).append('\n');
            if (this.checkCommand() || this.buffer.length() != 1) continue;
            this.say(null);
        }
    }

    private void say(String msg) {
        if (this.isSilent) {
            return;
        }
        if (msg == null) {
            msg = "Enter: \nquit     to stop processing and re-initialize input\nexit     to stop all script processing\nexitJmol to exit Jmol\nJmol> ";
        }
        System.out.print(msg);
        System.out.flush();
    }

    private boolean checkCommand() {
        String s = this.buffer.toString();
        if (s.length() == 1) {
            return false;
        }
        Object ret = this.vwr.scriptCheck(s);
        if (ret instanceof String) {
            s = (String)ret;
            if (s.indexOf("missing END") >= 0) {
                return true;
            }
            this.say(s);
            return false;
        }
        if (ret instanceof ScriptContext) {
            ScriptContext c = (ScriptContext)ret;
            if (!c.isComplete) {
                return true;
            }
        }
        this.buffer = new StringBuilder();
        s = s + "\u0001##noendcheck";
        if (this.isSilent) {
            this.vwr.evalStringQuiet(s);
        } else {
            this.vwr.evalString(s);
        }
        return true;
    }
}

