/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.cif;

import java.util.Hashtable;
import java.util.Map;
import javajs.api.GenericCifDataParser;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.M4;
import javajs.util.P3;
import javajs.util.T3;
import org.jmol.adapter.readers.cif.Cif2DataParser;
import org.jmol.adapter.readers.cif.CifReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.Bond;
import org.jmol.api.JmolAdapter;
import org.jmol.api.SymmetryInterface;
import org.jmol.symmetry.SymmetryOperation;
import org.jmol.util.BSUtil;
import org.jmol.util.JmolMolecule;

public class TopoCifParser
implements CifReader.Parser {
    static final int TOPOL_LINK = 0x1000000;
    static final int TOPOL_GROUP = 0x2000000;
    static final int TOPOL_NODE = 0x4000000;
    public static final int LINK_TYPE_GENERIC_LINK = 0;
    public static final int LINK_TYPE_SINGLE = 1;
    public static final int LINK_TYPE_DOUBLE = 2;
    public static final int LINK_TYPE_TRIPLE = 3;
    public static final int LINK_TYPE_QUADRUPLE = 4;
    public static final int LINK_TYPE_QUINTUPLE = 5;
    public static final int LINK_TYPE_SEXTUPLE = 6;
    public static final int LINK_TYPE_SEPTUPLE = 7;
    public static final int LINK_TYPE_OCTUPLE = 8;
    public static final int LINK_TYPE_AROM = 9;
    public static final int LINK_TYPE_POLY = 10;
    public static final int LINK_TYPE_DELO = 11;
    public static final int LINK_TYPE_PI = 12;
    public static final int LINK_TYPE_HBOND = 13;
    public static final int LINK_TYPE_VDW = 14;
    public static final int LINK_TYPE_OTHER = 15;
    public static String linkTypes = "?  SINDOUTRIQUAQUISEXSEPOCTAROPOLDELPI HBOVDW";
    public static final int LINK_TYPE_BITS = 4;
    static double ERROR_TOLERANCE = 0.001;
    CifReader reader;
    Lst<TAtom> atoms = new Lst();
    Lst<TNode> nodes = new Lst();
    Lst<TLink> links = new Lst();
    Lst<TNet> nets = new Lst();
    TNet singleNet;
    int netCount;
    int linkCount;
    int atomCount;
    T3 temp1 = new P3();
    T3 temp2 = new P3();
    private int ac0 = -1;
    private int bc0;
    private GenericCifDataParser cifParser;
    String failed;
    M4[] ops;
    int i0;
    int b0;
    private String allowedTypes;
    String netNotes = "";
    private SymmetryInterface sym;
    String selectedNet;
    private static final String[] topolFields = new String[]{"_topol_net_id", "_topol_net_label", "_topol_net_special_details", "_topol_link_id", "_topol_link_net_id", "_topol_link_node_id_1", "_topol_link_node_id_2", "_topol_link_symop_id_1", "_topol_link_translation_1", "_topol_link_translation_1_x", "_topol_link_translation_1_y", "_topol_link_translation_1_z", "_topol_link_symop_id_2", "_topol_link_translation_2", "_topol_link_translation_2_x", "_topol_link_translation_2_y", "_topol_link_translation_2_z", "_topol_link_distance", "_topol_link_type", "_topol_link_multiplicity", "_topol_link_voronoi_solidangle", "_topol_link_order", "_topol_node_id", "_topol_node_net_id", "_topol_node_label", "_topol_node_symop_id", "_topol_node_translation", "_topol_node_translation_x", "_topol_node_translation_y", "_topol_node_translation_z", "_topol_node_fract_x", "_topol_node_fract_y", "_topol_node_fract_z", "_topol_atom_id", "_topol_atom_atom_label", "_topol_atom_node_id", "_topol_atom_link_id", "_topol_atom_symop_id", "_topol_atom_translation", "_topol_atom_translation_x", "_topol_atom_translation_y", "_topol_atom_translation_z", "_topol_atom_fract_x", "_topol_atom_fract_y", "_topol_atom_fract_z", "_topol_atom_element_symbol", "_topol_link_site_symmetry_symop_1", "_topol_link_site_symmetry_translation_1_x", "_topol_link_site_symmetry_translation_1_y", "_topol_link_site_symmetry_translation_1_z", "_topol_link_site_symmetry_symop_2", "_topol_link_site_symmetry_translation_2_x", "_topol_link_site_symmetry_translation_2_y", "_topol_link_site_symmetry_translation_2_z", "_topol_link_site_symmetry_translation_1", "_topol_link_site_symmetry_translation_2", "_topol_link_node_label_1", "_topol_link_node_label_2", "_topol_link_atom_label_1", "_topol_link_atom_label_2"};
    private static final byte topol_net_id = 0;
    private static final byte topol_net_label = 1;
    private static final byte topol_net_special_details = 2;
    private static final byte topol_link_id = 3;
    private static final byte topol_link_net_id = 4;
    private static final byte topol_link_node_id_1 = 5;
    private static final byte topol_link_node_id_2 = 6;
    private static final byte topol_link_symop_id_1 = 7;
    private static final byte topol_link_translation_1 = 8;
    private static final byte topol_link_translation_1_x = 9;
    private static final byte topol_link_translation_1_y = 10;
    private static final byte topol_link_translation_1_z = 11;
    private static final byte topol_link_symop_id_2 = 12;
    private static final byte topol_link_translation_2 = 13;
    private static final byte topol_link_translation_2_x = 14;
    private static final byte topol_link_translation_2_y = 15;
    private static final byte topol_link_translation_2_z = 16;
    private static final byte topol_link_distance = 17;
    private static final byte topol_link_type = 18;
    private static final byte topol_link_multiplicity = 19;
    private static final byte topol_link_voronoi_solidangle = 20;
    private static final byte topol_link_order = 21;
    private static final byte topol_node_id = 22;
    private static final byte topol_node_net_id = 23;
    private static final byte topol_node_label = 24;
    private static final byte topol_node_symop_id = 25;
    private static final byte topol_node_translation = 26;
    private static final byte topol_node_translation_x = 27;
    private static final byte topol_node_translation_y = 28;
    private static final byte topol_node_translation_z = 29;
    private static final byte topol_node_fract_x = 30;
    private static final byte topol_node_fract_y = 31;
    private static final byte topol_node_fract_z = 32;
    private static final byte topol_atom_id = 33;
    private static final byte topol_atom_atom_label = 34;
    private static final byte topol_atom_node_id = 35;
    private static final byte topol_atom_link_id = 36;
    private static final byte topol_atom_symop_id = 37;
    private static final byte topol_atom_translation = 38;
    private static final byte topol_atom_translation_x = 39;
    private static final byte topol_atom_translation_y = 40;
    private static final byte topol_atom_translation_z = 41;
    private static final byte topol_atom_fract_x = 42;
    private static final byte topol_atom_fract_y = 43;
    private static final byte topol_atom_fract_z = 44;
    private static final byte topol_atom_element_symbol = 45;
    private static final byte topol_link_site_symmetry_symop_1_DEPRECATED = 46;
    private static final byte topol_link_site_symmetry_translation_1_x_DEPRECATED = 47;
    private static final byte topol_link_site_symmetry_translation_1_y_DEPRECATED = 48;
    private static final byte topol_link_site_symmetry_translation_1_z_DEPRECATED = 49;
    private static final byte topol_link_site_symmetry_symop_2_DEPRECATED = 50;
    private static final byte topol_link_site_symmetry_translation_2_x_DEPRECATED = 51;
    private static final byte topol_link_site_symmetry_translation_2_y_DEPRECATED = 52;
    private static final byte topol_link_site_symmetry_translation_2_z_DEPRECATED = 53;
    private static final byte topol_link_site_symmetry_translation_1_DEPRECATED = 54;
    private static final byte topol_link_site_symmetry_translation_2_DEPRECATED = 55;
    private static final byte topol_link_node_label_1_DEPRECATED = 56;
    private static final byte topol_link_node_label_2_DEPRECATED = 57;
    private static final P3 ZERO = new P3();

    static int getBondType(String type, int order) {
        if (type == null) {
            return 0;
        }
        if ((type = type.toUpperCase()).equals("V")) {
            return order == 0 ? 1 : order;
        }
        if (type.equals("sb")) {
            type = "?";
        }
        switch (type.charAt(0)) {
            case 'V': {
                return 14;
            }
        }
        if (type.length() > 3) {
            type = type.substring(0, 3);
        }
        return Math.max(1, linkTypes.indexOf(type) / 3);
    }

    @Override
    public TopoCifParser setReader(CifReader reader) {
        String net;
        if (!reader.checkFilterKey("TOPOL")) {
            reader.appendLoadNote("This file has Topology analysis records.\nUse LOAD \"\" {1 1 1} FILTER \"TOPOL\"  to load the topology.");
            return this;
        }
        this.reader = reader;
        this.selectedNet = net = reader.getFilter("TOPOLNET=");
        String types = reader.getFilter("TOPOS_TYPES=");
        if (types == null) {
            types = reader.getFilter("TOPOS_TYPE=");
        }
        if (types != null && types.length() > 0) {
            this.allowedTypes = types = "+" + types.toLowerCase() + "+";
        }
        this.i0 = reader.baseAtomIndex;
        this.b0 = reader.baseBondIndex;
        return this;
    }

    @Override
    public void ProcessRecord(String key, String data) throws Exception {
        if (this.reader == null || this.failed != null) {
            return;
        }
        int pt = key.indexOf(".");
        if (pt < 0) {
            pt = key.indexOf(95, key.indexOf(95, 1) + 1);
            if (pt < 0) {
                return;
            }
            key = key.substring(0, pt) + '.' + key.substring(pt + 1);
        }
        this.processBlock(key);
    }

    @Override
    public boolean processBlock(String key) throws Exception {
        if (this.reader == null || this.failed != null) {
            return false;
        }
        if (this.ac0 < 0) {
            this.ac0 = this.reader.asc.ac;
            this.bc0 = this.reader.asc.bondCount;
        }
        if (this.reader.ucItems != null) {
            this.reader.allow_a_len_1 = true;
            for (int i = 0; i < 6; ++i) {
                this.reader.setUnitCellItem(i, this.reader.ucItems[i]);
            }
        }
        this.reader.parseLoopParameters(topolFields);
        this.cifParser = this.reader.cifParser;
        if (key.startsWith("_topol_net")) {
            this.processNets();
        } else if (key.startsWith("_topol_link")) {
            this.processLinks();
        } else if (key.startsWith("_topol_node")) {
            this.processNodes();
        } else if (key.startsWith("_topol_atom")) {
            this.processAtoms();
        } else {
            return false;
        }
        return true;
    }

    private void processNets() throws Exception {
        while (this.cifParser.getData()) {
            String id = this.getDataValue((byte)0);
            String netLabel = this.getDataValue((byte)1);
            if (id == null) {
                id = "" + (this.netCount + 1);
            }
            TNet net = this.getNetFor(id, netLabel, true);
            net.specialDetails = this.getDataValue((byte)2);
            net.line = this.reader.line;
        }
    }

    private void processLinks() throws Exception {
        while (this.cifParser.getData()) {
            String type;
            String t = this.getDataValue((byte)18);
            String string = type = t == null ? null : t.toLowerCase();
            if (this.allowedTypes != null && (type == null || this.allowedTypes.indexOf("+" + type + "+") < 0)) continue;
            TLink link = new TLink();
            link.type = type;
            int[] t1 = new int[3];
            int[] t2 = new int[3];
            int n = this.cifParser.getColumnCount();
            block17: for (int i = 0; i < n; ++i) {
                int p = this.reader.fieldProperty(i);
                String field = this.reader.field;
                switch (p) {
                    case 3: {
                        link.id = field;
                        continue block17;
                    }
                    case 4: {
                        link.netID = field;
                        continue block17;
                    }
                    case 5: {
                        link.nodeIds[0] = field;
                        continue block17;
                    }
                    case 6: {
                        link.nodeIds[1] = field;
                        continue block17;
                    }
                    case 56: {
                        link.nodeLabels[0] = field;
                        continue block17;
                    }
                    case 57: {
                        link.nodeLabels[1] = field;
                        continue block17;
                    }
                    case 7: 
                    case 46: {
                        link.symops[0] = this.getInt(field) - 1;
                        continue block17;
                    }
                    case 12: 
                    case 50: {
                        link.symops[1] = this.getInt(field) - 1;
                        continue block17;
                    }
                    case 21: {
                        link.topoOrder = this.getInt(field);
                        continue block17;
                    }
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 47: 
                    case 48: 
                    case 49: 
                    case 54: {
                        t1 = this.processTranslation(p, t1, field);
                        continue block17;
                    }
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 55: {
                        t2 = this.processTranslation(p, t2, field);
                        continue block17;
                    }
                    case 17: {
                        link.cartesianDistance = this.getFloat(field);
                        continue block17;
                    }
                    case 19: {
                        link.multiplicity = this.getInt(field);
                        continue block17;
                    }
                    case 20: {
                        link.voronoiAngle = this.getFloat(field);
                    }
                }
            }
            if (!link.setLink(t1, t2, this.reader.line)) {
                this.failed = "invalid link! " + link;
                return;
            }
            this.links.addLast(link);
        }
    }

    private void processNodes() throws Exception {
        while (this.cifParser.getData()) {
            TNode node = new TNode();
            int[] t = new int[3];
            int n = this.cifParser.getColumnCount();
            block11: for (int i = 0; i < n; ++i) {
                int p = this.reader.fieldProperty(i);
                String field = this.reader.field;
                switch (p) {
                    case 22: {
                        node.id = field;
                        continue block11;
                    }
                    case 24: {
                        node.label = field;
                        continue block11;
                    }
                    case 23: {
                        node.netID = field;
                        continue block11;
                    }
                    case 25: {
                        node.symop = this.getInt(field) - 1;
                        continue block11;
                    }
                    case 26: 
                    case 27: 
                    case 28: 
                    case 29: {
                        t = this.processTranslation(p, t, field);
                        continue block11;
                    }
                    case 30: {
                        node.x = this.getFloat(field);
                        continue block11;
                    }
                    case 31: {
                        node.y = this.getFloat(field);
                        continue block11;
                    }
                    case 32: {
                        node.z = this.getFloat(field);
                    }
                }
            }
            if (!node.setNode(t, this.reader.line)) continue;
            this.nodes.addLast(node);
        }
    }

    private void processAtoms() throws Exception {
        while (this.cifParser.getData()) {
            TAtom atom = new TAtom();
            int[] t = new int[3];
            int n = this.cifParser.getColumnCount();
            block13: for (int i = 0; i < n; ++i) {
                int p = this.reader.fieldProperty(i);
                String field = this.reader.field;
                switch (p) {
                    case 33: {
                        atom.id = field;
                        continue block13;
                    }
                    case 34: {
                        atom.atomLabel = field;
                        continue block13;
                    }
                    case 35: {
                        atom.nodeID = field;
                        continue block13;
                    }
                    case 36: {
                        atom.linkID = field;
                        continue block13;
                    }
                    case 37: {
                        atom.symop = this.getInt(field) - 1;
                        continue block13;
                    }
                    case 38: 
                    case 39: 
                    case 40: 
                    case 41: {
                        t = this.processTranslation(p, t, field);
                        continue block13;
                    }
                    case 42: {
                        atom.x = this.getFloat(field);
                        continue block13;
                    }
                    case 43: {
                        atom.y = this.getFloat(field);
                        continue block13;
                    }
                    case 44: {
                        atom.z = this.getFloat(field);
                        continue block13;
                    }
                    case 45: {
                        atom.elementSymbol = field;
                    }
                }
            }
            if (!atom.setAtom(t, this.reader.line)) continue;
            this.atoms.addLast(atom);
        }
    }

    private int[] processTranslation(int p, int[] t, String field) {
        switch (p) {
            case 8: 
            case 13: 
            case 26: 
            case 38: 
            case 54: 
            case 55: {
                t = Cif2DataParser.getIntArrayFromStringList(field, 3);
                break;
            }
            case 9: 
            case 14: 
            case 27: 
            case 39: 
            case 47: 
            case 51: {
                t[0] = this.getInt(field);
                break;
            }
            case 10: 
            case 15: 
            case 28: 
            case 40: 
            case 48: 
            case 52: {
                t[1] = this.getInt(field);
                break;
            }
            case 11: 
            case 16: 
            case 29: 
            case 41: 
            case 49: 
            case 53: {
                t[2] = this.getInt(field);
            }
        }
        return t;
    }

    @Override
    public boolean finalizeReader() throws Exception {
        int i;
        if (this.reader == null || this.reader.symops == null) {
            return false;
        }
        this.cifParser = null;
        this.reader.applySymmetryToBonds = true;
        Lst<String> symops = this.reader.symops;
        int nOps = symops.size();
        this.ops = new M4[nOps];
        for (i = 0; i < nOps; ++i) {
            this.ops[i] = SymmetryOperation.getMatrixFromXYZ("!" + (String)symops.get(i));
        }
        for (i = 0; i < this.atoms.size(); ++i) {
            ((TAtom)this.atoms.get(i)).finalizeAtom();
        }
        this.sym = this.reader.getSymmetry();
        for (i = 0; i < this.links.size(); ++i) {
            ((TLink)this.links.get(i)).finalizeLink();
        }
        i = this.links.size();
        while (--i >= 0) {
            if (((TLink)this.links.get((int)i)).finalized) continue;
            this.links.remove(i);
        }
        if (this.reader.doApplySymmetry) {
            this.reader.applySymmetryAndSetTrajectory();
        }
        if (this.selectedNet != null) {
            this.selectNet();
        }
        return true;
    }

    private void selectNet() {
        TNet net = this.getNetFor(null, this.selectedNet, false);
        if (net == null) {
            net = this.getNetFor(this.selectedNet, null, false);
        }
        if (net == null) {
            return;
        }
        BS bsAtoms = this.reader.asc.bsAtoms;
        if (bsAtoms == null) {
            bsAtoms = this.reader.asc.bsAtoms = BSUtil.newBitSet2(0, this.reader.asc.ac);
        }
        Atom[] atoms = this.reader.asc.atoms;
        int i = this.reader.asc.ac;
        while (--i >= 0) {
            Atom a = atoms[i];
            if (a instanceof TPoint && ((TPoint)((Object)a)).getNet() == net) continue;
            bsAtoms.clear(i);
        }
    }

    @Override
    public void finalizeSymmetry(boolean haveSymmetry) throws Exception {
        if (this.reader == null || !haveSymmetry || this.links.size() == 0) {
            return;
        }
        BS bsConnected = new BS();
        BS bsAtoms = new BS();
        int nLinks = this.processAssociations(bsConnected, bsAtoms);
        BS bsExclude = TopoCifParser.shiftBits(bsAtoms, bsConnected);
        if (bsConnected.cardinality() > 0) {
            this.reader.asc.bsAtoms = bsAtoms;
            this.reader.asc.atomSetInfo.put("bsExcludeBonding", bsExclude);
        }
        this.reader.appendLoadNote("TopoCifParser created " + bsConnected.cardinality() + " nodes and " + nLinks + " links");
        Lst<Map<String, Object>> info = new Lst<Map<String, Object>>();
        int n = this.links.size();
        for (int i = 0; i < n; ++i) {
            info.addLast(((TLink)this.links.get(i)).getLinkInfo());
        }
        this.reader.asc.setCurrentModelInfo("topology", info);
        String script = "if (autobond) {delete !connected && !(atomName LIKE '*_Link*' or atomName LIKE '*_Node*')}; display displayed or " + ((TNet)this.nets.get((int)0)).label + "__*";
        this.reader.addJmolScript(script);
        for (int i = 0; i < this.nets.size(); ++i) {
            ((TNet)this.nets.get(i)).finalizeNet();
        }
    }

    static BS shiftBits(BS bsAtoms, BS bs) {
        BS bsNew = new BS();
        int pt = 0;
        int i = bsAtoms.nextSetBit(0);
        while (i >= 0) {
            while (bsAtoms.get(i)) {
                bsNew.setBitTo(pt++, bs.get(i++));
            }
            i = bsAtoms.nextSetBit(i + 1);
        }
        return bsNew;
    }

    private int processAssociations(BS bsConnected, BS bsAtoms) {
        int nlinks = 0;
        BS bsAtoms0 = this.reader.asc.bsAtoms;
        Atom[] atoms = this.reader.asc.atoms;
        int i = this.reader.asc.ac;
        while (--i >= this.ac0) {
            int idx;
            Atom a = atoms[i];
            if (bsAtoms0 != null && !bsAtoms0.get(i) || (idx = a.sequenceNumber) == Integer.MIN_VALUE || idx == 0) continue;
            if (idx > 0) {
                TNode node = this.getAssociatedNodeByIdx(idx - 1);
                if (node.bsAtoms == null) {
                    node.bsAtoms = new BS();
                }
                node.bsAtoms.set(this.i0 + a.index);
            } else {
                TLink link = this.getAssoiatedLinkByIdx(-idx - 1);
                if (link != null) {
                    if (link.bsAtoms == null) {
                        link.bsAtoms = new BS();
                    }
                    link.bsAtoms.set(this.i0 + a.index);
                }
            }
            bsAtoms.set(a.index);
        }
        boolean checkDistance = this.reader.doPackUnitCell;
        Bond[] bonds = this.reader.asc.bonds;
        int i2 = this.reader.asc.bondCount;
        while (--i2 >= this.bc0) {
            Bond b = bonds[i2];
            if (b.order >= 0x2000000) {
                bonds[i2] = null;
                continue;
            }
            if (b.order < 0x1000000) continue;
            if (!(bsAtoms0 == null || bsAtoms0.get(b.atomIndex1) && bsAtoms0.get(b.atomIndex2))) {
                bonds[i2] = null;
                continue;
            }
            b.order -= 0x1000000;
            TLink link = this.getAssoiatedLinkByIdx(b.order >> 4);
            if (checkDistance) {
                float f;
                float distance = this.calculateDistance(atoms[b.atomIndex1], atoms[b.atomIndex2]);
                if ((double)Math.abs(f - link.distance) >= ERROR_TOLERANCE) {
                    System.err.println("Distance error! removed! distance=" + distance + " for " + link + link.linkNodes[0] + link.linkNodes[1]);
                    bonds[i2] = null;
                    continue;
                }
            }
            if (link.bsBonds == null) {
                link.bsBonds = new BS();
            }
            link.bsBonds.set(this.b0 + i2);
            switch (b.order & 0xF) {
                default: {
                    b.order = 1;
                    break;
                }
                case 2: {
                    b.order = 2;
                    break;
                }
                case 3: {
                    b.order = 3;
                    break;
                }
                case 4: {
                    b.order = 4;
                    break;
                }
                case 5: {
                    b.order = 5;
                    break;
                }
                case 6: {
                    b.order = 6;
                    break;
                }
                case 10: {
                    b.order = 1;
                    break;
                }
                case 11: 
                case 12: {
                    b.order = 515;
                    break;
                }
                case 13: {
                    b.order = 2048;
                    break;
                }
                case 14: {
                    b.order = 33;
                }
            }
            bsConnected.set(b.atomIndex1);
            bsConnected.set(b.atomIndex2);
            ++nlinks;
        }
        bsAtoms.or(bsConnected);
        if (bsAtoms0 != null) {
            bsAtoms.and(bsAtoms0);
        }
        i2 = this.nodes.size();
        while (--i2 >= 0) {
            TNode node = (TNode)this.nodes.get(i2);
            if (node.bsAtoms == null) continue;
            node.bsAtoms = TopoCifParser.shiftBits(bsAtoms, node.bsAtoms);
        }
        i2 = this.links.size();
        while (--i2 >= 0) {
            TLink link = (TLink)this.links.get(i2);
            if (link.bsAtoms == null) continue;
            link.bsAtoms = TopoCifParser.shiftBits(bsAtoms, link.bsAtoms);
        }
        return nlinks;
    }

    static boolean isEqualD(T3 p1, T3 p2, double d) {
        return Double.isNaN(d) || Math.abs((double)p1.distance(p2) - d) < ERROR_TOLERANCE;
    }

    private String getDataValue(byte key) {
        String f = this.reader.getField(key);
        return "\u0000".equals(f) ? null : f;
    }

    private int getInt(String f) {
        return f == null ? Integer.MIN_VALUE : this.reader.parseIntStr(f);
    }

    private float getFloat(String f) {
        return f == null ? Float.NaN : this.reader.parseFloatStr(f);
    }

    static String getMF(Lst<TAtom> tatoms) {
        int n = tatoms.size();
        if (n < 2) {
            return n == 0 ? "" : ((TAtom)tatoms.get((int)0)).elementSymbol;
        }
        int[] atNos = new int[n];
        for (int i = 0; i < n; ++i) {
            atNos[i] = JmolAdapter.getElementNumber(((TAtom)tatoms.get(i)).getElementSymbol());
        }
        JmolMolecule m = new JmolMolecule();
        m.atNos = atNos;
        return m.getMolecularFormula(false, null, false);
    }

    static void setTAtom(Atom a, Atom b) {
        b.setT(a);
        b.formalCharge = a.formalCharge;
        b.bondRadius = a.bondRadius;
    }

    static void setElementSymbol(Atom a, String sym) {
        String name = a.atomName;
        a.atomName = sym == null ? (a.atomName == null ? "X" : a.atomName.substring(a.atomName.indexOf(95) + 1)) : sym;
        a.getElementSymbol();
        a.atomName = name;
    }

    static void applySymmetry(Atom a, M4[] ops, int op, T3 t) {
        if (op >= 0 && (op >= 1 || t.x != 0.0f || t.y != 0.0f || t.z != 0.0f)) {
            if (op >= 1) {
                ops[op].rotTrans(a);
            }
            a.add(t);
        }
    }

    public TNet getNetByID(String id) {
        int i = this.nets.size();
        while (--i >= 0) {
            TNet n = (TNet)this.nets.get(i);
            if (!n.id.equalsIgnoreCase(id)) continue;
            return n;
        }
        TNet n = new TNet(this.netCount++, id, "Net" + id, null);
        this.nets.addLast(n);
        return n;
    }

    public Atom getAtomFromName(String atomLabel) {
        return atomLabel == null ? null : this.reader.asc.getAtomFromName(atomLabel);
    }

    float calculateDistance(P3 p1, P3 p2) {
        this.temp1.setT(p1);
        this.temp2.setT(p2);
        this.sym.toCartesian(this.temp1, true);
        this.sym.toCartesian(this.temp2, true);
        return this.temp1.distance(this.temp2);
    }

    public TNet getNetFor(String id, String label, boolean forceNew) {
        TNet net;
        block6: {
            block5: {
                net = null;
                if (id == null) break block5;
                net = this.getNetByID(id);
                if (net == null || label == null || !forceNew) break block6;
                net.label = label;
                break block6;
            }
            if (label != null) {
                int i = this.nets.size();
                while (--i >= 0) {
                    TNet n = (TNet)this.nets.get(i);
                    if (!n.label.equalsIgnoreCase(label)) continue;
                    net = n;
                    break;
                }
            }
        }
        if (net == null) {
            if (!forceNew) {
                return null;
            }
            net = this.getNetByID(id == null ? "1" : id);
        }
        if (net != null && label != null && forceNew) {
            net.label = label;
        }
        return net;
    }

    TNode getAssociatedNodeByIdx(int idx) {
        int i = this.nodes.size();
        while (--i >= 0) {
            TNode n = (TNode)this.nodes.get(i);
            if (n.idx != idx) continue;
            return n;
        }
        return null;
    }

    TLink getAssoiatedLinkByIdx(int idx) {
        int i = this.links.size();
        while (--i >= 0) {
            TLink l = (TLink)this.links.get(i);
            if (l.idx != idx) continue;
            return l;
        }
        return null;
    }

    public TNode findNode(String nodeID, int op, P3 trans) {
        int i = this.nodes.size();
        while (--i >= 0) {
            TNode n = (TNode)this.nodes.get(i);
            if (!n.id.equals(nodeID) || (op >= 0 || n.linkSymop != 0 || !n.linkTrans.equals(ZERO)) && (n.linkSymop != op || !n.linkTrans.equals(trans))) continue;
            return n;
        }
        return null;
    }

    private class TLink
    extends Bond {
        String id;
        String[] nodeIds = new String[2];
        String[] nodeLabels = new String[2];
        int[] symops = new int[2];
        P3[] translations = new P3[2];
        String netID;
        String netLabel;
        String type = "";
        int multiplicity;
        int topoOrder;
        float voronoiAngle;
        float cartesianDistance;
        int idx;
        TNet net;
        TNode[] linkNodes = new TNode[2];
        int typeBondOrder;
        Lst<TAtom> tatoms;
        BS bsAtoms;
        BS bsBonds;
        private String line;
        boolean finalized;
        private String mf;

        public TLink() {
            boolean i = false;
        }

        boolean setLink(int[] t1, int[] t2, String line) {
            this.line = line;
            this.idx = TopoCifParser.this.linkCount++;
            if (this.nodeIds[1] == null) {
                this.nodeIds[1] = this.nodeIds[0];
            }
            this.typeBondOrder = TopoCifParser.getBondType(this.type, this.topoOrder);
            this.translations[0] = P3.new3(t1[0], t1[1], t1[2]);
            this.translations[1] = P3.new3(t2[0], t2[1], t2[2]);
            System.out.println("TopoCifParser.setLink " + this);
            return true;
        }

        TAtom addAtom(TAtom atom) {
            if (this.tatoms == null) {
                this.tatoms = new Lst();
            }
            if (atom.nodeID != null) {
                atom = atom.getTClone();
                atom.nodeID = null;
            }
            atom.atomName = "Link_" + atom.linkID + "_" + atom.atomLabel;
            this.tatoms.addLast(atom);
            return atom;
        }

        void finalizeLink() throws Exception {
            String string = this.netID = this.nodeIds[0] == null ? null : TopoCifParser.this.findNode((String)this.nodeIds[0], (int)-1, null).netID;
            this.net = this.netID == null && this.netLabel == null ? (TopoCifParser.this.nets.size() > 0 ? (TNet)TopoCifParser.this.nets.get(0) : TopoCifParser.this.getNetFor(null, null, true)) : TopoCifParser.this.getNetFor(this.netID, this.netLabel, true);
            this.netLabel = this.net.label;
            ++this.net.nLinks;
            if (TopoCifParser.this.selectedNet != null && !TopoCifParser.this.selectedNet.equalsIgnoreCase(this.net.label) && !TopoCifParser.this.selectedNet.equalsIgnoreCase(this.net.id)) {
                return;
            }
            this.finalizeLinkNode(0);
            this.finalizeLinkNode(1);
            if (this.tatoms != null) {
                int n = this.tatoms.size();
                this.net.hasAtoms = true;
                int i = n;
                while (--i >= 0) {
                    TAtom a = (TAtom)this.tatoms.get(i);
                    a.sequenceNumber = -this.idx - 1;
                    a.atomName = this.netLabel + "_" + a.atomName;
                    a.net = this.net;
                }
                if (n >= 0) {
                    this.mf = TopoCifParser.getMF(this.tatoms);
                    TopoCifParser.this.reader.appendLoadNote("_topos_link " + this.id + " for net " + this.netLabel + " has formula " + this.mf);
                }
            }
            this.order = 0x1000000 + (this.idx << 4) + this.typeBondOrder;
            this.distance = TopoCifParser.this.calculateDistance(this.linkNodes[0], this.linkNodes[1]);
            if (this.cartesianDistance != 0.0f && (double)Math.abs(this.distance - this.cartesianDistance) >= ERROR_TOLERANCE) {
                System.err.println("Distance error! distance=" + this.distance + " for " + this.line);
            }
            System.out.println("link d=" + this.distance + " " + this + this.linkNodes[0] + this.linkNodes[1]);
            TopoCifParser.this.reader.asc.addBond(this);
            this.finalized = true;
        }

        public String getMolecularFormula() {
            return this.mf == null ? (this.mf = TopoCifParser.getMF(this.tatoms)) : this.mf;
        }

        private void finalizeLinkNode(int index) throws Exception {
            Atom atom;
            TNode node;
            String id = this.nodeIds[index];
            String atomLabel = this.nodeLabels[index];
            int op = this.symops[index];
            P3 trans = this.translations[index];
            TNode node0 = node = this.getNodeWithSym(id, atomLabel, op, trans);
            if (node == null && id != null) {
                node = this.getNodeWithSym(id, null, -1, null);
            }
            Atom atom2 = atom = node == null && atomLabel != null ? TopoCifParser.this.getAtomFromName(atomLabel) : null;
            if (atom != null) {
                node = new TNode(TopoCifParser.this.atomCount++, atom, this.net, op, trans);
            } else if (node != null) {
                if (node0 == null) {
                    node = node.copy();
                }
                node.linkSymop = op;
                node.linkTrans = trans;
                this.nodeLabels[index] = node.atomName;
            } else {
                throw new Exception("_topol_link: no atom or node " + atomLabel + " line=" + this.line);
            }
            TopoCifParser.this.nodes.addLast(node);
            this.linkNodes[index] = node;
            if (index == 1 && node == this.linkNodes[0]) {
                this.linkNodes[1] = node.copy();
            }
            node.finalizeNode(TopoCifParser.this.ops);
            if (node0 == null) {
                TopoCifParser.applySymmetry(node, TopoCifParser.this.ops, op, trans);
            }
            if (index == 0) {
                this.atomIndex1 = node.index;
            } else {
                this.atomIndex2 = node.index;
            }
        }

        private TNode getNodeWithSym(String nodeID, String nodeLabel, int op, P3 trans) {
            if (nodeID != null) {
                return TopoCifParser.this.findNode(nodeID, op, trans);
            }
            int i = TopoCifParser.this.nodes.size();
            while (--i >= 0) {
                TNode n = (TNode)TopoCifParser.this.nodes.get(i);
                if (!n.label.equals(nodeLabel) || (op != -1 || n.linkSymop != 0 || !n.linkTrans.equals(ZERO)) && (op != n.linkSymop || !trans.equals(n.linkTrans))) continue;
                return n;
            }
            return null;
        }

        Map<String, Object> getLinkInfo() {
            Hashtable<String, Object> info = new Hashtable<String, Object>();
            info.put("index", this.idx + 1);
            if (this.id != null) {
                info.put("id", this.id);
            }
            info.put("netID", this.net.id);
            info.put("netLabel", this.net.label);
            if (this.nodeLabels[0] != null) {
                info.put("nodeLabel1", this.nodeLabels[0]);
            }
            if (this.nodeLabels[1] != null) {
                info.put("nodeLabel2", this.nodeLabels[1]);
            }
            if (this.nodeIds[0] != null) {
                info.put("nodeId1", this.nodeIds[0]);
            }
            if (this.nodeIds[1] != null) {
                info.put("nodeId2", this.nodeIds[1]);
            }
            info.put("distance", Float.valueOf(this.cartesianDistance));
            if (!Float.isNaN(this.distance)) {
                info.put("distance", Float.valueOf(this.distance));
            }
            info.put("symops1", this.symops[0] + 1);
            info.put("symops2", this.symops[1] + 1);
            info.put("translation1", this.translations[0]);
            info.put("translation2", this.translations[1]);
            info.put("multiplicity", this.multiplicity);
            if (this.type != null) {
                info.put("type", this.type);
            }
            info.put("voronoiSolidAngle", Float.valueOf(this.voronoiAngle));
            info.put("atomIndex1", TopoCifParser.this.i0 + this.linkNodes[0].index);
            info.put("atomIndex2", TopoCifParser.this.i0 + this.linkNodes[1].index);
            if (this.bsAtoms != null && this.bsAtoms.cardinality() > 0) {
                info.put("representedAtoms", this.bsAtoms);
            }
            info.put("topoOrder", this.topoOrder);
            info.put("order", this.typeBondOrder);
            return info;
        }

        String info() {
            return "[link " + this.line + " : " + this.distance + "]";
        }

        @Override
        public String toString() {
            return this.info();
        }
    }

    private class TNode
    extends Atom
    implements TPoint {
        public String id;
        public String atomLabel;
        String netID;
        String label;
        int symop = 0;
        P3 trans = new P3();
        Lst<TAtom> tatoms;
        BS bsAtoms = null;
        int linkSymop = 0;
        P3 linkTrans = new P3();
        TNet net;
        private boolean isFinalized;
        int idx;
        private Atom atom;
        private String line;
        private String mf;

        TNode() {
            boolean i = false;
        }

        TNode(int idx, Atom atom, TNet net, int op, P3 trans) {
            this.idx = idx;
            this.atom = atom;
            this.net = net;
            this.linkSymop = op;
            this.linkTrans = trans;
            this.atomName = this.atomLabel = atom.atomName;
            this.label = this.atomLabel;
            this.elementSymbol = atom.elementSymbol;
            TopoCifParser.setTAtom(atom, this);
        }

        public String getMolecularFormula() {
            return this.mf == null ? (this.mf = TopoCifParser.getMF(this.tatoms)) : this.mf;
        }

        @Override
        public TNet getNet() {
            return this.net;
        }

        boolean setNode(int[] a, String line) {
            this.line = line;
            if (this.tatoms == null) {
                if (Float.isNaN(this.x) != Float.isNaN(this.y) || Float.isNaN(this.y) != Float.isNaN(this.z)) {
                    return false;
                }
                this.idx = TopoCifParser.this.atomCount++;
                if (Float.isNaN(this.x)) {
                    this.trans = P3.new3(a[0], a[1], a[2]);
                } else {
                    this.symop = 0;
                }
            }
            return true;
        }

        void addAtom(TAtom atom) {
            if (this.tatoms == null) {
                this.tatoms = new Lst();
            }
            atom.atomName = "Node_" + atom.nodeID + "_" + atom.atomLabel;
            this.tatoms.addLast(atom);
        }

        void finalizeNode(M4[] ops) throws Exception {
            TNode a;
            boolean haveXYZ;
            if (this.isFinalized) {
                return;
            }
            this.isFinalized = true;
            if (this.net == null) {
                this.net = TopoCifParser.this.getNetFor(this.netID, null, true);
            }
            boolean bl = haveXYZ = !Float.isNaN(this.x);
            if (this.tatoms == null) {
                a = null;
                if (!haveXYZ) {
                    throw new Exception("_topol_node no atom " + this.atomLabel + " line=" + this.line);
                }
            } else {
                if (Float.isNaN(this.x)) {
                    this.setCentroid();
                }
                if (this.tatoms.size() == 1) {
                    TAtom ta = (TAtom)this.tatoms.get(0);
                    this.elementSymbol = ta.elementSymbol;
                    this.atomLabel = ta.atomLabel;
                    this.formalCharge = ta.formalCharge;
                    this.tatoms = null;
                } else {
                    this.net.hasAtoms = true;
                    this.elementSymbol = "Xx";
                    int i = this.tatoms.size();
                    while (--i >= 0) {
                        TAtom ta = (TAtom)this.tatoms.get(i);
                        ta.sequenceNumber = this.idx + 1;
                        if (ta.atomName == null || !ta.atomName.startsWith(this.net.label + "_")) {
                            ta.atomName = this.net.label + "_" + ta.atomName;
                        }
                        ta.net = this.net;
                    }
                }
                a = this;
            }
            if (a != null && a == this.atom || !haveXYZ) {
                if (a != this) {
                    TopoCifParser.setTAtom(a, this);
                }
                TopoCifParser.applySymmetry(this, ops, this.symop, this.trans);
            }
            this.atomName = this.net.label.replace(' ', '_') + "__";
            if (this.label != null && this.label.startsWith(this.atomName)) {
                this.atomName = "";
            }
            this.atomName = this.atomName + (this.label != null ? this.label : (this.atomLabel != null ? this.atomLabel : "Node_" + this.id));
            this.addNode();
        }

        private void addNode() {
            TopoCifParser.this.reader.addCifAtom(this, this.atomName, null, null);
            ++this.net.nNodes;
            if (this.tatoms != null && this.tatoms.size() > 1) {
                TopoCifParser.this.reader.appendLoadNote("_topos_node " + this.id + " " + this.atomName + " has formula " + this.getMolecularFormula());
            }
        }

        private void setCentroid() {
            int n;
            this.z = 0.0f;
            this.y = 0.0f;
            this.x = 0.0f;
            int i = n = this.tatoms.size();
            while (--i >= 0) {
                this.add((T3)this.tatoms.get(i));
            }
            this.x /= (float)n;
            this.y /= (float)n;
            this.z /= (float)n;
        }

        public String info() {
            return "[node idx=" + this.idx + " id=" + this.id + " " + this.label + "/" + this.atomName + " " + super.toString() + "]";
        }

        @Override
        public String toString() {
            return this.info();
        }

        public TNode copy() {
            TNode node = (TNode)this.clone();
            node.idx = TopoCifParser.this.atomCount++;
            if (node.isFinalized) {
                node.addNode();
            }
            if (this.tatoms != null) {
                node.tatoms = new Lst();
                int n = this.tatoms.size();
                for (int i = 0; i < n; ++i) {
                    TAtom ta = ((TAtom)this.tatoms.get(i)).getTClone();
                    node.tatoms.addLast(ta);
                    TopoCifParser.this.reader.addCifAtom(ta, ta.atomName, null, null);
                }
            }
            return node;
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }
    }

    private class TAtom
    extends Atom
    implements TPoint {
        String id;
        String atomLabel;
        String nodeID;
        String linkID;
        int symop = 0;
        private P3 trans = new P3();
        String line;
        private boolean isFinalized;
        int idx;
        TNet net;

        TAtom() {
            boolean i = false;
        }

        TAtom getTClone() {
            try {
                TAtom ta = (TAtom)this.clone();
                ta.idx = TopoCifParser.this.atomCount++;
                return ta;
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }

        @Override
        public TNet getNet() {
            return this.net;
        }

        boolean setAtom(int[] a, String line) {
            this.line = line;
            if (Float.isNaN(this.x) != Float.isNaN(this.y) || Float.isNaN(this.y) != Float.isNaN(this.z)) {
                return false;
            }
            this.idx = TopoCifParser.this.atomCount++;
            if (Float.isNaN(this.x)) {
                this.trans = P3.new3(a[0], a[1], a[2]);
            } else {
                this.symop = 0;
            }
            this.atomName = this.atomLabel;
            return true;
        }

        void finalizeAtom() throws Exception {
            if (this.isFinalized) {
                return;
            }
            this.isFinalized = true;
            Atom a = TopoCifParser.this.getAtomFromName(this.atomLabel);
            TopoCifParser.setElementSymbol(this, this.elementSymbol);
            if (a == null && Float.isNaN(this.x)) {
                throw new Exception("_topol_atom: no atom " + this.atomLabel + " line=" + this.line);
            }
            TNode node = null;
            if (this.nodeID != null) {
                node = TopoCifParser.this.findNode(this.nodeID, -1, null);
            }
            TLink link = null;
            if (this.linkID != null) {
                link = this.getLinkById(this.linkID);
            }
            if (node == null && link == null) {
                System.out.println("TAtom " + this + " ignored");
                return;
            }
            if (a != null && Float.isNaN(this.x)) {
                TopoCifParser.setTAtom(a, this);
                TopoCifParser.applySymmetry(this, TopoCifParser.this.ops, this.symop, this.trans);
            }
            this.atomName = this.atomLabel;
            if (node != null) {
                node.addAtom(this);
            }
            TAtom ta = this;
            if (link != null) {
                ta = link.addAtom(this);
            }
            TopoCifParser.this.reader.addCifAtom(this, this.atomName, null, null);
            if (ta != this) {
                TopoCifParser.this.reader.addCifAtom(ta, this.atomName, null, null);
            }
        }

        private TLink getLinkById(String linkID) {
            int i = TopoCifParser.this.links.size();
            while (--i >= 0) {
                TLink l = (TLink)TopoCifParser.this.links.get(i);
                if (!l.id.equalsIgnoreCase(linkID)) continue;
                return l;
            }
            return null;
        }

        @Override
        public String toString() {
            return this.line + " " + super.toString();
        }
    }

    private class TNet {
        String line;
        String id;
        int nLinks;
        int nNodes;
        String label;
        String specialDetails;
        int idx;
        boolean hasAtoms;

        TNet(int index, String id, String label, String specialDetails) {
            this.idx = index;
            this.id = id;
            this.label = label;
            this.specialDetails = specialDetails;
        }

        void finalizeNet() {
            if (this.id == null) {
                this.id = "" + (this.idx + 1);
            }
            if (TopoCifParser.this.selectedNet != null && !this.label.equalsIgnoreCase(TopoCifParser.this.selectedNet) && !this.id.equalsIgnoreCase(TopoCifParser.this.selectedNet)) {
                return;
            }
            String netKey = "," + this.id + ",";
            if (TopoCifParser.this.netNotes.indexOf(netKey) < 0) {
                TopoCifParser.this.reader.appendLoadNote("Net " + this.label + (this.specialDetails == null ? "" : " '" + this.specialDetails + "'") + " created from " + this.nLinks + " links and " + this.nNodes + " nodes.\nUse DISPLAY " + (this.hasAtoms ? this.label + "__* to display it without associated atoms\nUse DISPLAY " + this.label + "_* to display it with its associated atoms" : this.label + "* to display it"));
            }
        }
    }

    private static interface TPoint {
        public TNet getNet();
    }
}

