/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.script;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.M34;
import javajs.util.M4;
import javajs.util.PT;
import javajs.util.SB;
import org.jmol.api.Interface;
import org.jmol.i18n.GT;
import org.jmol.modelset.BondSet;
import org.jmol.modelset.Group;
import org.jmol.script.ContextToken;
import org.jmol.script.SV;
import org.jmol.script.ScriptContext;
import org.jmol.script.ScriptError;
import org.jmol.script.ScriptFlowContext;
import org.jmol.script.ScriptFunction;
import org.jmol.script.ScriptManager;
import org.jmol.script.ScriptParam;
import org.jmol.script.ScriptTokenParser;
import org.jmol.script.T;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.viewer.FileManager;
import org.jmol.viewer.Viewer;

public class ScriptCompiler
extends ScriptTokenParser {
    private String filename;
    private boolean isSilent;
    private Map<String, SV> contextVariables;
    private T[][] aatokenCompiled;
    private short[] lineNumbers;
    private int[][] lineIndices;
    private int lnLength = 8;
    private boolean preDefining;
    private boolean isShowScriptOutput;
    private boolean isCheckOnly;
    private boolean haveComments;
    String scriptExtensions;
    private ScriptFunction thisFunction;
    private ScriptFlowContext flowContext;
    private Lst<T> ltoken;
    private Lst<T[]> lltoken;
    private Lst<T> vBraces;
    private int ichBrace;
    private int cchToken;
    private int cchScript;
    private int nSemiSkip;
    private int parenCount;
    private int braceCount;
    private int setBraceCount;
    private int bracketCount;
    private int ptSemi;
    private int forPoint3;
    private int setEqualPt;
    private int iBrace;
    private boolean iHaveQuotedString;
    private boolean isEndOfCommand;
    private boolean needRightParen;
    private boolean endOfLine;
    private String comment;
    private static final int OK = 0;
    private static final int OK2 = 1;
    private static final int CONTINUE = 2;
    private static final int EOL = 3;
    private static final int ERROR = 4;
    private static final int RESTART = 5;
    private int tokLastMath;
    private boolean checkImpliedScriptCmd;
    private Lst<ScriptFunction> vFunctionStack;
    private boolean allowMissingEnd;
    private boolean isShowCommand;
    private boolean isComment;
    private boolean isUserToken;
    private boolean implicitString;
    private int tokInitialPlusPlus;
    private int afterWhite;
    private boolean isDotDot;
    private String ident;
    private String identLC;
    private Lst<T> vPush = new Lst();
    private int pushCount;
    private ScriptFlowContext forceFlowContext;
    private boolean haveENDIF;
    private char chFirst = '\u0000';
    private int afterMath;

    public ScriptCompiler(Viewer vwr) {
        this.vwr = vwr;
    }

    synchronized ScriptContext compile(String filename, String script, boolean isPredefining, boolean isSilent, boolean debugScript, boolean isCheckOnly) {
        this.isCheckOnly = isCheckOnly;
        this.filename = filename;
        this.isSilent = isSilent;
        this.script = script;
        this.logMessages = !isSilent && !isPredefining && debugScript;
        this.preDefining = filename == "#predefine";
        boolean doFull = true;
        boolean isOK = this.compile0(doFull);
        this.atokenInfix = null;
        if (!isOK) {
            this.handleError();
        }
        ScriptContext sc = new ScriptContext();
        sc.isComplete = isOK = this.iBrace == 0 && this.parenCount == 0 && this.braceCount == 0 && this.bracketCount == 0;
        sc.script = script;
        sc.scriptExtensions = this.scriptExtensions;
        sc.errorType = this.errorType;
        if (this.errorType != null) {
            sc.iCommandError = this.iCommand;
            this.setAaTokenCompiled();
        }
        sc.saveTokens(this.aatokenCompiled);
        sc.errorMessage = this.errorMessage;
        String string = sc.errorMessageUntranslated = this.errorMessageUntranslated == null ? this.errorMessage : this.errorMessageUntranslated;
        if (this.allowMissingEnd && sc.errorMessage != null && sc.errorMessageUntranslated.indexOf("missing END") >= 0) {
            sc.errorMessage = sc.errorMessageUntranslated;
        }
        sc.lineIndices = this.lineIndices;
        sc.lineNumbers = this.lineNumbers;
        sc.vars = this.contextVariables;
        return sc;
    }

    private void newContextVariable(String ident) {
        this.theToken = T.o(0x40000000, ident);
        if (this.pushCount > 0) {
            ContextToken ct = (ContextToken)this.vPush.get(this.pushCount - 1);
            ct.addName(ident);
            if (ct.tok != 364558) {
                return;
            }
        }
        if (this.thisFunction == null) {
            if (this.contextVariables == null) {
                this.contextVariables = new Hashtable<String, SV>();
            }
            ScriptCompiler.addContextVariable(this.contextVariables, ident);
        } else {
            this.thisFunction.addVariable(ident, false);
        }
    }

    static void addContextVariable(Map<String, SV> contextVariables, String name) {
        contextVariables.put(name, SV.newS("").setName(name));
    }

    private boolean isContextVariable(String ident) {
        int i = this.vPush.size();
        while (--i >= 0) {
            ContextToken ct = (ContextToken)this.vPush.get(i);
            if (ct.contextVariables == null || !ct.contextVariables.containsKey(ident)) continue;
            return true;
        }
        return this.thisFunction != null ? this.thisFunction.isVariable(ident) : this.contextVariables != null && this.contextVariables.containsKey(ident);
    }

    private String cleanScriptComments(String script) {
        int pt;
        if (script.indexOf(160) >= 0) {
            script = script.replace('\u00a0', ' ');
        }
        if (script.indexOf(8220) >= 0) {
            script = script.replace('\u201c', '\"');
        }
        if (script.indexOf(8221) >= 0) {
            script = script.replace('\u201d', '\"');
        }
        if (script.indexOf(65279) >= 0) {
            script = script.replace('\ufeff', ' ');
        }
        if ((pt = script.indexOf("\u0001##")) >= 0) {
            this.scriptExtensions = script.substring(pt + 1);
            script = script.substring(0, pt);
            this.allowMissingEnd = this.scriptExtensions.indexOf("##noendcheck") >= 0;
        }
        this.haveComments = script.indexOf("#") >= 0;
        return FileManager.getEmbeddedScript(script);
    }

    private void addTokenToPrefix(T token) {
        if (this.logMessages) {
            Logger.info("addTokenToPrefix" + this.lineCurrent + " " + this.iCommand + " " + token);
        }
        this.ltoken.addLast(token);
        if (token.tok != 0) {
            this.lastToken = token;
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean compile0(boolean isFull) {
        this.haveENDIF = false;
        this.script = this.cleanScriptComments(this.script);
        this.ichToken = this.script.indexOf("# Jmol state version ");
        v0 = this.isStateScript = this.ichToken >= 0;
        if (this.isStateScript) {
            this.ptSemi = this.script.indexOf(";", this.ichToken);
            if (this.ptSemi >= this.ichToken) {
                ScriptManager.setStateScriptVersion(this.vwr, this.script.substring(this.ichToken + "# Jmol state version ".length(), this.ptSemi).trim());
            }
        }
        this.cchScript = this.script.length();
        block23: while (true) {
            this.vFunctionStack = new Lst<V>();
            this.htUserFunctions = new Hashtable<K, V>();
            this.contextVariables = null;
            this.lineNumbers = null;
            this.lineIndices = null;
            this.aatokenCompiled = null;
            this.thisFunction = null;
            this.flowContext = null;
            this.errorType = null;
            this.errorMessage = null;
            this.errorMessageUntranslated = null;
            this.errorLine = null;
            this.nSemiSkip = 0;
            this.ichToken = 0;
            this.ichCurrentCommand = 0;
            this.ichComment = 0;
            this.ichBrace = 0;
            this.lineCurrent = 1;
            this.iCommand = 0;
            this.tokLastMath = 0;
            this.lastToken = T.tokenOff;
            this.vBraces = new Lst<V>();
            this.vPush = new Lst<V>();
            this.pushCount = 0;
            this.iBrace = 0;
            this.braceCount = 0;
            this.parenCount = 0;
            this.isDotDot = false;
            this.ptSemi = -10;
            this.cchToken = 0;
            this.lnLength = 8;
            this.lineNumbers = new short[this.lnLength];
            this.lineIndices = new int[this.lnLength][2];
            this.isSetBrace = false;
            this.isNewSet = false;
            this.ptNewSetModifier = 1;
            this.isShowScriptOutput = false;
            this.iHaveQuotedString = false;
            this.checkImpliedScriptCmd = false;
            this.lltoken = new Lst<V>();
            this.ltoken = new Lst<V>();
            this.tokCommand = 0;
            this.lastFlowCommand = null;
            this.tokenAndEquals = null;
            this.tokInitialPlusPlus = 0;
            this.setBraceCount = 0;
            this.bracketCount = 0;
            this.forPoint3 = -1;
            this.setEqualPt = 0x7FFFFFFF;
            this.endOfLine = false;
            this.comment = null;
            this.isEndOfCommand = false;
            this.needRightParen = false;
            this.lastFlowCommand = null;
            this.forceFlowContext = null;
            this.theTok = 0;
            iLine = 1;
            while (true) {
                block38: {
                    block40: {
                        block39: {
                            if ((this.nTokens = this.ltoken.size()) == 0) {
                                if (this.thisFunction != null && this.thisFunction.chpt0 == 0) {
                                    this.thisFunction.chpt0 = this.ichToken;
                                }
                                this.ichCurrentCommand = this.ichToken;
                                iLine = this.lineCurrent;
                            }
                            if (this.lookingAtLeadingWhitespace()) break block38;
                            this.endOfLine = false;
                            if (this.isEndOfCommand) break block39;
                            this.endOfLine = this.lookingAtEndOfLine();
                            switch (this.endOfLine != false ? 0 : this.lookingAtComment()) {
                                case 2: {
                                    break block38;
                                }
                                case 3: {
                                    this.isEndOfCommand = true;
                                    break block38;
                                }
                                case 1: {
                                    this.isEndOfCommand = true;
                                    this.comment = this.script.substring(this.ichToken, this.ichToken + this.cchToken).trim();
                                }
                                default: {
                                    v1 = this.isEndOfCommand = this.isEndOfCommand != false || this.endOfLine != false || this.lookingAtTerminator() != false;
                                }
                            }
                        }
                        if (!this.isEndOfCommand) break block40;
                        this.isEndOfCommand = false;
                        switch (this.processTokenList(iLine, isFull)) {
                            case 2: {
                                break block38;
                            }
                            case 4: {
                                return false;
                            }
                            default: {
                                this.checkImpliedScriptCmd = false;
                                if (this.ichToken >= this.cchScript) {
                                    if (this.flowContext != null) {
                                        this.ichCurrentCommand = this.ichToken = this.cchScript;
                                        while (this.flowContext != null) {
                                            this.fixFlowAddLine(this.flowContext);
                                            if (!this.haveENDIF && this.flowContext.checkForceEndIf(0)) {
                                                this.forceFlowEnd(this.flowContext.token);
                                                this.processTokenList(iLine, isFull);
                                                continue;
                                            }
                                            this.lineCurrent = (short)this.flowContext.lineStart;
                                            this.iCommand = this.flowContext.pt0;
                                            this.ichCurrentCommand = this.lineIndices[this.iCommand][0];
                                            this.ichToken = this.ichEnd = this.lineIndices[this.iCommand][1];
                                            return this.errorStr(11, this.flowContext.function == null ? T.nameOf(this.flowContext.token.tok) : this.flowContext.function.getSignature());
                                        }
                                        this.lltoken.addLast(new T[]{T.o(0, "// end of script")});
                                    }
                                    this.setAaTokenCompiled();
                                    return true;
                                }
                                break block38;
                            }
                        }
                    }
                    if (this.nTokens <= 0 || this.isDotDot) ** GOTO lbl-1000
                    block9 : switch (this.checkSpecialParameterSyntax()) {
                        case 2: {
                            break;
                        }
                        case 4: {
                            return false;
                        }
                        default: lbl-1000:
                        // 2 sources

                        {
                            if (this.lookingAtLookupToken(this.ichToken)) {
                                switch (this.parseKnownToken()) {
                                    case 2: {
                                        break block9;
                                    }
                                    case 4: {
                                        return false;
                                    }
                                    case 5: {
                                        this.haveENDIF = true;
                                        continue block23;
                                    }
                                }
                                switch (this.parseCommandParameter(iLine, isFull)) {
                                    case 2: {
                                        break block9;
                                    }
                                    case 4: {
                                        return false;
                                    }
                                    case 5: {
                                        this.haveENDIF = true;
                                        continue block23;
                                    }
                                }
                                this.addTokenToPrefix(this.theToken);
                                break;
                            }
                            if (this.nTokens == 0 || (this.isNewSet || this.isSetBrace) && this.nTokens == this.ptNewSetModifier) {
                                if (this.nTokens == 0) {
                                    if (this.lookingAtString(true)) {
                                        this.addTokenToPrefix(this.setCommand(T.tokenScript));
                                        this.cchToken = 0;
                                        break;
                                    }
                                    if (this.lookingAtImpliedString(true, true, true)) {
                                        this.ichEnd = this.ichToken + this.cchToken;
                                    }
                                }
                                return this.commandExpected();
                            }
                            return this.errorStr(19, this.script.substring(this.ichToken, this.ichToken + 1));
                        }
                    }
                }
                this.ichToken += this.cchToken;
            }
            break;
        }
    }

    private void setAaTokenCompiled() {
        this.aatokenCompiled = (T[][])this.lltoken.toArray((T[])new T[this.lltoken.size()][]);
    }

    private boolean lookingAtLeadingWhitespace() {
        int ichT = this.ichToken;
        while (ScriptCompiler.isSpaceOrTab(this.charAt(ichT))) {
            ++ichT;
        }
        if (this.isLineContinuation(ichT, true)) {
            ichT += 1 + this.nCharNewLine(ichT + 1);
        }
        this.cchToken = ichT - this.ichToken;
        if (this.cchToken == 0) {
            return false;
        }
        this.afterWhite = ichT;
        return true;
    }

    private boolean isLineContinuation(int ichT, boolean checkMathop) {
        boolean isEscaped;
        boolean bl = isEscaped = ichT + 2 < this.cchScript && this.script.charAt(ichT) == '\\' && this.nCharNewLine(ichT + 1) > 0 || !this.isShowScriptOutput && checkMathop && this.lookingAtMathContinuation(ichT);
        if (isEscaped) {
            this.lineCurrent = (short)(this.lineCurrent + 1);
        }
        return isEscaped;
    }

    private boolean lookingAtMathContinuation(int ichT) {
        int n = this.nCharNewLine(ichT);
        if (n == 0 || this.lastToken.tok == 1073742332) {
            return false;
        }
        if (this.parenCount > 0 || this.bracketCount > 0) {
            return true;
        }
        switch (this.tokCommand) {
            case 102436: 
            case 134320141: {
                this.flowContext.forceEndIf = false;
                return false;
            }
            case 102402: 
            case 102406: 
            case 364547: 
            case 134320648: 
            case 134320649: {
                if (!this.haveENDIF) {
                    this.flowContext.addLine = 1;
                    this.flowContext.forceEndIf = true;
                }
                return false;
            }
            case 36867: {
                if (this.nTokens > 1 && ((T)this.ltoken.get((int)1)).tok == 537022465) {
                    return false;
                }
            }
            case 36865: 
            case 36869: {
                break;
            }
            default: {
                return false;
            }
        }
        if (this.lastToken.tok == this.tokLastMath) {
            return true;
        }
        ichT += n;
        while (ScriptCompiler.isSpaceOrTab(this.charAt(ichT))) {
            ++ichT;
        }
        return this.lookingAtLookupToken(ichT) && this.tokLastMath == 1;
    }

    private boolean lookingAtEndOfLine() {
        if (this.ichToken >= this.cchScript) {
            this.ichEnd = this.cchScript;
            return true;
        }
        this.ichEnd = this.ichToken;
        this.cchToken = this.nCharNewLine(this.ichEnd);
        return this.cchToken > 0;
    }

    private int nCharNewLine(int ichT) {
        char ch = this.charAt(ichT);
        return ch != '\r' ? (ch == '\n' ? 1 : 0) : (this.charAt(++ichT) == '\n' ? 2 : 1);
    }

    private boolean lookingAtTerminator() {
        boolean isSemi;
        boolean bl = isSemi = this.script.charAt(this.ichToken) == ';';
        if (isSemi && this.nTokens > 0) {
            this.ptSemi = this.nTokens;
        }
        if (!isSemi || this.nSemiSkip-- > 0) {
            return false;
        }
        this.cchToken = 1;
        return true;
    }

    private int lookingAtComment() {
        boolean isSharp;
        char ch = this.script.charAt(this.ichToken);
        int ichT = this.ichToken;
        int ichFirstSharp = -1;
        if (this.ichToken == this.ichCurrentCommand && ch == '$' && (this.isShowScriptOutput || this.ichToken == 0)) {
            this.isShowScriptOutput = true;
            this.isShowCommand = true;
            if (this.charAt(++ichT) == '[') {
                while (ch != ']' && !this.eol(ch = this.charAt(ichT))) {
                    ++ichT;
                }
            }
            this.cchToken = ichT - this.ichToken;
            return 2;
        }
        if (this.isShowScriptOutput && !this.isShowCommand) {
            ichFirstSharp = ichT;
        }
        if (ch == '/' && ichT + 1 < this.cchScript) {
            switch (this.script.charAt(++ichT)) {
                case '/': {
                    ichFirstSharp = this.ichToken;
                    this.ichEnd = ichT - 1;
                    break;
                }
                case '*': {
                    this.ichEnd = ichT - 1;
                    ch = this.charAt(++ichT);
                    String terminator = ch == '*' ? "**/" : "*/";
                    ichT = this.script.indexOf(terminator, this.ichToken + 2);
                    if (ichT < 0) {
                        this.ichToken = this.cchScript;
                        return 3;
                    }
                    this.incrementLineCount(this.script.substring(this.ichToken, ichT));
                    this.cchToken = ichT + (ch == '*' ? 3 : 2) - this.ichToken;
                    return 2;
                }
                default: {
                    return 0;
                }
            }
        }
        boolean bl = isSharp = ichFirstSharp < 0;
        if (isSharp && !this.haveComments) {
            return 0;
        }
        if (this.ichComment > ichT) {
            ichT = this.ichComment;
        }
        while (ichT < this.cchScript) {
            ch = this.script.charAt(ichT);
            if (this.eol(ch)) {
                this.ichEnd = ichT;
                if (ichT > 0 && this.isLineContinuation(ichT - 1, false)) {
                    ichT += this.nCharNewLine(ichT);
                } else if (isSharp || ch != ';') break;
            } else if (ichFirstSharp < 0 && ch == '#') {
                ichFirstSharp = ichT;
            }
            ++ichT;
        }
        if (ichFirstSharp < 0) {
            return 0;
        }
        this.ichComment = ichFirstSharp;
        if (isSharp && this.nTokens == 0 && this.cchScript - ichFirstSharp >= 3 && this.script.charAt(ichFirstSharp + 1) == 'j' && this.script.charAt(ichFirstSharp + 2) == 'c') {
            this.cchToken = ichT - this.ichToken;
            return 2;
        }
        if (ichFirstSharp != this.ichToken) {
            return 0;
        }
        if (isSharp && this.cchScript > this.ichToken + 3 && this.script.charAt(this.ichToken + 1) == 'j' && this.script.charAt(this.ichToken + 2) == 'x' && ScriptCompiler.isSpaceOrTab(this.script.charAt(this.ichToken + 3))) {
            this.cchToken = 4;
            return 2;
        }
        if (ichT == this.ichToken) {
            return 0;
        }
        this.cchToken = ichT - this.ichToken;
        return this.nTokens == 0 ? 1 : 2;
    }

    private char charAt(int i) {
        return i < this.cchScript ? this.script.charAt(i) : (char)'\u0000';
    }

    private int processTokenList(short iLine, boolean doCompile) {
        boolean isEndFlow;
        int n = this.ltoken.size();
        if (n > 0 || this.comment != null) {
            T t;
            if (n == 0) {
                this.ichCurrentCommand = this.ichToken;
                if (this.comment != null) {
                    this.isComment = true;
                    this.addTokenToPrefix(T.o(0, this.comment));
                }
            } else if (this.setBraceCount > 0 && this.endOfLine && this.ichToken < this.cchScript) {
                return 2;
            }
            if (this.wasImpliedScript()) {
                return 2;
            }
            if (this.isNewSet && n > 2 && this.tokAt(2) == 0x40000200 && (this.tokAt(3) == 1275068444 || this.tokAt(3) == 0x44000005 || this.tokAt(3) == 1275335685 || this.tokAt(3) == 1275334681)) {
                this.ltoken.set(0, T.tokenSet);
                this.ltoken.add(1, this.tokAt(3) == 1275334681 ? T.tokenAll : (T)this.ltoken.get(1));
            } else if (this.tokInitialPlusPlus != 0) {
                if (!this.isNewSet) {
                    this.checkNewSetCommand();
                }
                this.tokenizePlusPlus(this.tokInitialPlusPlus, true);
                this.ichCurrentCommand -= 2;
            }
            this.iCommand = this.lltoken.size();
            if (this.thisFunction != null && this.thisFunction.cmdpt0 < 0) {
                this.thisFunction.cmdpt0 = this.iCommand;
            }
            if (n == 1 && this.braceCount == 1) {
                if (this.lastFlowCommand == null) {
                    this.braceCount = 0;
                    this.setBraceCount = 0;
                    this.parenCount = 0;
                    this.ltoken.removeItemAt(0);
                    t = ContextToken.newContext(true);
                    this.addTokenToPrefix(this.setCommand(t));
                    this.pushContext(t);
                    this.addBrace(this.tokenCommand);
                } else {
                    this.setBraceCount = 0;
                    this.parenCount = 0;
                    this.setCommand(this.lastFlowCommand);
                    if (this.lastFlowCommand.tok != 102439 && this.tokAt(0) == 1073742332) {
                        this.ltoken.removeItemAt(0);
                    }
                    this.lastFlowCommand = null;
                    this.forceFlowContext = this.flowContext;
                }
            }
            if (this.bracketCount > 0 || this.setBraceCount > 0 || this.parenCount > 0 || this.braceCount == 1 && !this.checkFlowStartBrace(true)) {
                this.error(n == 1 ? 2 : 4);
                return 4;
            }
            if (this.needRightParen) {
                this.addTokenToPrefix(T.tokenRightParen);
                this.needRightParen = false;
            }
            if (this.tokAt(1) == 1073741974 && T.tokAttr(this.tokCommand, 135168)) {
                switch (this.tokAt(2)) {
                    case 0: 
                    case 4: 
                    case 12290: {
                        break;
                    }
                    default: {
                        t = this.ltoken.removeItemAt(2);
                        this.ltoken.add(2, T.o(4, t.tok == 2 ? "" + t.intValue : t.value.toString()));
                    }
                }
            }
            if (this.ltoken.size() > 0) {
                if (doCompile && !this.compileCommand()) {
                    return 4;
                }
                if (this.logMessages) {
                    Logger.info("-------------------------------------");
                }
                boolean doEval = true;
                switch (this.tokCommand) {
                    case 102409: 
                    case 102436: 
                    case 364558: 
                    case 134320141: {
                        boolean bl = doEval = this.atokenInfix.length > 0 && this.atokenInfix[0].intValue != Integer.MAX_VALUE;
                    }
                }
                if (doEval) {
                    if (this.iCommand == this.lnLength) {
                        this.lineNumbers = AU.doubleLengthShort(this.lineNumbers);
                        int[][] lnI = new int[this.lnLength * 2][2];
                        System.arraycopy(this.lineIndices, 0, lnI, 0, this.lnLength);
                        this.lineIndices = lnI;
                        this.lnLength *= 2;
                    }
                    short s = iLine;
                    this.lineNumbers[this.lineNumbers.length - 1] = s;
                    this.lineNumbers[this.iCommand] = s;
                    this.lineIndices[this.iCommand][0] = this.ichCurrentCommand;
                    this.lineIndices[this.iCommand][1] = Math.max(this.ichCurrentCommand, Math.min(this.cchScript, this.ichEnd == this.ichCurrentCommand ? this.ichToken : this.ichEnd));
                    this.lltoken.addLast(this.atokenInfix);
                    this.iCommand = this.lltoken.size();
                }
                if (this.tokCommand == 36867) {
                    this.lastFlowCommand = null;
                }
            }
            this.setCommand(null);
            this.comment = null;
            this.needRightParen = false;
            this.isSetBrace = false;
            this.isNewSet = false;
            this.iHaveQuotedString = false;
            this.ptNewSetModifier = 1;
            this.ltoken.clear();
            this.nSemiSkip = 0;
            this.nTokens = 0;
            this.tokInitialPlusPlus = 0;
            this.tokenAndEquals = null;
            this.ptSemi = -10;
            this.forPoint3 = -1;
            this.setEqualPt = Integer.MAX_VALUE;
        }
        boolean isOneLine = this.flowContext != null && this.flowContext.addLine == 0;
        boolean bl = isEndFlow = (this.endOfLine || !isOneLine) && !this.haveENDIF && this.flowContext != null && this.flowContext.checkForceEndIf(-1);
        if (this.endOfLine) {
            if (isEndFlow) {
                if (this.isComment) {
                    if (!isOneLine) {
                        ++this.flowContext.addLine;
                        this.flowContext.forceEndIf = true;
                    }
                } else if (n > 0 && !this.haveENDIF || isOneLine) {
                    this.forceFlowEnd(this.flowContext.token);
                    if (!isOneLine) {
                        this.forceFlowContext.forceEndIf = true;
                    }
                }
                this.isEndOfCommand = true;
                this.cchToken = 0;
                this.ichCurrentCommand = this.ichToken;
                return 2;
            }
            this.isComment = false;
            this.isShowCommand = false;
            this.lineCurrent = (short)(this.lineCurrent + 1);
        } else if (isEndFlow) {
            this.forceFlowEnd(this.flowContext.token);
            this.forceFlowContext.forceEndIf = true;
        }
        if (this.ichToken >= this.cchScript) {
            this.setCommand(T.tokenAll);
            this.theTok = 0;
            switch (this.checkFlowEndBrace()) {
                case 4: {
                    return 4;
                }
                case 2: {
                    this.isEndOfCommand = true;
                    this.cchToken = 0;
                    return 2;
                }
            }
            this.ichToken = this.cchScript;
            return 0;
        }
        return 0;
    }

    private void addBrace(T t) {
        this.vBraces.addLast(t);
        ++this.iBrace;
    }

    private void pushContext(T t) {
        ++this.pushCount;
        this.vPush.addLast(t);
    }

    private boolean wasImpliedScript() {
        if (this.checkImpliedScriptCmd && this.nTokens >= 2 && (this.tokCommand == 134222850 || this.tokCommand == 4124)) {
            String s;
            String string = s = this.nTokens == 2 ? this.lastToken.value.toString().toUpperCase() : null;
            if (this.nTokens > 2 ? this.tokAt(2) != 0x10000010 || !((T)this.ltoken.get((int)1)).value.toString().endsWith(".spt") : s.endsWith(".SORT") || s.endsWith(".REVERSE") || s.endsWith(".POP") || s.indexOf(".SORT(") >= 0 || s.indexOf(".REVERSE(") >= 0 || s.indexOf(".POP(") >= 0 || s.indexOf(".PUSH(") >= 0 || s.endsWith("++") || s.endsWith("--") || s.endsWith("=") || this.tokInitialPlusPlus != 0) {
                this.ichToken = this.ichCurrentCommand;
                this.nTokens = 0;
                this.ltoken.clear();
                this.cchToken = 0;
                this.tokCommand = 0;
                return true;
            }
        }
        return false;
    }

    private boolean compileCommand() {
        switch (this.ltoken.size()) {
            case 0: {
                this.atokenInfix = new T[0];
                return true;
            }
            case 4: {
                if (!this.isNewSet || !this.tokenAt((int)2).value.equals(".") || !this.tokenAt((int)3).value.equals("spt")) break;
                String fname = this.tokenAt((int)1).value + "." + this.tokenAt((int)3).value;
                this.ltoken.clear();
                this.addTokenToPrefix(T.tokenScript);
                this.addTokenToPrefix(T.o(4, fname));
                this.isNewSet = false;
            }
        }
        this.setCommand(this.tokenAt(0));
        int size = this.ltoken.size();
        if (size == 1 && T.tokAttr(this.tokCommand, 524288)) {
            this.addTokenToPrefix(T.tokenOn);
        }
        if (this.tokenAndEquals != null) {
            int j;
            int i = 0;
            for (i = 1; i < size && (j = this.tokAt(i)) != 268435666; ++i) {
            }
            size = i++;
            if (this.ltoken.size() < i) {
                Logger.error("COMPILER ERROR! - andEquals ");
            } else {
                j = 1;
                while (j < size) {
                    this.ltoken.add(i, this.tokenAt(j));
                    ++j;
                    ++i;
                }
                this.ltoken.set(size, T.tokenEquals);
                this.ltoken.add(i, this.tokenAndEquals);
                this.ltoken.add(++i, T.tokenLeftParen);
                this.addTokenToPrefix(T.tokenRightParen);
            }
        }
        size = this.ltoken.size();
        this.atokenInfix = this.ltoken.toArray(new T[size]);
        return this.compileExpressions();
    }

    private T tokenAt(int i) {
        return (T)this.ltoken.get(i);
    }

    @Override
    protected int tokAt(int i) {
        return i < this.ltoken.size() ? this.tokenAt((int)i).tok : 0;
    }

    private T setCommand(T token) {
        this.tokenCommand = token;
        if (token == null) {
            this.tokCommand = 0;
        } else {
            this.tokCommand = this.tokenCommand.tok;
            this.isMathExpressionCommand = this.tokCommand == 0x40000000 || T.tokAttr(this.tokCommand, 36864);
            this.isSetOrDefine = this.tokCommand == 36867 || this.tokCommand == 12290;
            this.isCommaAsOrAllowed = T.tokAttr(this.tokCommand, 12288);
            this.implicitString = T.tokAttr(this.tokCommand, 20480);
        }
        return token;
    }

    private void replaceCommand(T token) {
        this.ltoken.removeItemAt(0);
        this.ltoken.add(0, this.setCommand(token));
    }

    private int getPrefixToken() {
        this.ident = this.script.substring(this.ichToken, this.ichToken + this.cchToken);
        this.identLC = this.ident.toLowerCase();
        boolean isUserVar = this.lastToken.tok != 0x40000200 && !this.isDotDot && this.isContextVariable(this.identLC);
        String myName = this.ident;
        String preserveCase = null;
        if (this.nTokens == 0) {
            this.isUserToken = isUserVar;
        }
        if (this.nTokens == 1 && (this.tokCommand == 134320141 || this.tokCommand == 102436 || this.tokCommand == 36868) || this.nTokens != 0 && isUserVar || !this.isDotDot && this.isUserFunction(this.identLC) && (preserveCase = this.ident) != null && (this.thisFunction == null || !this.thisFunction.name.equals(this.identLC))) {
            this.ident = preserveCase == null ? this.identLC : preserveCase;
            this.theToken = null;
        } else if (this.ident.length() == 1 || this.lastToken.tok == 0x10000022) {
            this.theToken = T.getTokenFromName(this.ident);
            if (this.theToken == null && (this.theToken = T.getTokenFromName(this.identLC)) != null) {
                this.theToken = T.tv(this.theToken.tok, this.theToken.intValue, this.ident);
            }
        } else {
            this.theToken = T.getTokenFromName(this.identLC);
            if (isUserVar && this.theToken != null && !this.theToken.value.toString().equalsIgnoreCase(this.identLC)) {
                this.theToken = null;
            }
            if (this.theToken != null) {
                switch (this.lastToken.tok) {
                    case 0x10000030: 
                    case 0x10000040: 
                    case 0x40000200: {
                        this.theToken = T.o(this.theToken.tok, this.ident);
                    }
                }
            }
        }
        if (this.theToken == null) {
            this.theToken = SV.newSV(this.identLC.indexOf("property_") == 0 ? 1715472409 : 0x40000000, Integer.MAX_VALUE, this.ident).setName(myName);
        }
        this.theTok = this.theToken.tok;
        return this.theTok;
    }

    /*
     * Unable to fully structure code
     */
    private int checkSpecialParameterSyntax() {
        if (this.lookingAtString(this.implicitString == false)) {
            if (this.cchToken < 0) {
                return this.ERROR(4);
            }
            str = this.getUnescapedStringLiteral(this.lastToken != null && this.iHaveQuotedString == false && this.lastToken.tok != 0x400000A0 && (this.tokCommand == 36867 && this.nTokens == 2 && this.lastToken.tok == 545259546 || this.tokCommand == 134222849 || this.tokCommand == 1610616835 || this.tokCommand == 134222850 || this.tokCommand == 4124));
            this.iHaveQuotedString = true;
            if ((this.tokCommand == 134222849 || this.tokCommand == 135174) && this.lastToken.tok == 134221834 || this.tokCommand == 134221834 && str.indexOf("@") < 0) {
                if (!this.getData(str)) {
                    return this.ERROR(11, "data");
                }
            } else {
                this.addTokenToPrefix(T.o(4, str));
                if (this.implicitString) {
                    this.ichEnd = this.ichToken + this.cchToken;
                    this.isEndOfCommand = true;
                }
            }
            return 2;
        }
        if (this.nTokens == this.ptNewSetModifier) {
            ch = this.script.charAt(this.ichToken);
            isAndEquals = "+-\\*/&|=".indexOf(ch) >= 0;
            isOperation = isAndEquals != false || ch == '.' || ch == '[';
            ch2 = this.charAt(this.ichToken + 1);
            if (!this.isNewSet && this.isUserToken && isOperation && (ch == '=' || ch2 == ch || ch2 == '=')) {
                this.isNewSet = true;
            }
            if (this.isNewSet || this.tokCommand == 36867 || T.tokAttr(this.tokCommand, 0x20000000)) {
                if (ch == '=') {
                    this.setEqualPt = this.ichToken;
                }
                if (T.tokAttr(this.tokCommand, 0x20000000) && ch == '=' || (this.isNewSet || this.isSetBrace) && isOperation) {
                    this.setCommand(isAndEquals != false ? T.tokenSet : (ch == '[' && this.isSetBrace == false || ch == '.' && ch2 == '.' ? T.tokenSetArray : T.tokenSetProperty));
                    this.ltoken.add(0, this.tokenCommand);
                    this.cchToken = 1;
                    switch (ch) {
                        case '[': {
                            this.tokLastMath = 1;
                            this.addTokenToPrefix(T.tokenArrayOpen);
                            ++this.bracketCount;
                            return 2;
                        }
                        case '.': {
                            if (ch2 == '.') {
                                this.addTokenToPrefix(T.tokenArrayOpen);
                                this.cchToken = 2;
                                this.isDotDot = true;
                                return 2;
                            }
                            this.addTokenToPrefix(T.o(0x40000200, "."));
                            return 2;
                        }
                        case '&': 
                        case '*': 
                        case '+': 
                        case '-': 
                        case '/': 
                        case '\\': 
                        case '|': {
                            if (ch2 == '\u0000') {
                                return this.ERROR(4);
                            }
                            if (ch2 == ch || ch2 == '=') break;
                            return this.ERROR(1, "\"" + ch + "\"");
                        }
                        default: {
                            this.lastToken = T.tokenMinus;
                            return 2;
                        }
                    }
                }
            }
        }
        block6 : switch (this.tokCommand) {
            case 134222350: {
                switch (this.lastToken.tok) {
                    case 4120: 
                    case 1073877010: 
                    case 1296041986: 
                    case 1715472409: {
                        if (this.nTokens != 2) break;
                        this.iHaveQuotedString = true;
                        break;
                    }
                    case 1073741925: 
                    case 1073742189: {
                        break;
                    }
                    default: {
                        if (this.iHaveQuotedString || this.nTokens == 2) break;
                        return 0;
                    }
                }
            }
            case 4124: 
            case 134222849: 
            case 134222850: 
            case 1275072526: {
                if (this.script.charAt(this.ichToken) == '@') {
                    this.iHaveQuotedString = true;
                    return 0;
                }
                switch (this.tokCommand) {
                    case 4124: {
                        this.haveMacro = true;
                        break block6;
                    }
                    case 134222849: {
                        v0 = isAppend = this.tokAt(1) == 0x4000000F;
                        if (this.nTokens != 1 && (!isAppend || this.nTokens != 2 && (this.nTokens != 3 || this.tokAt(2) != 2))) ** GOTO lbl94
                        if (isAppend && this.nTokens == 2 && PT.isDigit(this.charAt(this.ichToken))) break block6;
                        isDataBase = Viewer.isDatabaseCode(this.charAt(this.ichToken));
                        if (this.lookingAtLoadFormat(isDataBase)) {
                            strFormat = this.script.substring(this.ichToken, this.ichToken + this.cchToken);
                            token = T.getTokenFromName(strFormat.toLowerCase());
                            switch (token == null ? 0 : token.tok) {
                                case 4130: 
                                case 36868: 
                                case 0x4000000F: 
                                case 1073742015: 
                                case 1073742077: 
                                case 1073877011: 
                                case 1610616855: {
                                    if (this.nTokens != 1) {
                                        return 4;
                                    }
                                }
                                case 134218757: 
                                case 134221834: 
                                case 0x2000000E: 
                                case 1073741849: 
                                case 1073741851: 
                                case 0x400000A0: 
                                case 1094717454: 
                                case 1228935687: {
                                    this.addTokenToPrefix(token);
                                    break;
                                }
                                default: {
                                    v1 = isDataBase != false ? 4 : (tok = PT.isOneOf(strFormat = strFormat.toLowerCase(), ";xyz;vxyz;vibration;temperature;occupancy;partialcharge;") != false ? 0x40000000 : 0);
                                    if (tok == 0) break;
                                    this.addTokenToPrefix(T.o(tok, strFormat));
                                    this.iHaveQuotedString = tok == 4;
                                }
                            }
                            return 2;
                        }
                        ** GOTO lbl99
lbl94:
                        // 1 sources

                        if (this.script.charAt(this.ichToken) == '{' || this.parenCount > 0) break block6;
                        bs = this.lookingAtBitset();
                        if (bs != null) {
                            this.addTokenToPrefix(T.o(10, bs));
                            return 2;
                        }
                    }
lbl99:
                    // 4 sources

                    default: {
                        if (this.iHaveQuotedString || !this.lookingAtImpliedString(this.tokCommand == 134222350, this.tokCommand == 134222849, this.nTokens > 1 || this.tokCommand != 134222850 && this.tokCommand != 4124)) break block6;
                        str = this.script.substring(this.ichToken, this.ichToken + this.cchToken);
                        if (this.tokCommand == 134222850) {
                            if (str.startsWith("javascript:")) {
                                this.lookingAtImpliedString(true, true, true);
                                str = this.script.substring(this.ichToken, this.ichToken + this.cchToken);
                            } else if (str.toUpperCase().indexOf(".PUSH(") >= 0) {
                                this.cchToken = 0;
                                this.iHaveQuotedString = true;
                                return 2;
                            }
                        }
                        this.iHaveQuotedString = true;
                        this.addTokenToPrefix(T.o(4, str));
                        return 2;
                    }
                }
            }
            case 4156: {
                if (this.nTokens != 1 || !this.lookForSyncID()) break;
                ident = this.script.substring(this.ichToken, this.ichToken + this.cchToken);
                iident = PT.parseInt(ident);
                if (iident == -2147483648 || Math.abs(iident) < 1000) {
                    this.addTokenToPrefix(T.o(0x40000000, ident));
                } else {
                    this.addTokenToPrefix(T.i(iident));
                }
                return 2;
            }
            case 134221856: {
                if (this.nTokens == 2 && this.lastToken.tok == 4115) {
                    this.iHaveQuotedString = true;
                }
                if (this.iHaveQuotedString) break;
                if (this.script.charAt(this.ichToken) == '@') {
                    this.iHaveQuotedString = true;
                    return 0;
                }
                if (!this.lookingAtImpliedString(true, true, true)) break;
                str = this.script.substring(this.ichToken, this.ichToken + this.cchToken);
                pt = str.indexOf(" as ");
                if (pt > 0) {
                    this.cchToken = pt;
                    str = str.substring(0, this.cchToken);
                }
                if (str.indexOf(" ") >= 0 || str.indexOf(".") < 0) break;
                this.addTokenToPrefix(T.o(4, str));
                this.iHaveQuotedString = true;
                return 2;
            }
        }
        this.implicitString &= this.nTokens == 1;
        if (this.implicitString && (this.tokCommand != 134222850 && this.tokCommand != 4124 || !this.iHaveQuotedString) && this.lookingAtImpliedString(true, true, true)) {
            str = this.script.substring(this.ichToken, this.ichToken + this.cchToken);
            if (this.tokCommand == 1825200146 && PT.isOneOf(str.toLowerCase(), ";on;off;hide;display;")) {
                this.addTokenToPrefix(T.getTokenFromName(str.toLowerCase()));
            } else {
                this.addTokenToPrefix(T.o(4, str));
            }
            return 2;
        }
        if (this.lookingAtObjectID()) {
            this.addTokenToPrefix(T.getTokenFromName("$"));
            this.addTokenToPrefix(T.o(0x40000000, this.script.substring(this.ichToken, this.ichToken + this.cchToken)));
            return 2;
        }
        value = this.lookingAtExponential();
        if (!Float.isNaN(value)) {
            this.addNumber(3, 0x7FFFFFFF, Float.valueOf(value));
            return 2;
        }
        if (this.lookingAtDecimal()) {
            value = PT.fVal(this.script.substring(this.ichToken, this.ichToken + this.cchToken));
            intValue = ScriptParam.getFloatEncodedInt(this.script.substring(this.ichToken, this.ichToken + this.cchToken));
            this.addNumber(3, intValue, Float.valueOf(value));
            return 2;
        }
        if (this.lookingAtSeqcode()) {
            ch = this.script.charAt(this.ichToken);
            try {
                seqNum = ch == '*' || ch == '^' ? 0x7FFFFFFF : Integer.parseInt(this.script.substring(this.ichToken, this.ichToken + this.cchToken - 2));
                insertionCode = this.script.charAt(this.ichToken + this.cchToken - 1);
                if (insertionCode == '^') {
                    insertionCode = ' ';
                }
                if (seqNum < 0) {
                    seqNum = -seqNum;
                    this.addTokenToPrefix(T.tokenMinus);
                }
                seqcode = Group.getSeqcodeFor(seqNum, insertionCode);
                this.addTokenToPrefix(T.tv(5, seqcode, "seqcode"));
            }
            catch (NumberFormatException nfe) {
                return this.ERROR(9, "" + ch);
            }
            return 2;
        }
        val = this.lookingAtInteger();
        if (val != 0x7FFFFFFF) {
            intString = this.script.substring(this.ichToken, this.ichToken + this.cchToken);
            if (this.tokCommand == 102407 || this.tokCommand == 102408) {
                if (this.nTokens != 1) {
                    return this.ERROR(0);
                }
                if (this.flowContext == null) {
                    v2 = null;
                } else {
                    val = Math.abs(val);
                    v2 = f = this.flowContext.getBreakableContext(val);
                }
                if (f == null) {
                    return this.ERROR(1, (String)this.tokenCommand.value);
                }
                this.tokenAt((int)0).intValue = f.pt0;
            }
            this.addNumber(2, val, intString);
            return 2;
        }
        if (!this.isMathExpressionCommand && this.parenCount == 0 || this.lastToken.tok != 0x40000000 && !ScriptCompiler.tokenAttr(this.lastToken, 0x8000000)) {
            isBondOrMatrix = this.script.charAt(this.ichToken) == '[';
            bs = this.lookingAtBitset();
            if (bs != null) {
                this.addTokenToPrefix(T.o(10, isBondOrMatrix != false ? BondSet.newBS(bs, null) : bs));
                return 2;
            }
            if (isBondOrMatrix && (m = this.lookingAtMatrix()) instanceof M34) {
                this.addTokenToPrefix(T.o(m instanceof M4 != false ? 12 : 11, m));
                return 2;
            }
        }
        return 0;
    }

    private void addNumber(int tok, int i, Object v) {
        this.addTokenToPrefix(this.afterWhite == this.ichToken ? SV.newSV(tok, i, v) : T.tv(tok, i, v));
    }

    private Object lookingAtMatrix() {
        Object m;
        int ipt;
        if (this.ichToken + 4 >= this.cchScript || this.script.charAt(this.ichToken) != '[' || this.script.charAt(this.ichToken + 1) != '[' || (ipt = this.script.indexOf("]]", this.ichToken)) < 0 || (m = Escape.unescapeMatrix(this.script.substring(this.ichToken, ipt + 2))) == null) {
            return null;
        }
        this.cchToken = ipt + 2 - this.ichToken;
        return m;
    }

    private int parseKnownToken() {
        int tok = this.getPrefixToken();
        if (this.isDotDot) {
            if (tok == 0x10000040) {
                ++this.bracketCount;
            } else {
                this.addTokenToPrefix(T.o(4, this.ident));
                this.addTokenToPrefix(T.tokenArrayClose);
            }
            this.isDotDot = false;
            return 2;
        }
        if (this.tokLastMath != 0) {
            this.tokLastMath = tok;
        }
        if (this.flowContext != null && this.flowContext.token.tok == 102410 && this.flowContext.var != null && tok != 102411 && tok != 102413 && this.lastToken.tok != 102410) {
            return this.ERROR(1, this.ident);
        }
        if (this.lastToken.tok == 12290 && tok != 1073742332 && this.nTokens != 1) {
            this.addTokenToPrefix(tok == 12290 ? this.lastToken : T.o(4, this.ident));
            return 2;
        }
        switch (tok) {
            case 0x40000000: {
                if (this.nTokens != 0 || this.checkImpliedScriptCmd) break;
                if (this.ident.charAt(0) == '\'') {
                    this.addTokenToPrefix(this.setCommand(T.tokenScript));
                    this.cchToken = 0;
                    return 2;
                }
                if (this.charAt(this.ichToken + this.cchToken) != '.') break;
                this.addTokenToPrefix(this.setCommand(T.tokenScript));
                this.nTokens = 1;
                this.cchToken = 0;
                this.checkImpliedScriptCmd = true;
                return 2;
            }
            case 268435666: {
                if (this.nSemiSkip == this.forPoint3 && this.nTokens == this.ptSemi + 2) {
                    T token = this.lastToken;
                    this.addTokenToPrefix(T.tokenEquals);
                    this.addTokenToPrefix(token);
                    token = T.getTokenFromName(this.ident.substring(0, 1));
                    this.addTokenToPrefix(token);
                    this.addTokenToPrefix(T.tokenLeftParen);
                    this.needRightParen = true;
                    return 2;
                }
                this.checkNewSetCommand();
                if (this.tokCommand == 36867) {
                    this.tokenAndEquals = T.getTokenFromName(this.ident.substring(0, 1));
                    this.setEqualPt = this.ichToken;
                    return 0;
                }
                if (this.tokCommand == 554176565 || this.tokCommand == 554176526) {
                    this.addTokenToPrefix(this.tokenCommand);
                    this.replaceCommand(T.tokenSet);
                    this.tokenAndEquals = T.getTokenFromName(this.ident.substring(0, 1));
                    this.setEqualPt = this.ichToken;
                    return 0;
                }
                return 2;
            }
            case 0x100000C1: 
            case 268435650: {
                if (this.afterWhite == this.ichToken || this.afterMath == this.ichToken) {
                    this.theToken = T.tv(this.theToken.tok, -1, this.theToken.value);
                }
                if (!this.isNewSet && this.nTokens == 1) {
                    this.checkNewSetCommand();
                }
                if (this.isNewSet && this.parenCount == 0 && this.bracketCount == 0 && this.ichToken <= this.setEqualPt) {
                    this.tokenizePlusPlus(tok, false);
                    return 2;
                }
                if (this.nSemiSkip != this.forPoint3 || this.nTokens != this.ptSemi + 2) break;
                T token = this.lastToken;
                this.addTokenToPrefix(T.tokenEquals);
                this.addTokenToPrefix(token);
                this.addTokenToPrefix(tok == 0x100000C1 ? T.tokenMinus : T.tokenPlus);
                this.addTokenToPrefix(T.i(1));
                return 2;
            }
            case 268435860: {
                if (this.parenCount != 0 || this.bracketCount != 0) break;
                this.setEqualPt = this.ichToken;
                break;
            }
            case 0x40000200: {
                if (this.tokCommand != 36867 || this.parenCount != 0 || this.bracketCount != 0 || this.ichToken >= this.setEqualPt || this.ltoken.size() <= 1 || ((T)this.ltoken.get((int)1)).tok != 1073742332) break;
                this.ltoken.set(0, T.tokenSetProperty);
                this.ltoken.add(1, T.tokenExpressionBegin);
                this.addTokenToPrefix(T.tokenExpressionEnd);
                this.setEqualPt = 0;
                break;
            }
            case 1073742332: {
                if (++this.braceCount == 1 && this.parenCount == 0 && this.checkFlowStartBrace(false)) {
                    ScriptFlowContext f;
                    this.isEndOfCommand = true;
                    ScriptFlowContext scriptFlowContext = f = this.flowContext != null && this.flowContext.addLine == 0 || this.forceFlowContext == null ? this.flowContext : this.forceFlowContext;
                    if (f != null) {
                        f.addLine = 0;
                        f.forceEndIf = false;
                        this.lastToken = T.tokenLeftBrace;
                        this.forceFlowContext = f;
                    }
                    return 2;
                }
                ++this.parenCount;
                break;
            }
            case 0x10000010: {
                ++this.parenCount;
                if (this.nTokens <= 1 || this.lastToken.tok != 1275082245 && this.lastToken.tok != 134320648 && this.lastToken.tok != 134320649) break;
                this.nSemiSkip += 2;
                break;
            }
            case 0x40000202: {
                if (this.iBrace > 0 && this.parenCount == 0 && this.braceCount == 0) {
                    this.ichBrace = this.ichToken;
                    if (this.nTokens == 0) {
                        this.parenCount = 1;
                        this.braceCount = 1;
                    } else {
                        if (!this.wasImpliedScript()) {
                            this.nSemiSkip = 0;
                            this.parenCount = 0;
                            this.braceCount = 0;
                            this.addBrace(this.theToken);
                            this.isEndOfCommand = true;
                            this.ichEnd = this.ichToken;
                        }
                        return 2;
                    }
                }
                --this.braceCount;
            }
            case 0x10000011: {
                if (--this.parenCount < 0) {
                    return this.ERROR(16, this.ident);
                }
                if (this.parenCount == 0) {
                    this.nSemiSkip = 0;
                }
                if (!this.needRightParen) break;
                this.addTokenToPrefix(T.tokenRightParen);
                this.needRightParen = false;
                break;
            }
            case 0x10000040: {
                if (this.ichToken > 0 && PT.isWhitespace(this.script.charAt(this.ichToken - 1))) {
                    this.addTokenToPrefix(T.tokenSpaceBeforeSquare);
                }
                ++this.bracketCount;
                break;
            }
            case 0x10000041: {
                --this.bracketCount;
                if (this.bracketCount >= 0) break;
                return this.ERROR(16, "]");
            }
            case 1073742337: {
                this.isDotDot = true;
                this.addTokenToPrefix(T.tokenArrayOpen);
                return 2;
            }
        }
        switch (this.lastToken.tok) {
            case 0x10000030: 
            case 0x10000040: 
            case 0x40000200: 
            case 1073742337: {
                return 0;
            }
        }
        switch (tok) {
            case 102409: {
                if (this.tokCommand == 135174 || this.tokCommand == 4103 && this.nTokens == 1) {
                    return 0;
                }
                if (!this.haveENDIF) {
                    return 5;
                }
            }
            case 364548: {
                if (this.flowContext != null) {
                    this.flowContext.forceEndIf = false;
                }
            }
            case 364547: {
                if (this.nTokens <= 0) break;
                this.isEndOfCommand = true;
                this.cchToken = 0;
                return 2;
            }
            case 102402: 
            case 102406: 
            case 102410: 
            case 102411: 
            case 102412: 
            case 102413: 
            case 134320648: 
            case 134320649: {
                if (this.nTokens <= 1 || this.tokCommand == 36867 || this.nSemiSkip != 0) break;
                this.isEndOfCommand = true;
                if (this.flowContext != null) {
                    this.flowContext.forceEndIf = true;
                }
                this.cchToken = 0;
                return 2;
            }
        }
        return 0;
    }

    private void tokenizePlusPlus(int tok, boolean isPlusPlusX) {
        if (isPlusPlusX) {
            this.setCommand(T.tokenSet);
            if (this.nTokens == 1) {
                this.ltoken.add(0, this.tokenCommand);
            }
        }
        this.nTokens = this.ltoken.size();
        this.addTokenToPrefix(T.tokenEquals);
        this.setEqualPt = 0;
        for (int i = 1; i < this.nTokens; ++i) {
            this.addTokenToPrefix((T)this.ltoken.get(i));
        }
        this.addTokenToPrefix(tok == 0x100000C1 ? T.tokenMinus : T.tokenPlus);
        this.addTokenToPrefix(T.i(1));
    }

    private boolean checkNewSetCommand() {
        String name = ((T)this.ltoken.get((int)0)).value.toString();
        if (!this.isContextVariable(name.toLowerCase())) {
            return false;
        }
        T t = this.setNewSetCommand(false, name);
        this.setCommand(T.tokenSet);
        this.ltoken.add(0, this.tokenCommand);
        this.ltoken.set(1, t);
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private int parseCommandParameter(short iLine, boolean isFull) {
        this.nTokens = this.ltoken.size();
        block0 : switch (this.tokCommand) {
            case 0: {
                this.lastToken = T.tokenOff;
                this.ichCurrentCommand = this.ichEnd = this.ichToken;
                this.setCommand(this.theToken);
                if (this.logMessages) {
                    Logger.info("compiling " + this.theToken);
                }
                if (isFlowCmd = T.tokAttr(this.tokCommand, 102400)) {
                    this.lastFlowCommand = this.tokenCommand;
                }
                if ((ret = this.checkFlowEndBrace()) == 4) {
                    return 4;
                }
                if (ret == 2) {
                    this.isEndOfCommand = true;
                    this.cchToken = 0;
                    if (this.theTok == 0x10000010) {
                        --this.parenCount;
                    }
                    return 2;
                }
                switch (this.theTok) {
                    case 1073742332: {
                        break;
                    }
                    case 0x10000022: {
                        ++this.braceCount;
                        this.isEndOfCommand = true;
                        return 0;
                    }
                    case 102409: {
                        return 0;
                    }
                    case 102402: 
                    case 364547: {
                        this.fixFlowAddLine(this.flowContext);
                        if (((T[])this.lltoken.get((int)(this.iCommand - 1)))[0].tok != 102409 || this.forceFlowContext == null || !this.forceFlowContext.forceEndIf || this.forceFlowContext.addLine <= 0 || !this.isFlowIfContextOK(this.forceFlowContext)) ** GOTO lbl37
                        this.flowContext = this.forceFlowContext;
                        this.flowContext.forceEndIf = true;
                        this.lltoken.removeItemAt(--this.iCommand);
                        ** GOTO lbl48
lbl37:
                        // 1 sources

                        if (this.flowContext != null && this.flowContext.addLine > 0) {
                            while (this.flowContext != null && !this.isFlowIfContextOK(this.flowContext) && this.flowContext.checkForceEndIf(0)) {
                                this.forceFlowEnd(this.flowContext.token);
                                this.processTokenList(iLine, isFull);
                                this.fixFlowAddLine(this.flowContext);
                                this.setCommand(this.theToken);
                                this.theTok = this.theToken.tok;
                            }
                        }
                    }
lbl48:
                    // 5 sources

                    default: {
                        if (isFlowCmd) {
                            switch (this.checkFlowCommand((String)this.tokenCommand.value)) {
                                case 4: {
                                    return 4;
                                }
                                case 2: {
                                    return 2;
                                }
                                case 5: {
                                    return 5;
                                }
                                case 0: {
                                    this.theToken = this.tokenCommand;
                                    if (this.theTok == 102411) {
                                        this.addTokenToPrefix(this.tokenCommand);
                                        this.theToken = T.tokenLeftParen;
                                    }
                                    return 0;
                                }
                            }
                        }
                        if (this.flowContext != null && !this.haveENDIF && this.flowContext.addLine > 0) {
                            this.fixFlowAddLine(this.flowContext);
                            while (this.flowContext != null && this.flowContext.checkForceEndIf(0)) {
                                this.forceFlowEnd(this.flowContext.token);
                                this.processTokenList(iLine, isFull);
                                this.setCommand(this.theToken);
                                this.theTok = this.theToken.tok;
                            }
                        }
                        if (this.theTok == 0x40000202) {
                            this.forceFlowContext = null;
                            this.addBrace(this.tokenCommand);
                            this.tokCommand = 0;
                            return 2;
                        }
                        this.lastFlowCommand = null;
                    }
                }
                if (this.theTok == 0x10000060) {
                    this.theToken = T.o(4143, "resume");
                    this.setCommand(this.theToken);
                    this.addTokenToPrefix(this.theToken);
                    this.theToken = T.o(14, "context");
                    return 0;
                }
                if (T.tokAttr(this.tokCommand, 4096)) break;
                v0 = this.isSetBrace = this.theTok == 1073742332;
                if (this.isSetBrace) {
                    if (!this.lookingAtSetBraceSyntax()) {
                        this.isEndOfCommand = true;
                        if (this.flowContext != null) {
                            this.flowContext.forceEndIf = false;
                        }
                    }
                } else {
                    switch (this.theTok) {
                        case 0x100000C1: 
                        case 268435650: {
                            this.tokInitialPlusPlus = this.theTok;
                            this.tokCommand = 0;
                            return 2;
                        }
                        case 12290: 
                        case 36868: 
                        case 0x10000010: 
                        case 0x40000000: {
                            break;
                        }
                        default: {
                            if (T.tokAttr(this.theTok, 0x40000000) || T.tokAttr(this.theTok, 0x20000000) || this.isContextVariable(this.identLC)) break;
                            this.commandExpected();
                            return 4;
                        }
                    }
                }
                this.theToken = this.setNewSetCommand(this.isSetBrace, this.ident);
                break;
            }
            case 102412: {
                switch (this.nTokens) {
                    case 1: {
                        if (this.theTok == 0x10000010) break block0;
                        return this.ERROR(15, "(");
                    }
                    case 2: {
                        if (this.theTok != 0x10000011) {
                            ((ContextToken)this.tokenCommand).name0 = this.ident;
                        }
                        this.newContextVariable(this.ident);
                        break block0;
                    }
                    case 3: {
                        if (this.theTok != 0x10000011) {
                            return this.ERROR(15, ")");
                        }
                        this.isEndOfCommand = true;
                        this.ichEnd = this.ichToken + 1;
                        this.flowContext.setLine();
                        break block0;
                    }
                }
                return this.ERROR(0);
            }
            case 102436: 
            case 134320141: {
                if (this.tokenCommand.intValue == 0) {
                    if (this.nTokens != 1) break;
                    this.tokenCommand.value = this.ident;
                    return 2;
                }
                if (this.nTokens == 1) {
                    if (this.thisFunction != null) {
                        this.vFunctionStack.add(0, this.thisFunction);
                    }
                    this.thisFunction = this.tokCommand == 102436 ? (ScriptFunction)Interface.getInterface("org.jmol.script.ScriptParallelProcessor", null, null) : new ScriptFunction(this.ident, this.tokCommand);
                    this.thisFunction.set(this.ident, this.tokCommand);
                    this.htUserFunctions.put(this.ident, Boolean.TRUE);
                    this.flowContext.setFunction(this.thisFunction);
                    break;
                }
                if (this.nTokens == 2) {
                    if (this.theTok == 0x10000010) break;
                    return this.ERROR(15, "(");
                }
                if (this.nTokens == 3 && this.theTok == 0x10000011) break;
                if (this.nTokens % 2 == 0) {
                    if (this.theTok == 0x10000030 || this.theTok == 0x10000011) break;
                    return this.ERROR(15, ")");
                }
                this.thisFunction.addVariable(this.ident, true);
                break;
            }
            case 102411: {
                if (this.nTokens <= 1 || this.parenCount != 0 || this.braceCount != 0 || this.theTok != 0x10000022) break;
                this.addTokenToPrefix(T.tokenRightParen);
                this.braceCount = 1;
                this.isEndOfCommand = true;
                this.cchToken = 0;
                return 2;
            }
            case 102413: {
                if (this.nTokens <= 1) break;
                this.braceCount = 1;
                this.isEndOfCommand = true;
                this.cchToken = 0;
                return 2;
            }
            case 364547: {
                if (this.nTokens == 1 && this.theTok != 134320649) {
                    this.isEndOfCommand = true;
                    this.cchToken = 0;
                    return 2;
                }
                if (this.nTokens != 1 || this.theTok != 134320649 && this.theTok != 1073742332) {
                    return this.ERROR(0);
                }
                this.flowContext.token = ContextToken.newCmd(102402, "elseif");
                this.replaceCommand(this.flowContext.token);
                this.tokCommand = 102402;
                return 2;
            }
            case 102409: {
                if (this.nTokens != 1) {
                    return this.ERROR(0);
                }
                if (!this.checkFlowEnd(this.theTok, this.ident, this.ichCurrentCommand, true)) {
                    return 4;
                }
                if (this.theTok != 134320141 && this.theTok != 102436) break;
                return 2;
            }
            case 134320648: {
                if (this.nTokens == 1) {
                    if (this.theTok != 0x10000010) {
                        return this.ERROR(19, this.ident);
                    }
                    this.nSemiSkip = 0;
                    this.forPoint3 = 0;
                    this.nSemiSkip += 2;
                    break;
                }
                if (this.nTokens == 3 && this.tokAt(2) == 36868) {
                    this.newContextVariable(this.ident);
                    break;
                }
                if ((this.nTokens == 3 || this.nTokens == 4) && this.theTok == 1275068432) {
                    this.nSemiSkip -= 2;
                    this.forPoint3 = 2;
                    this.addTokenToPrefix(this.theToken);
                    this.theToken = T.tokenLeftParen;
                    break;
                }
            }
            case 102402: 
            case 102406: 
            case 102410: 
            case 134320649: {
                if (this.nTokens <= 2 || this.braceCount != 0 || this.parenCount != 0) break;
            }
            case 102439: {
                this.isEndOfCommand = true;
                this.ichEnd = this.ichToken + 1;
                this.flowContext.setLine();
                break;
            }
            case 36868: {
                if (this.nTokens == 1) {
                    this.replaceCommand(T.tokenSetVar);
                    this.newContextVariable(this.ident);
                    break;
                }
                if (this.ident.equals(",")) {
                    return 2;
                }
                if (!PT.isLetter(this.ident.charAt(0))) {
                    if (this.nTokens != 2 || this.ident.equals("[")) {
                        return this.ERROR(0);
                    }
                    this.replaceCommand(T.tokenSet);
                } else {
                    this.newContextVariable(this.ident);
                    break;
                }
            }
            case 36867: {
                if (this.theTok == 1073742332) {
                    ++this.setBraceCount;
                } else if (this.theTok == 0x40000202) {
                    --this.setBraceCount;
                    if (this.isSetBrace && this.setBraceCount == 0 && this.ptNewSetModifier == 0x7FFFFFFF) {
                        this.ptNewSetModifier = this.nTokens + 1;
                    }
                }
                if (this.nTokens != this.ptNewSetModifier) break;
                token = this.tokenAt(0);
                if (this.theTok == 0x10000010 || this.isUserFunction(token.value.toString())) {
                    this.ltoken.set(0, this.setCommand(T.tv(0x40000000, 0, token.value)));
                    this.setBraceCount = 0;
                    break;
                }
                if (this.theTok != 0x40000000 && this.theTok != 268435666 && this.theTok != 12290 && !T.tokAttr(this.theTok, 0x20000000)) {
                    if (this.isNewSet) {
                        this.commandExpected();
                    } else {
                        this.errorIntStr2(18, "SET", ": " + this.ident);
                    }
                    return 4;
                }
                if (this.nTokens != 1 || this.lastToken.tok != 268435650 && this.lastToken.tok != 0x100000C1) break;
                this.replaceCommand(T.tokenSet);
                this.addTokenToPrefix(this.lastToken);
                break;
            }
            case 134222849: {
                if (this.theTok == 12290 && (this.nTokens == 1 || this.lastToken.tok == 0x40000074 || this.lastToken.tok == 134217764)) {
                    this.addTokenToPrefix(T.tokenDefineString);
                    return 2;
                }
                if (this.theTok != 1073741848) break;
                this.iHaveQuotedString = false;
                break;
            }
            case 12290: {
                if (this.nTokens == 1) {
                    if (this.theTok != 0x40000000) {
                        if (this.preDefining) {
                            if (!T.tokAttr(this.theTok, 0x200000)) {
                                this.errorStr2("ERROR IN Token.java or JmolConstants.java -- the following term was used in JmolConstants.java but not listed as predefinedset in Token.java: " + this.ident, null);
                                return 4;
                            }
                        } else if (T.tokAttr(this.theTok, 0x200000)) {
                            Logger.warn("WARNING: predefined term '" + this.ident + "' has been redefined by the user until the next file load.");
                        } else if (!this.isCheckOnly && this.ident.length() > 1) {
                            Logger.warn("WARNING: redefining " + this.ident + "; was " + this.theToken + "not all commands may continue to be functional for the life of the applet!");
                            this.theToken.tok = 0x40000000;
                            this.theTok = 0x40000000;
                            T.addToken(this.ident, this.theToken);
                        }
                    }
                    this.addTokenToPrefix(this.theToken);
                    this.lastToken = T.tokenComma;
                    return 2;
                }
                if (this.nTokens != 2 || this.theTok != 268435860) break;
                this.ltoken.add(0, T.tokenSet);
                return 2;
            }
            case 135180: 
            case 135188: 
            case 135190: {
                ch = this.charAt(this.ichToken + this.cchToken);
                if (this.parenCount != 0 || this.bracketCount != 0 || ".:/\\+-!?".indexOf(ch) < 0 || ch == '-' && this.ident.equals("=")) break;
                this.checkUnquotedFileName();
            }
        }
        return 0;
    }

    private T setNewSetCommand(boolean isSetBrace, String ident) {
        this.tokCommand = 36867;
        this.isNewSet = !isSetBrace && !this.isUserFunction(ident);
        this.setBraceCount = isSetBrace ? 1 : 0;
        this.bracketCount = 0;
        this.setEqualPt = Integer.MAX_VALUE;
        this.ptNewSetModifier = this.isNewSet ? (ident.equals("(") ? 2 : 1) : Integer.MAX_VALUE;
        return isSetBrace || this.theToken.tok == 0x10000010 || this.theToken.tok == 0x20000006 || this.theToken.tok == 268435650 || this.theToken.tok == 0x100000C1 ? this.theToken : T.o(0x40000000, ident);
    }

    private void checkUnquotedFileName() {
        char ch;
        int ichT = this.ichToken;
        while (++ichT < this.cchScript && !PT.isWhitespace(ch = this.script.charAt(ichT)) && ch != '#' && ch != ';' && ch != '}') {
        }
        String name = this.script.substring(this.ichToken, ichT).replace('\\', '/');
        this.cchToken = ichT - this.ichToken;
        this.theToken = T.o(4, name);
    }

    private boolean checkFlowStartBrace(boolean atEnd) {
        int tok = this.tokCommand;
        switch (tok) {
            default: {
                if (!T.tokAttr(tok, 102400)) break;
                if (atEnd) {
                    switch (tok) {
                        case 102411: 
                        case 102413: {
                            break;
                        }
                        default: {
                            this.flowContext.addLine = 0;
                            this.addBrace(this.tokenCommand);
                            this.lastFlowCommand = null;
                        }
                    }
                    this.braceCount = 0;
                    this.parenCount = 0;
                }
                return true;
            }
            case 102407: 
            case 102408: 
        }
        return false;
    }

    private int checkFlowEndBrace() {
        if (this.iBrace <= 0 || ((T)this.vBraces.get((int)(this.iBrace - 1))).tok != 0x40000202) {
            return 0;
        }
        this.vBraces.removeItemAt(--this.iBrace);
        T token = this.vBraces.removeItemAt(--this.iBrace);
        if (this.theTok == 1073742332) {
            --this.braceCount;
            --this.parenCount;
        }
        if (token.tok == 1275335685) {
            this.vPush.removeItemAt(--this.pushCount);
            this.addTokenToPrefix(this.setCommand(ContextToken.newContext(false)));
            this.isEndOfCommand = true;
            return 2;
        }
        switch (this.flowContext == null ? 0 : this.flowContext.token.tok) {
            case 102402: 
            case 364547: 
            case 134320649: {
                if (this.tokCommand != 364547 && this.tokCommand != 102402) break;
                return 0;
            }
            case 102410: 
            case 102411: 
            case 102413: {
                if (this.tokCommand != 102411 && this.tokCommand != 102413) break;
                return 0;
            }
        }
        return this.forceFlowEnd(token);
    }

    private int forceFlowEnd(T token) {
        T t0 = this.tokenCommand;
        this.forceFlowContext = this.flowContext;
        token = this.flowStart(token);
        if (!this.checkFlowEnd(token.tok, (String)token.value, this.ichBrace, false)) {
            return 4;
        }
        switch (token.tok) {
            case 102436: 
            case 364558: 
            case 134320141: {
                break;
            }
            default: {
                this.addTokenToPrefix(token);
            }
        }
        this.setCommand(t0);
        return 2;
    }

    private T flowStart(T token) {
        switch (token.tok) {
            case 102402: 
            case 364547: 
            case 134320649: {
                return T.tokenIf;
            }
            case 102411: 
            case 102413: {
                return T.tokenSwitch;
            }
        }
        return T.getTokenFromName((String)token.value);
    }

    static boolean isBreakableContext(int tok) {
        return tok == 134320648 || tok == 102439 || tok == 102406 || tok == 102411 || tok == 102413;
    }

    private int checkFlowCommand(String ident) {
        int pt = this.lltoken.size();
        switch (this.tokCommand) {
            case 364548: {
                if (!this.isFlowIfContextOK(this.flowContext)) {
                    if (!this.haveENDIF) {
                        return 5;
                    }
                    this.errorStr(1, ident);
                    return 4;
                }
                this.flowContext.token.intValue = this.flowContext.setPt0(pt, false);
                this.setFlowEnd(this.tokCommand, ident);
                this.flowContext = this.flowContext.parent;
                return 0;
            }
            case 102407: 
            case 102408: {
                ScriptFlowContext f;
                ScriptFlowContext scriptFlowContext = f = this.flowContext == null ? null : this.flowContext.getBreakableContext(0);
                if (this.tokCommand == 102408) {
                    while (f != null && f.token.tok != 134320648 && f.token.tok != 102406) {
                        f = f.parent;
                    }
                }
                if (f == null) {
                    this.errorStr(1, ident);
                    return 4;
                }
                this.setCommand(T.tv(this.tokCommand, f.pt0, ident));
                this.theToken = this.tokenCommand;
                return 1;
            }
            case 102436: 
            case 134320141: {
                if (this.flowContext == null) break;
                this.errorStr(1, T.nameOf(this.tokCommand));
                return 4;
            }
            case 102406: 
            case 102410: 
            case 102412: 
            case 102439: 
            case 364558: 
            case 134320648: 
            case 134320649: {
                break;
            }
            case 102402: 
            case 364547: {
                if (this.flowContext != null && !this.isFlowIfContextOK(this.flowContext)) {
                    this.flowContext = this.flowContext.parent;
                }
                if (!this.isFlowIfContextOK(this.flowContext)) {
                    if (!this.haveENDIF) {
                        return 5;
                    }
                    this.errorStr(1, ident);
                    return 4;
                }
                this.flowContext.token.intValue = this.flowContext.setPt0(pt, false);
                break;
            }
            case 102411: 
            case 102413: {
                if (this.flowContext == null || this.flowContext.token.tok != 102410 && this.flowContext.token.tok != 102411 && (this.tokCommand == 102413 ? this.flowContext.ptDefault > 0 : this.flowContext.token.tok != 102413)) {
                    this.errorStr(1, ident);
                    return 4;
                }
                this.flowContext.token.intValue = this.flowContext.setPt0(pt, this.tokCommand == 102413);
            }
        }
        ContextToken ct = ContextToken.newCmd(this.tokCommand, this.tokenCommand.value);
        if (this.tokCommand == 102410) {
            ct.addName("_var");
        }
        this.setCommand(ct);
        switch (this.tokCommand) {
            case 364558: {
                this.flowContext = new ScriptFlowContext(this, ct, pt, this.flowContext, this.ichCurrentCommand, this.lineCurrent);
                if (this.thisFunction != null) {
                    this.vFunctionStack.add(0, this.thisFunction);
                }
                this.thisFunction = new ScriptFunction("", 364558);
                this.flowContext.setFunction(this.thisFunction);
                this.pushContext(ct);
                break;
            }
            case 102411: 
            case 102413: {
                ct.contextVariables = this.flowContext.token.contextVariables;
            }
            case 102402: 
            case 364547: {
                this.flowContext.token = ct;
                break;
            }
            case 102406: 
            case 102412: 
            case 102439: 
            case 134320648: {
                this.pushContext(ct);
            }
            default: {
                this.flowContext = new ScriptFlowContext(this, ct, pt, this.flowContext, this.ichCurrentCommand, this.lineCurrent);
            }
        }
        return 0;
    }

    private void setFlowEnd(int tokCommand, String ident) {
        this.setCommand(T.tv(tokCommand, this.flowContext.ptDefault > 0 ? this.flowContext.ptDefault : -this.flowContext.pt0, ident));
    }

    private boolean isFlowIfContextOK(ScriptFlowContext f) {
        switch (f == null ? 0 : f.token.tok) {
            case 102402: 
            case 134320649: {
                return true;
            }
            case 364547: {
                return this.tokCommand != 364547;
            }
        }
        return false;
    }

    private boolean checkFlowEnd(int tok, String ident, int pt1, boolean isExplicitEnd) {
        if (isExplicitEnd) {
            if (this.flowContext == null) {
                return this.errorStr(1, "end " + ident);
            }
            this.flowContext.addLine = 0;
            this.flowContext.forceEndIf = false;
            switch (this.flowContext.token.tok) {
                case 102436: 
                case 364558: 
                case 134320141: {
                    break;
                }
                default: {
                    this.setFlowEnd(102409, "end");
                    this.ltoken.set(0, this.tokenCommand);
                    break;
                }
            }
        } else {
            this.setFlowEnd(102409, "end");
            this.addTokenToPrefix(this.tokenCommand);
        }
        if (this.flowContext == null || tok != this.flowContext.tok0) {
            return this.errorStr(1, "end " + ident);
        }
        int pt = this.lltoken.size();
        this.flowContext.token.intValue = this.tokCommand == 102412 ? -pt : pt;
        switch (tok) {
            case 102410: 
            case 134320649: {
                break;
            }
            case 102406: 
            case 102412: 
            case 102439: 
            case 134320648: {
                if (isExplicitEnd) break;
                this.vPush.removeItemAt(--this.pushCount);
                break;
            }
            case 102436: 
            case 364558: 
            case 134320141: {
                if (!this.isCheckOnly) {
                    this.addTokenToPrefix(T.o(tok, this.thisFunction));
                    ScriptFunction.setFunction(this.thisFunction, this.script, pt1, this.lltoken.size(), this.lineNumbers, this.lineIndices, this.lltoken);
                }
                this.thisFunction = this.vFunctionStack.size() == 0 ? null : this.vFunctionStack.removeItemAt(0);
                this.tokenCommand.intValue = 0;
                if (tok != 364558) break;
                this.vPush.removeItemAt(--this.pushCount);
                break;
            }
            default: {
                return this.errorStr(19, "end " + ident);
            }
        }
        this.flowContext = this.flowContext.parent;
        this.fixFlowAddLine(this.flowContext);
        return true;
    }

    private void fixFlowAddLine(ScriptFlowContext flowContext) {
        while (flowContext != null) {
            if (flowContext.addLine > 0 || flowContext.forceEndIf) {
                flowContext.addLine = this.lineCurrent - flowContext.ptLine;
                flowContext.forceEndIf = true;
            }
            flowContext = flowContext.parent;
        }
    }

    private boolean getData(String key) {
        int i;
        this.addTokenToPrefix(T.o(4, key));
        this.ichToken += key.length() + 2;
        if (this.charAt(this.ichToken) == '\r') {
            this.lineCurrent = (short)(this.lineCurrent + 1);
            ++this.ichToken;
        }
        if (this.charAt(this.ichToken) == '\n') {
            this.lineCurrent = (short)(this.lineCurrent + 1);
            ++this.ichToken;
        }
        if ((i = this.script.indexOf(this.chFirst + key + this.chFirst, this.ichToken) - 4) < 0 || !this.script.substring(i, i + 4).equalsIgnoreCase("END ")) {
            return false;
        }
        String str = this.script.substring(this.ichToken, i);
        this.incrementLineCount(str);
        this.addTokenToPrefix(T.o(134221834, str));
        this.addTokenToPrefix(T.o(0x40000000, "end"));
        this.addTokenToPrefix(T.o(4, key));
        this.cchToken = i - this.ichToken + key.length() + 6;
        return true;
    }

    private int incrementLineCount(String str) {
        int pt = str.indexOf(13);
        int pt2 = str.indexOf(10);
        if (pt < 0 && pt2 < 0) {
            return 0;
        }
        short n = this.lineCurrent;
        if (pt < 0 || pt2 < pt) {
            pt = pt2;
        }
        int i = str.length();
        while (--i >= pt) {
            char ch = str.charAt(i);
            if (ch != '\n' && ch != '\r') continue;
            this.lineCurrent = (short)(this.lineCurrent + 1);
        }
        return this.lineCurrent - n;
    }

    private static boolean isSpaceOrTab(char ch) {
        return ch == ' ' || ch == '\t';
    }

    private boolean eol(char ch) {
        return ch == '\u0000' || ch == '\r' || ch == '\n' || ch == ';' && this.nSemiSkip <= 0;
    }

    private boolean lookingAtSetBraceSyntax() {
        int ichT = this.ichToken;
        int nParen = 1;
        while (++ichT < this.cchScript && nParen > 0) {
            switch (this.script.charAt(ichT)) {
                case '{': {
                    ++nParen;
                    break;
                }
                case '}': {
                    --nParen;
                }
            }
        }
        if (this.charAt(ichT) == '[' && ++nParen == 1) {
            while (++ichT < this.cchScript && nParen > 0) {
                switch (this.script.charAt(ichT)) {
                    case '[': {
                        ++nParen;
                        break;
                    }
                    case ']': {
                        if (this.charAt(ichT + 1) == '[') {
                            ++ichT;
                            break;
                        }
                        --nParen;
                    }
                }
            }
        }
        return this.charAt(ichT) == '.' && nParen == 0;
    }

    private boolean lookingAtString(boolean allowPrime) {
        char ch;
        if (this.ichToken + 2 > this.cchScript) {
            return false;
        }
        this.chFirst = this.script.charAt(this.ichToken);
        if (!(this.chFirst == '\"' || allowPrime && this.chFirst == '\'')) {
            return false;
        }
        int ichT = this.ichToken;
        boolean previousCharBackslash = false;
        while (++ichT < this.cchScript && ((ch = this.script.charAt(ichT)) != this.chFirst || previousCharBackslash)) {
            previousCharBackslash = ch == '\\' ? !previousCharBackslash : false;
        }
        if (ichT == this.cchScript) {
            this.cchToken = -1;
            this.ichEnd = this.cchScript;
        } else {
            this.cchToken = ++ichT - this.ichToken;
        }
        return true;
    }

    private String getUnescapedStringLiteral(boolean isFileName) {
        if (isFileName) {
            String s = this.script.substring(this.ichToken + 1, this.ichToken + this.cchToken - 1);
            if (s.indexOf("\\u") >= 0) {
                s = Escape.unescapeUnicode(s);
            }
            if (s.indexOf(";base64,") != 0) {
                return s;
            }
        }
        return ScriptCompiler.unescapeString(this.script, this.ichToken + 1, this.cchToken - 2);
    }

    public static String unescapeString(String script, int ich, int nChar) {
        SB sb = SB.newN(nChar);
        int ichMax = ich + nChar;
        while (ich < ichMax) {
            int ch;
            if ((ch = script.charAt(ich++)) == 92 && ich < ichMax) {
                ch = script.charAt(ich++);
                switch (ch) {
                    case 110: {
                        ch = 10;
                        break;
                    }
                    case 116: {
                        ch = 9;
                        break;
                    }
                    case 114: {
                        ch = 13;
                    }
                    case 34: 
                    case 39: 
                    case 92: {
                        break;
                    }
                    case 117: 
                    case 120: {
                        char chT;
                        int hexit;
                        int digitCount;
                        int n = digitCount = ch == 120 ? 2 : 4;
                        if (ich >= ichMax) break;
                        int unicode = 0;
                        int k = digitCount;
                        while (--k >= 0 && ich < ichMax && (hexit = Escape.getHexitValue(chT = script.charAt(ich))) >= 0) {
                            unicode <<= 4;
                            unicode += hexit;
                            ++ich;
                        }
                        ch = (char)unicode;
                    }
                }
            }
            sb.appendC((char)ch);
        }
        return sb.toString();
    }

    private boolean lookingAtLoadFormat(boolean allchar) {
        char ch;
        int ichT = this.ichToken;
        while (PT.isLetterOrDigit(ch = this.charAt(ichT)) && (allchar || PT.isLetter(ch)) || allchar && !this.eol(ch) && !PT.isWhitespace(ch)) {
            ++ichT;
        }
        if (!allchar && ichT == this.ichToken || !ScriptCompiler.isSpaceOrTab(ch)) {
            return false;
        }
        this.cchToken = ichT - this.ichToken;
        return true;
    }

    private boolean lookingAtImpliedString(boolean allowSpace, boolean allowEquals, boolean allowSptParen) {
        boolean isMath;
        int ichT = this.ichToken;
        char ch = this.script.charAt(ichT);
        boolean isID = this.lastToken.tok == 1073741974;
        boolean passVariableToString = T.tokAttr(this.tokCommand, 20480) && (this.tokCommand & 1) == 1;
        boolean isVariable = ch == '@';
        boolean bl = isMath = isVariable && ichT + 3 < this.cchScript && this.script.charAt(ichT + 1) == '{';
        if (isMath && (isID || !passVariableToString)) {
            return false;
        }
        int ptSpace = -1;
        int ptLastChar = -1;
        boolean isOK = true;
        int parenpt = 0;
        block6: while (isOK && !this.eol(ch = this.charAt(ichT))) {
            switch (ch) {
                case '(': {
                    if (allowSptParen || this.tokCommand != 4124 && (ichT < 5 || !this.script.substring(ichT - 4, ichT).equals(".spt") && !this.script.substring(ichT - 4, ichT).equals(".png") && !this.script.substring(ichT - 5, ichT).equals(".pngj"))) break;
                    isOK = false;
                    continue block6;
                }
                case '=': {
                    if (allowEquals) break;
                    isOK = false;
                    continue block6;
                }
                case '{': {
                    ++parenpt;
                    break;
                }
                case '}': {
                    if (--parenpt < 0 && (this.braceCount > 0 || this.iBrace > 0)) {
                        isOK = false;
                        continue block6;
                    }
                }
                default: {
                    if (PT.isWhitespace(ch)) {
                        if (ptSpace >= 0) break;
                        ptSpace = ichT;
                        break;
                    }
                    ptLastChar = ichT;
                }
            }
            ++ichT;
        }
        if (allowSpace) {
            ichT = ptLastChar + 1;
        } else if (ptSpace > 0) {
            ichT = ptSpace;
        }
        if (isVariable && (!allowSpace || ptSpace < 0 && parenpt <= 0 && ichT - this.ichToken > 1)) {
            return false;
        }
        this.cchToken = ichT - this.ichToken;
        return this.cchToken > 0;
    }

    private float lookingAtExponential() {
        int ichT;
        if (this.ichToken == this.cchScript) {
            return Float.NaN;
        }
        int pt0 = ichT = this.ichToken;
        if (this.script.charAt(ichT) == '-') {
            ++ichT;
        }
        boolean isOK = false;
        int ch = 88;
        while (true) {
            char c = this.charAt(ichT);
            ch = c;
            if (!PT.isDigit(c)) break;
            ++ichT;
            isOK = true;
        }
        if (ichT < this.cchScript && ch == 46) {
            ++ichT;
        }
        while (true) {
            char c = this.charAt(ichT);
            ch = c;
            if (!PT.isDigit(c)) break;
            ++ichT;
            isOK = true;
        }
        if (ichT == this.cchScript || !isOK) {
            return Float.NaN;
        }
        boolean bl = isOK = ch != 69 && ch != 101;
        if (isOK || ++ichT == this.cchScript) {
            return Float.NaN;
        }
        ch = this.script.charAt(ichT);
        if (ch == 45 || ch == 43) {
            ++ichT;
        }
        while (PT.isDigit(this.charAt(ichT))) {
            ++ichT;
            isOK = true;
        }
        if (!isOK) {
            return Float.NaN;
        }
        this.cchToken = ichT - this.ichToken;
        return (float)PT.dVal(this.script.substring(pt0, ichT));
    }

    private boolean lookingAtDecimal() {
        char ch;
        if (this.ichToken == this.cchScript) {
            return false;
        }
        int ichT = this.ichToken;
        if (this.script.charAt(ichT) == '-') {
            // empty if block
        }
        boolean digitSeen = false;
        while (true) {
            int n = ++ichT;
            ++ichT;
            ch = this.charAt(n);
            if (!PT.isDigit(ch)) break;
            digitSeen = true;
        }
        if (ch != '.') {
            return false;
        }
        char ch1 = this.charAt(ichT);
        if (!ScriptCompiler.isSpaceOrTab(ch1) && !this.eol(ch1)) {
            if (PT.isLetter(ch1) || ch1 == '?' || ch1 == '*' || ch1 == '_') {
                return false;
            }
            ch1 = this.charAt(ichT + 1);
            if (PT.isLetter(ch1) || ch1 == '?') {
                return false;
            }
        }
        while (PT.isDigit(this.charAt(ichT))) {
            ++ichT;
            digitSeen = true;
        }
        this.cchToken = ichT - this.ichToken;
        return digitSeen;
    }

    private boolean lookingAtSeqcode() {
        char ch;
        int ichT = this.ichToken;
        if (this.charAt(ichT + 1) == '^' && this.script.charAt(ichT) == '*') {
            ch = '^';
            ++ichT;
        } else {
            if (this.script.charAt(ichT) == '-') {
                ++ichT;
            }
            while (true) {
                char c = this.charAt(ichT);
                ch = c;
                if (!PT.isDigit(c)) break;
                ++ichT;
            }
        }
        if (ch != '^') {
            return false;
        }
        if ((ch = ++ichT == this.cchScript ? (char)' ' : (char)this.script.charAt(ichT++)) != ' ' && ch != '*' && ch != '?' && !PT.isLetter(ch)) {
            return false;
        }
        this.cchToken = ichT - this.ichToken;
        return true;
    }

    private int lookingAtInteger() {
        if (this.ichToken == this.cchScript) {
            return Integer.MAX_VALUE;
        }
        int ichT = this.ichToken;
        if (this.script.charAt(this.ichToken) == '-') {
            ++ichT;
        }
        int ichBeginDigits = ichT;
        while (PT.isDigit(this.charAt(ichT))) {
            ++ichT;
        }
        if (ichBeginDigits == ichT) {
            return Integer.MAX_VALUE;
        }
        this.cchToken = ichT - this.ichToken;
        try {
            this.ident = this.script.substring(this.ichToken, ichT);
            int val = Integer.parseInt(this.ident);
            return val;
        }
        catch (NumberFormatException numberFormatException) {
            return Integer.MAX_VALUE;
        }
    }

    BS lookingAtBitset() {
        int ichT;
        if (this.script.indexOf("({null})", this.ichToken) == this.ichToken) {
            this.cchToken = 8;
            return new BS();
        }
        if (this.ichToken + 4 > this.cchScript || this.script.charAt(this.ichToken + 1) != '{' || (ichT = this.script.indexOf("}", this.ichToken)) < 0 || ichT + 1 == this.cchScript) {
            return null;
        }
        BS bs = BS.unescape(this.script.substring(this.ichToken, ichT + 2));
        if (bs != null) {
            this.cchToken = ichT + 2 - this.ichToken;
        }
        return bs;
    }

    private boolean lookingAtObjectID() {
        boolean allowWildID = this.nTokens == 1;
        int ichT = this.ichToken;
        if (this.charAt(ichT) != '$') {
            return false;
        }
        if (this.charAt(++ichT) == '\"') {
            return false;
        }
        while (ichT < this.cchScript) {
            char ch = this.script.charAt(ichT);
            if (PT.isWhitespace(ch)) {
                if (ichT != this.ichToken + 1) break;
                return false;
            }
            if (!PT.isLetterOrDigit(ch)) {
                switch (ch) {
                    default: {
                        return false;
                    }
                    case '*': {
                        if (allowWildID) break;
                        return false;
                    }
                    case '_': 
                    case '~': 
                }
            }
            ++ichT;
        }
        this.cchToken = ichT - ++this.ichToken;
        return true;
    }

    private boolean lookingAtLookupToken(int ichT) {
        if (ichT == this.cchScript) {
            return false;
        }
        int ichT0 = ichT;
        this.afterMath = this.tokLastMath != 0 ? ichT : 0;
        this.tokLastMath = 0;
        char ch = this.script.charAt(ichT++);
        switch (ch) {
            case '&': 
            case '*': 
            case '+': 
            case '-': 
            case '|': {
                if (ichT < this.cchScript) {
                    if (this.script.charAt(ichT) == ch) {
                        ++ichT;
                        if (ch == '-' || ch == '+') break;
                        if (ch == '&' && this.charAt(ichT) == ch) {
                            ++ichT;
                        }
                    } else if (this.script.charAt(ichT) == '=') {
                        ++ichT;
                    }
                }
                this.tokLastMath = 1;
                break;
            }
            case '/': {
                if (this.charAt(ichT) == '/') break;
            }
            case '!': 
            case '\\': {
                if (this.charAt(ichT) == '=') {
                    ++ichT;
                }
                this.tokLastMath = 1;
                break;
            }
            case ')': 
            case ']': 
            case '}': {
                break;
            }
            case '.': {
                if (this.charAt(ichT) == '.') {
                    ++ichT;
                }
                this.tokLastMath = 1;
                break;
            }
            case '@': 
            case '{': {
                this.tokLastMath = 2;
                break;
            }
            case ':': {
                this.tokLastMath = 1;
                break;
            }
            case '$': 
            case '%': 
            case '(': 
            case ',': 
            case ';': 
            case '[': {
                this.tokLastMath = 1;
                break;
            }
            case '<': 
            case '=': 
            case '>': {
                ch = this.charAt(ichT);
                if (ch == '<' || ch == '=' || ch == '>') {
                    ++ichT;
                }
                this.tokLastMath = 1;
                break;
            }
            default: {
                if (!PT.isLetter(ch) && !this.isDotDot) {
                    return false;
                }
            }
            case '\'': 
            case '?': 
            case '_': 
            case '~': {
                if (ch == '?') {
                    this.tokLastMath = 1;
                }
                while (PT.isLetterOrDigit(ch = this.charAt(ichT)) || ch == '_' || ch == '*' && this.charAt(ichT - 1) == '?' || ch == '?' || ch == '~' || ch == '\'' || ch == '\\' && this.charAt(ichT + 1) == '?' || ch == '^' && ichT > ichT0 && PT.isDigit(this.charAt(ichT - 1))) {
                    ++ichT;
                }
                break block0;
            }
        }
        this.cchToken = ichT - ichT0;
        return true;
    }

    private boolean lookForSyncID() {
        char ch = this.charAt(this.ichToken);
        if (ch == '\"' || ch == '@' || ch == '\u0000') {
            return false;
        }
        int ichT = this.ichToken;
        while (!ScriptCompiler.isSpaceOrTab(ch = this.charAt(ichT)) && ch != '#' && ch != '}' && !this.eol(ch)) {
            ++ichT;
        }
        this.cchToken = ichT - this.ichToken;
        return true;
    }

    private int ERROR(int error) {
        this.errorIntStr2(error, null, null);
        return 4;
    }

    private int ERROR(int error, String value) {
        this.errorStr(error, value);
        return 4;
    }

    private boolean handleError() {
        this.errorType = this.errorMessage;
        this.errorLine = this.script.substring(this.ichCurrentCommand, this.ichEnd <= this.ichCurrentCommand ? this.ichToken + this.cchToken : this.ichEnd);
        String lineInfo = (this.ichToken < this.ichEnd ? this.errorLine.substring(0, this.ichToken - this.ichCurrentCommand) + " >>>> " + this.errorLine.substring(this.ichToken - this.ichCurrentCommand) : this.errorLine) + " <<<<";
        this.errorMessage = GT.$("script compiler ERROR: ") + this.errorMessage + ScriptError.getErrorLineMessage(null, this.filename, this.lineCurrent, this.iCommand, lineInfo);
        if (!this.isSilent) {
            this.ichToken = Math.max(this.ichEnd, this.ichToken);
            while (!this.lookingAtEndOfLine() && !this.lookingAtTerminator()) {
                ++this.ichToken;
            }
            this.errorLine = this.script.substring(this.ichCurrentCommand, this.ichToken);
            this.vwr.addCommand(this.errorLine + "#??");
            Logger.error(this.errorMessage);
        }
        return false;
    }
}

