/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.nwdiag.legacy;

import net.sourceforge.plantuml.nwdiag.legacy.Footprint;
import net.sourceforge.plantuml.nwdiag.legacy.LinkedElement;
import net.sourceforge.plantuml.nwdiag.legacy.NwGroupLegacy;

public class NwArray {
    private final LinkedElement[][] data;

    public NwArray(int lines, int cols) {
        this.data = new LinkedElement[lines][cols];
    }

    public int getNbLines() {
        return this.data.length;
    }

    public int getNbCols() {
        return this.data[0].length;
    }

    public LinkedElement get(int i, int j) {
        return this.data[i][j];
    }

    public LinkedElement[] getLine(int i) {
        return this.data[i];
    }

    public void set(int i, int j, LinkedElement value) {
        this.data[i][j] = value;
    }

    public void swapCols(int col1, int col2) {
        if (col1 == col2) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < this.getNbLines(); ++i) {
            LinkedElement tmp = this.data[i][col1];
            this.data[i][col1] = this.data[i][col2];
            this.data[i][col2] = tmp;
        }
    }

    public Footprint getFootprint(NwGroupLegacy group) {
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        for (int i = 0; i < this.getNbLines(); ++i) {
            for (int j = 0; j < this.getNbCols(); ++j) {
                if (this.data[i][j] == null || !group.matches(this.data[i][j])) continue;
                min = Math.min(min, j);
                max = Math.max(max, j);
            }
        }
        return new Footprint(min, max);
    }
}

