/*
 * Decompiled with CFR 0.152.
 */
package joptsimple;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import joptsimple.AbbreviationMap;
import joptsimple.AlternativeLongOptionSpec;
import joptsimple.ArgumentList;
import joptsimple.OptionException;
import joptsimple.OptionParserHelpFormatter;
import joptsimple.OptionParserState;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import joptsimple.OptionSpecTokenizer;
import joptsimple.ParserRules;
import joptsimple.util.KeyValuePair;

public class OptionParser {
    private final AbbreviationMap recognizedOptions = new AbbreviationMap();
    private OptionParserState state = OptionParserState.moreOptions(false);
    private boolean posixlyCorrect;

    public OptionParser() {
    }

    public OptionParser(String optionSpecification) {
        new OptionSpecTokenizer(optionSpecification).configure(this);
    }

    public OptionSpecBuilder accepts(String option) {
        return this.acceptsAll(Collections.singletonList(option));
    }

    public OptionSpecBuilder accepts(String option, String description) {
        return this.acceptsAll(Collections.singletonList(option), description);
    }

    public OptionSpecBuilder acceptsAll(List options) {
        return this.acceptsAll(options, "");
    }

    public OptionSpecBuilder acceptsAll(List options, String description) {
        if (options.isEmpty()) {
            throw new IllegalArgumentException("acceptsAll needs at least one option");
        }
        ParserRules.checkLegalOptions(options);
        return new OptionSpecBuilder(this, options, description);
    }

    public void setPosixlyCorrect(boolean setting) {
        this.posixlyCorrect = setting;
        this.state = OptionParserState.moreOptions(setting);
    }

    public void posixlyCorrect(boolean setting) {
        this.setPosixlyCorrect(setting);
    }

    boolean posixlyCorrect() {
        return this.posixlyCorrect;
    }

    public void recognizeAlternativeLongOptions(boolean recognize) {
        if (recognize) {
            this.recognize(new AlternativeLongOptionSpec());
        } else {
            this.recognizedOptions.remove(String.valueOf("W"));
        }
    }

    void recognize(OptionSpec spec) {
        this.recognizedOptions.putAll(spec.options(), spec);
    }

    public void printHelpOn(OutputStream sink) throws IOException {
        this.printHelpOn(new OutputStreamWriter(sink));
    }

    public void printHelpOn(Writer sink) throws IOException {
        sink.write(new OptionParserHelpFormatter().format(this.recognizedOptions.toJavaUtilMap()));
        sink.flush();
    }

    public OptionSet parse(String[] arguments) {
        ArgumentList argumentList = new ArgumentList(arguments);
        OptionSet detected = new OptionSet();
        while (argumentList.hasMore()) {
            this.state.handleArgument(this, argumentList, detected);
        }
        this.reset();
        return detected;
    }

    void handleLongOptionToken(String candidate, ArgumentList arguments, OptionSet detected) {
        KeyValuePair optionAndArgument = OptionParser.parseLongOptionWithArgument(candidate);
        if (!this.isRecognized(optionAndArgument.key)) {
            throw OptionException.unrecognizedOption(optionAndArgument.key);
        }
        OptionSpec optionSpec = this.specFor(optionAndArgument.key);
        optionSpec.handleOption(this, arguments, detected, optionAndArgument.value);
    }

    void handleShortOptionToken(String candidate, ArgumentList arguments, OptionSet detected) {
        KeyValuePair optionAndArgument = OptionParser.parseShortOptionWithArgument(candidate);
        if (this.isRecognized(optionAndArgument.key)) {
            this.specFor(optionAndArgument.key).handleOption(this, arguments, detected, optionAndArgument.value);
        } else {
            this.handleShortOptionCluster(candidate, arguments, detected);
        }
    }

    private void handleShortOptionCluster(String candidate, ArgumentList arguments, OptionSet detected) {
        char[] options = OptionParser.extractShortOptionsFrom(candidate);
        this.validateOptionCharacters(options);
        OptionSpec optionSpec = this.specFor(options[0]);
        if (optionSpec.acceptsArguments() && options.length > 1) {
            String detectedArgument = String.valueOf(options, 1, options.length - 1);
            optionSpec.handleOption(this, arguments, detected, detectedArgument);
        } else {
            for (int i = 0; i < options.length; ++i) {
                this.specFor(options[i]).handleOption(this, arguments, detected, null);
            }
        }
    }

    void noMoreOptions() {
        this.state = OptionParserState.noMoreOptions();
    }

    boolean looksLikeAnOption(String argument) {
        return ParserRules.isShortOptionToken(argument) || ParserRules.isLongOptionToken(argument);
    }

    private boolean isRecognized(String option) {
        return this.recognizedOptions.contains(option);
    }

    private OptionSpec specFor(char option) {
        return this.specFor(String.valueOf(option));
    }

    private OptionSpec specFor(String option) {
        return (OptionSpec)this.recognizedOptions.get(option);
    }

    private void reset() {
        this.state = OptionParserState.moreOptions(this.posixlyCorrect);
    }

    private static char[] extractShortOptionsFrom(String argument) {
        char[] options = new char[argument.length() - 1];
        argument.getChars(1, argument.length(), options, 0);
        return options;
    }

    private void validateOptionCharacters(char[] options) {
        for (int i = 0; i < options.length; ++i) {
            String option = String.valueOf(options[i]);
            if (!this.isRecognized(option)) {
                throw OptionException.unrecognizedOption(option);
            }
            if (!this.specFor(option).acceptsArguments()) continue;
            if (i > 0) {
                throw OptionException.illegalOptionCluster(option);
            }
            return;
        }
    }

    private static KeyValuePair parseLongOptionWithArgument(String argument) {
        return KeyValuePair.valueOf(argument.substring(2));
    }

    private static KeyValuePair parseShortOptionWithArgument(String argument) {
        return KeyValuePair.valueOf(argument.substring(1));
    }
}

