/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.testng.IInvokedMethod;
import org.testng.IInvokedMethodListener;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.SkipException;
import org.testng.SuiteRunState;
import org.testng.collections.Maps;
import org.testng.internal.IConfiguration;
import org.testng.internal.ITestResultNotifier;
import org.testng.internal.Utils;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.internal.invokers.InvokedMethodListenerInvoker;
import org.testng.internal.invokers.InvokedMethodListenerMethod;

class BaseInvoker {
    private final Collection<IInvokedMethodListener> m_invokedMethodListeners;
    protected final ITestResultNotifier m_notifier;
    protected final ITestContext m_testContext;
    protected final SuiteRunState m_suiteState;
    protected IConfiguration m_configuration;
    protected final Map<Class<?>, Set<Object>> m_classInvocationResults = Maps.newConcurrentMap();

    public BaseInvoker(ITestResultNotifier notifier, Collection<IInvokedMethodListener> invokedMethodListeners, ITestContext testContext, SuiteRunState suiteState, IConfiguration configuration) {
        this.m_notifier = notifier;
        this.m_invokedMethodListeners = invokedMethodListeners;
        this.m_testContext = testContext;
        this.m_suiteState = suiteState;
        this.m_configuration = configuration;
    }

    protected IAnnotationFinder annotationFinder() {
        return this.m_configuration.getAnnotationFinder();
    }

    protected void runInvokedMethodListeners(InvokedMethodListenerMethod listenerMethod, IInvokedMethod invokedMethod, ITestResult testResult) {
        if (this.noListenersPresent()) {
            return;
        }
        InvokedMethodListenerInvoker invoker = new InvokedMethodListenerInvoker(listenerMethod, testResult, testResult.getTestContext());
        for (IInvokedMethodListener currentListener : this.m_invokedMethodListeners) {
            try {
                invoker.invokeListener(currentListener, invokedMethod);
            }
            catch (SkipException e) {
                String msg = String.format("Caught a [%s] exception from one of listeners %s. Will mark [%s()] as SKIPPED.", SkipException.class.getSimpleName(), currentListener.getClass().getName(), invokedMethod.getTestMethod().getQualifiedName());
                Utils.warn(msg);
                testResult.setStatus(3);
                testResult.setThrowable(e);
            }
        }
    }

    private boolean noListenersPresent() {
        return this.m_invokedMethodListeners == null || this.m_invokedMethodListeners.isEmpty();
    }

    protected void handleException(Throwable throwable, ITestNGMethod testMethod, ITestResult testResult, int failureCount) {
        int invocationCount;
        int successPercentage;
        float numberOfTestsThatCanFail;
        if (throwable != null && testResult.getThrowable() == null) {
            testResult.setThrowable(throwable);
        }
        if ((float)failureCount < (numberOfTestsThatCanFail = (float)((100 - (successPercentage = testMethod.getSuccessPercentage())) * (invocationCount = testMethod.getInvocationCount())) / 100.0f)) {
            testResult.setStatus(4);
        } else {
            testResult.setStatus(2);
        }
    }

    protected boolean isSkipExceptionAndSkip(Throwable ite) {
        return SkipException.class.isAssignableFrom(ite.getClass()) && ((SkipException)ite).isSkip();
    }

    static void log(int level, String s) {
        Utils.log("Invoker " + Thread.currentThread().hashCode(), level, s);
    }
}

