/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.coverage;

import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyHash;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.ext.coverage.CoverageData;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.collections.IntList;

public class CoverageModule {
    @JRubyMethod(module=true)
    public static IRubyObject start(ThreadContext context, IRubyObject self2) {
        Ruby runtime2 = context.runtime;
        if (!runtime2.getCoverageData().isCoverageEnabled()) {
            runtime2.getCoverageData().setCoverageEnabled(1);
        }
        return context.nil;
    }

    @JRubyMethod(module=true)
    public static IRubyObject start(ThreadContext context, IRubyObject self2, IRubyObject opts) {
        Ruby runtime2 = context.runtime;
        if (!runtime2.getCoverageData().isCoverageEnabled()) {
            int mode2 = 0;
            if (ArgsUtil.extractKeywordArg(context, "all", opts).isTrue()) {
                mode2 |= 7;
            } else {
                if (ArgsUtil.extractKeywordArg(context, "lines", opts).isTrue()) {
                    mode2 |= 1;
                }
                if (ArgsUtil.extractKeywordArg(context, "branches", opts).isTrue()) {
                    runtime2.getWarnings().warn("branch coverage is not supported");
                    mode2 |= 2;
                }
                if (ArgsUtil.extractKeywordArg(context, "methods", opts).isTrue()) {
                    runtime2.getWarnings().warn("method coverage is not supported");
                    mode2 |= 4;
                }
                if (ArgsUtil.extractKeywordArg(context, "oneshot_lines", opts).isTrue()) {
                    mode2 |= 1;
                    mode2 |= 8;
                }
            }
            runtime2.getCoverageData().setCoverageEnabled(mode2);
        }
        return context.nil;
    }

    @JRubyMethod(module=true)
    public static IRubyObject result(ThreadContext context, IRubyObject self2) {
        Ruby runtime2 = context.runtime;
        CoverageData coverageData = runtime2.getCoverageData();
        if (!coverageData.isCoverageEnabled()) {
            throw runtime2.newRuntimeError("coverage measurement is not enabled");
        }
        IRubyObject result2 = CoverageModule.convertCoverageToRuby(context, runtime2, coverageData.getCoverage(), coverageData.getMode());
        coverageData.resetCoverage();
        return result2;
    }

    @JRubyMethod(module=true)
    public static IRubyObject peek_result(ThreadContext context, IRubyObject self2) {
        Ruby runtime2 = context.runtime;
        CoverageData coverageData = runtime2.getCoverageData();
        if (!coverageData.isCoverageEnabled()) {
            throw runtime2.newRuntimeError("coverage measurement is not enabled");
        }
        return CoverageModule.convertCoverageToRuby(context, runtime2, coverageData.getCoverage(), coverageData.getMode());
    }

    @JRubyMethod(name={"running?"}, module=true)
    public static IRubyObject running_p(ThreadContext context, IRubyObject self2) {
        return context.runtime.getCoverageData().isCoverageEnabled() ? context.tru : context.fals;
    }

    private static IRubyObject convertCoverageToRuby(ThreadContext context, Ruby runtime2, Map<String, IntList> coverage2, int mode2) {
        RubyHash covHash = RubyHash.newHash(runtime2);
        for (Map.Entry<String, IntList> entry : coverage2.entrySet()) {
            if (entry.getKey().equals("")) continue;
            IntList val = entry.getValue();
            boolean oneshot = (mode2 & 8) != 0;
            RubyArray ary = RubyArray.newArray(runtime2, val.size());
            for (int i2 = 0; i2 < val.size(); ++i2) {
                int integer = val.get(i2);
                if (oneshot) {
                    ary.push(runtime2.newFixnum(integer + 1));
                    continue;
                }
                ary.store(i2, integer == -1 ? context.nil : runtime2.newFixnum(integer));
            }
            RubyString key2 = RubyString.newString(runtime2, entry.getKey());
            RubyObject value2 = ary;
            if (oneshot) {
                RubyHash oneshotHash = RubyHash.newSmallHash(runtime2);
                oneshotHash.fastASetSmall(runtime2.newSymbol("oneshot_lines"), ary);
                value2 = oneshotHash;
            }
            covHash.fastASetCheckString(runtime2, key2, value2);
        }
        return covHash;
    }
}

