/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.ir2wasm;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.wasm.WasmBackendContext;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.ClassInfoKt;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.ClassMetadata;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.ConstantDataElement;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.InterfaceImplementation;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.WasmCompiledModuleFragment;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.WasmModuleCodegenContext;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.WasmTypeTransformer;
import org.jetbrains.kotlin.backend.wasm.lower.WasmSignature;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFieldSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.wasm.ir.WasmExport;
import org.jetbrains.kotlin.wasm.ir.WasmFunction;
import org.jetbrains.kotlin.wasm.ir.WasmFunctionType;
import org.jetbrains.kotlin.wasm.ir.WasmGlobal;
import org.jetbrains.kotlin.wasm.ir.WasmI32;
import org.jetbrains.kotlin.wasm.ir.WasmSymbol;
import org.jetbrains.kotlin.wasm.ir.WasmTable;
import org.jetbrains.kotlin.wasm.ir.WasmType;
import org.jetbrains.kotlin.wasm.ir.WasmTypeDeclaration;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00c6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\u0014\u001a\u00020\u00152\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0016J\u0018\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0018\u0010!\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020#H\u0016J\u0018\u0010$\u001a\u00020\u00152\u0006\u0010%\u001a\u00020\u000b2\u0006\u0010&\u001a\u00020'H\u0016J\u0018\u0010(\u001a\u00020\u00152\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0016J\u0018\u0010-\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010.\u001a\u00020/H\u0016J\u0018\u00100\u001a\u00020\u00152\u0006\u0010%\u001a\u00020\u000b2\u0006\u0010+\u001a\u00020,H\u0016J\u0018\u00101\u001a\u00020\u00152\u0006\u0010%\u001a\u00020\u000b2\u0006\u00102\u001a\u000203H\u0016J\u0018\u00104\u001a\u00020\u00152\u0006\u0010%\u001a\u00020\u000b2\u0006\u00105\u001a\u000203H\u0016J\u0010\u00106\u001a\u00020\f2\u0006\u0010%\u001a\u00020\u000bH\u0016J\u0016\u00107\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u00108\u001a\u000209H\u0016J\u0016\u0010:\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010%\u001a\u00020\u000bH\u0016J\u0016\u0010;\u001a\b\u0012\u0004\u0012\u00020,0\u000e2\u0006\u0010%\u001a\u00020\u000bH\u0016J\u0016\u0010<\u001a\b\u0012\u0004\u0012\u00020 0\u000e2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0016\u0010=\u001a\b\u0012\u0004\u0012\u00020#0\u000e2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0016\u0010>\u001a\b\u0012\u0004\u0012\u00020'0\u000e2\u0006\u0010%\u001a\u00020\u000bH\u0016J\u0016\u0010?\u001a\b\u0012\u0004\u0012\u00020,0\u000e2\u0006\u0010)\u001a\u00020*H\u0016J\u0016\u0010@\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010A\u001a\u00020\u000bH\u0016J\u0016\u0010B\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010C\u001a\u00020DH\u0016J\u0016\u0010E\u001a\b\u0012\u0004\u0012\u00020/0\u000e2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0016\u0010F\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010%\u001a\u00020\u000bH\u0016J\u0016\u0010G\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010H\u001a\u00020IH\u0016J\u0016\u0010J\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010K\u001a\u00020\u001aH\u0016J\u0016\u0010L\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u001d\u001a\u00020MH\u0016J\u0010\u0010N\u001a\u00020\u00152\u0006\u0010%\u001a\u00020\u000bH\u0016J\u0010\u0010O\u001a\u00020\u00152\u0006\u0010A\u001a\u00020\u000bH\u0016J*\u0010P\u001a\u00020\u00152\u0006\u0010C\u001a\u00020D2\u0018\u00102\u001a\u0014\u0012\u0004\u0012\u00020\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u000e0QH\u0016J\u0010\u0010R\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020MH\u0016J\u0010\u0010S\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0012\u0010T\u001a\u0004\u0018\u00010U2\u0006\u0010V\u001a\u00020WH\u0016J\u0010\u0010X\u001a\u00020U2\u0006\u0010V\u001a\u00020WH\u0016J\u0012\u0010Y\u001a\u0004\u0018\u00010U2\u0006\u0010V\u001a\u00020WH\u0016J\u0010\u0010Z\u001a\u00020U2\u0006\u0010V\u001a\u00020WH\u0016J\u0012\u0010[\u001a\u0004\u0018\u00010U2\u0006\u0010V\u001a\u00020WH\u0016J\u0010\u0010\\\u001a\u00020U2\u0006\u0010V\u001a\u00020WH\u0016J\u0010\u0010]\u001a\u00020U2\u0006\u0010^\u001a\u00020_H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006`"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmModuleCodegenContextImpl;", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmModuleCodegenContext;", "backendContext", "Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "wasmFragment", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmCompiledModuleFragment;", "(Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmCompiledModuleFragment;)V", "getBackendContext", "()Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "classMetadataCache", "", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/ClassMetadata;", "scratchMemAddr", "Lorg/jetbrains/kotlin/wasm/ir/WasmSymbol;", "", "getScratchMemAddr", "()Lorg/jetbrains/kotlin/wasm/ir/WasmSymbol;", "typeTransformer", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmTypeTransformer;", "addExport", "", "wasmExport", "Lorg/jetbrains/kotlin/wasm/ir/WasmExport;", "addJsFun", "importName", "", "jsCode", "defineFunction", "irFunction", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "wasmFunction", "Lorg/jetbrains/kotlin/wasm/ir/WasmFunction;", "defineFunctionType", "wasmFunctionType", "Lorg/jetbrains/kotlin/wasm/ir/WasmFunctionType;", "defineGcType", "irClass", "wasmType", "Lorg/jetbrains/kotlin/wasm/ir/WasmTypeDeclaration;", "defineGlobal", "irField", "Lorg/jetbrains/kotlin/ir/symbols/IrFieldSymbol;", "wasmGlobal", "Lorg/jetbrains/kotlin/wasm/ir/WasmGlobal;", "defineInterfaceMethodTable", "wasmTable", "Lorg/jetbrains/kotlin/wasm/ir/WasmTable;", "defineRTT", "generateInterfaceTable", "table", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/ConstantDataElement;", "generateTypeInfo", "typeInfo", "getClassMetadata", "getStructFieldRef", "field", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "referenceClassId", "referenceClassRTT", "referenceFunction", "referenceFunctionType", "referenceGcType", "referenceGlobal", "referenceInterfaceId", "irInterface", "referenceInterfaceImplementationId", "interfaceImplementation", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/InterfaceImplementation;", "referenceInterfaceTable", "referenceInterfaceTableAddress", "referenceSignatureId", "signature", "Lorg/jetbrains/kotlin/backend/wasm/lower/WasmSignature;", "referenceStringLiteral", "string", "referenceVirtualFunctionId", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "registerClass", "registerInterface", "registerInterfaceImplementationMethod", "", "registerVirtualFunction", "setStartFunction", "transformBlockResultType", "Lorg/jetbrains/kotlin/wasm/ir/WasmType;", "irType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "transformBoxedType", "transformExportedResultType", "transformFieldType", "transformResultType", "transformType", "transformValueParameterType", "irValueParameter", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "backend.wasm"})
public final class WasmModuleCodegenContextImpl
implements WasmModuleCodegenContext {
    @NotNull
    private final WasmBackendContext backendContext;
    @NotNull
    private final WasmCompiledModuleFragment wasmFragment;
    @NotNull
    private final WasmTypeTransformer typeTransformer;
    @NotNull
    private final Map<IrClassSymbol, ClassMetadata> classMetadataCache;

    public WasmModuleCodegenContextImpl(@NotNull WasmBackendContext backendContext, @NotNull WasmCompiledModuleFragment wasmFragment) {
        Intrinsics.checkNotNullParameter(backendContext, "backendContext");
        Intrinsics.checkNotNullParameter(wasmFragment, "wasmFragment");
        this.backendContext = backendContext;
        this.wasmFragment = wasmFragment;
        this.typeTransformer = new WasmTypeTransformer(this, this.getBackendContext().getIrBuiltIns());
        this.classMetadataCache = new LinkedHashMap();
    }

    @Override
    @NotNull
    public WasmBackendContext getBackendContext() {
        return this.backendContext;
    }

    @Override
    @NotNull
    public WasmSymbol<Integer> getScratchMemAddr() {
        return this.wasmFragment.getScratchMemAddr();
    }

    @Override
    @NotNull
    public WasmType transformType(@NotNull IrType irType) {
        WasmTypeTransformer wasmTypeTransformer;
        Intrinsics.checkNotNullParameter(irType, "irType");
        WasmTypeTransformer $this$transformType_u24lambda_u2d0 = wasmTypeTransformer = this.typeTransformer;
        boolean bl = false;
        return $this$transformType_u24lambda_u2d0.toWasmValueType(irType);
    }

    @Override
    @NotNull
    public WasmType transformFieldType(@NotNull IrType irType) {
        WasmTypeTransformer wasmTypeTransformer;
        Intrinsics.checkNotNullParameter(irType, "irType");
        WasmTypeTransformer $this$transformFieldType_u24lambda_u2d1 = wasmTypeTransformer = this.typeTransformer;
        boolean bl = false;
        return $this$transformFieldType_u24lambda_u2d1.toWasmFieldType(irType);
    }

    @Override
    @NotNull
    public WasmType transformBoxedType(@NotNull IrType irType) {
        WasmTypeTransformer wasmTypeTransformer;
        Intrinsics.checkNotNullParameter(irType, "irType");
        WasmTypeTransformer $this$transformBoxedType_u24lambda_u2d2 = wasmTypeTransformer = this.typeTransformer;
        boolean bl = false;
        return $this$transformBoxedType_u24lambda_u2d2.toBoxedInlineClassType(irType);
    }

    @Override
    @NotNull
    public WasmType transformValueParameterType(@NotNull IrValueParameter irValueParameter) {
        WasmTypeTransformer wasmTypeTransformer;
        Intrinsics.checkNotNullParameter(irValueParameter, "irValueParameter");
        WasmTypeTransformer $this$transformValueParameterType_u24lambda_u2d3 = wasmTypeTransformer = this.typeTransformer;
        boolean bl = false;
        return $this$transformValueParameterType_u24lambda_u2d3.getContext().getBackendContext().getInlineClassesUtils().shouldValueParameterBeBoxed(irValueParameter) ? $this$transformValueParameterType_u24lambda_u2d3.toBoxedInlineClassType(irValueParameter.getType()) : $this$transformValueParameterType_u24lambda_u2d3.toWasmValueType(irValueParameter.getType());
    }

    @Override
    @Nullable
    public WasmType transformResultType(@NotNull IrType irType) {
        WasmTypeTransformer wasmTypeTransformer;
        Intrinsics.checkNotNullParameter(irType, "irType");
        WasmTypeTransformer $this$transformResultType_u24lambda_u2d4 = wasmTypeTransformer = this.typeTransformer;
        boolean bl = false;
        return $this$transformResultType_u24lambda_u2d4.toWasmResultType(irType);
    }

    @Override
    @Nullable
    public WasmType transformExportedResultType(@NotNull IrType irType) {
        WasmTypeTransformer wasmTypeTransformer;
        Intrinsics.checkNotNullParameter(irType, "irType");
        if (Intrinsics.areEqual(IrTypesKt.getClass(irType), IrTypesKt.getClass(this.getBackendContext().getIrBuiltIns().getStringType()))) {
            return WasmI32.INSTANCE;
        }
        WasmTypeTransformer $this$transformExportedResultType_u24lambda_u2d5 = wasmTypeTransformer = this.typeTransformer;
        boolean bl = false;
        return $this$transformExportedResultType_u24lambda_u2d5.toWasmResultType(irType);
    }

    @Override
    @Nullable
    public WasmType transformBlockResultType(@NotNull IrType irType) {
        WasmTypeTransformer wasmTypeTransformer;
        Intrinsics.checkNotNullParameter(irType, "irType");
        WasmTypeTransformer $this$transformBlockResultType_u24lambda_u2d6 = wasmTypeTransformer = this.typeTransformer;
        boolean bl = false;
        return $this$transformBlockResultType_u24lambda_u2d6.toWasmBlockResultType(irType);
    }

    @Override
    @NotNull
    public WasmSymbol<Integer> referenceStringLiteral(@NotNull String string2) {
        Intrinsics.checkNotNullParameter(string2, "string");
        return this.wasmFragment.getStringLiteralId().reference(string2);
    }

    @Override
    public void generateTypeInfo(@NotNull IrClassSymbol irClass2, @NotNull ConstantDataElement typeInfo) {
        Intrinsics.checkNotNullParameter(irClass2, "irClass");
        Intrinsics.checkNotNullParameter(typeInfo, "typeInfo");
        this.wasmFragment.getTypeInfo().define(irClass2, typeInfo);
    }

    @Override
    public void generateInterfaceTable(@NotNull IrClassSymbol irClass2, @NotNull ConstantDataElement table) {
        Intrinsics.checkNotNullParameter(irClass2, "irClass");
        Intrinsics.checkNotNullParameter(table, "table");
        this.wasmFragment.getDefinedClassITableData().define(irClass2, table);
    }

    @Override
    public void setStartFunction(@NotNull WasmFunction wasmFunction) {
        Intrinsics.checkNotNullParameter(wasmFunction, "wasmFunction");
        this.wasmFragment.setStartFunction(wasmFunction);
    }

    @Override
    public void addExport(@NotNull WasmExport<?> wasmExport) {
        Intrinsics.checkNotNullParameter(wasmExport, "wasmExport");
        WasmCompiledModuleFragment wasmCompiledModuleFragment = this.wasmFragment;
        Collection collection = wasmCompiledModuleFragment.getExports();
        collection.add(wasmExport);
    }

    @Override
    public void registerVirtualFunction(@NotNull IrSimpleFunctionSymbol irFunction2) {
        Intrinsics.checkNotNullParameter(irFunction2, "irFunction");
        WasmCompiledModuleFragment wasmCompiledModuleFragment = this.wasmFragment;
        Collection collection = wasmCompiledModuleFragment.getVirtualFunctions();
        collection.add(irFunction2);
    }

    @Override
    public void registerInterface(@NotNull IrClassSymbol irInterface) {
        Intrinsics.checkNotNullParameter(irInterface, "irInterface");
        WasmCompiledModuleFragment wasmCompiledModuleFragment = this.wasmFragment;
        Collection collection = wasmCompiledModuleFragment.getInterfaces();
        collection.add(irInterface);
    }

    @Override
    public void registerClass(@NotNull IrClassSymbol irClass2) {
        Intrinsics.checkNotNullParameter(irClass2, "irClass");
        WasmCompiledModuleFragment wasmCompiledModuleFragment = this.wasmFragment;
        Collection collection = wasmCompiledModuleFragment.getClasses();
        collection.add(irClass2);
    }

    @Override
    public void defineFunction(@NotNull IrFunctionSymbol irFunction2, @NotNull WasmFunction wasmFunction) {
        Intrinsics.checkNotNullParameter(irFunction2, "irFunction");
        Intrinsics.checkNotNullParameter(wasmFunction, "wasmFunction");
        this.wasmFragment.getFunctions().define(irFunction2, wasmFunction);
    }

    @Override
    public void defineGlobal(@NotNull IrFieldSymbol irField, @NotNull WasmGlobal wasmGlobal) {
        Intrinsics.checkNotNullParameter(irField, "irField");
        Intrinsics.checkNotNullParameter(wasmGlobal, "wasmGlobal");
        this.wasmFragment.getGlobals().define(irField, wasmGlobal);
    }

    @Override
    public void defineGcType(@NotNull IrClassSymbol irClass2, @NotNull WasmTypeDeclaration wasmType) {
        Intrinsics.checkNotNullParameter(irClass2, "irClass");
        Intrinsics.checkNotNullParameter(wasmType, "wasmType");
        this.wasmFragment.getGcTypes().define(irClass2, wasmType);
    }

    @Override
    public void defineRTT(@NotNull IrClassSymbol irClass2, @NotNull WasmGlobal wasmGlobal) {
        Intrinsics.checkNotNullParameter(irClass2, "irClass");
        Intrinsics.checkNotNullParameter(wasmGlobal, "wasmGlobal");
        this.wasmFragment.getRuntimeTypes().define(irClass2, wasmGlobal);
    }

    @Override
    public void defineFunctionType(@NotNull IrFunctionSymbol irFunction2, @NotNull WasmFunctionType wasmFunctionType) {
        Intrinsics.checkNotNullParameter(irFunction2, "irFunction");
        Intrinsics.checkNotNullParameter(wasmFunctionType, "wasmFunctionType");
        this.wasmFragment.getFunctionTypes().define(irFunction2, wasmFunctionType);
    }

    @Override
    public void defineInterfaceMethodTable(@NotNull IrFunctionSymbol irFunction2, @NotNull WasmTable wasmTable) {
        Intrinsics.checkNotNullParameter(irFunction2, "irFunction");
        Intrinsics.checkNotNullParameter(wasmTable, "wasmTable");
        this.wasmFragment.getInterfaceMethodTables().define(irFunction2, wasmTable);
    }

    @Override
    @NotNull
    public WasmSymbol<Integer> referenceInterfaceImplementationId(@NotNull InterfaceImplementation interfaceImplementation) {
        Intrinsics.checkNotNullParameter(interfaceImplementation, "interfaceImplementation");
        return this.wasmFragment.getReferencedInterfaceImplementationId().reference(interfaceImplementation);
    }

    @Override
    public void registerInterfaceImplementationMethod(@NotNull InterfaceImplementation interfaceImplementation, @NotNull Map<IrFunctionSymbol, ? extends WasmSymbol<? extends WasmFunction>> table) {
        Intrinsics.checkNotNullParameter(interfaceImplementation, "interfaceImplementation");
        Intrinsics.checkNotNullParameter(table, "table");
        Map map = this.wasmFragment.getInterfaceImplementationsMethods();
        map.put(interfaceImplementation, table);
    }

    @Override
    @NotNull
    public ClassMetadata getClassMetadata(@NotNull IrClassSymbol irClass2) {
        ClassMetadata classMetadata;
        Intrinsics.checkNotNullParameter(irClass2, "irClass");
        Map<IrClassSymbol, ClassMetadata> $this$getOrPut$iv = this.classMetadataCache;
        boolean $i$f$getOrPut = false;
        ClassMetadata value$iv = $this$getOrPut$iv.get(irClass2);
        if (value$iv == null) {
            ClassMetadata classMetadata2;
            boolean bl = false;
            IrClass superClass = ClassInfoKt.getSuperClass((IrClass)irClass2.getOwner(), this.getBackendContext().getIrBuiltIns());
            IrClass irClass3 = superClass;
            if (irClass3 == null) {
                classMetadata2 = null;
            } else {
                IrClass irClass4;
                IrClass it = irClass4 = irClass3;
                boolean bl2 = false;
                classMetadata2 = this.getClassMetadata(it.getSymbol());
            }
            ClassMetadata superClassMetadata = classMetadata2;
            ClassMetadata answer$iv = new ClassMetadata((IrClass)irClass2.getOwner(), superClassMetadata, this.getBackendContext().getIrBuiltIns());
            $this$getOrPut$iv.put(irClass2, answer$iv);
            classMetadata = answer$iv;
        } else {
            classMetadata = value$iv;
        }
        return classMetadata;
    }

    @Override
    @NotNull
    public WasmSymbol<WasmFunction> referenceFunction(@NotNull IrFunctionSymbol irFunction2) {
        Intrinsics.checkNotNullParameter(irFunction2, "irFunction");
        return this.wasmFragment.getFunctions().reference(irFunction2);
    }

    @Override
    @NotNull
    public WasmSymbol<WasmGlobal> referenceGlobal(@NotNull IrFieldSymbol irField) {
        Intrinsics.checkNotNullParameter(irField, "irField");
        return this.wasmFragment.getGlobals().reference(irField);
    }

    @Override
    @NotNull
    public WasmSymbol<WasmTypeDeclaration> referenceGcType(@NotNull IrClassSymbol irClass2) {
        boolean bl;
        Intrinsics.checkNotNullParameter(irClass2, "irClass");
        IrType type2 = IrTypesKt.getDefaultType(irClass2);
        boolean bl2 = bl = !IrTypePredicatesKt.isNothing(type2);
        if (!bl) {
            boolean bl3 = false;
            String string2 = "Can't reference Nothing type";
            throw new IllegalArgumentException(string2.toString());
        }
        return this.wasmFragment.getGcTypes().reference(irClass2);
    }

    @Override
    @NotNull
    public WasmSymbol<WasmGlobal> referenceClassRTT(@NotNull IrClassSymbol irClass2) {
        Intrinsics.checkNotNullParameter(irClass2, "irClass");
        return this.wasmFragment.getRuntimeTypes().reference(irClass2);
    }

    @Override
    @NotNull
    public WasmSymbol<WasmFunctionType> referenceFunctionType(@NotNull IrFunctionSymbol irFunction2) {
        Intrinsics.checkNotNullParameter(irFunction2, "irFunction");
        return this.wasmFragment.getFunctionTypes().reference(irFunction2);
    }

    @Override
    @NotNull
    public WasmSymbol<Integer> referenceClassId(@NotNull IrClassSymbol irClass2) {
        Intrinsics.checkNotNullParameter(irClass2, "irClass");
        return this.wasmFragment.getClassIds().reference(irClass2);
    }

    @Override
    @NotNull
    public WasmSymbol<Integer> referenceInterfaceTableAddress(@NotNull IrClassSymbol irClass2) {
        Intrinsics.checkNotNullParameter(irClass2, "irClass");
        if (((IrClass)irClass2.getOwner()).getModality() == Modality.ABSTRACT) {
            return new WasmSymbol<Integer>(-1);
        }
        return this.wasmFragment.getReferencedClassITableAddresses().reference(irClass2);
    }

    @Override
    @NotNull
    public WasmSymbol<Integer> referenceInterfaceId(@NotNull IrClassSymbol irInterface) {
        Intrinsics.checkNotNullParameter(irInterface, "irInterface");
        IrType defaultType = IrTypesKt.getDefaultType(irInterface);
        if (IrTypeUtilsKt.isFunction(defaultType)) {
            int n = ((IrClass)irInterface.getOwner()).getTypeParameters().size() - 1;
            return this.wasmFragment.getInterfaceId().reference(this.getBackendContext().getWasmSymbols().functionN(n));
        }
        return this.wasmFragment.getInterfaceId().reference(irInterface);
    }

    @Override
    @NotNull
    public WasmSymbol<Integer> referenceVirtualFunctionId(@NotNull IrSimpleFunctionSymbol irFunction2) {
        Intrinsics.checkNotNullParameter(irFunction2, "irFunction");
        if (((IrSimpleFunction)irFunction2.getOwner()).getModality() == Modality.ABSTRACT) {
            throw new IllegalStateException("Abstract functions are not stored in table".toString());
        }
        return this.wasmFragment.getVirtualFunctionId().reference(irFunction2);
    }

    @Override
    @NotNull
    public WasmSymbol<Integer> referenceSignatureId(@NotNull WasmSignature signature2) {
        Intrinsics.checkNotNullParameter(signature2, "signature");
        this.wasmFragment.getSignatures().add(signature2);
        return this.wasmFragment.getSignatureId().reference(signature2);
    }

    @Override
    @NotNull
    public WasmSymbol<WasmTable> referenceInterfaceTable(@NotNull IrFunctionSymbol irFunction2) {
        Intrinsics.checkNotNullParameter(irFunction2, "irFunction");
        return this.wasmFragment.getInterfaceMethodTables().reference(irFunction2);
    }

    @Override
    @NotNull
    public WasmSymbol<Integer> getStructFieldRef(@NotNull IrField field2) {
        Intrinsics.checkNotNullParameter(field2, "field");
        IrClass klass = IrUtilsKt.getParentAsClass(field2);
        ClassMetadata metadata = this.getClassMetadata(klass.getSymbol());
        int fieldId = metadata.getFields().indexOf(field2);
        return new WasmSymbol<Integer>(fieldId);
    }

    @Override
    public void addJsFun(@NotNull String importName, @NotNull String jsCode2) {
        Intrinsics.checkNotNullParameter(importName, "importName");
        Intrinsics.checkNotNullParameter(jsCode2, "jsCode");
        WasmCompiledModuleFragment wasmCompiledModuleFragment = this.wasmFragment;
        ((Collection)wasmCompiledModuleFragment.getJsFuns()).add(new WasmCompiledModuleFragment.JsCodeSnippet(importName, jsCode2));
    }
}

