/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter.intrinsics;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.interpreter.Instruction;
import org.jetbrains.kotlin.ir.interpreter.IrInterpreterEnvironment;
import org.jetbrains.kotlin.ir.interpreter.UtilsKt;
import org.jetbrains.kotlin.ir.interpreter.intrinsics.EnumValueOf;
import org.jetbrains.kotlin.ir.interpreter.intrinsics.EnumValues;
import org.jetbrains.kotlin.ir.interpreter.intrinsics.IntrinsicBase;
import org.jetbrains.kotlin.ir.interpreter.stack.CallStack;
import org.jetbrains.kotlin.ir.interpreter.state.State;
import org.jetbrains.kotlin.ir.interpreter.state.StateKt;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0010H\u0016J\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/intrinsics/EnumIntrinsics;", "Lorg/jetbrains/kotlin/ir/interpreter/intrinsics/IntrinsicBase;", "()V", "canHandleFunctionWithName", "", "fqName", "", "origin", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOrigin;", "evaluate", "", "irFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "environment", "Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreterEnvironment;", "getListOfAcceptableFunctions", "", "unwind", "Lorg/jetbrains/kotlin/ir/interpreter/Instruction;", "ir.interpreter"})
public final class EnumIntrinsics
extends IntrinsicBase {
    @NotNull
    public static final EnumIntrinsics INSTANCE = new EnumIntrinsics();

    private EnumIntrinsics() {
        super(null);
    }

    @Override
    @NotNull
    public List<String> getListOfAcceptableFunctions() {
        return CollectionsKt.emptyList();
    }

    public final boolean canHandleFunctionWithName(@NotNull String fqName2, @NotNull IrDeclarationOrigin origin) {
        Intrinsics.checkNotNullParameter(fqName2, "fqName");
        Intrinsics.checkNotNullParameter(origin, "origin");
        if (Intrinsics.areEqual(origin, IrDeclarationOrigin.ENUM_CLASS_SPECIAL_MEMBER.INSTANCE)) {
            return true;
        }
        return StringsKt.startsWith$default(fqName2, "kotlin.Enum.", false, 2, null);
    }

    @Override
    @NotNull
    public List<Instruction> unwind(@NotNull IrFunction irFunction2, @NotNull IrInterpreterEnvironment environment) {
        List<Instruction> list2;
        Intrinsics.checkNotNullParameter(irFunction2, "irFunction");
        Intrinsics.checkNotNullParameter(environment, "environment");
        switch (irFunction2.getName().asString()) {
            case "values": {
                list2 = EnumValues.INSTANCE.unwind(irFunction2, environment);
                break;
            }
            case "valueOf": {
                list2 = EnumValueOf.INSTANCE.unwind(irFunction2, environment);
                break;
            }
            default: {
                list2 = super.unwind(irFunction2, environment);
            }
        }
        return list2;
    }

    @Override
    public void evaluate(@NotNull IrFunction irFunction2, @NotNull IrInterpreterEnvironment environment) {
        Intrinsics.checkNotNullParameter(irFunction2, "irFunction");
        Intrinsics.checkNotNullParameter(environment, "environment");
        CallStack callStack = environment.getCallStack$ir_interpreter();
        IrValueParameter irValueParameter = irFunction2.getDispatchReceiverParameter();
        Intrinsics.checkNotNull(irValueParameter);
        State enumEntry = callStack.loadState(irValueParameter.getSymbol());
        switch (irFunction2.getName().asString()) {
            case "<get-ordinal>": 
            case "<get-name>": {
                IrPropertySymbol irPropertySymbol = ((IrSimpleFunction)irFunction2).getCorrespondingPropertySymbol();
                Intrinsics.checkNotNull(irPropertySymbol);
                IrPropertySymbol symbol2 = irPropertySymbol;
                State state = enumEntry.getField(symbol2);
                Intrinsics.checkNotNull(state);
                callStack.pushState(state);
                break;
            }
            case "compareTo": {
                IrPropertySymbol ordinalSymbol = UtilsKt.getOriginalPropertyByName(enumEntry.getIrClass(), "ordinal").getSymbol();
                State other = callStack.loadState(CollectionsKt.single(irFunction2.getValueParameters()).getSymbol());
                State state = enumEntry.getField(ordinalSymbol);
                Intrinsics.checkNotNull(state);
                int n = StateKt.asInt(state);
                State state2 = other.getField(ordinalSymbol);
                Intrinsics.checkNotNull(state2);
                int compareTo = Intrinsics.compare(n, StateKt.asInt(state2));
                callStack.pushState(environment.convertToState$ir_interpreter(compareTo, irFunction2.getReturnType()));
                break;
            }
            case "equals": {
                State other = callStack.loadState(CollectionsKt.single(irFunction2.getValueParameters()).getSymbol());
                callStack.pushState(environment.convertToState$ir_interpreter(enumEntry == other, irFunction2.getReturnType()));
                break;
            }
            case "hashCode": {
                callStack.pushState(environment.convertToState$ir_interpreter(enumEntry.hashCode(), irFunction2.getReturnType()));
                break;
            }
            case "toString": {
                IrPropertySymbol nameSymbol = UtilsKt.getOriginalPropertyByName(enumEntry.getIrClass(), "name").getSymbol();
                State state = enumEntry.getField(nameSymbol);
                Intrinsics.checkNotNull(state);
                callStack.pushState(state);
                break;
            }
            case "values": {
                EnumValues.INSTANCE.evaluate(irFunction2, environment);
                break;
            }
            case "valueOf": {
                EnumValueOf.INSTANCE.evaluate(irFunction2, environment);
            }
        }
    }
}

