/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.util;

import gnu.trove.list.TLongList;
import java.util.Collection;
import net.osmand.data.LatLon;
import net.osmand.osm.edit.Node;
import net.osmand.osm.edit.OsmMapUtils;

public class MapAlgorithms {
    public static boolean isClockwiseWay(TLongList c) {
        if (c.size() == 0) {
            return true;
        }
        long mask = 0xFFFFFFFFL;
        long middleY = 0L;
        for (int i = 0; i < c.size(); ++i) {
            middleY += c.get(i) & mask;
        }
        middleY /= (long)c.size();
        double clockwiseSum = 0.0;
        boolean firstDirectionUp = false;
        int previousX = Integer.MIN_VALUE;
        int firstX = Integer.MIN_VALUE;
        int prevX = (int)(c.get(0) >> 32);
        int prevY = (int)(c.get(0) & mask);
        for (int i = 1; i < c.size(); ++i) {
            int y;
            int x = (int)(c.get(i) >> 32);
            int rX = MapAlgorithms.ray_intersect_x(prevX, prevY, x, y = (int)(c.get(i) & mask), (int)middleY);
            if (rX != Integer.MIN_VALUE) {
                boolean directionUp;
                boolean skipSameSide;
                boolean bl = skipSameSide = (long)y <= middleY == (long)prevY <= middleY;
                if (skipSameSide) continue;
                boolean bl2 = directionUp = (long)prevY >= middleY;
                if (firstX == Integer.MIN_VALUE) {
                    firstDirectionUp = directionUp;
                    firstX = rX;
                } else {
                    boolean clockwise;
                    boolean bl3 = clockwise = !directionUp == previousX < rX;
                    clockwiseSum = clockwise ? (clockwiseSum += (double)Math.abs(previousX - rX)) : (clockwiseSum -= (double)Math.abs(previousX - rX));
                }
                previousX = rX;
            }
            prevX = x;
            prevY = y;
        }
        if (firstX != Integer.MIN_VALUE) {
            boolean clockwise;
            boolean bl = clockwise = !firstDirectionUp == previousX < firstX;
            clockwiseSum = clockwise ? (clockwiseSum += (double)Math.abs(previousX - firstX)) : (clockwiseSum -= (double)Math.abs(previousX - firstX));
        }
        return clockwiseSum >= 0.0;
    }

    public static int ray_intersect_x(int prevX, int prevY, int x, int y, int middleY) {
        if (prevY > y) {
            int tx = x;
            int ty = y;
            x = prevX;
            y = prevY;
            prevX = tx;
            prevY = ty;
        }
        if (y == middleY || prevY == middleY) {
            --middleY;
        }
        if (prevY > middleY || y < middleY) {
            return Integer.MIN_VALUE;
        }
        if (y == prevY) {
            return x;
        }
        double rx = (double)x + ((double)middleY - (double)y) * ((double)x - (double)prevX) / ((double)y - (double)prevY);
        return (int)rx;
    }

    private static long combine2Points(int x, int y) {
        return (long)x << 32 | (long)y;
    }

    public static long calculateIntersection(int inx, int iny, int outx, int outy, int leftX, int rightX, int bottomY, int topY) {
        int ty;
        int tx;
        int by = -1;
        int bx = -1;
        if (outy < topY && iny >= topY && leftX <= (tx = (int)((double)outx + (double)(inx - outx) * (double)(topY - outy) / (double)(iny - outy))) && tx <= rightX) {
            bx = tx;
            by = topY;
            return MapAlgorithms.combine2Points(bx, by);
        }
        if (outy > bottomY && iny <= bottomY && leftX <= (tx = (int)((double)outx + (double)(inx - outx) * (double)(outy - bottomY) / (double)(outy - iny))) && tx <= rightX) {
            bx = tx;
            by = bottomY;
            return MapAlgorithms.combine2Points(bx, by);
        }
        if (outx < leftX && inx >= leftX && (ty = (int)((double)outy + (double)(iny - outy) * (double)(leftX - outx) / (double)(inx - outx))) >= topY && ty <= bottomY) {
            by = ty;
            bx = leftX;
            return MapAlgorithms.combine2Points(bx, by);
        }
        if (outx > rightX && inx <= rightX && (ty = (int)((double)outy + (double)(iny - outy) * (double)(outx - rightX) / (double)(outx - inx))) >= topY && ty <= bottomY) {
            by = ty;
            bx = rightX;
            return MapAlgorithms.combine2Points(bx, by);
        }
        if (outy > topY && iny <= topY && leftX <= (tx = (int)((double)outx + (double)(inx - outx) * (double)(topY - outy) / (double)(iny - outy))) && tx <= rightX) {
            bx = tx;
            by = topY;
            return MapAlgorithms.combine2Points(bx, by);
        }
        if (outy < bottomY && iny >= bottomY && leftX <= (tx = (int)((double)outx + (double)(inx - outx) * (double)(outy - bottomY) / (double)(outy - iny))) && tx <= rightX) {
            bx = tx;
            by = bottomY;
            return MapAlgorithms.combine2Points(bx, by);
        }
        if (outx > leftX && inx <= leftX && (ty = (int)((double)outy + (double)(iny - outy) * (double)(leftX - outx) / (double)(inx - outx))) >= topY && ty <= bottomY) {
            by = ty;
            bx = leftX;
            return MapAlgorithms.combine2Points(bx, by);
        }
        if (outx < rightX && inx >= rightX && (ty = (int)((double)outy + (double)(iny - outy) * (double)(outx - rightX) / (double)(outx - inx))) >= topY && ty <= bottomY) {
            by = ty;
            bx = rightX;
            return MapAlgorithms.combine2Points(bx, by);
        }
        if (outx == rightX || outx == leftX || outy == topY || outy == bottomY) {
            bx = outx;
            by = outy;
        }
        return -1L;
    }

    public static boolean linesIntersect(LatLon a, LatLon b, LatLon c, LatLon d) {
        return MapAlgorithms.linesIntersect(a.getLatitude(), a.getLongitude(), b.getLatitude(), b.getLongitude(), c.getLatitude(), c.getLongitude(), d.getLatitude(), d.getLongitude());
    }

    public static boolean linesIntersect(double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4) {
        if (x1 == x2 && y1 == y2 || x3 == x4 && y3 == y4) {
            return false;
        }
        double ax = x2 - x1;
        double ay = y2 - y1;
        double bx = x3 - x4;
        double by = y3 - y4;
        double cx = x1 - x3;
        double cy = y1 - y3;
        double alphaNumerator = by * cx - bx * cy;
        double commonDenominator = ay * bx - ax * by;
        if (commonDenominator > 0.0 ? alphaNumerator < 0.0 || alphaNumerator > commonDenominator : commonDenominator < 0.0 && (alphaNumerator > 0.0 || alphaNumerator < commonDenominator)) {
            return false;
        }
        double betaNumerator = ax * cy - ay * cx;
        if (commonDenominator > 0.0 ? betaNumerator < 0.0 || betaNumerator > commonDenominator : commonDenominator < 0.0 && (betaNumerator > 0.0 || betaNumerator < commonDenominator)) {
            return false;
        }
        if (commonDenominator == 0.0) {
            double y3LessY1 = y3 - y1;
            double collinearityTestForP3 = x1 * (y2 - y3) + x2 * y3LessY1 + x3 * (y1 - y2);
            return collinearityTestForP3 == 0.0 && (x1 >= x3 && x1 <= x4 || x1 <= x3 && x1 >= x4 || x2 >= x3 && x2 <= x4 || x2 <= x3 && x2 >= x4 || x3 >= x1 && x3 <= x2 || x3 <= x1 && x3 >= x2) && (y1 >= y3 && y1 <= y4 || y1 <= y3 && y1 >= y4 || y2 >= y3 && y2 <= y4 || y2 <= y3 && y2 >= y4 || y3 >= y1 && y3 <= y2 || y3 <= y1 && y3 >= y2);
        }
        return true;
    }

    public static boolean containsPoint(Collection<Node> polyNodes, double latitude, double longitude) {
        return MapAlgorithms.countIntersections(polyNodes, latitude, longitude) % 2 == 1;
    }

    private static int countIntersections(Collection<Node> polyNodes, double latitude, double longitude) {
        int intersections = 0;
        if (polyNodes.size() == 0) {
            return 0;
        }
        Node prev = null;
        Node first = null;
        Node last = null;
        for (Node n : polyNodes) {
            if (prev == null) {
                first = prev = n;
                continue;
            }
            if (n == null) continue;
            last = n;
            if (OsmMapUtils.ray_intersect_lon(prev, n, latitude, longitude) != -360.0) {
                ++intersections;
            }
            prev = n;
        }
        if (first == null || last == null) {
            return 0;
        }
        if (OsmMapUtils.ray_intersect_lon(first, last, latitude, longitude) != -360.0) {
            ++intersections;
        }
        return intersections;
    }
}

