/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.eps;

import java.awt.font.TextLayout;
import net.sourceforge.plantuml.eps.EpsGraphics;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.UnusedSpace;
import net.sourceforge.plantuml.ugraphic.UCenteredCharacter;
import net.sourceforge.plantuml.ugraphic.UDriver;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UParam;
import net.sourceforge.plantuml.ugraphic.UShape;
import net.sourceforge.plantuml.ugraphic.color.ColorMapper;
import net.sourceforge.plantuml.ugraphic.eps.DriverTextEps;

public class DriverCenteredCharacterEps
implements UDriver<EpsGraphics> {
    @Override
    public void draw(UShape ushape, double x, double y, ColorMapper mapper, UParam param, EpsGraphics eps) {
        UCenteredCharacter centeredCharacter = (UCenteredCharacter)ushape;
        char c = centeredCharacter.getChar();
        UFont font = centeredCharacter.getFont();
        UnusedSpace unusedSpace = UnusedSpace.getUnusedSpace(font, c);
        double xpos = x - unusedSpace.getCenterX() - 0.5;
        double ypos = y - unusedSpace.getCenterY() - 0.5;
        TextLayout t = new TextLayout("" + c, font.getUnderlayingFont(), TextBlockUtils.getFontRenderContext());
        eps.setStrokeColor(mapper.toColor(param.getColor()));
        DriverTextEps.drawPathIterator(eps, xpos, ypos, t.getOutline(null));
    }
}

