# Zellij Governance
Zellij is an open source project that belongs to those who contribute to it.
As such, we feel it's important to codify some rules that seem obvious and straightforward now, but might not be in the future.

## Organization members
Members of the Zellij organization are in effect those empowered to make decisions for the project. Individual members are trusted to make decisions on their own and to bring larger and more controversial decisions to be decided by the full quorum of members in a real-time meeting or by correspondence.

## How decisions are made regarding the project
When larger decisions are brought to the full quorum of members, we would like to hear all the voices and dissenting  opinions on the decision at hand. Ideally, we would then decide on a course of action by consensus. Only if one cannot be reached, will each member of the organization get a vote. The decision in the majority will be taken.

In case of ties, one member designated as Arbiter can break the tie. For reasons of focus and expediency, the Arbiter also has veto privileges which are to be used as scarecely as possible.

Some decisions that should always be brought to the quorum of members:
* Adding new members to the organization
* Removing existing members from the organization
* Any decision involving money or finances
* Collaborations with outside organizations

## Role of the Arbiter
The Arbiter is a member of the quorum who serves as a tie breaker in votes and also has veto privileges for the votes themselves. Both of these should be used as seldom as possible and preferably not at all.

### Arbiter no-confidence vote
It is preferable that any conflict with the Arbiter, no matter how severe, be resolved amicably. However, it is acknowledged that this is not always possible. For those cases, and for the health of Zellij and its community, this is the process in order to remove a sitting Arbiter against their will:

1. Find another willing candidate from the existing organization members
2. Email all the organization members to the addresses specified in this document, letting them know about the vote and the replacement candidate
3. All the maintainers have 2 weeks to reply (privately) with a yes (remove the Arbiter) or no (do not remove the Arbiter) vote - the sitting Arbiter does not get a vote
4. The votes should be tallied and verified by the vote initiator as well as another organization member who is not the sitting Arbiter
5. If at least two thirds (rounded up) of the respondents vote to remove - the vote succeeds and the new Arbiter is instated in place of the sitting one
6. The sitting Arbiter remains an organization member unless explicitly removed by a normal majority vote

For the removal of doubt: changing this rule itself requires a two thirds majority of maintainers as well.

## Current Organization Members
* Aram Drevekenin <aram@poor.dev> (Arbiter)
* Doron Tsur <qballer@gmail.com>
* Brooks Rady <b.j.rady@gmail.com>
* Denis Maximov <denis_maxim0v@protonmail.com>
* Kunal Mohan <kunalmohan99@gmail.com>
* Henil Dedania <dedaniahenil@gmail.com>
* Roee Shapira <ro33.sha@gmail.com>
* Alex Kenji Berthold <aks.kenji@protonmail.com>
* Kyle Sutherland-Cash <kyle.sutherlandcash@gmail.com>
* Dante Pippi <dante.dpf@gmail.com>
* Thomas Linford <linford.t@gmail.com>
