/*
 * Copyright (c) 2012, 2019, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_cy extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Africa_Central = new String[] {
               "Amser Canolbarth Affrica",
               "CAT",
               "Central African Summer Time",
               "CAST",
               "Central Africa Time",
               "CAT",
            };
        final String[] Moscow = new String[] {
               "Amser Safonol Moscfa",
               "MSK",
               "Amser Haf Moscfa",
               "MSD",
               "Amser Moscfa",
               "MT",
            };
        final String[] Japan = new String[] {
               "Amser Safonol Siapan",
               "JST",
               "Amser Haf Siapan",
               "JDT",
               "Amser Siapan",
               "JT",
            };
        final String[] Pakistan = new String[] {
               "Amser Safonol Pakistan",
               "PKT",
               "Amser Haf Pakistan",
               "PKST",
               "Amser Pakistan",
               "PKT",
            };
        final String[] Taipei = new String[] {
               "Amser Safonol Taipei",
               "CST",
               "Amser Haf Taipei",
               "CDT",
               "Amser Taipei",
               "CT",
            };
        final String[] Hovd = new String[] {
               "Amser Safonol Hovd",
               "HOVT",
               "Amser Haf Hovd",
               "HOVST",
               "Amser Hovd",
               "HOVT",
            };
        final String[] Magadan = new String[] {
               "Amser Safonol Magadan",
               "MAGT",
               "Amser Haf Magadan",
               "MAGST",
               "Amser Magadan",
               "MAGT",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Amser Safonol Canolbarth Gorllewin Awstralia",
               "ACWST",
               "Amser Haf Canolbarth Gorllewin Awstralia",
               "ACWDT",
               "Amser Canolbarth Gorllewin Awstralia",
               "ACWT",
            };
        final String[] Europe_Central = new String[] {
               "Amser Safonol Canolbarth Ewrop",
               "CET",
               "Amser Haf Canolbarth Ewrop",
               "CEST",
               "Amser Canolbarth Ewrop",
               "CET",
            };
        final String[] Sakhalin = new String[] {
               "Amser Safonol Sakhalin",
               "SAKT",
               "Amser Haf Sakhalin",
               "SAKST",
               "Amser Sakhalin",
               "SAKT",
            };
        final String[] Paraguay = new String[] {
               "Amser Safonol Paraguay",
               "PYT",
               "Amser Haf Paraguay",
               "PYST",
               "Amser Paraguay",
               "PYT",
            };
        final String[] Malaysia = new String[] {
               "Amser Malaysia",
               "MYT",
               "Malaysia Summer Time",
               "MYST",
               "Malaysia Time",
               "MYT",
            };
        final String[] America_Eastern = new String[] {
               "Amser Safonol Dwyrain Gogledd America",
               "EST",
               "Amser Haf Dwyrain Gogledd America",
               "EDT",
               "Amser Dwyrain Gogledd America",
               "ET",
            };
        final String[] Lord_Howe = new String[] {
               "Amser Safonol yr Arglwydd Howe",
               "LHST",
               "Amser Haf yr Arglwydd Howe",
               "LHDT",
               "Amser yr Arglwydd Howe",
               "LHT",
            };
        final String[] New_Zealand = new String[] {
               "Amser Safonol Seland Newydd",
               "NZST",
               "Amser Haf Seland Newydd",
               "NZDT",
               "Amser Seland Newydd",
               "NZT",
            };
        final String[] Indian_Ocean = new String[] {
               "Amser Cefnfor India",
               "IOT",
               "Indian Ocean Territory Summer Time",
               "IOST",
               "Indian Ocean Territory Time",
               "IOT",
            };
        final String[] Yakutsk = new String[] {
               "Amser Safonol Yakutsk",
               "YAKT",
               "Amser Haf Yakutsk",
               "YAKST",
               "Amser Yakutsk",
               "YAKT",
            };
        final String[] Mauritius = new String[] {
               "Amser Safonol Mauritius",
               "MUT",
               "Amser Haf Mauritius",
               "MUST",
               "Amser Mauritius",
               "MUT",
            };
        final String[] Africa_Eastern = new String[] {
               "Amser Dwyrain Affrica",
               "EAT",
               "Eastern African Summer Time",
               "EAST",
               "Eastern Africa Time",
               "EAT",
            };
        final String[] East_Timor = new String[] {
               "Amser Dwyrain Timor",
               "TLT",
               "Timor-Leste Summer Time",
               "TLST",
               "Timor-Leste Time",
               "TLT",
            };
        final String[] Solomon = new String[] {
               "Amser Ynysoedd Solomon",
               "SBT",
               "Solomon Is. Summer Time",
               "SBST",
               "Solomon Is. Time",
               "SBT",
            };
        final String[] Kosrae = new String[] {
               "Amser Kosrae",
               "KOST",
               "Kosrae Summer Time",
               "KOSST",
               "Kosrae Time",
               "KOST",
            };
        final String[] Marshall_Islands = new String[] {
               "Amser Ynysoedd Marshall",
               "MHT",
               "Marshall Islands Summer Time",
               "MHST",
               "Marshall Islands Time",
               "MHT",
            };
        final String[] Europe_Eastern = new String[] {
               "Amser Safonol Dwyrain Ewrop",
               "EET",
               "Amser Haf Dwyrain Ewrop",
               "EEST",
               "Amser Dwyrain Ewrop",
               "EET",
            };
        final String[] Newfoundland = new String[] {
               "Amser Safonol Newfoundland",
               "NST",
               "Amser Haf Newfoundland",
               "NDT",
               "Amser Newfoundland",
               "NT",
            };
        final String[] Afghanistan = new String[] {
               "Amser Afghanistan",
               "AFT",
               "Afghanistan Summer Time",
               "AFST",
               "Afghanistan Time",
               "AFT",
            };
        final String[] Hong_Kong = new String[] {
               "Amser Safonol Hong Kong",
               "HKT",
               "Amser Haf Hong Kong",
               "HKST",
               "Amser Hong Kong",
               "HKT",
            };
        final String[] Argentina_Western = new String[] {
               "Amser Safonol Gorllewin Ariannin",
               "ART",
               "Amser Haf Gorllewin Ariannin",
               "ARST",
               "Amser Gorllewin Ariannin",
               "ART",
            };
        final String[] Atlantic = new String[] {
               "Amser Safonol Cefnfor yr Iwerydd",
               "AST",
               "Amser Haf Cefnfor yr Iwerydd",
               "ADT",
               "Amser Cefnfor yr Iwerydd",
               "AT",
            };
        final String[] Ponape = new String[] {
               "Amser Pohnpei",
               "PONT",
               "Pohnpei Summer Time",
               "PONST",
               "Ponape Time",
               "PONT",
            };
        final String[] Bolivia = new String[] {
               "Amser Bolivia",
               "BOT",
               "Bolivia Summer Time",
               "BOST",
               "Bolivia Time",
               "BOT",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Amser Safonol Saint-Pierre-et-Miquelon",
               "PMST",
               "Amser Haf Saint-Pierre-et-Miquelon",
               "PMDT",
               "Amser Saint-Pierre-et-Miquelon",
               "PMT",
            };
        final String[] Indochina = new String[] {
               "Amser Indo-Tsieina",
               "ICT",
               "Indochina Summer Time",
               "ICST",
               "Indochina Time",
               "ICT",
            };
        final String[] Yekaterinburg = new String[] {
               "Amser Safonol Yekaterinburg",
               "YEKT",
               "Amser Haf Yekaterinburg",
               "YEKST",
               "Amser Yekaterinburg",
               "YEKT",
            };
        final String[] Maldives = new String[] {
               "Amser Y Maldives",
               "MVT",
               "Maldives Summer Time",
               "MVST",
               "Maldives Time",
               "MVT",
            };
        final String[] Tahiti = new String[] {
               "Amser Tahiti",
               "TAHT",
               "Tahiti Summer Time",
               "TAHST",
               "Tahiti Time",
               "TAHT",
            };
        final String[] Israel = new String[] {
               "Amser Safonol Israel",
               "IST",
               "Amser Haf Israel",
               "IDT",
               "Amser Israel",
               "IT",
            };
        final String[] Indonesia_Central = new String[] {
               "Amser Canolbarth Indonesia",
               "WITA",
               "Central Indonesia Summer Time",
               "CIST",
               "Central Indonesia Time",
               "WITA",
            };
        final String[] Wallis = new String[] {
               "Amser Wallis a Futuna",
               "WFT",
               "Wallis & Futuna Summer Time",
               "WFST",
               "Wallis & Futuna Time",
               "WFT",
            };
        final String[] Africa_Southern = new String[] {
               "Amser Safonol De Affrica",
               "SAST",
               "South Africa Summer Time",
               "SAST",
               "South Africa Time",
               "SAT",
            };
        final String[] Syowa = new String[] {
               "Amser Syowa",
               "SYOT",
               "Syowa Summer Time",
               "SYOST",
               "Syowa Time",
               "SYOT",
            };
        final String[] Line_Islands = new String[] {
               "Amser Ynysoedd Line",
               "LINT",
               "Line Is. Summer Time",
               "LINST",
               "Line Is. Time",
               "LINT",
            };
        final String[] Uzbekistan = new String[] {
               "Amser Safonol Wsbecistan",
               "UZT",
               "Amser Haf Wsbecistan",
               "UZST",
               "Amser Wsbecistan",
               "UZT",
            };
        final String[] Omsk = new String[] {
               "Amser Safonol Omsk",
               "OMST",
               "Amser Haf Omsk",
               "OMSST",
               "Amser Omsk",
               "OMST",
            };
        final String[] Seychelles = new String[] {
               "Amser Seychelles",
               "SCT",
               "Seychelles Summer Time",
               "SCST",
               "Seychelles Time",
               "SCT",
            };
        final String[] Uruguay = new String[] {
               "Amser Safonol Uruguay",
               "UYT",
               "Amser Haf Uruguay",
               "UYST",
               "Amser Uruguay",
               "UYT",
            };
        final String[] Nepal = new String[] {
               "Amser Nepal",
               "NPT",
               "Nepal Summer Time",
               "NPST",
               "Nepal Time",
               "NPT",
            };
        final String[] Mongolia = new String[] {
               "Amser Safonol Ulan Bator",
               "ULAT",
               "Amser Haf Ulan Bator",
               "ULAST",
               "Amser Ulan Bator",
               "ULAT",
            };
        final String[] America_Central = new String[] {
               "Amser Safonol Canolbarth Gogledd America",
               "CST",
               "Amser Haf Canolbarth Gogledd America",
               "CDT",
               "Amser Canolbarth Gogledd America",
               "CT",
            };
        final String[] Truk = new String[] {
               "Amser Chuuk",
               "CHUT",
               "Chuuk Summer Time",
               "CHUST",
               "Chuuk Time",
               "CHUT",
            };
        final String[] Niue = new String[] {
               "Amser Niue",
               "NUT",
               "Niue Summer Time",
               "NUST",
               "Niue Time",
               "NUT",
            };
        final String[] Wake = new String[] {
               "Amser Ynys Wake",
               "WAKT",
               "Wake Summer Time",
               "WAKST",
               "Wake Time",
               "WAKT",
            };
        final String[] Falkland = new String[] {
               "Amser Safonol Ynysoedd Falklands/Malvinas",
               "FKT",
               "Amser Haf Ynysoedd Falklands/Malvinas",
               "FKST",
               "Amser Ynysoedd Falklands/Malvinas",
               "FKT",
            };
        final String[] Vanuatu = new String[] {
               "Amser Safonol Vanuatu",
               "VUT",
               "Amser Haf Vanuatu",
               "VUST",
               "Amser Vanuatu",
               "VUT",
            };
        final String[] Novosibirsk = new String[] {
               "Amser Safonol Novosibirsk",
               "NOVT",
               "Amser Haf Novosibirsk",
               "NOVST",
               "Amser Novosibirsk",
               "NOVT",
            };
        final String[] Singapore = new String[] {
               "Amser Singapore",
               "SRET",
               "Srednekolymsk Daylight Time",
               "SREDT",
               "Srednekolymsk Time",
               "SRET",
            };
        final String[] Azores = new String[] {
               "Amser Safonol yr Azores",
               "AZOT",
               "Amser Haf yr Azores",
               "AZOST",
               "Amser yr Azores",
               "AZOT",
            };
        final String[] Apia = new String[] {
               "Amser Safonol Apia",
               "WSST",
               "Amser Haf Apia",
               "WSDT",
               "Amser Apia",
               "WST",
            };
        final String[] Bhutan = new String[] {
               "Amser Bhutan",
               "BTT",
               "Bhutan Summer Time",
               "BTST",
               "Bhutan Time",
               "BTT",
            };
        final String[] Suriname = new String[] {
               "Amser Suriname",
               "SRT",
               "Suriname Summer Time",
               "SRST",
               "Suriname Time",
               "SRT",
            };
        final String[] Nauru = new String[] {
               "Amser Nauru",
               "NRT",
               "Nauru Summer Time",
               "NRST",
               "Nauru Time",
               "NRT",
            };
        final String[] Krasnoyarsk = new String[] {
               "Amser Safonol Krasnoyarsk",
               "KRAT",
               "Amser Haf Krasnoyarsk",
               "KRAST",
               "Amser Krasnoyarsk",
               "KRAT",
            };
        final String[] Kazakhstan_Western = new String[] {
               "Amser Gorllewin Casachstan",
               "AQTT",
               "Aqtau Summer Time",
               "AQTST",
               "Aqtau Time",
               "AQTT",
            };
        final String[] Myanmar = new String[] {
               "Amser Myanmar",
               "MMT",
               "Myanmar Summer Time",
               "MMST",
               "Myanmar Time",
               "MMT",
            };
        final String[] Christmas = new String[] {
               "Amser Ynys Y Nadolig",
               "CXT",
               "Christmas Island Summer Time",
               "CXST",
               "Christmas Island Time",
               "CIT",
            };
        final String[] Amazon = new String[] {
               "Amser Safonol Amazonas",
               "AMT",
               "Amser Haf Amazonas",
               "AMST",
               "Amser Amazonas",
               "AMT",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "Amser Dwyrain Casachstan",
               "ALMT",
               "Alma-Ata Summer Time",
               "ALMST",
               "Alma-Ata Time",
               "ALMT",
            };
        final String[] Fiji = new String[] {
               "Amser Safonol Fiji",
               "FJT",
               "Amser Haf Fiji",
               "FJST",
               "Amser Fiji",
               "FJT",
            };
        final String[] Reunion = new String[] {
               "Amser R\u00e9union",
               "RET",
               "Reunion Summer Time",
               "REST",
               "Reunion Time",
               "RET",
            };
        final String[] Cocos = new String[] {
               "Amser Ynysoedd Cocos",
               "CCT",
               "Cocos Islands Summer Time",
               "CCST",
               "Cocos Islands Time",
               "CCT",
            };
        final String[] Chatham = new String[] {
               "Amser Safonol Chatham",
               "CHAST",
               "Amser Haf Chatham",
               "CHADT",
               "Amser Chatham",
               "CHAT",
            };
        final String[] Vostok = new String[] {
               "Amser Vostok",
               "VOST",
               "Vostok Summer Time",
               "VOSST",
               "Vostok Time",
               "VOST",
            };
        final String[] Argentina = new String[] {
               "Amser Safonol Ariannin",
               "ART",
               "Amser Haf Ariannin",
               "ARST",
               "Amser yr Ariannin",
               "ART",
            };
        final String[] Gambier = new String[] {
               "Amser Gambier",
               "GAMT",
               "Gambier Summer Time",
               "GAMST",
               "Gambier Time",
               "GAMT",
            };
        final String[] Tuvalu = new String[] {
               "Amser Tuvalu",
               "TVT",
               "Tuvalu Summer Time",
               "TVST",
               "Tuvalu Time",
               "TVT",
            };
        final String[] Galapagos = new String[] {
               "Amser Galapagos",
               "GALT",
               "Galapagos Summer Time",
               "GALST",
               "Galapagos Time",
               "GALT",
            };
        final String[] Macquarie = new String[] {
               "Amser Ynys Macquarie",
               "MIST",
               "Macquarie Island Daylight Time",
               "MIDT",
               "Macquarie Island Time",
               "MIST",
            };
        final String[] Venezuela = new String[] {
               "Amser Venezuela",
               "VET",
               "Venezuela Summer Time",
               "VEST",
               "Venezuela Time",
               "VET",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Amser Safonol Hawaii-Aleutian",
               "HAST",
               "Amser Haf Hawaii-Aleutian",
               "HADT",
               "Amser Hawaii-Aleutian",
               "HAT",
            };
        final String[] Australia_Central = new String[] {
               "Amser Safonol Canolbarth Awstralia",
               "ACST",
               "Amser Haf Canolbarth Awstralia",
               "ACDT",
               "Amser Canolbarth Awstralia",
               "ACT",
            };
        final String[] America_Pacific = new String[] {
               "Amser Safonol Cefnfor Tawel Gogledd America",
               "PST",
               "Amser Haf Cefnfor Tawel Gogledd America",
               "PDT",
               "Amser Cefnfor Tawel Gogledd America",
               "PT",
            };
        final String[] Phoenix_Islands = new String[] {
               "Amser Ynysoedd Phoenix",
               "PHOT",
               "Phoenix Is. Summer Time",
               "PHOST",
               "Phoenix Is. Time",
               "PHOT",
            };
        final String[] Turkmenistan = new String[] {
               "Amser Safonol Tyrcmenistan",
               "TMT",
               "Amser Haf Tyrcmenistan",
               "TMST",
               "Amser Tyrcmenistan",
               "TMT",
            };
        final String[] Europe_Western = new String[] {
               "Amser Safonol Gorllewin Ewrop",
               "WET",
               "Amser Haf Gorllewin Ewrop",
               "WEST",
               "Amser Gorllewin Ewrop",
               "WET",
            };
        final String[] Cape_Verde = new String[] {
               "Amser Safonol Cabo Verde",
               "CVT",
               "Amser Haf Cabo Verde",
               "CVST",
               "Amser Cabo Verde",
               "CVT",
            };
        final String[] Norfolk = new String[] {
               "Amser Ynys Norfolk",
               "NFT",
               "Norfolk Summer Time",
               "NFST",
               "Norfolk Time",
               "NFT",
            };
        final String[] Guyana = new String[] {
               "Amser Guyana",
               "GYT",
               "Guyana Summer Time",
               "GYST",
               "Guyana Time",
               "GYT",
            };
        final String[] Pitcairn = new String[] {
               "Amser Pitcairn",
               "PST",
               "Pitcairn Daylight Time",
               "PDT",
               "Pitcairn Time",
               "PT",
            };
        final String[] Rothera = new String[] {
               "Amser Rothera",
               "ROTT",
               "Rothera Summer Time",
               "ROTST",
               "Rothera Time",
               "ROTT",
            };
        final String[] Samoa = new String[] {
               "Amser Safonol Samoa",
               "SST",
               "Amser Haf Samoa",
               "SDT",
               "Amser Samoa",
               "ST",
            };
        final String[] Palau = new String[] {
               "Amser Palau",
               "PWT",
               "Palau Summer Time",
               "PWST",
               "Palau Time",
               "PWT",
            };
        final String[] Europe_Further_Eastern = new String[] {
               "Amser Dwyrain Pell Ewrop",
               "MSK",
               "Moscow Daylight Time",
               "MSD",
               "Moscow Time",
               "MT",
            };
        final String[] Azerbaijan = new String[] {
               "Amser Safonol Aserbaijan",
               "AZT",
               "Amser Haf Aserbaijan",
               "AZST",
               "Amser Aserbaijan",
               "AZT",
            };
        final String[] Mawson = new String[] {
               "Amser Mawson",
               "MAWT",
               "Mawson Summer Time",
               "MAWST",
               "Mawson Time",
               "MAWT",
            };
        final String[] Mexico_Pacific = new String[] {
               "Amser Safonol Pasiffig Mecsico",
               "MST",
               "Amser Haf Pasiffig Mecsico",
               "MDT",
               "Amser Pasiffig Mecsico",
               "MT",
            };
        final String[] Davis = new String[] {
               "Amser Davis",
               "DAVT",
               "Davis Summer Time",
               "DAVST",
               "Davis Time",
               "DAVT",
            };
        final String[] Cuba = new String[] {
               "Amser Safonol Cuba",
               "CST",
               "Amser Haf Cuba",
               "CDT",
               "Amser Cuba",
               "CT",
            };
        final String[] Africa_Western = new String[] {
               "Amser Safonol Gorllewin Affrica",
               "CAT",
               "Amser Haf Gorllewin Affrica",
               "CAST",
               "Amser Gorllewin Affrica",
               "CAT",
            };
        final String[] GMT = new String[] {
               "Amser Safonol Greenwich",
               "GMT",
               "Greenwich Mean Time",
               "GMT",
               "Greenwich Mean Time",
               "GMT",
            };
        final String[] Philippines = new String[] {
               "Amser Safonol Pilipinas",
               "PHT",
               "Amser Haf Pilipinas",
               "PHST",
               "Amser Pilipinas",
               "PHT",
            };
        final String[] French_Southern = new String[] {
               "Amser Deheuol ac Antarctig Frengig",
               "TFT",
               "French Southern & Antarctic Lands Summer Time",
               "TFST",
               "French Southern & Antarctic Lands Time",
               "TFT",
            };
        final String[] South_Georgia = new String[] {
               "Amser De Georgia",
               "GST",
               "South Georgia Daylight Time",
               "GDT",
               "South Georgia Time",
               "GT",
            };
        final String[] New_Caledonia = new String[] {
               "Amser Safonol Caledonia Newydd",
               "NCT",
               "Amser Haf Caledonia Newydd",
               "NCST",
               "Amser Caledonia Newydd",
               "NCT",
            };
        final String[] Brunei = new String[] {
               "Amser Brunei Darussalam",
               "BNT",
               "Brunei Summer Time",
               "BNST",
               "Brunei Time",
               "BNT",
            };
        final String[] Iran = new String[] {
               "Amser Safonol Iran",
               "IRST",
               "Amser Haf Iran",
               "IRDT",
               "Amser Iran",
               "IRT",
            };
        final String[] Easter = new String[] {
               "Amser Safonol Ynys y Pasg",
               "EAST",
               "Amser Haf Ynys y Pasg",
               "EASST",
               "Amser Ynys y Pasg",
               "EAST",
            };
        final String[] Mexico_Northwest = new String[] {
               "Amser Safonol Gogledd Orllewin Mecsico",
               "PST",
               "Amser Haf Gogledd Orllewin Mecsico",
               "PDT",
               "Amser Gogledd Orllewin Mecsico",
               "PT",
            };
        final String[] DumontDUrville = new String[] {
               "Amser Dumont-d\u2019Urville",
               "DDUT",
               "Dumont-d'Urville Summer Time",
               "DDUST",
               "Dumont-d'Urville Time",
               "DDUT",
            };
        final String[] Tajikistan = new String[] {
               "Amser Tajicistan",
               "TJT",
               "Tajikistan Summer Time",
               "TJST",
               "Tajikistan Time",
               "TJT",
            };
        final String[] Tonga = new String[] {
               "Amser Safonol Tonga",
               "TOT",
               "Amser Haf Tonga",
               "TOST",
               "Amser Tonga",
               "TOT",
            };
        final String[] Bangladesh = new String[] {
               "Amser Safonol Bangladesh",
               "BDT",
               "Amser Haf Bangladesh",
               "BDST",
               "Amser Bangladesh",
               "BDT",
            };
        final String[] Peru = new String[] {
               "Amser Safonol Periw",
               "PET",
               "Amser Haf Periw",
               "PEST",
               "Amser Periw",
               "PET",
            };
        final String[] Greenland_Western = new String[] {
               "Amser Safonol Gorllewin yr Ynys Las",
               "WGT",
               "Amser Haf Gorllewin yr Ynys Las",
               "WGST",
               "Amser Gorllewin yr Ynys Las",
               "WGT",
            };
        final String[] Ecuador = new String[] {
               "Amser Ecuador",
               "ECT",
               "Ecuador Summer Time",
               "ECST",
               "Ecuador Time",
               "ECT",
            };
        final String[] Greenland_Eastern = new String[] {
               "Amser Safonol Dwyrain yr Ynys Las",
               "EGT",
               "Amser Haf Dwyrain yr Ynys Las",
               "EGST",
               "Amser Dwyrain yr Ynys Las",
               "EGT",
            };
        final String[] Gulf = new String[] {
               "Amser Safonol y Gwlff",
               "GST",
               "Gulf Daylight Time",
               "GDT",
               "Gulf Time",
               "GT",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Amser Dwyrain Indonesia",
               "WIT",
               "East Indonesia Summer Time",
               "EIST",
               "East Indonesia Time",
               "WIT",
            };
        final String[] Korea = new String[] {
               "Amser Safonol Corea",
               "KST",
               "Amser Haf Corea",
               "KDT",
               "Amser Corea",
               "KT",
            };
        final String[] Australia_Western = new String[] {
               "Amser Safonol Gorllewin Awstralia",
               "AWST",
               "Amser Haf Gorllewin Awstralia",
               "AWDT",
               "Amser Gorllewin Awstralia",
               "AWT",
            };
        final String[] Kyrgystan = new String[] {
               "Amser Casachstan",
               "KGT",
               "Kirgizstan Summer Time",
               "KGST",
               "Kirgizstan Time",
               "KGT",
            };
        final String[] Indonesia_Western = new String[] {
               "Amser Gorllewin Indonesia",
               "WIB",
               "West Indonesia Summer Time",
               "WIST",
               "West Indonesia Time",
               "WIB",
            };
        final String[] Australia_Eastern = new String[] {
               "Amser Safonol Dwyrain Awstralia",
               "AEST",
               "Amser Haf Dwyrain Awstralia",
               "AEDT",
               "Amser Dwyrain Awstralia",
               "AET",
            };
        final String[] French_Guiana = new String[] {
               "Amser Guyane Ffrengig",
               "GFT",
               "French Guiana Summer Time",
               "GFST",
               "French Guiana Time",
               "GFT",
            };
        final String[] Colombia = new String[] {
               "Amser Safonol Colombia",
               "COT",
               "Amser Haf Colombia",
               "COST",
               "Amser Colombia",
               "COT",
            };
        final String[] Chile = new String[] {
               "Amser Safonol Chile",
               "CLT",
               "Amser Haf Chile",
               "CLST",
               "Amser Chile",
               "CLT",
            };
        final String[] Gilbert_Islands = new String[] {
               "Amser Ynysoedd Gilbert",
               "GILT",
               "Gilbert Is. Summer Time",
               "GILST",
               "Gilbert Is. Time",
               "GILT",
            };
        final String[] America_Mountain = new String[] {
               "Amser Safonol Mynyddoedd Gogledd America",
               "MST",
               "Amser Haf Mynyddoedd Gogledd America",
               "MDT",
               "Amser Mynyddoedd Gogledd America",
               "MT",
            };
        final String[] Marquesas = new String[] {
               "Amser Marquises",
               "MART",
               "Marquesas Summer Time",
               "MARST",
               "Marquesas Time",
               "MART",
            };
        final String[] Arabian = new String[] {
               "Amser Safonol Arabaidd",
               "AST",
               "Amser Haf Arabaidd",
               "ADT",
               "Amser Arabaidd",
               "AT",
            };
        final String[] Alaska = new String[] {
               "Amser Safonol Alaska",
               "AKST",
               "Amser Haf Alaska",
               "AKDT",
               "Amser Alaska",
               "AKT",
            };
        final String[] Vladivostok = new String[] {
               "Amser Safonol Vladivostok",
               "VLAT",
               "Amser Haf Vladivostok",
               "VLAST",
               "Amser Vladivostok",
               "VLAT",
            };
        final String[] Chamorro = new String[] {
               "Amser Chamorro",
               "ChST",
               "Chamorro Daylight Time",
               "ChDT",
               "Chamorro Time",
               "ChT",
            };
        final String[] Irkutsk = new String[] {
               "Amser Safonol Irkutsk",
               "IRKT",
               "Amser Haf Irkutsk",
               "IRKST",
               "Amser Irkutsk",
               "IRKT",
            };
        final String[] Georgia = new String[] {
               "Amser Safonol Georgia",
               "GET",
               "Amser Haf Georgia",
               "GEST",
               "Amser Georgia",
               "GET",
            };
        final String[] Tokelau = new String[] {
               "Amser Tokelau",
               "TKT",
               "Tokelau Summer Time",
               "TKST",
               "Tokelau Time",
               "TKT",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Amser Papua Guinea Newydd",
               "PGT",
               "Papua New Guinea Summer Time",
               "PGST",
               "Papua New Guinea Time",
               "PGT",
            };
        final String[] Noronha = new String[] {
               "Amser Safonol Fernando de Noronha",
               "FNT",
               "Amser Haf Fernando de Noronha",
               "FNST",
               "Amser Fernando de Noronha",
               "FNT",
            };
        final String[] Choibalsan = new String[] {
               "Amser Safonol Choibalsan",
               "CHOT",
               "Amser Haf Choibalsan",
               "CHOST",
               "Amser Choibalsan",
               "CHOT",
            };
        final String[] Brasilia = new String[] {
               "Amser Safonol Bras\u00edlia",
               "BRT",
               "Amser Haf Bras\u00edlia",
               "BRST",
               "Amser Bras\u00edlia",
               "BRT",
            };
        final String[] China = new String[] {
               "Amser Safonol Tsieina",
               "CST",
               "Amser Haf Tsieina",
               "CDT",
               "Amser Tsieina",
               "CT",
            };
        final String[] Armenia = new String[] {
               "Amser Safonol Armenia",
               "AMT",
               "Amser Haf Armenia",
               "AMST",
               "Amser Armenia",
               "AMT",
            };
        final String[] India = new String[] {
               "Amser India",
               "IST",
               "India Daylight Time",
               "IDT",
               "India Time",
               "IT",
            };
        final String[] Cook = new String[] {
               "Amser Safonol Ynysoedd Cook",
               "CKT",
               "Amser Hanner Haf Ynysoedd Cook",
               "CKHST",
               "Amser Ynysoedd Cook",
               "CKT",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "Asia/Aden", Arabian },
            { "America/Cuiaba", Amazon },
            { "Africa/Nairobi", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "America/El_Salvador", America_Central },
            { "Asia/Pontianak", Indonesia_Western },
            { "Africa/Cairo", Europe_Eastern },
            { "Pacific/Pago_Pago", Samoa },
            { "Africa/Mbabane", Africa_Southern },
            { "Asia/Kuching", Malaysia },
            { "Pacific/Rarotonga", Cook },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Europe/London",
                new String[] {
                    "Amser Safonol Greenwich",
                    "GMT",
                    "Amser Haf Prydain",
                    "GMT",
                    "Greenwich Mean Time",
                    "GMT",
                }
            },
            { "America/Belize", America_Central },
            { "America/Panama", America_Eastern },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Asia/Yerevan", Armenia },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Jersey", GMT },
            { "America/Tegucigalpa", America_Central },
            { "Europe/Istanbul", Europe_Eastern },
            { "America/Miquelon", Pierre_Miquelon },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Atlantic/St_Helena", GMT },
            { "Europe/Guernsey", GMT },
            { "America/Grand_Turk", Atlantic },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Phnom_Penh", Indochina },
            { "Africa/Kigali", Africa_Central },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Asia/Dubai", Gulf },
            { "Europe/Isle_of_Man", GMT },
            { "America/Araguaina", Brasilia },
            { "Asia/Novosibirsk", Novosibirsk },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tunis", Europe_Central },
            { "Pacific/Fakaofo", Tokelau },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Banjul", GMT },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "Antarctica/Syowa", Syowa },
            { "Indian/Reunion", Reunion },
            { "Pacific/Palau", Palau },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "America/Montevideo", Uruguay },
            { "Africa/Windhoek", Africa_Western },
            { "Asia/Karachi", Pakistan },
            { "Africa/Mogadishu", Africa_Eastern },
            { "Australia/Perth", Australia_Western },
            { "Asia/Chita", Yakutsk },
            { "Pacific/Easter", Easter },
            { "Antarctica/Davis", Davis },
            { "Antarctica/McMurdo", New_Zealand },
            { "America/Manaus", Amazon },
            { "Africa/Freetown", GMT },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "Pacific/Tahiti", Tahiti },
            { "Africa/Asmera", Africa_Eastern },
            { "Europe/Busingen", Europe_Central },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Africa/Malabo", Africa_Western },
            { "Europe/Skopje", Europe_Central },
            { "America/Catamarca", Argentina },
            { "America/Godthab", Greenland_Western },
            { "Europe/Sarajevo", Europe_Central },
            { "Africa/Lagos", Africa_Western },
            { "America/Cordoba", Argentina },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mauritius", Mauritius },
            { "America/Regina", America_Central },
            { "America/Dawson_Creek", America_Mountain },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "America/Anguilla", Atlantic },
            { "Asia/Dili", East_Timor },
            { "Africa/Bamako", GMT },
            { "Pacific/Wallis", Wallis },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Lubumbashi", Africa_Central },
            { "America/Havana", Cuba },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Omsk", Omsk },
            { "Europe/Vaduz", Europe_Central },
            { "Asia/Dhaka", Bangladesh },
            { "America/Barbados", Atlantic },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Chatham", Chatham },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "America/Curacao", Atlantic },
            { "Asia/Dushanbe", Tajikistan },
            { "America/Guyana", Guyana },
            { "America/Guayaquil", Ecuador },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rankin_Inlet", America_Central },
            { "Pacific/Ponape", Ponape },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Europe/Zagreb", Europe_Central },
            { "America/Port_of_Spain", Atlantic },
            { "Europe/Helsinki", Europe_Eastern },
            { "Asia/Beirut", Europe_Eastern },
            { "Pacific/Bougainville", New_Zealand },
            { "Africa/Sao_Tome", GMT },
            { "Indian/Chagos", Indian_Ocean },
            { "America/Cayenne", French_Guiana },
            { "Asia/Yakutsk", Yakutsk },
            { "Pacific/Galapagos", Galapagos },
            { "Africa/Ndjamena", Africa_Western },
            { "Pacific/Fiji", Fiji },
            { "America/Rainy_River", America_Central },
            { "Indian/Maldives", Maldives },
            { "Asia/Oral", Kazakhstan_Western },
            { "America/Yellowknife", America_Mountain },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "America/Juneau", Alaska },
            { "America/Indiana/Vevay", America_Eastern },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Jakarta", Indonesia_Western },
            { "Africa/Ceuta", Europe_Central },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "America/Noronha", Noronha },
            { "America/Swift_Current", America_Central },
            { "Australia/Adelaide", Australia_Central },
            { "America/Metlakatla", Alaska },
            { "Africa/Djibouti", Africa_Eastern },
            { "America/Paramaribo", Suriname },
            { "Europe/Simferopol", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Nouakchott", GMT },
            { "Europe/Prague", Europe_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/Mawson", Mawson },
            { "America/Kralendijk", Atlantic },
            { "Antarctica/Troll", GMT },
            { "Indian/Christmas", Christmas },
            { "America/Antigua", Atlantic },
            { "Pacific/Gambier", Gambier },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Pacific/Funafuti", Tuvalu },
            { "Antarctica/Macquarie", Macquarie },
            { "America/Moncton", Atlantic },
            { "Africa/Gaborone", Africa_Central },
            { "America/St_Vincent", Atlantic },
            { "Asia/Gaza", Europe_Eastern },
            { "PST8PDT", America_Pacific },
            { "Atlantic/Faeroe", Europe_Western },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "America/Yakutat", Alaska },
            { "Antarctica/Casey", Australia_Western },
            { "Europe/Copenhagen", Europe_Central },
            { "Atlantic/Azores", Azores },
            { "Europe/Vienna", Europe_Central },
            { "Pacific/Pitcairn", Pitcairn },
            { "America/Mazatlan", Mexico_Pacific },
            { "Pacific/Nauru", Nauru },
            { "Europe/Tirane", Europe_Central },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "America/Dominica", Atlantic },
            { "Africa/Abidjan", GMT },
            { "America/Mendoza", Argentina },
            { "America/Santarem", Brasilia },
            { "America/Asuncion", Paraguay },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "EST5EDT", America_Eastern },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Wake", Wake },
            { "Atlantic/Bermuda", Atlantic },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "Europe/Amsterdam", Europe_Central },
            { "America/Indiana/Knox", America_Central },
            { "America/North_Dakota/Beulah", America_Central },
            { "Africa/Accra", GMT },
            { "America/Maceio", Brasilia },
            { "Pacific/Apia", Apia },
            { "Pacific/Niue", Niue },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Dublin",
                new String[] {
                    "Amser Safonol Greenwich",
                    "GMT",
                    "Amser Haf Iwerddon",
                    "GMT",
                    "Greenwich Mean Time",
                    "GMT",
                }
            },
            { "Pacific/Truk", Truk },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "Asia/Bishkek", Kyrgystan },
            { "Atlantic/Stanley", Falkland },
            { "Indian/Mahe", Seychelles },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Vladivostok", Vladivostok },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "America/Kentucky/Monticello", America_Eastern },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Coral_Harbour", America_Eastern },
            { "Pacific/Marquesas", Marquesas },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Baghdad", Arabian },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Tijuana", America_Pacific },
            { "Pacific/Saipan", Chamorro },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", Mexico_Pacific },
            { "America/Ojinaga", America_Mountain },
            { "Asia/Hovd", Hovd },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/Santiago", Chile },
            { "Asia/Baku", Azerbaijan },
            { "America/Argentina/Ushuaia", Argentina },
            { "Atlantic/Reykjavik", GMT },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/La_Paz", Bolivia },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "Asia/Taipei", Taipei },
            { "Asia/Manila", Philippines },
            { "Asia/Bangkok", Indochina },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Atlantic/Madeira", Europe_Western },
            { "Antarctica/Palmer", Chile },
            { "America/Thunder_Bay", America_Eastern },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Creston", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "Antarctica/Vostok", Vostok },
            { "Europe/Andorra", Europe_Central },
            { "Asia/Vientiane", Indochina },
            { "Pacific/Kiritimati", Line_Islands },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Asia/Riyadh", Arabian },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/Oslo", Europe_Central },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "Asia/Kuwait", Arabian },
            { "Pacific/Efate", Vanuatu },
            { "Africa/Lome", GMT },
            { "America/Bogota", Colombia },
            { "America/Menominee", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "Pacific/Norfolk", Norfolk },
            { "America/Resolute", America_Central },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "Africa/Bujumbura", Africa_Central },
            { "America/Santo_Domingo", Atlantic },
            { "Europe/Minsk", Europe_Further_Eastern },
            { "Pacific/Auckland", New_Zealand },
            { "America/Glace_Bay", Atlantic },
            { "Asia/Qatar", Arabian },
            { "Europe/Kiev", Europe_Eastern },
            { "Asia/Magadan", Magadan },
            { "America/Port-au-Prince", America_Eastern },
            { "America/St_Barthelemy", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Africa/Luanda", Africa_Western },
            { "America/Nipigon", America_Eastern },
            { "Asia/Muscat", Gulf },
            { "Asia/Bahrain", Arabian },
            { "Europe/Vilnius", Europe_Eastern },
            { "America/Fortaleza", Brasilia },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Cancun", America_Eastern },
            { "Africa/Maseru", Africa_Southern },
            { "Pacific/Kosrae", Kosrae },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Seoul", Korea },
            { "Australia/Sydney", Australia_Eastern },
            { "America/Lima", Peru },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "Asia/Brunei", Brunei },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Colombo", India },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Europe/Volgograd", Moscow },
            { "America/Lower_Princes", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Africa/Blantyre", Africa_Central },
            { "America/Danmarkshavn", GMT },
            { "America/Detroit", America_Eastern },
            { "America/Thule", Atlantic },
            { "Africa/Lusaka", Africa_Central },
            { "Asia/Hong_Kong", Hong_Kong },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Dakar", GMT },
            { "America/Tortola", Atlantic },
            { "America/Porto_Velho", Amazon },
            { "Asia/Sakhalin", Sakhalin },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Africa/Harare", Africa_Central },
            { "America/Nome", Alaska },
            { "Europe/Tallinn", Europe_Eastern },
            { "Africa/Khartoum", Africa_Eastern },
            { "Africa/Johannesburg", Africa_Southern },
            { "Africa/Bangui", Africa_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Africa/Bissau", GMT },
            { "Asia/Tehran", Iran },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "Asia/Saigon", Indochina },
            { "Pacific/Midway", Samoa },
            { "America/Jujuy", Argentina },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "America/Pangnirtung", America_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Africa/Niamey", Africa_Western },
            { "America/Whitehorse", America_Pacific },
            { "Pacific/Noumea", New_Caledonia },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Boa_Vista", Amazon },
            { "America/Grenada", Atlantic },
            { "Australia/Darwin", Australia_Central },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Rangoon", Myanmar },
            { "Europe/Bratislava", Europe_Central },
            { "Asia/Calcutta", India },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Kabul", Afghanistan },
            { "Indian/Cocos", Cocos },
            { "Pacific/Tongatapu", Tonga },
            { "America/Merida", America_Central },
            { "America/St_Kitts", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Caracas", Venezuela },
            { "America/Guadeloupe", Atlantic },
            { "Asia/Hebron", Europe_Eastern },
            { "Indian/Kerguelen", French_Southern },
            { "Africa/Monrovia", GMT },
            { "Asia/Ust-Nera", Vladivostok },
            { "Asia/Srednekolymsk", Singapore },
            { "America/North_Dakota/New_Salem", America_Central },
            { "Asia/Anadyr", Magadan },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "America/Winnipeg", America_Central },
            { "Europe/Vatican", Europe_Central },
            { "Asia/Amman", Europe_Eastern },
            { "America/Toronto", America_Eastern },
            { "Asia/Singapore", Singapore },
            { "Australia/Lindeman", Australia_Eastern },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Guadalcanal", Solomon },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Monaco", Europe_Central },
        };
        return data;
    }
}
