/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.buf;

public final class Ascii {
    private static final byte[] toLower;
    private static final boolean[] isDigit;
    private static final long OVERFLOW_LIMIT = 0xCCCCCCCCCCCCCCCL;

    public static int toLower(int n) {
        return toLower[n & 0xFF] & 0xFF;
    }

    private static boolean isDigit(int n) {
        return isDigit[n & 0xFF];
    }

    public static long parseLong(byte[] byArray, int n, int n2) throws NumberFormatException {
        byte by;
        if (byArray == null || n2 <= 0 || !Ascii.isDigit(by = byArray[n++])) {
            throw new NumberFormatException();
        }
        long l = by - 48;
        while (--n2 > 0) {
            if (Ascii.isDigit(by = byArray[n++]) && (l < 0xCCCCCCCCCCCCCCCL || l == 0xCCCCCCCCCCCCCCCL && by - 48 < 8)) {
                l = l * 10L + (long)by - 48L;
                continue;
            }
            throw new NumberFormatException();
        }
        return l;
    }

    static {
        int n;
        toLower = new byte[256];
        isDigit = new boolean[256];
        for (n = 0; n < 256; ++n) {
            Ascii.toLower[n] = (byte)n;
        }
        for (n = 97; n <= 122; ++n) {
            int n2 = n + 65 - 97;
            Ascii.toLower[n2] = (byte)n;
        }
        for (n = 48; n <= 57; ++n) {
            Ascii.isDigit[n] = true;
        }
    }
}

