/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.beans.PropertyVetoException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.management.ManagementFactory;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import org.openide.filesystems.AbstractFileSystem;
import org.openide.filesystems.AbstractFolder;
import org.openide.filesystems.ExternalUtil;
import org.openide.filesystems.FSException;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.BaseUtilities;
import org.openide.util.Enumerations;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class JarFileSystem
extends AbstractFileSystem {
    static final long serialVersionUID = -98124752801761145L;
    private static final RequestProcessor req = new RequestProcessor("JarFs - modification watcher", 1, false, false);
    private static final int REFRESH_TIME = Integer.getInteger("org.openide.filesystems.JarFileSystem.REFRESH_TIME", 0);
    private static final long MEM_STREAM_SIZE = 100000L;
    private static final int CLOSE_DELAY_MAX = 5000;
    private static final int CLOSE_DELAY_MIN = 300;
    private transient JarFile jar;
    private transient Manifest manifest;
    private File root = new File(".");
    private volatile transient RequestProcessor.Task watcherTask = null;
    private volatile transient RequestProcessor.Task closeTask = null;
    private transient long lastModification = 0L;
    private static final Logger LOGGER = Logger.getLogger(JarFileSystem.class.getName());
    private transient Object closeSync = new Object();
    private int checkTime = REFRESH_TIME;
    private transient long aliveCount = 0L;
    private transient Cache strongCache;
    private transient Reference<Cache> softCache = new SoftReference<Object>(null);
    private transient FileObject foRoot;
    private transient FileChangeListener fcl;
    private transient int closeDelay = 300;
    private transient long openRequestTime = 0L;

    public JarFileSystem() {
        Impl impl = new Impl(this);
        this.list = impl;
        this.info = impl;
        this.change = impl;
        this.attr = impl;
    }

    public JarFileSystem(File file) throws IOException {
        this();
        try {
            this.setJarFile(file, true, false);
        }
        catch (PropertyVetoException propertyVetoException) {
            throw (IOException)new IOException().initCause(propertyVetoException);
        }
    }

    @Override
    protected <T extends FileObject> Reference<T> createReference(T t) {
        ++this.aliveCount;
        if (this.checkTime > 0 && this.watcherTask == null) {
            this.watcherTask = req.post(this.watcherTask(), this.checkTime);
        }
        return new Ref(this, t);
    }

    private void freeReference() {
        --this.aliveCount;
        if (this.aliveCount == 0L) {
            RequestProcessor.Task task = this.watcherTask;
            if (task != null) {
                task.cancel();
                this.watcherTask = null;
            }
            this.strongCache = null;
            this.closeCurrentRoot(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Manifest getManifest() {
        if (this.manifest == null) {
            try {
                Object object = this.closeSync;
                synchronized (object) {
                    JarFile jarFile = this.reOpenJarFile();
                    this.manifest = jarFile == null ? null : jarFile.getManifest();
                    this.manifest = this.manifest == null ? null : new Manifest(this.manifest);
                }
            }
            catch (IOException iOException) {
            }
            finally {
                this.closeCurrentRoot(false);
            }
            if (this.manifest == null) {
                this.manifest = new Manifest();
            }
        }
        return this.manifest;
    }

    public void setJarFile(File file) throws IOException, PropertyVetoException {
        this.setJarFile(file, true, true);
    }

    private void _setSystemName(String string) throws PropertyVetoException {
        this.setSystemName(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setJarFile(final File file, boolean bl, boolean bl2) throws IOException, PropertyVetoException {
        if (!file.equals(FileUtil.normalizeFile(file))) {
            throw new IllegalArgumentException("Parameter aRoot was not normalized. Was " + file + " instead of " + FileUtil.normalizeFile(file));
        }
        FileObject fileObject = null;
        String string = this.getDisplayName();
        if (this.getRefreshTime() > 0) {
            this.setRefreshTime(0);
        }
        if (file == null) {
            throw new FSException(NbBundle.getMessage(JarFileSystem.class, (String)"EXC_NotValidFile", (Object)file));
        }
        if (!file.exists()) {
            throw new FSException(NbBundle.getMessage(JarFileSystem.class, (String)"EXC_FileNotExists", (Object)file.getAbsolutePath()));
        }
        if (!file.canRead()) {
            throw new FSException(NbBundle.getMessage(JarFileSystem.class, (String)"EXC_CanntRead", (Object)file.getAbsolutePath()));
        }
        if (!file.isFile()) {
            throw new FSException(NbBundle.getMessage(JarFileSystem.class, (String)"EXC_NotValidFile", (Object)file.getAbsolutePath()));
        }
        String string2 = file.getAbsolutePath();
        string2 = string2.intern();
        JarFile jarFile = null;
        if (bl2) {
            try {
                jarFile = new JarFile(string2, false);
                LOGGER.log(Level.FINE, "opened: " + System.currentTimeMillis() + "   " + string2);
            }
            catch (ZipException zipException) {
                throw new FSException(NbBundle.getMessage(JarFileSystem.class, (String)"EXC_NotValidJarFile2", (Object)zipException.getLocalizedMessage(), (Object)string2));
            }
        }
        Object object = this.closeSync;
        synchronized (object) {
            this._setSystemName(string2);
            this.closeCurrentRoot(false);
            this.setJar(jarFile);
            this.openRequestTime = System.currentTimeMillis();
            this.root = new File(string2);
            if (bl) {
                this.strongCache = null;
                this.softCache.clear();
                this.aliveCount = 0L;
                fileObject = this.refreshRoot();
                this.manifest = null;
                this.lastModification = 0L;
                if (fileObject != null) {
                    this.firePropertyChange("root", null, fileObject);
                }
            }
        }
        this.firePropertyChange("displayName", string, this.getDisplayName());
        this.foRoot = FileUtil.toFileObject(this.root);
        if (this.foRoot != null && this.fcl == null) {
            this.fcl = new FileChangeAdapter(){

                @Override
                public void fileChanged(FileEvent fileEvent) {
                    if (JarFileSystem.this.watcherTask == null) {
                        JarFileSystem.this.parse(true);
                    }
                }

                @Override
                public void fileRenamed(FileRenameEvent fileRenameEvent) {
                    File file2 = FileUtil.toFile(fileRenameEvent.getFile());
                    if (file2 != null && !file2.equals(file)) {
                        try {
                            JarFileSystem.this.setJarFile(file2, false, true);
                        }
                        catch (IOException iOException) {
                            ExternalUtil.exception(iOException);
                        }
                        catch (PropertyVetoException propertyVetoException) {
                            ExternalUtil.exception(propertyVetoException);
                        }
                    }
                }

                @Override
                public void fileDeleted(FileEvent fileEvent) {
                    Enumeration<? extends FileObject> enumeration = JarFileSystem.this.existingFileObjects(JarFileSystem.this.getRoot());
                    while (enumeration.hasMoreElements()) {
                        AbstractFolder abstractFolder = (AbstractFolder)enumeration.nextElement();
                        abstractFolder.validFlag = false;
                        abstractFolder.fileDeleted0(new FileEvent(abstractFolder));
                    }
                    JarFileSystem.this.refreshRoot();
                }
            };
            if (bl) {
                this.foRoot.addFileChangeListener(FileUtil.weakFileChangeListener(this.fcl, this.foRoot));
            }
        }
    }

    public File getJarFile() {
        return this.root;
    }

    @Override
    public String getDisplayName() {
        return this.root != null ? this.root.getAbsolutePath() : NbBundle.getMessage(JarFileSystem.class, (String)"JAR_UnknownJar");
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public void removeNotify() {
        this.closeCurrentRoot(true);
    }

    protected String[] children(String string) {
        Cache cache = this.getCache();
        return cache.getChildrenOf(string);
    }

    protected void createFolder(String string) throws IOException {
        throw new IOException();
    }

    protected void createData(String string) throws IOException {
        throw new IOException();
    }

    protected void rename(String string, String string2) throws IOException {
        throw new IOException();
    }

    protected void delete(String string) throws IOException {
        throw new IOException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Date lastModified(String string) {
        long l;
        if (string.length() == 0) {
            l = this.getJarFile().lastModified();
        } else {
            try {
                l = this.getEntry(string).getTime();
            }
            finally {
                this.closeCurrentRoot(false);
            }
        }
        return new Date(l);
    }

    protected boolean folder(String string) {
        if ("".equals(string)) {
            return true;
        }
        Cache cache = this.getCache();
        return cache.isFolder(string);
    }

    protected boolean readOnly(String string) {
        return true;
    }

    protected String mimeType(String string) {
        return null;
    }

    protected long size(String string) {
        long l = this.getEntry(string).getSize();
        this.closeCurrentRoot(false);
        return l == -1L ? 0L : l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream getMemInputStream(JarFile jarFile, JarEntry jarEntry) throws IOException {
        InputStream inputStream = this.getInputStream4336753(jarFile, jarEntry);
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(inputStream.available());){
            FileUtil.copy(inputStream, byteArrayOutputStream);
        }
        return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream getTemporaryInputStream(JarFile jarFile, JarEntry jarEntry, boolean bl) throws IOException {
        File file;
        boolean bl2;
        String string = jarFile.getName();
        String string2 = jarEntry.getName();
        StringBuffer stringBuffer = new StringBuffer("jarfscache");
        stringBuffer.append(System.getProperty("user.name")).append("/");
        File file2 = new File(System.getProperty("java.io.tmpdir"), stringBuffer.toString());
        if (!file2.exists()) {
            file2.mkdirs();
        }
        boolean bl3 = bl2 = !(file = new File(file2, JarFileSystem.temporaryName(string, string2))).exists();
        if (bl2) {
            file.createNewFile();
        } else {
            bl |= Math.abs(System.currentTimeMillis() - file.lastModified()) > 10000L;
        }
        if (bl2 || bl) {
            try (InputStream inputStream = this.getInputStream4336753(jarFile, jarEntry);
                 FileOutputStream fileOutputStream = new FileOutputStream(file);){
                FileUtil.copy(inputStream, fileOutputStream);
            }
        }
        file.deleteOnExit();
        return new FileInputStream(file);
    }

    private static String temporaryName(String string, String string2) {
        String string3 = String.valueOf(string.hashCode());
        String string4 = String.valueOf(string2.hashCode());
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("f").append(string3).append("e").append(string4);
        return stringBuffer.toString().replace('-', 'x');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InputStream inputStream(String string) throws FileNotFoundException {
        InputStream inputStream = null;
        try {
            Object object = this.closeSync;
            synchronized (object) {
                JarEntry jarEntry;
                JarFile jarFile = this.reOpenJarFile();
                if (jarFile != null && (jarEntry = jarFile.getJarEntry(string)) != null) {
                    inputStream = jarEntry.getSize() < 100000L ? this.getMemInputStream(jarFile, jarEntry) : this.getTemporaryInputStream(jarFile, jarEntry, this.strongCache != null);
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw fileNotFoundException;
        }
        catch (IOException iOException) {
            FileNotFoundException fileNotFoundException = new FileNotFoundException(this.root.getAbsolutePath());
            fileNotFoundException.initCause(iOException);
            throw fileNotFoundException;
        }
        catch (RuntimeException runtimeException) {
            FileNotFoundException fileNotFoundException = new FileNotFoundException(this.root.getAbsolutePath());
            fileNotFoundException.initCause(runtimeException);
            throw fileNotFoundException;
        }
        finally {
            this.closeCurrentRoot(false);
        }
        if (inputStream == null) {
            throw new FileNotFoundException(string);
        }
        return inputStream;
    }

    private InputStream getInputStream4336753(JarFile jarFile, JarEntry jarEntry) throws IOException {
        InputStream inputStream = null;
        while (inputStream == null) {
            try {
                inputStream = jarFile.getInputStream(jarEntry);
                break;
            }
            catch (NullPointerException nullPointerException) {
            }
        }
        return inputStream;
    }

    protected OutputStream outputStream(String string) throws IOException {
        throw new IOException();
    }

    protected void lock(String string) throws IOException {
        throw new FSException(NbBundle.getMessage(JarFileSystem.class, (String)"EXC_CannotLock_JAR", (Object)string, (Object)this.root));
    }

    protected void unlock(String string) {
    }

    protected void markUnimportant(String string) {
    }

    protected Object readAttribute(String string, String string2) {
        if ("java.io.File".equals(string2)) {
            return null;
        }
        Attributes attributes = this.getManifest().getAttributes(string);
        try {
            return attributes == null ? null : attributes.getValue(string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    protected void writeAttribute(String string, String string2, Object object) throws IOException {
        throw new IOException("Setting attribute not allowed for JarFileSystem [" + this.getDisplayName() + "!" + string + " <- " + string2 + "=" + object + "]");
    }

    protected Enumeration<String> attributes(String string) {
        Attributes attributes = this.getManifest().getAttributes(string);
        if (attributes != null) {
            class ToString
            implements Enumerations.Processor<Object, String> {
                ToString() {
                }

                public String process(Object object, Collection<Object> collection) {
                    return object.toString();
                }
            }
            return Enumerations.convert(Collections.enumeration(attributes.keySet()), (Enumerations.Processor)new ToString());
        }
        return Enumerations.empty();
    }

    protected void renameAttributes(String string, String string2) {
    }

    protected void deleteAttributes(String string) {
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.closeCurrentRoot(false);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.closeSync = new Object();
        this.strongCache = null;
        this.softCache = new SoftReference<Object>(null);
        this.aliveCount = 0L;
        try {
            this.setJarFile(this.root);
        }
        catch (PropertyVetoException propertyVetoException) {
            throw new IOException(propertyVetoException.getMessage());
        }
        catch (IOException iOException) {
            ExternalUtil.log(iOException.getLocalizedMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JarFile reOpenJarFile() throws IOException {
        Object object = this.closeSync;
        synchronized (object) {
            if (this.closeTask != null) {
                this.closeTask.cancel();
            }
            long l = System.currentTimeMillis();
            long l2 = l - this.openRequestTime;
            this.openRequestTime = l;
            this.closeDelay = (int)Math.min(5000.0, Math.max(300.0, 1.5 * (double)l2));
            return this.getJar(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeCurrentRoot(boolean bl) {
        Object object = this.closeSync;
        synchronized (object) {
            if (this.closeTask != null) {
                this.closeTask.cancel();
            }
            if (bl) {
                this.realClose().run();
            } else {
                this.closeTask = req.post(this.realClose(), this.closeDelay);
            }
        }
    }

    private Runnable realClose() {
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = JarFileSystem.this.closeSync;
                synchronized (object) {
                    JarFile jarFile = JarFileSystem.this.getJar(false);
                    if (jarFile != null) {
                        try {
                            jarFile.close();
                            LOGGER.log(Level.FINE, "closed: " + System.currentTimeMillis() + "   " + JarFileSystem.this.root.getAbsolutePath());
                        }
                        catch (Exception exception) {
                            ExternalUtil.exception(exception);
                        }
                        finally {
                            JarFileSystem.this.setJar(null);
                            JarFileSystem.this.closeTask = null;
                        }
                    }
                }
            }
        };
    }

    private Cache getCache() {
        Cache cache = this.strongCache;
        if (cache == null) {
            cache = this.softCache.get();
        }
        if (cache == null) {
            cache = this.parse(false);
        }
        assert (cache != null);
        return cache;
    }

    private void refreshExistingFileObjects() {
        Cache cache = this.getCache();
        String[] stringArray = new String[]{};
        Enumeration<? extends FileObject> enumeration = this.existingFileObjects(this.getRoot());
        while (enumeration.hasMoreElements()) {
            AbstractFolder abstractFolder = (AbstractFolder)enumeration.nextElement();
            assert (abstractFolder != null);
            if (abstractFolder.isFolder() && !abstractFolder.isInitialized()) continue;
            String[] stringArray2 = cache.getChildrenOf(abstractFolder.getPath());
            if (stringArray2 == null) {
                stringArray2 = stringArray;
            }
            abstractFolder.refresh(null, null, true, true, stringArray2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Cache parse(boolean bl) {
        Object object;
        block22: {
            JarFile jarFile = null;
            this.beginAtomicAction();
            try {
                Object object2 = this.closeSync;
                synchronized (object2) {
                    long l = System.currentTimeMillis();
                    this.lastModification = 0L;
                    this.closeCurrentRoot(false);
                    for (int i = 0; i <= 2; ++i) {
                        try {
                            jarFile = this.reOpenJarFile();
                            break;
                        }
                        catch (IOException iOException) {
                            if (i < 2) continue;
                            Cache cache = Cache.INVALID;
                            // MONITOREXIT @DISABLED, blocks:[0, 7, 8, 11] lbl16 : MonitorExitStatement: MONITOREXIT : var5_3
                            this.closeCurrentRoot(false);
                            if (bl) {
                                this.refreshExistingFileObjects();
                            }
                            if (this.checkTime > 0 && this.watcherTask == null) {
                                this.watcherTask = req.post(this.watcherTask(), this.checkTime);
                            }
                            this.finishAtomicAction();
                            return cache;
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                this.closeCurrentRoot(false);
                if (bl) {
                    this.refreshExistingFileObjects();
                }
                if (this.checkTime > 0 && this.watcherTask == null) {
                    this.watcherTask = req.post(this.watcherTask(), this.checkTime);
                }
                this.finishAtomicAction();
                throw throwable;
            }
            {
                try {
                    Object object3;
                    Enumeration<JarEntry> enumeration = jarFile.entries();
                    HashSet<String> hashSet = new HashSet<String>();
                    HashSet<JarEntry> hashSet2 = new HashSet<JarEntry>();
                    boolean bl2 = false;
                    while (enumeration.hasMoreElements()) {
                        object3 = enumeration.nextElement();
                        object = ((ZipEntry)object3).getName();
                        if (hashSet.add((String)object)) {
                            hashSet2.add((JarEntry)object3);
                            continue;
                        }
                        if (bl2) continue;
                        LOGGER.warning("Duplicate entries in " + this.getJarFile() + ": " + (String)object + "; please report to JAR creator.");
                        bl2 = true;
                    }
                    object3 = new Cache(hashSet2);
                    this.lastModification = this.root.lastModified();
                    this.strongCache = object3;
                    this.softCache = new SoftReference<Object>(object3);
                    object = object3;
                    // MONITOREXIT @DISABLED, blocks:[4, 7] lbl54 : MonitorExitStatement: MONITOREXIT : var5_3
                    this.closeCurrentRoot(false);
                    if (bl) {
                        this.refreshExistingFileObjects();
                    }
                    if (this.checkTime <= 0 || this.watcherTask != null) break block22;
                }
                catch (Throwable throwable) {
                    Cache cache = Cache.INVALID;
                    // MONITOREXIT @DISABLED, blocks:[7, 9] lbl62 : MonitorExitStatement: MONITOREXIT : var5_3
                    this.closeCurrentRoot(false);
                    if (bl) {
                        this.refreshExistingFileObjects();
                    }
                    if (this.checkTime > 0 && this.watcherTask == null) {
                        this.watcherTask = req.post(this.watcherTask(), this.checkTime);
                    }
                    this.finishAtomicAction();
                    return cache;
                }
            }
            this.watcherTask = req.post(this.watcherTask(), this.checkTime);
        }
        this.finishAtomicAction();
        return object;
    }

    private Runnable watcherTask() {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    if (JarFileSystem.this.root == null) {
                        return;
                    }
                    if (JarFileSystem.this.root.lastModified() != JarFileSystem.this.lastModification) {
                        JarFileSystem.this.parse(true);
                    }
                }
                finally {
                    RequestProcessor.Task task = JarFileSystem.this.watcherTask;
                    if (task != null) {
                        task.schedule(JarFileSystem.this.checkTime);
                    }
                }
            }
        };
    }

    @Override
    final void waitRefreshed() {
        RequestProcessor.Task task = this.watcherTask;
        if (task != null) {
            task.waitFinished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final JarEntry getEntry(String string) {
        JarFile jarFile = null;
        try {
            Object object = this.closeSync;
            synchronized (object) {
                jarFile = this.reOpenJarFile();
                JarEntry jarEntry = null;
                if (jarFile != null) {
                    jarEntry = jarFile.getJarEntry(string);
                }
                if (jarEntry != null) {
                    return jarEntry;
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new JarEntry(string);
    }

    private JarFile getJar(boolean bl) {
        assert (Thread.holdsLock(this.closeSync));
        if (this.jar == null && bl) {
            try {
                if (this.root.canRead()) {
                    this.jar = new JarFile(this.root, false);
                    LOGGER.log(Level.FINE, "opened: {0} {1}", new Object[]{this.root.getAbsolutePath(), System.currentTimeMillis()});
                    return this.jar;
                }
            }
            catch (ZipException zipException) {
                JarFileSystem.dumpFDs();
                LOGGER.log(Level.INFO, zipException.getMessage(), zipException);
            }
            catch (IOException iOException) {
                LOGGER.log(Level.INFO, iOException.getMessage(), iOException);
            }
            LOGGER.log(Level.WARNING, "cannot open {0}", this.root.getAbsolutePath());
        }
        return this.jar;
    }

    private void setJar(JarFile jarFile) {
        this.jar = jarFile;
    }

    private static void dumpFDs() {
        if (BaseUtilities.isUnix()) {
            int n;
            String string = ManagementFactory.getRuntimeMXBean().getName().replaceAll("@.*", "");
            LOGGER.log(Level.INFO, "Dumping file descriptors for pid {0}", string);
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.info("Cannot get pid");
                return;
            }
            File file = new File("/proc/" + n + "/fd");
            File[] fileArray = file.listFiles();
            String string2 = fileArray == null ? "nothing" : fileArray.length + " files";
            LOGGER.log(Level.INFO, "There is {0} in {1}", new Object[]{string2, file});
            if (fileArray != null) {
                for (File file2 : fileArray) {
                    try {
                        LOGGER.log(Level.INFO, "{0} -> {1}", new Object[]{file2, file2.getCanonicalFile()});
                    }
                    catch (IOException iOException) {
                        LOGGER.log(Level.INFO, "{0}", file2);
                    }
                }
            }
        }
    }

    private static class Cache {
        private static final Set<JarEntry> EMPTY_SET = Collections.emptySet();
        static final Cache INVALID = new Cache(EMPTY_SET);
        byte[] names = new byte[1000];
        private int nameOffset = 0;
        int[] EMPTY = new int[0];
        private Map<String, Folder> folders = new HashMap<String, Folder>();

        public Cache(Set<JarEntry> set) {
            this.parse(set);
            this.trunc();
        }

        public boolean isFolder(String string) {
            return this.folders.get(string) != null;
        }

        public String[] getChildrenOf(String string) {
            Folder folder = this.folders.get(string);
            if (folder != null) {
                return folder.getNames();
            }
            return new String[0];
        }

        private void parse(Set<JarEntry> set) {
            this.folders.put("", new Folder());
            for (JarEntry jarEntry : set) {
                String string = jarEntry.getName();
                boolean bl = false;
                if ((string = string.replace('\\', '/')).startsWith("/")) {
                    string = string.substring(1);
                }
                if (string.endsWith("/")) {
                    string = string.substring(0, string.length() - 1);
                    bl = true;
                }
                int n = string.lastIndexOf(47);
                String string2 = "";
                String string3 = string;
                if (n > 0) {
                    string2 = string.substring(0, n);
                    string3 = string.substring(n + 1);
                }
                if (bl) {
                    this.getFolder(string);
                    continue;
                }
                Folder folder = this.getFolder(string2);
                folder.addChild(string3);
            }
        }

        private Folder getFolder(String string) {
            Folder folder = this.folders.get(string);
            if (folder == null) {
                int n = string.lastIndexOf(47);
                String string2 = "";
                String string3 = string;
                if (n > 0) {
                    string2 = string.substring(0, n);
                    string3 = string.substring(n + 1);
                }
                this.getFolder(string2).addChild(string3);
                folder = new Folder();
                this.folders.put(string, folder);
            }
            return folder;
        }

        private void trunc() {
            byte[] byArray = new byte[this.nameOffset];
            System.arraycopy(this.names, 0, byArray, 0, this.nameOffset);
            this.names = byArray;
            for (Folder folder : this.folders.values()) {
                folder.trunc();
            }
        }

        private int putName(byte[] byArray) {
            int n = this.nameOffset;
            if (n + byArray.length > this.names.length) {
                byte[] byArray2 = new byte[this.names.length * 2 + byArray.length];
                System.arraycopy(this.names, 0, byArray2, 0, n);
                this.names = byArray2;
            }
            System.arraycopy(byArray, 0, this.names, n, byArray.length);
            this.nameOffset += byArray.length;
            return n;
        }

        private class Folder {
            private int[] indices;
            private int idx;

            public Folder() {
                this.indices = Cache.this.EMPTY;
                this.idx = 0;
            }

            public String[] getNames() {
                String[] stringArray = new String[this.idx / 2];
                for (int i = 0; i < stringArray.length; ++i) {
                    byte[] byArray = new byte[this.indices[2 * i + 1]];
                    System.arraycopy(Cache.this.names, this.indices[2 * i], byArray, 0, byArray.length);
                    try {
                        stringArray[i] = new String(byArray, "UTF-8");
                        continue;
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        throw new InternalError("No UTF-8");
                    }
                }
                return stringArray;
            }

            void addChild(String string) {
                Object[] objectArray;
                if (this.idx + 2 > this.indices.length) {
                    objectArray = new int[2 * this.indices.length + 2];
                    System.arraycopy(this.indices, 0, objectArray, 0, this.idx);
                    this.indices = objectArray;
                }
                try {
                    objectArray = string.getBytes("UTF-8");
                    this.indices[this.idx++] = Cache.this.putName(objectArray);
                    this.indices[this.idx++] = objectArray.length;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new InternalError("No UTF-8");
                }
            }

            void trunc() {
                if (this.indices.length > this.idx) {
                    int[] nArray = new int[this.idx];
                    System.arraycopy(this.indices, 0, nArray, 0, this.idx);
                    this.indices = nArray;
                }
            }
        }
    }

    public static class Impl
    implements AbstractFileSystem.List,
    AbstractFileSystem.Info,
    AbstractFileSystem.Change,
    AbstractFileSystem.Attr {
        static final long serialVersionUID = -67233308132567232L;
        private JarFileSystem fs;

        public Impl(JarFileSystem jarFileSystem) {
            this.fs = jarFileSystem;
        }

        @Override
        public String[] children(String string) {
            return this.fs.children(string);
        }

        @Override
        public void createFolder(String string) throws IOException {
            this.fs.createFolder(string);
        }

        @Override
        public void createData(String string) throws IOException {
            this.fs.createData(string);
        }

        @Override
        public void rename(String string, String string2) throws IOException {
            this.fs.rename(string, string2);
        }

        @Override
        public void delete(String string) throws IOException {
            this.fs.delete(string);
        }

        @Override
        public Date lastModified(String string) {
            return this.fs.lastModified(string);
        }

        @Override
        public boolean folder(String string) {
            return this.fs.folder(string);
        }

        @Override
        public boolean readOnly(String string) {
            return this.fs.readOnly(string);
        }

        @Override
        public String mimeType(String string) {
            return this.fs.mimeType(string);
        }

        @Override
        public long size(String string) {
            return this.fs.size(string);
        }

        @Override
        public InputStream inputStream(String string) throws FileNotFoundException {
            return this.fs.inputStream(string);
        }

        @Override
        public OutputStream outputStream(String string) throws IOException {
            return this.fs.outputStream(string);
        }

        @Override
        public void lock(String string) throws IOException {
            this.fs.lock(string);
        }

        @Override
        public void unlock(String string) {
            this.fs.unlock(string);
        }

        @Override
        public void markUnimportant(String string) {
            this.fs.markUnimportant(string);
        }

        @Override
        public Object readAttribute(String string, String string2) {
            return this.fs.readAttribute(string, string2);
        }

        @Override
        public void writeAttribute(String string, String string2, Object object) throws IOException {
            this.fs.writeAttribute(string, string2, object);
        }

        @Override
        public Enumeration<String> attributes(String string) {
            return this.fs.attributes(string);
        }

        @Override
        public void renameAttributes(String string, String string2) {
            this.fs.renameAttributes(string, string2);
        }

        @Override
        public void deleteAttributes(String string) {
            this.fs.deleteAttributes(string);
        }
    }

    private static class Ref<T extends FileObject>
    extends WeakReference<T>
    implements Runnable {
        final /* synthetic */ JarFileSystem this$0;

        public Ref(T t) {
            this.this$0 = var1_1;
            super(t, BaseUtilities.activeReferenceQueue());
        }

        @Override
        public void run() {
            this.this$0.freeReference();
        }
    }
}

