/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.common.item;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.openjdk.jmc.common.IPredicate;
import org.openjdk.jmc.common.IWritableState;
import org.openjdk.jmc.common.item.IAccessorFactory;
import org.openjdk.jmc.common.item.ICanonicalAccessorFactory;
import org.openjdk.jmc.common.item.IItem;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.item.IMemberAccessor;
import org.openjdk.jmc.common.item.IType;
import org.openjdk.jmc.common.item.PersistableItemFilter;
import org.openjdk.jmc.common.item.RangeMatchPolicy;
import org.openjdk.jmc.common.unit.ContentType;
import org.openjdk.jmc.common.unit.IRange;
import org.openjdk.jmc.common.unit.RangeContentType;
import org.openjdk.jmc.common.util.PredicateToolkit;

public class ItemFilters {
    public static IItemFilter type(String typeId) {
        return new Type(typeId);
    }

    public static IItemFilter type(String ... typeIds) {
        return ItemFilters.type(new HashSet<String>(Arrays.asList(typeIds)));
    }

    public static <V> IItemFilter hasAttribute(ICanonicalAccessorFactory<V> attribute) {
        return new HasAttribute<V>(attribute);
    }

    public static <V> IItemFilter notHasAttribute(ICanonicalAccessorFactory<V> attribute) {
        return new NotHasAttribute<V>(attribute);
    }

    public static IItemFilter type(Set<String> typeIds) {
        IItemFilter[] filters = new IItemFilter[typeIds.size()];
        int i = 0;
        for (String type : typeIds) {
            filters[i++] = ItemFilters.type(type);
        }
        return new Types(filters, typeIds);
    }

    public static IItemFilter typeMatches(String typeMatches) {
        return new TypeMatches(typeMatches);
    }

    public static <M> IItemFilter equals(ICanonicalAccessorFactory<M> attribute, M value) {
        return new Equals(attribute, value);
    }

    public static <M> IItemFilter notEquals(ICanonicalAccessorFactory<M> attribute, M value) {
        return new NotEquals(attribute, value);
    }

    public static <M> IItemFilter isNull(ICanonicalAccessorFactory<M> attribute) {
        return new IsNull(attribute);
    }

    public static <M> IItemFilter isNotNull(ICanonicalAccessorFactory<M> attribute) {
        return new IsNotNull(attribute);
    }

    public static IItemFilter all() {
        return new BooleanFilter(true);
    }

    public static IItemFilter none() {
        return new BooleanFilter(false);
    }

    public static IItemFilter matches(ICanonicalAccessorFactory<String> attribute, String regexp) {
        return new Matches(regexp, attribute);
    }

    public static IItemFilter contains(ICanonicalAccessorFactory<String> attribute, String substring) {
        return new Contains(substring, attribute);
    }

    public static IItemFilter notMatches(ICanonicalAccessorFactory<String> attribute, String regexp) {
        return new NotMatches(regexp, attribute);
    }

    public static IItemFilter notContains(ICanonicalAccessorFactory<String> attribute, String regexp) {
        return new NotContains(regexp, attribute);
    }

    public static <M> IItemFilter memberOf(ICanonicalAccessorFactory<M> attribute, Set<M> values) {
        IItemFilter[] filters = new IItemFilter[values.size()];
        int i = 0;
        for (M m : values) {
            filters[i++] = ItemFilters.equals(attribute, m);
        }
        return new MemberOf<M>(filters, attribute, values);
    }

    public static <M extends Comparable<? super M>> IItemFilter less(ICanonicalAccessorFactory<M> attribute, M upperLimit) {
        return new Compare(PersistableItemFilter.Kind.LESS, attribute, upperLimit, null);
    }

    public static <M extends Comparable<? super M>> IItemFilter lessOrEqual(ICanonicalAccessorFactory<M> attribute, M upperLimit) {
        return new Compare(PersistableItemFilter.Kind.LESS_OR_EQUAL, attribute, upperLimit, null);
    }

    public static <M extends Comparable<? super M>> IItemFilter more(ICanonicalAccessorFactory<M> attribute, M lowerLimit) {
        return new Compare(PersistableItemFilter.Kind.MORE, attribute, lowerLimit, null);
    }

    public static <M extends Comparable<? super M>> IItemFilter moreOrEqual(ICanonicalAccessorFactory<M> attribute, M lowerLimit) {
        return new Compare(PersistableItemFilter.Kind.MORE_OR_EQUAL, attribute, lowerLimit, null);
    }

    public static <M extends Comparable<? super M>> IItemFilter rangeIntersects(ICanonicalAccessorFactory<IRange<M>> rangeAttribute, IRange<M> rangeLimit) {
        return ItemFilters.matchRange(RangeMatchPolicy.CLOSED_INTERSECTS_WITH_CLOSED, rangeAttribute, rangeLimit);
    }

    public static <M extends Comparable<? super M>> IItemFilter rangeContainedIn(ICanonicalAccessorFactory<IRange<M>> rangeAttribute, IRange<M> rangeLimit) {
        return ItemFilters.matchRange(RangeMatchPolicy.CONTAINED_IN_CLOSED, rangeAttribute, rangeLimit);
    }

    public static <M extends Comparable<? super M>> IItemFilter centerContainedIn(ICanonicalAccessorFactory<IRange<M>> rangeAttribute, IRange<M> rangeLimit) {
        return ItemFilters.matchRange(RangeMatchPolicy.CENTER_CONTAINED_IN_RIGHT_OPEN, rangeAttribute, rangeLimit);
    }

    public static <M extends Comparable<? super M>> IItemFilter matchRange(RangeMatchPolicy policy, ICanonicalAccessorFactory<IRange<M>> rangeAttribute, IRange<M> rangeLimit) {
        return new RangeMatches(policy.kind, rangeAttribute, rangeLimit);
    }

    public static <M extends Comparable<? super M>> IItemFilter matchRange(PersistableItemFilter.Kind kind, ICanonicalAccessorFactory<IRange<M>> rangeAttribute, IRange<M> rangeLimit) {
        return new RangeMatches(kind, rangeAttribute, rangeLimit);
    }

    public static <M extends Comparable<? super M>> IItemFilter interval(ICanonicalAccessorFactory<M> attribute, M lowerLimit, boolean lowerClosed, M upperLimit, boolean upperClosed) {
        IItemFilter lower = lowerClosed ? ItemFilters.moreOrEqual(attribute, lowerLimit) : ItemFilters.more(attribute, lowerLimit);
        IItemFilter upper = upperClosed ? ItemFilters.lessOrEqual(attribute, upperLimit) : ItemFilters.less(attribute, upperLimit);
        return ItemFilters.and(lower, upper);
    }

    public static IItemFilter and(IItemFilter ... filters) {
        return new Composite(PersistableItemFilter.Kind.AND, filters);
    }

    public static IItemFilter or(IItemFilter ... filters) {
        if (filters.length > 0) {
            if (filters[0] instanceof Type || filters[0] instanceof Types) {
                HashSet<String> types = new HashSet<String>();
                for (IItemFilter f : filters) {
                    if (f instanceof Type) {
                        types.add(((Type)f).typeId);
                        continue;
                    }
                    if (f instanceof Types) {
                        types.addAll(((Types)f).types);
                        continue;
                    }
                    return new Composite(PersistableItemFilter.Kind.OR, filters);
                }
                return new Types(filters, types);
            }
            if (filters[0] instanceof Equals) {
                return ItemFilters.optimizeOr(((Equals)filters[0]).getAttribute(), filters);
            }
        }
        return new Composite(PersistableItemFilter.Kind.OR, filters);
    }

    private static <M> Composite optimizeOr(ICanonicalAccessorFactory<M> attribute, IItemFilter ... filters) {
        HashSet values = new HashSet();
        for (IItemFilter f : filters) {
            Equals ef;
            if (!(f instanceof Equals) || !(ef = (Equals)f).getAttribute().equals(attribute)) {
                return new Composite(PersistableItemFilter.Kind.OR, filters);
            }
            values.add(ef.getValue());
        }
        return new MemberOf<M>(filters, attribute, values);
    }

    public static IItemFilter not(IItemFilter filter) {
        return new Not(filter);
    }

    public static IItemFilter convertToTypes(IItemFilter filter, List<IType<IItem>> types) {
        HashSet<String> typesForFilter = new HashSet<String>();
        for (IType<IItem> t : types) {
            if (!filter.getPredicate(t).equals(PredicateToolkit.truePredicate())) continue;
            typesForFilter.add(t.getIdentifier());
        }
        return ItemFilters.type(typesForFilter);
    }

    public static <V> IItemFilter buildEqualityFilter(PersistableItemFilter.Kind comparisonKind, ICanonicalAccessorFactory<V> attribute, V value) {
        switch (comparisonKind) {
            case EQUALS: {
                return ItemFilters.equals(attribute, value);
            }
            case NOT_EQUALS: {
                return ItemFilters.notEquals(attribute, value);
            }
        }
        return ItemFilters.buildExistenceFilter(comparisonKind, attribute, value);
    }

    public static <V> IItemFilter buildExistenceFilter(PersistableItemFilter.Kind comparisonKind, ICanonicalAccessorFactory<V> attribute, V value) {
        switch (comparisonKind) {
            case EXISTS: {
                return ItemFilters.hasAttribute(attribute);
            }
            case NOT_EXISTS: {
                return ItemFilters.notHasAttribute(attribute);
            }
            case IS_NULL: {
                return ItemFilters.isNull(attribute);
            }
            case IS_NOT_NULL: {
                return ItemFilters.isNotNull(attribute);
            }
        }
        throw new RuntimeException("Unknown comparison kind");
    }

    public static IItemFilter buildStringFilter(PersistableItemFilter.Kind comparisonKind, ICanonicalAccessorFactory<String> attribute, String value) {
        switch (comparisonKind) {
            case MATCHES: {
                return ItemFilters.matches(attribute, value);
            }
            case NOT_MATCHES: {
                return ItemFilters.notMatches(attribute, value);
            }
            case CONTAINS: {
                return ItemFilters.contains(attribute, value);
            }
            case NOT_CONTAINS: {
                return ItemFilters.notContains(attribute, value);
            }
        }
        return ItemFilters.buildComparisonFilter(comparisonKind, attribute, value);
    }

    public static <V extends Comparable<V>> IItemFilter buildComparisonFilter(PersistableItemFilter.Kind comparisonKind, ICanonicalAccessorFactory<V> attribute, V value) {
        switch (comparisonKind) {
            case LESS: {
                return ItemFilters.less(attribute, value);
            }
            case LESS_OR_EQUAL: {
                return ItemFilters.lessOrEqual(attribute, value);
            }
            case MORE: {
                return ItemFilters.more(attribute, value);
            }
            case MORE_OR_EQUAL: {
                return ItemFilters.moreOrEqual(attribute, value);
            }
        }
        return ItemFilters.buildEqualityFilter(comparisonKind, attribute, value);
    }

    public static class BooleanFilter
    implements IItemFilter {
        public boolean value;
        private static final IPredicate<IItem> ALWAYSTRUE = new IPredicate<IItem>(){

            @Override
            public boolean evaluate(IItem o) {
                return true;
            }
        };
        private static final IPredicate<IItem> ALWAYSFALSE = new IPredicate<IItem>(){

            @Override
            public boolean evaluate(IItem o) {
                return false;
            }
        };

        protected BooleanFilter(boolean value) {
            this.value = value;
        }

        @Override
        public IPredicate<IItem> getPredicate(IType<IItem> type) {
            return this.value ? ALWAYSTRUE : ALWAYSFALSE;
        }
    }

    public static class NotContains
    extends AttributeValue<String> {
        NotContains(String substring, ICanonicalAccessorFactory<String> attribute) {
            super(PersistableItemFilter.Kind.NOT_CONTAINS, attribute, substring);
        }

        @Override
        protected IPredicate<IItem> getPredicate(IMemberAccessor<? extends String, IItem> accessor, String substring) {
            return PredicateToolkit.not(PredicateToolkit.contains(accessor, substring));
        }
    }

    public static class Contains
    extends AttributeValue<String> {
        Contains(String substring, ICanonicalAccessorFactory<String> attribute) {
            super(PersistableItemFilter.Kind.CONTAINS, attribute, substring);
        }

        @Override
        protected IPredicate<IItem> getPredicate(IMemberAccessor<? extends String, IItem> accessor, String substring) {
            return PredicateToolkit.contains(accessor, substring);
        }
    }

    public static class NotMatches
    extends AttributeValue<String> {
        NotMatches(String regexp, ICanonicalAccessorFactory<String> attribute) {
            super(PersistableItemFilter.Kind.NOT_MATCHES, attribute, regexp);
        }

        @Override
        protected IPredicate<IItem> getPredicate(IMemberAccessor<? extends String, IItem> accessor, String regexp) {
            return PredicateToolkit.not(PredicateToolkit.matches(accessor, regexp));
        }
    }

    public static class Matches
    extends AttributeValue<String> {
        Matches(String regexp, ICanonicalAccessorFactory<String> attribute) {
            super(PersistableItemFilter.Kind.MATCHES, attribute, regexp);
        }

        @Override
        protected IPredicate<IItem> getPredicate(IMemberAccessor<? extends String, IItem> accessor, String regexp) {
            return PredicateToolkit.matches(accessor, regexp);
        }
    }

    private static class RangeMatches<M extends Comparable<? super M>>
    extends AttributeValue<IRange<M>> {
        private RangeMatches(PersistableItemFilter.Kind kind, ICanonicalAccessorFactory<IRange<M>> attribute, IRange<M> limit) {
            super(kind, attribute, limit);
        }

        @Override
        protected IPredicate<IItem> getPredicate(IMemberAccessor<? extends IRange<M>, IItem> accessor, IRange<M> limit) {
            switch (this.kind) {
                case RANGE_INTERSECTS: {
                    return PredicateToolkit.rangeIntersects(accessor, limit);
                }
                case RANGE_CONTAINED: {
                    return PredicateToolkit.rangeContained(accessor, limit);
                }
                case CENTER_CONTAINED: {
                    return PredicateToolkit.centerContained(accessor, limit);
                }
                case RANGE_NOT_INTERSECTS: {
                    return PredicateToolkit.not(PredicateToolkit.rangeIntersects(accessor, limit));
                }
                case RANGE_NOT_CONTAINED: {
                    return PredicateToolkit.not(PredicateToolkit.rangeContained(accessor, limit));
                }
                case CENTER_NOT_CONTAINED: {
                    return PredicateToolkit.not(PredicateToolkit.centerContained(accessor, limit));
                }
            }
            throw new RuntimeException("Unknown kind " + (Object)((Object)this.kind));
        }

        @Override
        protected void saveArgs(IWritableState memento) {
            memento.putString("field", this.attribute.getIdentifier());
            ContentType valueType = ((RangeContentType)this.attribute.getContentType()).getEndPointContentType();
            RangeMatches.putValueType(memento, valueType);
            RangeMatches.writeValue(((IRange)this.value).getStart(), valueType.getPersister(), memento, "start");
            RangeMatches.writeValue(((IRange)this.value).getEnd(), valueType.getPersister(), memento, "end");
        }
    }

    private static class Compare<M extends Comparable<? super M>>
    extends AttributeValue<M> {
        private Compare(PersistableItemFilter.Kind kind, ICanonicalAccessorFactory<M> attribute, M limit) {
            super(kind, attribute, limit);
        }

        @Override
        protected IPredicate<IItem> getPredicate(IMemberAccessor<? extends M, IItem> accessor, M limit) {
            switch (this.kind) {
                case MORE: {
                    return PredicateToolkit.more(accessor, limit);
                }
                case MORE_OR_EQUAL: {
                    return PredicateToolkit.moreOrEqual(accessor, limit);
                }
                case LESS: {
                    return PredicateToolkit.less(accessor, limit);
                }
                case LESS_OR_EQUAL: {
                    return PredicateToolkit.lessOrEqual(accessor, limit);
                }
            }
            throw new RuntimeException("Unknown kind " + (Object)((Object)this.kind));
        }

        /* synthetic */ Compare(PersistableItemFilter.Kind x0, ICanonicalAccessorFactory x1, Comparable x2, 1 x3) {
            this(x0, x1, x2);
        }
    }

    private static class IsNotNull<M>
    extends AttributeFilter<M> {
        private IsNotNull(ICanonicalAccessorFactory<M> attribute) {
            super(PersistableItemFilter.Kind.IS_NOT_NULL, attribute);
        }

        @Override
        public IPredicate<IItem> getPredicate(IType<IItem> type) {
            IMemberAccessor accessor = this.attribute.getAccessor(type);
            if (accessor != null) {
                return PredicateToolkit.notEquals(accessor, null);
            }
            return PredicateToolkit.falsePredicate();
        }
    }

    private static class IsNull<M>
    extends AttributeFilter<M> {
        private IsNull(ICanonicalAccessorFactory<M> attribute) {
            super(PersistableItemFilter.Kind.IS_NULL, attribute);
        }

        @Override
        public IPredicate<IItem> getPredicate(IType<IItem> type) {
            IMemberAccessor accessor = this.attribute.getAccessor(type);
            if (accessor != null) {
                return PredicateToolkit.equals(accessor, null);
            }
            return PredicateToolkit.truePredicate();
        }
    }

    private static class NotEquals<M>
    extends AttributeValue<M> {
        private NotEquals(ICanonicalAccessorFactory<M> attribute, M value) {
            super(PersistableItemFilter.Kind.NOT_EQUALS, attribute, value);
        }

        @Override
        protected IPredicate<IItem> getPredicate(IMemberAccessor<? extends M, IItem> accessor, M value) {
            return PredicateToolkit.notEquals(accessor, value);
        }
    }

    private static class Equals<M>
    extends AttributeValue<M> {
        private Equals(ICanonicalAccessorFactory<M> attribute, M value) {
            super(PersistableItemFilter.Kind.EQUALS, attribute, value);
        }

        @Override
        protected IPredicate<IItem> getPredicate(IMemberAccessor<? extends M, IItem> accessor, M value) {
            return PredicateToolkit.equals(accessor, value);
        }
    }

    public static class NotHasAttribute<M>
    extends AttributeFilter<M> {
        public NotHasAttribute(ICanonicalAccessorFactory<M> attribute) {
            super(PersistableItemFilter.Kind.NOT_EXISTS, attribute);
        }

        @Override
        public IPredicate<IItem> getPredicate(IType<IItem> type) {
            if (this.attribute.getAccessor(type) == null) {
                return PredicateToolkit.truePredicate();
            }
            return PredicateToolkit.falsePredicate();
        }
    }

    public static class HasAttribute<M>
    extends AttributeFilter<M> {
        public HasAttribute(ICanonicalAccessorFactory<M> attribute) {
            super(PersistableItemFilter.Kind.EXISTS, attribute);
        }

        @Override
        public IPredicate<IItem> getPredicate(IType<IItem> type) {
            if (this.attribute.getAccessor(type) != null) {
                return PredicateToolkit.truePredicate();
            }
            return PredicateToolkit.falsePredicate();
        }
    }

    public static abstract class AttributeValue<M>
    extends AttributeFilter<M> {
        protected final M value;

        private AttributeValue(PersistableItemFilter.Kind kind, ICanonicalAccessorFactory<M> attribute, M value) {
            super(kind, attribute);
            this.value = value;
        }

        public M getValue() {
            return this.value;
        }

        @Override
        protected void saveArgs(IWritableState memento) {
            super.saveArgs(memento);
            AttributeValue.writeValue(this.value, this.attribute.getContentType().getPersister(), memento);
        }

        @Override
        public IPredicate<IItem> getPredicate(IType<IItem> type) {
            IMemberAccessor accessor = this.attribute.getAccessor(type);
            if (accessor != null) {
                return this.getPredicate(accessor, this.value);
            }
            return PredicateToolkit.falsePredicate();
        }

        protected abstract IPredicate<IItem> getPredicate(IMemberAccessor<? extends M, IItem> var1, M var2);

        @Override
        public String toString() {
            return super.toString() + this.toString("value", String.valueOf(this.value));
        }
    }

    public static abstract class AttributeFilter<M>
    extends PersistableItemFilter {
        protected final ICanonicalAccessorFactory<M> attribute;

        protected AttributeFilter(PersistableItemFilter.Kind kind, ICanonicalAccessorFactory<M> attribute) {
            super(kind);
            this.attribute = attribute;
        }

        @Override
        protected void saveArgs(IWritableState memento) {
            memento.putString("field", this.attribute.getIdentifier());
            AttributeFilter.putValueType(memento, this.attribute.getContentType());
        }

        public ICanonicalAccessorFactory<M> getAttribute() {
            return this.attribute;
        }

        public PersistableItemFilter.Kind getKind() {
            return this.kind;
        }

        @Override
        public String toString() {
            return super.toString() + this.toString("attribute", this.attribute);
        }
    }

    public static class TypeMatches
    extends PersistableItemFilter {
        private String typeMatchString;

        TypeMatches(String typeMatchString) {
            super(PersistableItemFilter.Kind.TYPE_MATCHES);
            this.typeMatchString = typeMatchString;
        }

        public String getTypeMatch() {
            return this.typeMatchString;
        }

        @Override
        protected void saveArgs(IWritableState memento) {
            memento.putString("typeMatches", this.typeMatchString);
        }

        @Override
        public IPredicate<IItem> getPredicate(IType<IItem> type) {
            Pattern typeMatch = PredicateToolkit.getValidPattern(this.typeMatchString);
            if (typeMatch.matcher(type.getIdentifier()).matches()) {
                return PredicateToolkit.truePredicate();
            }
            return PredicateToolkit.falsePredicate();
        }

        @Override
        public String toString() {
            return super.toString() + this.toString("typeMatchString", this.typeMatchString);
        }
    }

    public static class Type
    extends PersistableItemFilter {
        private final String typeId;

        Type(String typeId) {
            super(PersistableItemFilter.Kind.TYPE);
            this.typeId = typeId;
        }

        public String getTypeId() {
            return this.typeId;
        }

        @Override
        protected void saveArgs(IWritableState memento) {
            memento.putString("type", this.typeId);
        }

        @Override
        public IPredicate<IItem> getPredicate(IType<IItem> type) {
            if (this.typeId.equals(type.getIdentifier())) {
                return PredicateToolkit.truePredicate();
            }
            return PredicateToolkit.falsePredicate();
        }
    }

    public static class Types
    extends Composite {
        private final Set<String> types;

        Types(IItemFilter[] filters, Set<String> types) {
            super(PersistableItemFilter.Kind.OR, filters);
            this.types = types;
        }

        @Override
        public IPredicate<IItem> getPredicate(IType<IItem> type) {
            if (this.types.contains(type.getIdentifier())) {
                return PredicateToolkit.truePredicate();
            }
            return PredicateToolkit.falsePredicate();
        }

        public Set<String> getTypes() {
            return this.types;
        }
    }

    private static class MemberOf<M>
    extends Composite {
        private final IAccessorFactory<M> attribute;
        private final Set<M> values;

        MemberOf(IItemFilter[] filters, IAccessorFactory<M> attribute, Set<M> values) {
            super(PersistableItemFilter.Kind.OR, filters);
            this.attribute = attribute;
            this.values = values;
        }

        @Override
        public IPredicate<IItem> getPredicate(IType<IItem> type) {
            IMemberAccessor<M, IItem> accessor = this.attribute.getAccessor(type);
            if (accessor != null) {
                return PredicateToolkit.memberOf(accessor, this.values);
            }
            return PredicateToolkit.falsePredicate();
        }
    }

    public static class Composite
    extends PersistableItemFilter {
        private final IItemFilter[] filters;

        Composite(PersistableItemFilter.Kind kind, IItemFilter[] filters) {
            super(kind);
            this.filters = filters;
        }

        public boolean isUnion() {
            return this.kind == PersistableItemFilter.Kind.OR;
        }

        @Override
        protected void saveArgs(IWritableState memento) {
            for (IItemFilter filter : this.filters) {
                if (!(filter instanceof PersistableItemFilter)) continue;
                PersistableItemFilter persistable = (PersistableItemFilter)filter;
                persistable.saveTo(memento.createChild("filter"));
            }
        }

        public IItemFilter[] getFilters() {
            return this.filters;
        }

        @Override
        public IPredicate<IItem> getPredicate(IType<IItem> type) {
            ArrayList predicates = new ArrayList(this.filters.length);
            for (IItemFilter f : this.filters) {
                predicates.add(f.getPredicate(type));
            }
            return this.kind == PersistableItemFilter.Kind.OR ? PredicateToolkit.or(predicates) : PredicateToolkit.and(predicates);
        }
    }

    public static class Not
    extends PersistableItemFilter {
        private final IItemFilter filter;

        Not(IItemFilter filter) {
            super(PersistableItemFilter.Kind.NOT);
            this.filter = filter;
        }

        public IItemFilter getFilter() {
            return this.filter;
        }

        @Override
        protected void saveArgs(IWritableState memento) {
            if (this.filter instanceof PersistableItemFilter) {
                PersistableItemFilter persistable = (PersistableItemFilter)this.filter;
                persistable.saveTo(memento.createChild("filter"));
            }
        }

        @Override
        public IPredicate<IItem> getPredicate(IType<IItem> type) {
            return PredicateToolkit.not(this.filter.getPredicate(type));
        }
    }
}

