/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.gotosource.java;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.graalvm.visualvm.gotosource.SourceHandle;
import org.graalvm.visualvm.gotosource.SourceHandleUtils;
import org.graalvm.visualvm.gotosource.SourcePathHandle;
import org.graalvm.visualvm.gotosource.java.JavaSourceUtils;

final class JavaSourceHandle
extends SourceHandle {
    private static final String LANGUAGE_ID = "java";
    private final String className;
    private final String methodName;
    private final String methodSignature;
    private String text;
    private int line;
    private int column;
    private int offset;
    private int endOffset;
    private final SourcePathHandle pathHandle;

    JavaSourceHandle(String className, String methodName, String methodSignature, int line, SourcePathHandle pathHandle) {
        this.className = className;
        this.methodName = methodName;
        this.methodSignature = methodSignature;
        this.line = line;
        this.offset = -1;
        this.endOffset = -1;
        this.column = -1;
        this.pathHandle = pathHandle;
    }

    @Override
    public String getLanguage() {
        return LANGUAGE_ID;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public String getMethodName() {
        return this.methodName;
    }

    @Override
    public String getMethodSignature() {
        return this.methodSignature;
    }

    @Override
    public int getLine() {
        if (this.line == -1) {
            int[] line_column = SourceHandleUtils.offsetToLineColumn(this.getText(), this.getOffset());
            this.line = line_column[0];
            this.column = line_column[1];
        }
        return this.line;
    }

    @Override
    public int getColumn() {
        if (this.column == -1) {
            int[] line_column = SourceHandleUtils.offsetToLineColumn(this.getText(), this.getOffset());
            this.line = line_column[0];
            this.column = line_column[1];
        }
        return this.column;
    }

    @Override
    public int getOffset() {
        if (this.offset == -1) {
            this.offset = this.methodName == null || this.methodName.isEmpty() || this.methodName.startsWith("*") ? JavaSourceUtils.classDefinitionOffset(this.getText(), this.className, false) : JavaSourceUtils.methodDefinitionOffset(this.getText(), this.className, this.methodName, this.methodSignature, false);
            if (this.offset == -1) {
                this.offset = 0;
            }
        }
        return this.offset;
    }

    @Override
    public int getEndOffset() {
        if (this.endOffset == -1) {
            Pattern pattern;
            Matcher matcher;
            int _offset = this.getOffset();
            String _text = this.getText();
            this.endOffset = _text.charAt(_offset) == '{' ? _offset + 1 : _offset + ((matcher = (pattern = Pattern.compile("(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\.)*\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*")).matcher(_text)).find(_offset) ? matcher.group().length() : 0);
        }
        return this.endOffset;
    }

    @Override
    public String getText() {
        if (this.text == null) {
            this.text = this.pathHandle.readText();
        }
        return this.text;
    }

    @Override
    public String getSourceUri() {
        return this.pathHandle.getPath().toUri().toString();
    }

    @Override
    public String getSourceFile() {
        return this.pathHandle.getRegularPath().toAbsolutePath().toString();
    }

    @Override
    protected void close() {
        this.pathHandle.close();
    }
}

