/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.threads;

import java.security.AccessController;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.tomcat.util.security.PrivilegedSetTccl;
import org.apache.tomcat.util.threads.Constants;
import org.apache.tomcat.util.threads.TaskThread;

public class TaskThreadFactory
implements ThreadFactory {
    private final ThreadGroup group;
    private final AtomicInteger threadNumber = new AtomicInteger(1);
    private final String namePrefix;
    private final boolean daemon;
    private final int threadPriority;

    public TaskThreadFactory(String string, boolean bl, int n) {
        SecurityManager securityManager = System.getSecurityManager();
        this.group = securityManager != null ? securityManager.getThreadGroup() : Thread.currentThread().getThreadGroup();
        this.namePrefix = string;
        this.daemon = bl;
        this.threadPriority = n;
    }

    @Override
    public Thread newThread(Runnable runnable) {
        TaskThread taskThread = new TaskThread(this.group, runnable, this.namePrefix + this.threadNumber.getAndIncrement());
        taskThread.setDaemon(this.daemon);
        taskThread.setPriority(this.threadPriority);
        if (Constants.IS_SECURITY_ENABLED) {
            PrivilegedSetTccl privilegedSetTccl = new PrivilegedSetTccl(taskThread, this.getClass().getClassLoader());
            AccessController.doPrivileged(privilegedSetTccl);
        } else {
            taskThread.setContextClassLoader(this.getClass().getClassLoader());
        }
        return taskThread;
    }
}

