/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.mindmapmode.actions;

import freemind.controller.actions.generated.instance.ArrowLinkPointXmlAction;
import freemind.controller.actions.generated.instance.XmlAction;
import freemind.main.Tools;
import freemind.modes.MindMapArrowLink;
import freemind.modes.MindMapLinkRegistry;
import freemind.modes.mindmapmode.MindMapController;
import freemind.modes.mindmapmode.actions.FreemindAction;
import freemind.modes.mindmapmode.actions.xml.ActionPair;
import freemind.modes.mindmapmode.actions.xml.ActorXml;
import java.awt.Point;
import java.awt.event.ActionEvent;

public class ChangeArrowLinkEndPoints
extends FreemindAction
implements ActorXml {
    private MindMapController controller;

    public ChangeArrowLinkEndPoints(MindMapController modeController) {
        super("change_link_arrows", "images/designer.png", modeController);
        this.controller = modeController;
        this.addActor(this);
    }

    public void setArrowLinkEndPoints(MindMapArrowLink link, Point startPoint, Point endPoint) {
        this.controller.doTransaction((String)this.getValue("Name"), this.getActionPair(link, startPoint, endPoint));
    }

    private ActionPair getActionPair(MindMapArrowLink link, Point startPoint, Point endPoint) {
        return new ActionPair((XmlAction)this.createArrowLinkPointXmlAction(link, startPoint, endPoint), (XmlAction)this.createArrowLinkPointXmlAction(link, link.getStartInclination(), link.getEndInclination()));
    }

    @Override
    public void act(XmlAction action) {
        if (action instanceof ArrowLinkPointXmlAction) {
            ArrowLinkPointXmlAction pointAction = (ArrowLinkPointXmlAction)action;
            MindMapArrowLink link = (MindMapArrowLink)this.getLinkRegistry().getLinkForId(pointAction.getId());
            link.setStartInclination(Tools.xmlToPoint(pointAction.getStartPoint()));
            link.setEndInclination(Tools.xmlToPoint(pointAction.getEndPoint()));
            this.controller.nodeChanged(link.getSource());
            this.controller.nodeChanged(link.getTarget());
        }
    }

    @Override
    public Class getDoActionClass() {
        return ArrowLinkPointXmlAction.class;
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
    }

    private ArrowLinkPointXmlAction createArrowLinkPointXmlAction(MindMapArrowLink arrowLink, Point startPoint, Point endPoint) {
        ArrowLinkPointXmlAction action = new ArrowLinkPointXmlAction();
        action.setStartPoint(Tools.PointToXml(startPoint));
        action.setEndPoint(Tools.PointToXml(endPoint));
        action.setId(arrowLink.getUniqueId());
        return action;
    }

    private MindMapLinkRegistry getLinkRegistry() {
        return this.controller.getMap().getLinkRegistry();
    }
}

