/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts.apps;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;

public abstract class AbstractFontReader {
    protected static final Log log = LogFactory.getLog(AbstractFontReader.class);

    protected AbstractFontReader() {
    }

    protected static String[] parseArguments(Map options, String[] args) {
        ArrayList<String> arguments = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-")) {
                if ("-t".equals(args[i]) || "-d".equals(args[i]) || "-q".equals(args[i])) {
                    options.put(args[i], "");
                    continue;
                }
                if (i + 1 < args.length && !args[i + 1].startsWith("-")) {
                    options.put(args[i], args[i + 1]);
                    ++i;
                    continue;
                }
                options.put(args[i], "");
                continue;
            }
            arguments.add(args[i]);
        }
        return arguments.toArray(new String[arguments.size()]);
    }

    protected static void setLogLevel(String level) {
        LogFactory.getFactory().setAttribute("level", level);
    }

    protected static void determineLogLevel(Map options) {
        if (options.get("-t") != null) {
            AbstractFontReader.setLogLevel("trace");
        } else if (options.get("-d") != null) {
            AbstractFontReader.setLogLevel("debug");
        } else if (options.get("-q") != null) {
            AbstractFontReader.setLogLevel("error");
        } else {
            AbstractFontReader.setLogLevel("info");
        }
    }

    public void writeFontXML(Document doc, String target) throws TransformerException {
        this.writeFontXML(doc, new File(target));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeFontXML(Document doc, File target) throws TransformerException {
        log.info("Writing xml font file " + target + "...");
        try {
            OutputStream out = new FileOutputStream(target);
            out = new BufferedOutputStream(out);
            try {
                TransformerFactory factory = TransformerFactory.newInstance();
                Transformer transformer = factory.newTransformer();
                transformer.transform(new DOMSource(doc), new StreamResult(out));
            }
            finally {
                out.close();
            }
        }
        catch (IOException ioe) {
            throw new TransformerException("Error writing the output file", ioe);
        }
    }
}

