/*
 * Decompiled with CFR 0.152.
 */
package javajs.util;

import java.io.BufferedReader;
import java.util.Hashtable;
import java.util.Map;
import javajs.api.GenericCifDataParser;
import javajs.api.GenericLineReader;
import javajs.util.Lst;
import javajs.util.PT;
import javajs.util.SB;

public class CifDataParser
implements GenericCifDataParser {
    public static final int KEY_MAX = 100;
    private GenericLineReader reader;
    private BufferedReader br;
    protected String line;
    protected String str;
    protected int ich;
    protected int cch;
    protected boolean wasUnquoted;
    protected char cterm = '\u0000';
    protected String nullString = "\u0000";
    protected boolean asObject;
    protected boolean debugging;
    private Object strPeeked;
    private int ichPeeked;
    private int columnCount;
    private String[] columnNames;
    private Object[] columnData = new Object[100];
    private boolean isLoop;
    private boolean haveData;
    private SB fileHeader = new SB();
    private boolean isHeader = true;
    private static Map<String, Integer> htFields = new Hashtable<String, Integer>();
    private static final String grABC = "ABX\u0394E\u03a6\u0393HI_K\u039bMNO\u03a0\u0398P\u03a3TY_\u03a9\u039e\u03a5Z";
    private static final String grabc = "\u03b1\u03b2\u03c7\u03a4\u03a5\u03c6\u03b3\u03b7\u03b9_\u03ba\u03bb\u03bc\u03bd\u03bf\u03c0\u03b8\u03c1\u03c3\u03c4\u03c5_\u03c9\u03be\u03c5\u03b6";

    protected int getVersion() {
        return 1;
    }

    public void setNullValue(String nullString) {
        this.nullString = nullString;
    }

    @Override
    public Object getColumnData(int i) {
        return this.columnData[i];
    }

    @Override
    public int getColumnCount() {
        return this.columnCount;
    }

    @Override
    public String getColumnName(int i) {
        return this.columnNames[i];
    }

    @Override
    public CifDataParser set(GenericLineReader reader, BufferedReader br, boolean debugging) {
        this.reader = reader;
        this.br = br;
        this.debugging = debugging;
        return this;
    }

    @Override
    public String getFileHeader() {
        return this.fileHeader.toString();
    }

    @Override
    public Map<String, Object> getAllCifData() {
        this.line = "";
        Map<String, Object> data = null;
        Hashtable<String, Object> data0 = null;
        Hashtable<String, Object> allData = new Hashtable<String, Object>();
        Lst<Hashtable<String, Object>> models = new Lst<Hashtable<String, Object>>();
        allData.put("models", models);
        this.asObject = this.getVersion() >= 2;
        this.nullString = null;
        Lst<Hashtable<String, Object>> saveFrames = new Lst<Hashtable<String, Object>>();
        try {
            String key;
            while ((key = this.getNextToken()) != null) {
                Object value;
                if (key.startsWith("global_") || key.startsWith("data_")) {
                    data0 = data = new Hashtable<String, Object>();
                    models.addLast((Hashtable<String, Object>)data);
                    data.put("name", key);
                    continue;
                }
                if (key.startsWith("loop_")) {
                    this.getAllCifLoopData(data);
                    continue;
                }
                if (key.startsWith("save_")) {
                    if (key.equals("save_")) {
                        int n = saveFrames.size();
                        if (n == 0) {
                            System.out.println("CIF ERROR ? save_ without corresponding save_xxxx");
                            data = data0;
                            continue;
                        }
                        data = (Map)saveFrames.removeItemAt(n - 1);
                        continue;
                    }
                    saveFrames.addLast((Hashtable<String, Object>)data);
                    Hashtable<String, Object> d = data;
                    data = new Hashtable();
                    d.put(key, data);
                    continue;
                }
                if (key.charAt(0) != '_') {
                    System.out.println("CIF ERROR ? should be an underscore: " + key);
                    continue;
                }
                Object object = value = this.asObject ? this.getNextTokenObject() : this.getNextToken();
                if (value == null) {
                    System.out.println("CIF ERROR ? end of file; data missing: " + key);
                    continue;
                }
                data.put(this.fixKey(key), value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.asObject = false;
        try {
            if (this.br != null) {
                this.br.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.nullString = "\u0000";
        return allData;
    }

    private void getAllCifLoopData(Map<String, Object> data) throws Exception {
        Object o;
        Lst<String> keyWords = new Lst<String>();
        while ((o = this.peekToken()) != null && o instanceof String && ((String)o).charAt(0) == '_') {
            String key = this.fixKey((String)this.getTokenPeeked());
            keyWords.addLast(key);
            data.put(key, new Lst());
        }
        this.columnCount = keyWords.size();
        if (this.columnCount == 0) {
            return;
        }
        this.isLoop = true;
        while (this.getData()) {
            for (int i = 0; i < this.columnCount; ++i) {
                ((Lst)data.get(keyWords.get(i))).addLast(this.columnData[i]);
            }
        }
        this.isLoop = false;
    }

    @Override
    public String readLine() {
        try {
            String string = this.line = this.reader == null ? this.br.readLine() : this.reader.readNextLine();
            if (this.line == null) {
                return null;
            }
            if (this.isHeader) {
                if (this.line.startsWith("#")) {
                    this.fileHeader.append(this.line).appendC('\n');
                } else {
                    this.isHeader = false;
                }
            }
            return this.line;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public boolean getData() throws Exception {
        if (this.isLoop) {
            for (int i = 0; i < this.columnCount; ++i) {
                this.columnData[i] = this.getNextDataToken();
                if (this.columnData[i] != null) continue;
                return false;
            }
        } else if (this.haveData) {
            this.haveData = false;
        } else {
            return false;
        }
        return this.columnCount > 0;
    }

    @Override
    public String skipLoop(boolean doReport) throws Exception {
        String str;
        SB ret = doReport ? new SB() : null;
        int n = 0;
        while ((str = (String)this.peekToken()) != null && str.charAt(0) == '_') {
            if (ret != null) {
                ret.append(str).append("\n");
            }
            this.getTokenPeeked();
            ++n;
        }
        if (n == 0) {
            n = this.columnCount;
        }
        int m = 0;
        while ((str = (String)this.getNextDataToken()) != null) {
            if (ret == null) continue;
            ret.append(str).append(" ");
            if (++m % n != 0) continue;
            ret.append("\n");
        }
        return ret == null ? null : ret.toString();
    }

    @Override
    public String getNextToken() throws Exception {
        this.wasUnquoted = true;
        return (String)this.getNextTokenProtected();
    }

    public Object getNextTokenObject() throws Exception {
        this.wasUnquoted = true;
        return this.getNextTokenProtected();
    }

    protected Object getNextTokenProtected() throws Exception {
        return this.getNextLine() ? this.nextStrToken() : null;
    }

    @Override
    public Object getNextDataToken() throws Exception {
        String str;
        Object o = this.peekToken();
        if (o == null) {
            return null;
        }
        if (this.wasUnquoted && o instanceof String && ((str = (String)o).charAt(0) == '_' || str.startsWith("loop_") || str.startsWith("data_") || str.startsWith("save_") || str.startsWith("stop_") || str.startsWith("global_"))) {
            return null;
        }
        return this.getTokenPeeked();
    }

    @Override
    public Object peekToken() throws Exception {
        if (!this.getNextLine()) {
            return null;
        }
        int ich = this.ich;
        this.strPeeked = this.nextStrToken();
        this.ichPeeked = this.ich;
        this.ich = ich;
        return this.strPeeked;
    }

    private boolean getNextLine() throws Exception {
        while (!this.strHasMoreTokens()) {
            if (this.prepareNextLine() != null) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object getTokenPeeked() {
        this.ich = this.ichPeeked;
        return this.strPeeked;
    }

    @Override
    public String fullTrim(String str) {
        int pt0 = -1;
        int pt1 = str.length();
        while (++pt0 < pt1 && PT.isWhitespace(str.charAt(pt0))) {
        }
        while (--pt1 > pt0 && PT.isWhitespace(str.charAt(pt1))) {
        }
        return str.substring(pt0, pt1 + 1);
    }

    @Override
    public String toUnicode(String data) {
        try {
            int pt;
            while ((pt = data.indexOf(92)) >= 0) {
                char c = data.charAt(pt + 1);
                String ch = c >= 'A' && c <= 'Z' ? grABC.substring(c - 65, c - 64) : (c >= 'a' && c <= 'z' ? grabc.substring(c - 97, c - 96) : "_");
                data = data.substring(0, pt) + ch + data.substring(pt + 2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return data;
    }

    @Override
    public void parseDataBlockParameters(String[] fields, String key, String data, int[] key2col, int[] col2key) throws Exception {
        int pt;
        boolean bl = this.isLoop = key == null;
        if (fields == null) {
            this.columnNames = new String[100];
        } else {
            int i;
            if (!htFields.containsKey(fields[0])) {
                i = fields.length;
                while (--i >= 0) {
                    htFields.put(fields[i], i);
                }
            }
            i = fields.length;
            while (--i >= 0) {
                key2col[i] = -1;
            }
        }
        this.columnCount = 0;
        if (this.isLoop) {
            while (true) {
                Object o;
                if ((o = this.peekToken()) == null) {
                    this.columnCount = 0;
                } else if (o instanceof String && ((String)o).charAt(0) == '_') {
                    ++this.columnCount;
                    String s = this.fixKey((String)this.getTokenPeeked());
                    if (fields == null) {
                        col2key[pt] = key2col[pt] = pt;
                        this.columnNames[key2col[pt]] = s;
                        continue;
                    }
                    Integer iField = htFields.get(s);
                    int i = iField == null ? -1 : iField;
                    col2key[pt] = i;
                    if (col2key[pt] == -1) continue;
                    key2col[i] = pt;
                    continue;
                }
                break;
            }
        } else {
            pt = key.indexOf(".");
            String str0 = pt < 0 ? key : key.substring(0, pt + 1);
            while (true) {
                Integer iField;
                int i;
                ++this.columnCount;
                if (key == null) {
                    key = (String)this.getTokenPeeked();
                    data = this.getNextToken();
                }
                if ((col2key[pt] = (i = (iField = htFields.get(this.fixKey(key))) == null ? -1 : iField)) == -1) {
                    this.columnData[pt] = "";
                } else {
                    key2col[i] = pt;
                    this.columnData[key2col[i]] = data;
                }
                Object o = this.peekToken();
                if (o == null || !(o instanceof String) || !((String)o).startsWith(str0)) break;
                key = null;
            }
            this.haveData = this.columnCount > 0;
        }
    }

    @Override
    public String fixKey(String key) {
        return (key.startsWith("_magnetic") ? key.substring(9) : (key.startsWith("_jana") ? key.substring(5) : key)).replace('.', '_').toLowerCase();
    }

    protected String setString(String str) {
        this.str = this.line = str;
        this.cch = str == null ? 0 : str.length();
        this.ich = 0;
        return str;
    }

    protected String prepareNextLine() throws Exception {
        this.setString(this.readLine());
        if (this.line == null || this.line.length() == 0) {
            return this.line;
        }
        if (this.line.charAt(0) == ';') {
            return this.preprocessString();
        }
        if (this.str.startsWith("###non-st#")) {
            this.ich = 10;
        }
        return this.line;
    }

    protected String preprocessString() throws Exception {
        return this.setString(this.preprocessSemiString());
    }

    protected String preprocessSemiString() throws Exception {
        this.ich = 1;
        String str = '\u0001' + this.line.substring(1) + '\n';
        while (this.readLine() != null) {
            if (this.line.startsWith(";")) {
                str = str.substring(0, str.length() - 1) + '\u0001' + this.line.substring(1);
                break;
            }
            str = str + this.line + '\n';
        }
        return str;
    }

    private boolean strHasMoreTokens() {
        if (this.str == null) {
            return false;
        }
        int ch = 35;
        while (this.ich < this.cch) {
            char c = this.str.charAt(this.ich);
            ch = c;
            if (c != ' ' && ch != 9) break;
            ++this.ich;
        }
        return this.ich < this.cch && ch != 35;
    }

    private Object nextStrToken() {
        if (this.ich == this.cch) {
            return null;
        }
        char ch = this.str.charAt(this.ich);
        if (this.isQuote(ch)) {
            this.wasUnquoted = false;
            return this.getQuotedStringOrObject(ch);
        }
        int ichStart = this.ich;
        this.wasUnquoted = true;
        while (this.ich < this.cch && !this.isTerminator(ch = this.str.charAt(this.ich))) {
            ++this.ich;
        }
        if (this.ich == ichStart + 1 && this.nullString != null && (this.str.charAt(ichStart) == '.' || this.str.charAt(ichStart) == '?')) {
            return this.nullString;
        }
        String s = this.str.substring(ichStart, this.ich);
        return this.unquoted(s);
    }

    protected Object unquoted(String s) {
        return s;
    }

    protected boolean isTerminator(char c) {
        return c == ' ' || c == '\t' || c == this.cterm;
    }

    protected boolean isQuote(char ch) {
        switch (ch) {
            case '\u0001': 
            case '\"': 
            case '\'': 
            case '[': 
            case ']': {
                return true;
            }
        }
        return false;
    }

    protected Object getQuotedStringOrObject(char ch) {
        switch (ch) {
            case '[': {
                try {
                    return this.readList();
                }
                catch (Exception e) {
                    System.out.println("exception in CifDataParser ; " + e);
                }
            }
            case ']': {
                ++this.ich;
                return "]";
            }
        }
        int ichStart = this.ich;
        char chClosingQuote = ch;
        boolean wasQuote = false;
        while (++this.ich < this.cch) {
            ch = this.str.charAt(this.ich);
            if (wasQuote && (ch == ' ' || ch == '\t')) break;
            wasQuote = ch == chClosingQuote;
        }
        int pt1 = ichStart + 1;
        int pt2 = this.ich - 1;
        if (this.ich == this.cch && !wasQuote) {
            --pt1;
            ++pt2;
        } else {
            ++this.ich;
        }
        return this.str.substring(pt1, pt2);
    }

    public Object readList() throws Exception {
        ++this.ich;
        char cterm0 = this.cterm;
        this.cterm = (char)93;
        String ns = this.nullString;
        this.nullString = null;
        Lst<Object> lst = this.asObject ? new Lst<Object>() : null;
        int n = 0;
        String str = "";
        while (true) {
            Object value;
            Object object = value = this.asObject ? this.getNextTokenObject() : this.getNextToken();
            if (value == null || value.equals("]")) break;
            if (this.asObject) {
                lst.addLast(value);
                continue;
            }
            if (n++ > 0) {
                str = str + ",";
            }
            str = str + value;
        }
        this.cterm = cterm0;
        this.nullString = ns;
        return this.asObject ? lst : "[" + str + "]";
    }
}

