/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io.importexport;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.io.importexport.FileImporter;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.GpxRouteLayer;
import org.openstreetmap.josm.gui.layer.ImageryLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.Compression;
import org.openstreetmap.josm.io.GpxReader;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.xml.sax.SAXException;

public class GpxImporter
extends FileImporter {
    public GpxImporter() {
        super(GpxImporter.getFileFilter());
    }

    public static ExtensionFileFilter getFileFilter() {
        return ExtensionFileFilter.newFilterWithArchiveExtensions("gpx", Config.getPref().get("save.extension.gpx", "gpx"), I18n.tr("GPX Files", new Object[0]), true);
    }

    @Override
    public void importData(File file, ProgressMonitor progressMonitor) throws IOException {
        String fileName = file.getName();
        try (InputStream is = Compression.getUncompressedFileInputStream(file);){
            GpxReader r = new GpxReader(is);
            boolean parsedProperly = r.parse(true);
            r.getGpxData().storageFile = file;
            GpxImporter.addLayers(GpxImporter.loadLayers(r.getGpxData(), parsedProperly, fileName));
        }
        catch (SAXException e) {
            Logging.error(e);
            throw new IOException(e.getLocalizedMessage(), e);
        }
    }

    public static void addLayers(GpxImporterData data) {
        GuiHelper.runInEDT(() -> {
            if (data.markerLayer != null) {
                MainApplication.getLayerManager().addLayer(data.markerLayer);
            }
            if (data.gpxRouteLayer != null) {
                MainApplication.getLayerManager().addLayer(data.gpxRouteLayer);
            }
            if (data.gpxLayer != null) {
                MainApplication.getLayerManager().addLayer(data.gpxLayer);
                MainApplication.getLayerManager().setActiveLayer(data.gpxLayer);
            }
            data.postLayerTask.run();
        });
    }

    public static GpxImporterData loadLayers(GpxData data, boolean parsedProperly, String gpxLayerName) {
        MarkerLayer markerLayer = null;
        GpxRouteLayer gpxRouteLayer = null;
        GpxLayer gpxLayer = new GpxLayer(data, gpxLayerName, data.storageFile != null);
        if (Config.getPref().getBoolean("marker.makeautomarkers", true) && !data.waypoints.isEmpty()) {
            markerLayer = new MarkerLayer(data, I18n.tr("Markers from {0}", gpxLayerName), data.storageFile, gpxLayer);
            if (markerLayer.data.isEmpty()) {
                markerLayer = null;
            } else {
                gpxLayer.setLinkedMarkerLayer(markerLayer);
            }
        }
        if (Config.getPref().getBoolean("gpx.makeautoroutes", true) && !data.getRoutes().isEmpty()) {
            gpxRouteLayer = new GpxRouteLayer(I18n.tr("Routes from {0}", gpxLayerName), gpxLayer);
        }
        boolean isSameColor = MainApplication.getLayerManager().getLayersOfType(ImageryLayer.class).stream().noneMatch(Layer::isVisible) && data.getTracks().stream().anyMatch(t -> OsmDataLayer.getBackgroundColor().equals(t.getColor()));
        Runnable postLayerTask = () -> {
            if (!parsedProperly) {
                String msg = data.storageFile == null ? I18n.tr("Error occurred while parsing gpx data for layer ''{0}''. Only a part of the file will be available.", gpxLayerName) : I18n.tr("Error occurred while parsing gpx file ''{0}''. Only a part of the file will be available.", data.storageFile.getPath());
                JOptionPane.showMessageDialog(null, msg);
            }
            if (isSameColor) {
                new Notification(I18n.tr("The imported track \"{0}\" might not be visible because it has the same color as the background.<br>You can change this in the context menu of the imported layer.", gpxLayerName)).setIcon(2).setDuration(Notification.TIME_LONG).show();
            }
        };
        return new GpxImporterData(gpxLayer, gpxRouteLayer, markerLayer, postLayerTask);
    }

    public static GpxImporterData loadLayers(InputStream is, File associatedFile, String gpxLayerName, ProgressMonitor progressMonitor) throws IOException {
        try {
            GpxReader r = new GpxReader(is);
            boolean parsedProperly = r.parse(true);
            r.getGpxData().storageFile = associatedFile;
            return GpxImporter.loadLayers(r.getGpxData(), parsedProperly, gpxLayerName);
        }
        catch (SAXException e) {
            Logging.error(e);
            throw new IOException(I18n.tr("Parsing data for layer ''{0}'' failed", gpxLayerName), e);
        }
    }

    public static class GpxImporterData {
        private final GpxLayer gpxLayer;
        private final GpxRouteLayer gpxRouteLayer;
        private final MarkerLayer markerLayer;
        private final Runnable postLayerTask;

        public GpxImporterData(GpxLayer gpxLayer, GpxRouteLayer gpxRouteLayer, MarkerLayer markerLayer, Runnable postLayerTask) {
            this.gpxLayer = gpxLayer;
            this.gpxRouteLayer = gpxRouteLayer;
            this.markerLayer = markerLayer;
            this.postLayerTask = postLayerTask;
        }

        public GpxLayer getGpxLayer() {
            return this.gpxLayer;
        }

        public GpxRouteLayer getGpxRouteLayer() {
            return this.gpxRouteLayer;
        }

        public MarkerLayer getMarkerLayer() {
            return this.markerLayer;
        }

        public Runnable getPostLayerTask() {
            return this.postLayerTask;
        }
    }
}

